<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Password;
use Illuminate\Support\Facades\Mail;
use App\Mail\UserInvitation;
use App\Models\Utilisateur;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\DB;
use Carbon\Carbon;

class ForgotPasswordController extends Controller
{
    public function showForgotForm()
    {
        return view('auth.password.forgot-password');
    }

    
    public function sendResetLinkEmail(Request $request)
    {
        $request->validate([
            'email' => 'required|email',
            ], [
            'email.required' => 'الرجاء إدخال البريد الإلكتروني',
            'email.email'    => ' الرجاء إدخال بريد إلكتروني صحيح',
        ]);

        $user = Utilisateur::where('email', $request->email)->first();

        if (!$user) {
            return back()->withErrors(['email' => 'البريد الإلكتروني غير موجود.']);
        }

        $token = Str::random(60);

        DB::table('password_resets')->updateOrInsert(
            ['email' => $user->email],
            [
                'token' => $token,
                'created_at' => Carbon::now()
            ]
        );

        $resetLink = url("/reset-password/{$token}?email={$user->email}");

        Mail::to($user->email)->send(new UserInvitation($user, $resetLink));

        return back()->with('success', 'تم إرسال رابط إعادة تعيين كلمة المرور إلى بريدك الإلكتروني.');
    }

}
