<?php
namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;

class AssetController extends Controller
{
    public function upload(Request $req)
    {
        if (!$req->hasFile('file')) {
            return response()->json(['error'=>'file missing'], 422);
        }
        $file = $req->file('file');
        $path = $file->store('public/uploads'); // stocke dans storage/app/public/uploads
        $url = Storage::url($path); // /storage/uploads/xxx.jpg (assure-toi d'avoir php artisan storage:link)
        return response()->json(['url' => $url], 201);
    }
}
