<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Page;

class PageBuilderController extends Controller
{
    public function store(Request $request)
    {
        $data = $request->validate([
            'html' => 'nullable|string',
            'css'  => 'nullable|string',
            'titre_P' => 'nullable|string'
        ]);

        $page = Page::updateOrCreate(
            ['titre_P' => $data['titre_P'] ?? 'home'],
            ['html_content' => $data['html'] ?? '', 'css_content' => $data['css'] ?? '']
        );

        return response()->json(['success' => true, 'id' => $page->id_P]);
    }
}

