<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire.css')); ?>">
<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>
<?php if(Auth::check()): ?>

<div class="container">
    <form action="<?php echo e(route('admin.jeunesse.update', $institution->id_inst)); ?>" method="POST" enctype="multipart/form-data" lang="ar">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>
        <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire->id_type); ?>">
     
        <h3><?php echo e($formulaire->type_ar); ?></h3>
   <h4 class="title-request">اطلاع على المطلب</h4>

        <div>
                   <div class="d-flex align-items-center mb-3">
    <h5 class="mb-0 fw-bold me-2">الوضعية الحالية:</h5>

    <?php switch($institution->id_statut):

        case (1): ?>
            <span><strong> قبول</strong></span>
            <?php break; ?>

        <?php case (2): ?>
            <span><strong>في الانتظار</strong></span>
            <?php break; ?>

        <?php case (3): ?>
            <span><strong>رفض</strong></span>
            <?php break; ?>

        <?php case (4): ?>
            <span><strong>موافقة شريطة</strong></span>
            <?php break; ?>

        <?php case (5): ?>
            <span><strong>إرجاء لإبداء الرأي</strong></span>
            <?php break; ?>

        <?php case (6): ?>
            <span><strong>مسودّة</strong></span>
            <?php break; ?>

        <?php default: ?>
            <span><strong>غير محدد</strong></span>

    <?php endswitch; ?>
</div>

            <?php if($institution->id_statut == 3 && !empty($institution->commentaire_motif)): ?>
                <div class="d-flex align-items-center mb-3">
                    <label class="fw-bold text-danger me-2 mb-0">سبب الرفض:</label>
                    <p class="mb-0 border p-2 rounded shadow-sm text-muted"><?php echo e($institution->commentaire_motif); ?></p>
                </div>
            <?php endif; ?>
        </div>

  
<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-light py-2"><h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h5></div>

  <div class="card-body p-2" dir="rtl">
    <?php if(! isset($institution->statutHistories) || $institution->statutHistories->isEmpty()): ?>
      <p class="text-muted mb-0">لا توجد تغييرات سابقة.</p>
    <?php else: ?>
      <div class="compact-timeline">
        <?php $__currentLoopData = $institution->statutHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php
            $from = optional($hist->fromStatut)->statut_ar ?? optional($hist->fromStatut)->libelle_ar ?? '—';
            $to = optional($hist->toStatut)->statut_ar ?? optional($hist->toStatut)->libelle_ar ?? '—';
            $toId = optional($hist->toStatut)->id_statut;
            $badgeClass = $toId === 1 ? 'badge-success' : ($toId === 3 ? 'badge-danger' : 'badge-muted');
            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
          ?>

          <div class="compact-item">
            <div class="compact-row d-flex align-items-center justify-content-between w-100">
              <div class="left-block text-end">
                <div class="small text-muted compact-date"><?php echo e($hist->created_at->format('d/m/Y H:i')); ?></div>
                <div class="very-small text-muted compact-user">بواسطة: <?php echo e($changer); ?></div>
              </div>

              <div class="right-block text-right flex-fill">
                <span class="compact-from small text-muted"><?php echo e($from); ?></span>
                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                <span class="compact-to small <?php echo e($badgeClass); ?>"><?php echo e($to); ?></span>
              </div>
            </div>

            <?php if($hist->commentaire): ?>
              <details class="compact-comment mt-1">
                <summary class="very-small text-danger">سبب / تعليق</summary>
                <div class="very-small text-muted mt-1"><?php echo e($hist->commentaire); ?></div>
              </details>
            <?php endif; ?>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    <?php endif; ?>
  </div>
</div>
<style>
/* compact styles (same as earlier) */
.compact-timeline { display:flex; flex-direction:column; gap:6px; }
.compact-item { padding:6px 4px; border-bottom:1px solid rgba(0,0,0,0.06); }
.left-block { width:160px; min-width:120px; margin-left:12px; }
.compact-date { font-size:12px; color:#6c757d; }
.compact-user { font-size:11px; color:#8a8f94; margin-top:2px; }
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color:#6c757d; font-size:13px; }
.compact-arrow { color:#6c757d; font-size:14px; margin:0 4px; }
.compact-to { font-size:13px; padding:3px 8px; border-radius:10px; }
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }
.compact-comment summary { list-style:none; cursor:pointer; outline:none; padding:0; }
</style>
        <div class="form-section">
            <h4>المستثمر</h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0"><?php echo e($institution->investissements->first()?->utilisateur->nom_prenom ?? '-'); ?></div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">مكان الولادة</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->investissements->first()?->utilisateur->lieu_naissance ?? '-'); ?>

                    </div>
                </div>

                <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->investissements->first()?->utilisateur->date_naissance ?? '-'); ?>

                    </div>
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->investissements->first()?->utilisateur->typeIdentite->type_ar ?? '-'); ?>

                    </div>
                </div>

                <?php
                    $typeIdentite = $institution->investissements->first()?->utilisateur->id_type_identite;
                ?>

                <?php if($typeIdentite == 1): ?>
                    <div class="col-sm-6">
                        <div class="form-control bg-white border-0">
                            <?php echo e($institution->investissements->first()?->utilisateur->cin ?? '-'); ?>

                        </div>
                    </div>
                <?php elseif($typeIdentite == 2): ?>
                    <div class="col-sm-6">
                        <div class="form-control bg-white border-0">
                            <?php echo e($institution->investissements->first()?->utilisateur->passport ?? '-'); ?>

                        </div>
                    </div>
                <?php elseif($typeIdentite == 3): ?>
                    <div class="col-sm-6">
                        <div class="form-control bg-white border-0">
                            <?php echo e($institution->investissements->first()?->utilisateur->num_fiscal ?? '-'); ?>

                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <?php
                $user = $institution->investissements->first()?->utilisateur;
            ?>

            <?php if($user && $user->id_type_identite == 1): ?>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($user->date_delivrance_cin ?? '-'); ?>

                    </div>
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($user->lieu_delivrance_cin ?? '-'); ?>

                    </div>
                </div>
            </div>
            <?php endif; ?>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">العنوان الشخصي</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">
                        <?php echo e($user->adresse ?? '-'); ?>

                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">المستوى التعليمي</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($user->niveau_etude ?? '-'); ?>

                    </div>
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($user->dernier_diplome ?? '-'); ?>

                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاقدمية في تعاطي النشاط</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->investissements->first()?->utilisateur->experience ?? '-'); ?>

                    </div>
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4> خاصيات النشاط </h4>
            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <strong> المؤسسة الشبابية الخاصة</strong>
                    </label>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label class="col-sm-10 col-form-label">
                        <strong> الرجاء الاختبار </strong>
                    </label>
                </div>

                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($types_espace->firstWhere('id_type', $institution->type_espace_id)?->type_ar ?? 'غير محدد'); ?>

                    </div>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u> مميزات الفضاء  </u>
                    </label>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> عدد الغرف </label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->nbr_chambre ?? 'غير محدد'); ?>

                    </div>
                </div>

                <label class="col-sm-2 col-form-label"> عدد القاعات </label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->nbr_salles ?? 'غير محدد'); ?>

                    </div>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u>طاقة الاستعاب</u>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">  بالمبيت </label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->capacite_accueil_hebergement ?? 'غير محدد'); ?>

                    </div>
                </div>

                <label class="col-sm-2 col-form-label">  تحت الخيام </label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->capacite_accueil_sous_tente ?? 'غير محدد'); ?>

                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">  بفضاءات التنشيط </label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->capacite_accueil_espace_animation ?? 'غير محدد'); ?>

                    </div>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label">
                        <u> الخدمات التي تؤمنها المؤسسة  </u>
                    </label>
                </div>
            </div>

            <div class="form-check d-flex align-items-center">
                <input readonly type="hidden" name="heberg_rest" value="0"> 
                <input readonly class="form-check-input me-2 bg-white" type="checkbox" id="heberg_rest" name="heberg_rest" value="1" disabled
                       <?php echo e(old('heberg_rest', $institution->heberg_rest) ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="heberg_rest"> الإقامة والتغذية </label>
            </div>

            <div class="form-check d-flex align-items-center mb-2">
                <input type="hidden" name="heberg_stage_activ" value="0">
                <input class="form-check-input me-2" type="checkbox" id="heberg_stage_activ" 
                    name="heberg_stage_activ" value="1" disabled
                    <?php echo e($institution->heberg_stage_activ ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="heberg_stage_activ">
                    إيواء التربصات والأنشطة التكوينية
                </label>
            </div>

            <div class="form-check d-flex align-items-center mb-2">
                <input type="hidden" name="camping" value="0">
                <input class="form-check-input me-2" type="checkbox" id="camping" 
                    name="camping" value="1" disabled
                    <?php echo e($institution->camping ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="camping">
                    التخييم
                </label>
            </div>

            <div class="form-check d-flex align-items-center mb-2">
                <input type="hidden" name="activ_educative" value="0">
                <input class="form-check-input me-2" type="checkbox" id="activ_educative" 
                    name="activ_educative" value="1" disabled
                    <?php echo e($institution->activ_educative ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="activ_educative">
                    التنشيط التربوي والإجتماعي والثقافي
                </label>
            </div>

            <div class="form-check d-flex align-items-center mb-2">
                <input type="hidden" name="voyage" value="0">
                <input class="form-check-input me-2" type="checkbox" id="voyage" 
                    name="voyage" value="1" disabled
                    <?php echo e($institution->voyage ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="voyage">
                    الرحلات الداخلية والخارجية
                </label>
            </div>

            <div class="form-check d-flex align-items-center mb-2">
                <input type="hidden" name="evenement" value="0">
                <input class="form-check-input me-2" type="checkbox" id="evenement" 
                    name="evenement" value="1" disabled
                    <?php echo e($institution->evenement ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="evenement">
                    التظاهرات الثقافية والحفلات
                </label>
            </div>

            <div class="form-check d-flex align-items-center mb-2">
                <input type="hidden" name="autre" value="0">
                <input class="form-check-input me-2" type="checkbox" id="autre" 
                    name="autre" value="1" disabled
                    <?php echo e($institution->autre ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="autre">
                    غير ذلك
                </label>
            </div>

            <div class="form-group row mb-3 align-items-center">
                <label class="col-sm-2 col-form-label">الاسم التجاري للمشروع</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->nom_projet ?? 'غير محدد'); ?>

                    </div>
                </div>

                <label class="col-sm-2 col-form-label">طبيعة المشروع</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($nature_projet->firstWhere('id_nature_p', $institution->nature_projet_id)?->nature_ar ?? 'غير محدد'); ?>

                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">عدد مواطن الشغل</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->nbr_emplois ?? 'غير محدد'); ?>

                    </div>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u>مدير المؤسسة</u>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->directeur->nom_prenom_d ?? 'غير محدد'); ?>

                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">رقم بطاقة التعريف الوطنية</label>
                <div class="col-sm-10">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->directeur->num_cin ?? 'غير محدد'); ?>

                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->directeur->date_delivrance ?? 'غير محدد'); ?>

                    </div>
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->directeur->lieu_delivrance ?? 'غير محدد'); ?>

                    </div>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">المستوى التعليمي</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->directeur->niveau_etude ?? 'غير محدد'); ?>

                    </div>
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <div class="form-control bg-white border-0">
                        <?php echo e($institution->directeur->dernier_diplome_obtenu ?? 'غير محدد'); ?>

                    </div>
                </div>
            </div>

        </div>
        <h4>جدول الاستثمار و التمويل</h4>
        <div class="form-section mt-4">
            <table class="custom-table">
                <thead>
                    <tr>
                        <th>الإستثمار</th>
                        <th>مبلغ الإستثمار</th>
                        <th>مصادر التمويل</th>
                        <th>مبلغ التمويل</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__currentLoopData = $institution->investissements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td>
                            <?php echo e($secteurs->firstWhere('id_secteur', $inv->secteur_invest_id)?->secteur_ar ?? 'غير محدد'); ?>

                        </td>
                        <td><?php echo e($inv->montant_inv ?? 'غير محدد'); ?></td>
                        <td>
                            <?php echo e($source_fin->firstWhere('id_source', $inv->id_source_financement)?->source_ar ?? 'غير محدد'); ?>

                        </td>
                        <td><?php echo e($inv->montant_fin ?? 'غير محدد'); ?></td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>
        </div>

        <div class="mt-3">
            <h4>تصريح على الشرف</h4>
            <span>
                إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4> ملاحظات خاصة بالمندوبية الجهوية للشباب و الرياضة و التربية البدنية :</h4>
            <textarea class="form-control mt-2 bg-white" name="remarques" readonly rows="6" placeholder="اكتب ملاحظاتك هنا..."><?php echo e(old('remarques', $institution->remarques)); ?></textarea>
        </div>

		<div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                  <button type="button" onclick="window.print()" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-print"></i> طباعة
                </button>
                <a href="<?php echo e(route('admin.jeunesse.index')); ?>" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    </form>
</div>


<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('login')); ?>";
    </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/investissement/gestion_jeunesse/show.blade.php ENDPATH**/ ?>