<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <title>تحديث حالة الملف</title>
    <style>
        body {
            font-family: 'Tahoma', 'Segoe UI', sans-serif;
            background-color: #eef1f5;
            direction: rtl;
            text-align: center;
            margin: 0;
            padding: 40px 10px;
            color: #333;
        }

        .email-wrapper {
            background: #fff;
            max-width: 650px;
            margin: auto;
            border-radius: 18px;
            box-shadow: 0 6px 18px rgba(0,0,0,0.08);
            overflow: hidden;
            border-top: 6px solid #0d6efd;
        }

        .header {
            background: linear-gradient(135deg, #0d6efd, #4a9efc);
            color: white;
            padding: 25px 10px;
            font-size: 22px;
            font-weight: bold;
        }

        .content {
            padding: 35px 30px;
            text-align: center;
        }

        .content p {
            font-size: 17px;
            line-height: 1.9;
            color: #444;
            margin: 0 0 20px;
        }

        .file-box {
            display: inline-block;
            background: #f0f7ff;
            color: #0d47a1;
            font-size: 16px;
            padding: 10px 18px;
            border-radius: 12px;
            margin: 15px 0 25px;
            border: 1px solid #d0e2ff;
        }

        .message-box {
            background: #fafafa;
            border: 1px solid #eee;
            border-radius: 12px;
            padding: 25px;
            font-size: 17px;
            color: #333;
            line-height: 1.8;
            box-shadow: inset 0 0 8px rgba(0,0,0,0.04);
            margin-bottom: 30px;
        }

        hr {
            border: none;
            border-top: 1px solid #eee;
            margin: 30px 0;
        }

        .footer {
            padding: 25px;
            font-size: 14px;
            color: #666;
            background: #f8f9fb;
        }

        .footer .app-name {
            color: #0d6efd;
            font-weight: bold;
            font-size: 16px;
            margin-bottom: 10px;
        }

        .footer img {
            display: block;
            margin: 10px auto 0;
            width: 110px;
            opacity: 0.9;
        }
    </style>
</head>
<body>
    <div class="email-wrapper">
        <div class="header"> تحديث حالة الملف الإعفاء الجبائي</div>

        <div class="content">
            <p>مرحباً <strong><?php echo e($utilisateur->nom_prenom ?? 'المستخدم'); ?></strong>،</p>

            <div class="file-box">
                 رقم الملف: <strong><?php echo e($numeroDossier); ?></strong>
            </div>

            <div class="message-box">
                <?php echo $messageStatus; ?>

            </div>

            <p>نشكركم على تعاونكم واهتمامكم.</p>
        </div>

        <hr>

        <div class="footer">
            <div class="app-name"> وزارة الشباب والرياضة </div>
        </div>
    </div>
</body>
</html>
<?php /**PATH /home/preprov/www/mjs/back/resources/views/emails/document_status.blade.php ENDPATH**/ ?>