<?php $__env->startSection('content'); ?>

<?php if(Auth::check()): ?>
<style>
    .my-table table {
    font-size: 14px;
}

.my-table table th {
    font-size: 13px;
    white-space: nowrap;
}

.my-table table td {
    font-size: 13px;
    padding: 6px 8px;
}

/* ==== BADGE MODERNE ==== */
.status-badge {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 6px 12px;
    font-size: 13px;
    border-radius: 8px;
    font-weight: 600;
    min-width: 75px;
    text-align: center;
    transition: 0.3s;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
}

.status-badge--success {
    background-color: #e8f9ee;
    color: #27ae60;
}
.status-badge--danger {
    background-color: #fde8ea;
    color: #e74c3c;
}
.status-badge--pending {
    background-color: #fff8e1;
    color: #d4a017;
}

/* ==== ACTION BUTTONS ==== */
.actions-cell {
    display: inline-flex;
    align-items: center;
    gap: 6px;
}

.btn-icon {
    width: 30px;
    height: 30px;
    border-radius: 6px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    border: none;
    cursor: pointer;
    background-color: #f8f9fa;
    font-size: 16px;
    transition: 0.2s;
}

.btn-icon:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 5px rgba(0,0,0,0.15);
}

/* couleurs */
.btn-icon--primary {
    background-color: #e3f2fd;
    color: #0d6efd;
}
.btn-icon--danger {
    background-color: #f8d7da;
    color: #dc3545;
}

</style>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">

            <div class="block-card dashboard-card mb-4 px-0">

                
                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                   <h2 class="widget-title pb-0">قائمة الحجوزات</h2>

                    
                    <!--a class="btn btn-orange font-weight-medium" href="<?php echo e(route('reservation.archives')); ?>">
                        <i class="la la-plus mr-1"></i>  الأرشيف
                    </a-->
                </div>

 
<div class="block-card-header px-4 border-bottom-0 pb-3">
                    <form method="GET" action="<?php echo e(route('reservation.index')); ?>">
                        <div class="form-row align-items-center" style="direction: rtl;">
                            <div class="col-auto" style="width: 250px;">
                                <input 
                                    type="text" 
                                    name="q" 
                                    class="form-control" 
                                    placeholder="بحث بالحريف، المركز أو التواريخ" 
                                    value="<?php echo e($search ?? ''); ?>"
                                >
                            </div>
                            <div class="col d-flex">
                                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">
                                    بحث
                                </button>
                                <a href="<?php echo e(route('reservation.index')); ?>"
                                   class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
                                   style="width: 45px; height: 38px; margin-right: 5px; padding: 0;">
                                    <i class="fa-solid fa-rotate-right"></i>
                                </a>
                            </div>
                        </div>
                    </form>
                </div> 

                <?php if(session('success')): ?>
                    <div class="alert alert-success mt-2"><?php echo e(session('success')); ?></div>
                <?php endif; ?>

                <div class="block-card-body">
                    <div class="my-table table-responsive">
                        <table class="table align-items-center table-flush mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th width="5%">المعرف</th>
                                    <th width="15%">إسم الحريف</th>
                                    <th width="15%">إسم المركب الشبابي</th>
                                    <th width="10%">تاريخ الحجز</th>
                                    <th width="10%">تاريخ الوصول</th>
                                    <th width="10%">تاريخ المغادرة</th>
                                    <th width="10%">السعر الإجمالي</th>
                                    <th width="10%">وضعية الطلب</th>
                                    <th width="15%">إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $reservations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reserv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
								
									<?php
										$nights = \Carbon\Carbon::parse($reserv->date_arrive)
											->diffInDays(\Carbon\Carbon::parse($reserv->date_depart));

										$basePrice = ($reserv->auberge->prix_lit ?? 0)
											* ($reserv->nbr_personnes ?? 0)
											* $nights;

										$restoTotal = $reserv->restaurations->sum(fn($r) => $r->pivot->tarif ?? 0);

										$total = $basePrice + $restoTotal;
									?>

                                    <tr>
                                        <td><?php echo e($reserv->id_reserv); ?></td>
                                        <td><?php echo e($reserv->user?->nom_prenom ?? '---'); ?></td>
                                        <td><?php echo e($reserv->auberge?->nom_ar ?? '---'); ?></td>
                                        <td><?php echo e($reserv->date_reserv ?? '---'); ?></td>
                                        <td><?php echo e($reserv->date_arrive ?? '---'); ?></td>
                                        <td><?php echo e($reserv->date_depart ?? '---'); ?></td>
                                        <td><?php echo e(number_format($total, 2)); ?> د</td>

                                        <td><span class="status-badge 
                                                <?php echo e($reserv->statut?->statut_ar == 'قبول' ? 'status-badge--success' : 
                                                ($reserv->statut?->statut_ar == 'رفض' ? 'status-badge--danger' : 'status-badge--pending')); ?>">
                                                <?php echo e($reserv->statut?->statut_ar  ?? 'في الانتظار'); ?>

                                            </span>
                                        </td>
                                        
                                      


                                        <td class="text-center" style="white-space: nowrap;">
                                            <div class="d-flex justify-content-center align-items-center gap-1">

                                                <div class="actions-cell d-inline-flex gap-2">

                                                    <a href="<?php echo e(route('reservation.show', $reserv->id_reserv)); ?>"
                                                    class="btn-icon btn-icon--primary"
                                                    title="عرض">
                                                        <i class="la la-eye"></i>
                                                    </a>

                                                    <?php if($reserv->statut_id == 2): ?>
                                                        <form action="<?php echo e(route('reservation.updateStatus', $reserv->id_reserv)); ?>" method="POST">
                                                                        <?php echo csrf_field(); ?>
                                                                        <?php echo method_field('PUT'); ?>

                                                            <input type="hidden" name="statut_id" value="1">

                                                            <button type="button"
                                                                    onclick="confirmStatusChange10(this.closest('form'))"
                                                                    class="btn-icon btn-icon--secondary"
                                                                    title="تغيير الحالة">
                                                                <i class="la la-toggle-on"></i>
                                                            </button>
                                                        </form>
                                                    <?php endif; ?>


                                                    <?php if($reserv->statut_id == 1): ?>
                                                        <a href="<?php echo e(route('reservation.chambres', $reserv->id_reserv)); ?>" 
                                                        class="btn-icon btn-icon--primary" 
                                                        title="Affecter chambres">
                                                            <i class="la la-bed"></i>
                                                        </a>
                                                    <?php endif; ?>

                                                </div>

                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="9" class="text-center">لا يوجد حجز.</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>

                    </div>

                   <div class="d-flex justify-content-between align-items-center mt-3">
                      <?php echo e($reservations->links('pagination::bootstrap-5')); ?>

                    </div>
                </div>
            </div>

        </div>
    </div>
</div>

<div id="back-to-top">
    <i class="la la-arrow-up" title="Go top"></i>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script>
function ensurePutMethodOnForm(form) {
    try { form.method = 'POST'; } catch(e) {}
    let methodInput = form.querySelector('input[name="_method"]');
    if (!methodInput) {
        methodInput = document.createElement('input');
        methodInput.type = 'hidden';
        methodInput.name = '_method';
        form.appendChild(methodInput);
    }
    methodInput.value = 'PUT';
}

function confirmStatusChange10(form) {
    Swal.fire({
        title: "تأكيد",
        text: "هل تريد قبول أو رفض هذا الحجز ؟",
        icon: "warning",
        showCancelButton: true,
        confirmButtonText: "قبول",
        cancelButtonText: "رفض",
        reverseButtons: true
    }).then((result) => {
        if (result.isConfirmed) {
            ensurePutMethodOnForm(form);
            let s = form.querySelector('input[name="statut_id"]');
            if (s) s.value = 1;
            form.submit();
        } else if (result.dismiss === Swal.DismissReason.cancel) {
            Swal.fire({
                title: "رفض الحجز",
                html: `
                    <textarea id="motifReject" 
                              class="swal2-textarea" 
                              placeholder="اكتب سبب الرفض هنا..." 
                              style="direction: rtl; text-align: right;"></textarea>
                `,
                showCancelButton: true,
                confirmButtonText: "تأكيد الرفض",
                cancelButtonText: "إلغاء",
                preConfirm: () => {
                    let motif = document.getElementById("motifReject").value;
                    if (!motif) {
                        Swal.showValidationMessage("الرجاء كتابة سبب الرفض");
                        return false;
                    }
                    return motif;
                }
            }).then((result2) => {
                if (result2.isConfirmed) {
                    ensurePutMethodOnForm(form);
                    let input = form.querySelector('input[name="commentaire_motif"]');
                    if (!input) {
                        input = document.createElement("input");
                        input.type = "hidden";
                        input.name = "commentaire_motif";
                        form.appendChild(input);
                    }
                    input.value = result2.value;
                    let s = form.querySelector('input[name="statut_id"]');
                    if (s) s.value = 3;
                    else {
                        let si = document.createElement("input");
                        si.type = "hidden";
                        si.name = "statut_id";
                        si.value = 3;
                        form.appendChild(si);
                    }

                    form.submit();
                }
            });
        }
    });
}
</script>


<?php else: ?>
<script>
    window.location.href = "<?php echo e(route('admin')); ?>";
</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/auberges/reservation/index.blade.php ENDPATH**/ ?>