<?php $__env->startSection('content'); ?>
<script>
(function() {
    'use strict';
    
    window.toggleDashboardSection = function(sectionName) {
        
        const details = document.getElementById('details-' + sectionName);
        const icon = document.getElementById('icon-' + sectionName);
        const text = document.getElementById('text-' + sectionName);
        
        if (!details || !icon || !text) return;
        
        const isHidden = details.classList.contains('section-hidden');
        
        if (isHidden) {
            details.classList.remove('section-hidden');
            details.classList.add('section-visible');
            icon.className = 'ri-eye-off-line';
            text.textContent = 'إخفاء التفاصيل';
            localStorage.setItem('section-' + sectionName, 'open');
            details.style.opacity = '0';
            details.style.transform = 'translateY(-20px)';
            setTimeout(function() {
                details.style.opacity = '1';
                details.style.transform = 'translateY(0)';
            }, 10);
        } else {
            details.style.opacity = '0';
            details.style.transform = 'translateY(-20px)';
            setTimeout(function() {
                details.classList.remove('section-visible');
                details.classList.add('section-hidden');
                icon.className = 'ri-eye-line';
                text.textContent = 'عرض التفاصيل';
                localStorage.setItem('section-' + sectionName, 'closed');
            }, 300);
        }
    };
    
    
    // Redéfinir la fonction après un court délai pour écraser toute autre définition
    setTimeout(function() {
        window.toggleDashboardSection = function(sectionName) {
            
            const details = document.getElementById('details-' + sectionName);
            const icon = document.getElementById('icon-' + sectionName);
            const text = document.getElementById('text-' + sectionName);
            
            if (!details || !icon || !text) return;
            
            const isHidden = details.classList.contains('section-hidden');
            
            if (isHidden) {
                details.classList.remove('section-hidden');
                details.classList.add('section-visible');
                icon.className = 'ri-eye-off-line';
                text.textContent = 'إخفاء التفاصيل';
                localStorage.setItem('section-' + sectionName, 'open');
                details.style.opacity = '0';
                details.style.transform = 'translateY(-20px)';
                setTimeout(function() {
                    details.style.opacity = '1';
                    details.style.transform = 'translateY(0)';
                }, 10);
            } else {
                details.style.opacity = '0';
                details.style.transform = 'translateY(-20px)';
                setTimeout(function() {
                    details.classList.remove('section-visible');
                    details.classList.add('section-hidden');
                    icon.className = 'ri-eye-line';
                    text.textContent = 'عرض التفاصيل';
                    localStorage.setItem('section-' + sectionName, 'closed');
                }, 300);
            }
        };

    }, 100);
})();
</script>

<?php
    $user = Auth::user();
?>

<?php
            use App\Models\Type;
            $types_G = Type::orderBy('id_type', 'asc')->get();
?>

<?php
    $hasInvestmentPermission = $user->hasPermission(20) || $user->hasPermission(31) || $user->hasPermission(36) ||  $user->hasPermission(42) || $user->hasPermission(48) || $user->hasPermission(54) || $user->hasPermission(60);
    $hasFinPermission = $user->hasPermission(66) || $user->hasPermission(72);
    $hasManifestationPermission = $user->hasPermission(77) || $user->hasPermission(83);
	$hasAubergePermission = $user->hasPermission(115) || $user->hasPermission(117) || $user->hasPermission(119);
?>

<div class="dashboard-content p-4">
    <!-- En-tête du Dashboard -->
    <div class="dashboard-header-section mb-4">
        <h2 class="dashboard-title">
            <i class="ri-dashboard-line"></i>
            لوحة القيادة
        </h2>
    </div>

    <!-- BARRE DE FILTRES -->
    <div class="filters-container mb-4">
        <form method="GET" action="<?php echo e(route('admin.dashboard')); ?>" id="filtersForm">
            <div class="filters-card">
                <div class="filters-header">
                    <i class="ri-filter-3-line"></i>
                    <h3>المعايير</h3>
                </div>
                <div class="filters-body">
                    <div class="row g-3">
                        <!-- Filtre Période -->
                        <div class="col-md-6 col-lg-3">
                            <label class="filter-label">
                                <i class="ri-calendar-line"></i>
                                الفترة
                            </label>
                            <select name="periode" class="filter-select" id="periodeSelect">
                                <option value="all" <?php echo e($periode == 'all' ? 'selected' : ''); ?>>كل الفترات</option>
                                <option value="today" <?php echo e($periode == 'today' ? 'selected' : ''); ?>>اليوم</option>
                                <option value="week" <?php echo e($periode == 'week' ? 'selected' : ''); ?>>هذا الأسبوع</option>
                                <option value="month" <?php echo e($periode == 'month' ? 'selected' : ''); ?>>هذا الشهر</option>
                                <option value="3months" <?php echo e($periode == '3months' ? 'selected' : ''); ?>>آخر 3 أشهر</option>
                                <option value="6months" <?php echo e($periode == '6months' ? 'selected' : ''); ?>>آخر 6 أشهر</option>
                                <option value="year" <?php echo e($periode == 'year' ? 'selected' : ''); ?>>هذه السنة</option>
                                <option value="custom" <?php echo e($periode == 'custom' ? 'selected' : ''); ?>>فترة مخصصة</option>
                            </select>
                        </div>

                        <!-- Dates personnalisées -->
                        <div class="col-md-6 col-lg-3" id="customDatesContainer" style="display: <?php echo e($periode == 'custom' ? 'block' : 'none'); ?>;">
                            <label class="filter-label">
                                <i class="ri-calendar-2-line"></i>
                                من - إلى
                            </label>
                            <div class="date-inputs">
                                <input type="date" name="date_debut" class="filter-input" value="<?php echo e($dateDebut); ?>" placeholder="من">
                                <input type="date" name="date_fin" class="filter-input" value="<?php echo e($dateFin); ?>" placeholder="إلى">
                            </div>
                        </div>

                        <!-- Filtre Gouvernorat -->
                        <div class="col-md-6 col-lg-3">
                            <label class="filter-label">
                                <i class="ri-map-pin-line"></i>
                                الولاية
                            </label>
                            <select name="gouvernorat_id" class="filter-select" id="gouvernoratSelect">
                                <option value="all" <?php echo e($gouvernoratId == 'all' ? 'selected' : ''); ?>>كل الولايات</option>
                                <?php $__currentLoopData = $gouvernorats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gouv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($gouv->id_gouver); ?>" <?php echo e($gouvernoratId == $gouv->id_gouver ? 'selected' : ''); ?>>
                                        <?php echo e($gouv->nom_ar ?? $gouv->nom_fr); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Filtre Délégation (affiché si gouvernorat sélectionné) -->
                        <div class="col-md-6 col-lg-3" id="delegationContainer" style="display: <?php echo e($gouvernoratId != 'all' && $delegations->count() > 0 ? 'block' : 'none'); ?>;">
                            <label class="filter-label">
                                <i class="ri-map-pin-2-line"></i>
                                المعتمدية
                            </label>
                            <select name="delegation_id" class="filter-select" id="delegationSelect">
                                <option value="all" <?php echo e($delegationId == 'all' ? 'selected' : ''); ?>>كل المعتمديات</option>
                                <?php $__currentLoopData = $delegations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $deleg): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($deleg->id_delegation); ?>" <?php echo e($delegationId == $deleg->id_delegation ? 'selected' : ''); ?>>
                                        <?php echo e($deleg->nom_ar ?? $deleg->nom_fr); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </div>

                        <!-- Filtre Statut -->
                        <div class="col-md-6 col-lg-3">
                            <label class="filter-label">
                                <i class="ri-checkbox-circle-line"></i>
                                الحالة
                            </label>
                            <select name="statut" class="filter-select">
                                <option value="all" <?php echo e($statutFilter == 'all' ? 'selected' : ''); ?>>كل الحالات</option>
                                <option value="en_cours" <?php echo e($statutFilter == 'en_cours' ? 'selected' : ''); ?>>قيد المعالجة</option>
                                <option value="accepte" <?php echo e($statutFilter == 'accepte' ? 'selected' : ''); ?>>مقبولة</option>
                                <option value="refuse" <?php echo e($statutFilter == 'refuse' ? 'selected' : ''); ?>>مرفوضة</option>
                            </select>
                        </div>
                    </div>

                    <!-- Boutons d'action -->
                    <div class="filters-actions">
                        <button type="submit" class="btn-filter btn-apply">
                            <i class="ri-search-line"></i>
                            تطبيق المعايير
                        </button>
                        <a href="<?php echo e(route('admin.dashboard')); ?>" class="btn-filter btn-reset">
                            <i class="ri-refresh-line"></i>
                            إعادة تعيين
                        </a>
                    </div>
                </div>
            </div>
        </form>
    </div>

<!--<?php if($user && $hasInvestmentPermission): ?>-->
	<?php if(($user->roles->pluck('id_roles')->contains(8) && $user->gouvernorat) || $hasInvestmentPermission): ?>
    <div class="section-divider mt-5 mb-4">
        <h3 class="section-title">
            <i class="ri-line-chart-line"></i>
            إحصائيات الاستثمار
        </h3>
        <p class="section-subtitle">متابعة طلبات الاستثمار في المجال الرياضي والشبابي</p>
        <button class="btn-toggle-details" data-section="investissement">
            <i class="ri-eye-line" id="icon-investissement"></i>
            <span id="text-investissement">عرض التفاصيل</span>
        </button>
    </div>

    <!-- KPI Globaux -->
    <div class="stats-widgets mb-4">
        <div class="row g-3">
            <!-- Total des demandes -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-purple">
                    <div class="widget-content">
                        <h3 class="widget-title">إجمالي الطلبات</h3>
                        <div class="widget-value"><?php echo e($totaux['total']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: 100%"></div>
                            <span class="progress-value">جميع المشاريع</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-file-list-3-line"></i>
                    </div>
                </div>
            </div>

            <!-- Demandes en cours -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-blue">
                    <div class="widget-content">
                        <h3 class="widget-title">قيد المعالجة</h3>
                        <div class="widget-value"><?php echo e($totaux['en_cours']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: <?php echo e($totaux['total'] > 0 ? ($totaux['en_cours'] / $totaux['total'] * 100) : 0); ?>%"></div>
                            <span class="progress-value"><?php echo e($totaux['total'] > 0 ? round($totaux['en_cours'] / $totaux['total'] * 100, 1) : 0); ?>%</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-time-line"></i>
                    </div>
                </div>
            </div>

            <!-- Demandes acceptées -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-green">
                    <div class="widget-content">
                        <h3 class="widget-title">مقبولة</h3>
                        <div class="widget-value"><?php echo e($totaux['accepte']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: <?php echo e($totaux['total'] > 0 ? ($totaux['accepte'] / $totaux['total'] * 100) : 0); ?>%"></div>
                            <span class="progress-value"><?php echo e($totaux['total'] > 0 ? round($totaux['accepte'] / $totaux['total'] * 100, 1) : 0); ?>%</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-checkbox-circle-line"></i>
                    </div>
                </div>
            </div>

            <!-- Demandes refusées -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-red">
                    <div class="widget-content">
                        <h3 class="widget-title">مرفوضة</h3>
                        <div class="widget-value"><?php echo e($totaux['refuse']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: <?php echo e($totaux['total'] > 0 ? ($totaux['refuse'] / $totaux['total'] * 100) : 0); ?>%"></div>
                            <span class="progress-value"><?php echo e($totaux['total'] > 0 ? round($totaux['refuse'] / $totaux['total'] * 100, 1) : 0); ?>%</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-close-circle-line"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>
    

    <!-- KPI par Module d'Investissement -->
    <div class="row g-4 section-details section-hidden" id="details-investissement">
        <!-- Salles de Sport -->
        <div class="col-lg-6 col-xl-4">
            <div class="investment-card">
                <div class="investment-card-header">
                    <div class="investment-icon bg-sport">
                        <i class="ri-building-4-line"></i>
                    </div>
                    <div>
                        <h4 class="investment-title">قاعات رياضية</h4>
                        <p class="investment-subtitle">مشاريع البنية التحتية الرياضية</p>
                    </div>
                </div>
                <div class="investment-stats">
                    <div class="stat-item">
                        <span class="stat-label">الإجمالي</span>
                        <span class="stat-number"><?php echo e($sallesSport['total']); ?></span>
                    </div>
                    <div class="stat-item stat-pending">
                        <span class="stat-label">قيد المعالجة</span>
                        <span class="stat-number"><?php echo e($sallesSport['en_cours']); ?></span>
                    </div>
                    <div class="stat-item stat-success">
                        <span class="stat-label">مقبولة</span>
                        <span class="stat-number"><?php echo e($sallesSport['accepte']); ?></span>
                    </div>
                    <div class="stat-item stat-danger">
                        <span class="stat-label">مرفوضة</span>
                        <span class="stat-number"><?php echo e($sallesSport['refuse']); ?></span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Début d'Activité -->
        <div class="col-lg-6 col-xl-4">
            <div class="investment-card">
                <div class="investment-card-header">
                    <div class="investment-icon bg-activity">
                        <i class="ri-play-circle-line"></i>
                    </div>
                    <div>
                        <h4 class="investment-title">بداية النشاط</h4>
                        <p class="investment-subtitle">طلبات بدء النشاط الرياضي</p>
                    </div>
                </div>
                <div class="investment-stats">
                    <div class="stat-item">
                        <span class="stat-label">الإجمالي</span>
                        <span class="stat-number"><?php echo e($debutActivite['total']); ?></span>
                    </div>
                    <div class="stat-item stat-pending">
                        <span class="stat-label">قيد المعالجة</span>
                        <span class="stat-number"><?php echo e($debutActivite['en_cours']); ?></span>
                    </div>
                    <div class="stat-item stat-success">
                        <span class="stat-label">مقبولة</span>
                        <span class="stat-number"><?php echo e($debutActivite['accepte']); ?></span>
                    </div>
                    <div class="stat-item stat-danger">
                        <span class="stat-label">مرفوضة</span>
                        <span class="stat-number"><?php echo e($debutActivite['refuse']); ?></span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Jeunesse - Institutions -->
        <div class="col-lg-6 col-xl-4">
            <div class="investment-card">
                <div class="investment-card-header">
                    <div class="investment-icon bg-youth">
                        <i class="ri-community-line"></i>
                    </div>
                    <div>
                        <h4 class="investment-title">الشباب - مؤسسات</h4>
                        <p class="investment-subtitle">المؤسسات الخاصة للشباب</p>
                    </div>
                </div>
                <div class="investment-stats">
                    <div class="stat-item">
                        <span class="stat-label">الإجمالي</span>
                        <span class="stat-number"><?php echo e($jeunesseInstitutions['total']); ?></span>
                    </div>
                    <div class="stat-item stat-pending">
                        <span class="stat-label">قيد المعالجة</span>
                        <span class="stat-number"><?php echo e($jeunesseInstitutions['en_cours']); ?></span>
                    </div>
                    <div class="stat-item stat-success">
                        <span class="stat-label">مقبولة</span>
                        <span class="stat-number"><?php echo e($jeunesseInstitutions['accepte']); ?></span>
                    </div>
                    <div class="stat-item stat-danger">
                        <span class="stat-label">مرفوضة</span>
                        <span class="stat-number"><?php echo e($jeunesseInstitutions['refuse']); ?></span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Jeunesse - Activités -->
        <div class="col-lg-6 col-xl-4">
            <div class="investment-card">
                <div class="investment-card-header">
                    <div class="investment-icon bg-activities">
                        <i class="ri-group-line"></i>
                    </div>
                    <div>
                        <h4 class="investment-title">الشباب - أنشطة</h4>
                        <p class="investment-subtitle">أنشطة الشباب والطفل</p>
                    </div>
                </div>
                <div class="investment-stats">
                    <div class="stat-item">
                        <span class="stat-label">الإجمالي</span>
                        <span class="stat-number"><?php echo e($jeunesseActivites['total']); ?></span>
                    </div>
                    <div class="stat-item stat-pending">
                        <span class="stat-label">قيد المعالجة</span>
                        <span class="stat-number"><?php echo e($jeunesseActivites['en_cours']); ?></span>
                    </div>
                    <div class="stat-item stat-success">
                        <span class="stat-label">مقبولة</span>
                        <span class="stat-number"><?php echo e($jeunesseActivites['accepte']); ?></span>
                    </div>
                    <div class="stat-item stat-danger">
                        <span class="stat-label">مرفوضة</span>
                        <span class="stat-number"><?php echo e($jeunesseActivites['refuse']); ?></span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Jeune Enfant -->
        <div class="col-lg-6 col-xl-4">
            <div class="investment-card">
                <div class="investment-card-header">
                    <div class="investment-icon bg-children">
                        <i class="ri-emotion-happy-line"></i>
                    </div>
                    <div>
                        <h4 class="investment-title">الفضاءات الترفيهية للشباب و الطفولة</h4>
                        <p class="investment-subtitle">مشاريع الترفيه للأطفال</p>
                    </div>
                </div>
                <div class="investment-stats">
                    <div class="stat-item">
                        <span class="stat-label">الإجمالي</span>
                        <span class="stat-number"><?php echo e($jeuneEnfant['total']); ?></span>
                    </div>
                    <div class="stat-item stat-pending">
                        <span class="stat-label">قيد المعالجة</span>
                        <span class="stat-number"><?php echo e($jeuneEnfant['en_cours']); ?></span>
                    </div>
                    <div class="stat-item stat-success">
                        <span class="stat-label">مقبولة</span>
                        <span class="stat-number"><?php echo e($jeuneEnfant['accepte']); ?></span>
                    </div>
                    <div class="stat-item stat-danger">
                        <span class="stat-label">مرفوضة</span>
                        <span class="stat-number"><?php echo e($jeuneEnfant['refuse']); ?></span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Formation & Stage -->
        <div class="col-lg-6 col-xl-4">
            <div class="investment-card">
                <div class="investment-card-header">
                    <div class="investment-icon bg-training">
                        <i class="ri-graduation-cap-line"></i>
                    </div>
                    <div>
                        <h4 class="investment-title">التكوين والتدريب</h4>
                        <p class="investment-subtitle">الاستثمار الرياضي</p>
                    </div>
                </div>
                <div class="investment-stats">
                    <div class="stat-item">
                        <span class="stat-label">الإجمالي</span>
                        <span class="stat-number"><?php echo e($formationStage['total']); ?></span>
                    </div>
                    <div class="stat-item stat-pending">
                        <span class="stat-label">قيد المعالجة</span>
                        <span class="stat-number"><?php echo e($formationStage['en_cours']); ?></span>
                    </div>
                    <div class="stat-item stat-success">
                        <span class="stat-label">مقبولة</span>
                        <span class="stat-number"><?php echo e($formationStage['accepte']); ?></span>
                    </div>
                    <div class="stat-item stat-danger">
                        <span class="stat-label">مرفوضة</span>
                        <span class="stat-number"><?php echo e($formationStage['refuse']); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if($user && $hasFinPermission): ?>
    <div class="section-divider mt-5 mb-4">
        <h3 class="section-title">
            <i class="ri-money-dollar-circle-line"></i>
            إدارة التمويلات
        </h3>
        <p class="section-subtitle">طلبات التمويل للجمعيات والمشاريع</p>
        <button class="btn-toggle-details" data-section="financements">
            <i class="ri-eye-line" id="icon-financements"></i>
            <span id="text-financements">عرض التفاصيل</span>
        </button>
    </div>

    <!-- KPI Globaux Financements -->
    <div class="stats-widgets mb-4">
        <div class="row g-3">
            <!-- Total des financements -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-financement-total">
                    <div class="widget-content">
                        <h3 class="widget-title">إجمالي التمويلات</h3>
                        <div class="widget-value"><?php echo e($totauxFinancements['total']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: 100%"></div>
                            <span class="progress-value">جميع الطلبات</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-file-list-3-line"></i>
                    </div>
                </div>
            </div>

            <!-- Financements en cours -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-blue">
                    <div class="widget-content">
                        <h3 class="widget-title">قيد المعالجة</h3>
                        <div class="widget-value"><?php echo e($totauxFinancements['en_cours']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: <?php echo e($totauxFinancements['total'] > 0 ? ($totauxFinancements['en_cours'] / $totauxFinancements['total'] * 100) : 0); ?>%"></div>
                            <span class="progress-value"><?php echo e($totauxFinancements['total'] > 0 ? round($totauxFinancements['en_cours'] / $totauxFinancements['total'] * 100, 1) : 0); ?>%</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-time-line"></i>
                    </div>
                </div>
            </div>

            <!-- Financements acceptés -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-green">
                    <div class="widget-content">
                        <h3 class="widget-title">مقبولة</h3>
                        <div class="widget-value"><?php echo e($totauxFinancements['accepte']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: <?php echo e($totauxFinancements['total'] > 0 ? ($totauxFinancements['accepte'] / $totauxFinancements['total'] * 100) : 0); ?>%"></div>
                            <span class="progress-value"><?php echo e($totauxFinancements['total'] > 0 ? round($totauxFinancements['accepte'] / $totauxFinancements['total'] * 100, 1) : 0); ?>%</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-checkbox-circle-line"></i>
                    </div>
                </div>
            </div>

            <!-- Financements refusés -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-red">
                    <div class="widget-content">
                        <h3 class="widget-title">مرفوضة</h3>
                        <div class="widget-value"><?php echo e($totauxFinancements['refuse']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: <?php echo e($totauxFinancements['total'] > 0 ? ($totauxFinancements['refuse'] / $totauxFinancements['total'] * 100) : 0); ?>%"></div>
                            <span class="progress-value"><?php echo e($totauxFinancements['total'] > 0 ? round($totauxFinancements['refuse'] / $totauxFinancements['total'] * 100, 1) : 0); ?>%</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-close-circle-line"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Carte détaillée Financements -->
    <div class="row g-4 mb-5 section-details section-hidden" id="details-financements">
        <div class="col-lg-6 col-xl-4">
            <div class="investment-card">
                <div class="investment-card-header">
                    <div class="investment-icon bg-financement">
                        <i class="ri-money-dollar-circle-line"></i>
                    </div>
                    <div>
                        <h4 class="investment-title">طلبات التمويل</h4>
                        <p class="investment-subtitle">تمويل الجمعيات والمشاريع</p>
                    </div>
                </div>
                <div class="investment-stats">
                    <div class="stat-item">
                        <span class="stat-label">الإجمالي</span>
                        <span class="stat-number"><?php echo e($financements['total']); ?></span>
                    </div>
                    <div class="stat-item stat-pending">
                        <span class="stat-label">قيد المعالجة</span>
                        <span class="stat-number"><?php echo e($financements['en_cours']); ?></span>
                    </div>
                    <div class="stat-item stat-success">
                        <span class="stat-label">مقبولة</span>
                        <span class="stat-number"><?php echo e($financements['accepte']); ?></span>
                    </div>
                    <div class="stat-item stat-danger">
                        <span class="stat-label">مرفوضة</span>
                        <span class="stat-number"><?php echo e($financements['refuse']); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if($user && $hasManifestationPermission): ?>
    <div class="section-divider mt-5 mb-4">
        <h3 class="section-title">
            <i class="ri-trophy-line"></i>
            إدارة تنظيم التظاهرات الرياضية
        </h3>
        <p class="section-subtitle">طلبات التظاهرات الرياضية الوطنية والدولية</p>
        <button class="btn-toggle-details" data-section="manifestations">
            <i class="ri-eye-line" id="icon-manifestations"></i>
            <span id="text-manifestations">عرض التفاصيل</span>
        </button>
    </div>

    <!-- KPI Globaux Manifestations -->
    <div class="stats-widgets mb-4">
        <div class="row g-3">
            <!-- Total des manifestations -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-manifestation-total">
                    <div class="widget-content">
                        <h3 class="widget-title">إجمالي التظاهرات</h3>
                        <div class="widget-value"><?php echo e($totauxManifestations['total']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: 100%"></div>
                            <span class="progress-value">جميع التظاهرات</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-trophy-line"></i>
                    </div>
                </div>
            </div>

            <!-- Manifestations en cours -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-blue">
                    <div class="widget-content">
                        <h3 class="widget-title">قيد المعالجة</h3>
                        <div class="widget-value"><?php echo e($totauxManifestations['en_cours']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: <?php echo e($totauxManifestations['total'] > 0 ? ($totauxManifestations['en_cours'] / $totauxManifestations['total'] * 100) : 0); ?>%"></div>
                            <span class="progress-value"><?php echo e($totauxManifestations['total'] > 0 ? round($totauxManifestations['en_cours'] / $totauxManifestations['total'] * 100, 1) : 0); ?>%</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-time-line"></i>
                    </div>
                </div>
            </div>

            <!-- Manifestations acceptées -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-green">
                    <div class="widget-content">
                        <h3 class="widget-title">مقبولة</h3>
                        <div class="widget-value"><?php echo e($totauxManifestations['accepte']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: <?php echo e($totauxManifestations['total'] > 0 ? ($totauxManifestations['accepte'] / $totauxManifestations['total'] * 100) : 0); ?>%"></div>
                            <span class="progress-value"><?php echo e($totauxManifestations['total'] > 0 ? round($totauxManifestations['accepte'] / $totauxManifestations['total'] * 100, 1) : 0); ?>%</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-checkbox-circle-line"></i>
                    </div>
                </div>
            </div>

            <!-- Manifestations refusées -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-red">
                    <div class="widget-content">
                        <h3 class="widget-title">مرفوضة</h3>
                        <div class="widget-value"><?php echo e($totauxManifestations['refuse']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: <?php echo e($totauxManifestations['total'] > 0 ? ($totauxManifestations['refuse'] / $totauxManifestations['total'] * 100) : 0); ?>%"></div>
                            <span class="progress-value"><?php echo e($totauxManifestations['total'] > 0 ? round($totauxManifestations['refuse'] / $totauxManifestations['total'] * 100, 1) : 0); ?>%</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-close-circle-line"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 section-details section-hidden" id="details-manifestations">
        <!-- Manifestations Nationales -->
        <div class="col-lg-6 col-xl-4">
            <div class="investment-card">
                <div class="investment-card-header">
                    <div class="investment-icon bg-manifestation-nationale">
                        <i class="ri-flag-line"></i>
                    </div>
                    <div>
                        <h4 class="investment-title">التظاهرات الوطنية</h4>
                        <p class="investment-subtitle">طلبات التظاهرات الرياضية الوطنية</p>
                    </div>
                </div>
                <div class="investment-stats">
                    <div class="stat-item">
                        <span class="stat-label">الإجمالي</span>
                        <span class="stat-number"><?php echo e($manifestationsNationales['total']); ?></span>
                    </div>
                    <div class="stat-item stat-pending">
                        <span class="stat-label">قيد المعالجة</span>
                        <span class="stat-number"><?php echo e($manifestationsNationales['en_cours']); ?></span>
                    </div>
                    <div class="stat-item stat-success">
                        <span class="stat-label">مقبولة</span>
                        <span class="stat-number"><?php echo e($manifestationsNationales['accepte']); ?></span>
                    </div>
                    <div class="stat-item stat-danger">
                        <span class="stat-label">مرفوضة</span>
                        <span class="stat-number"><?php echo e($manifestationsNationales['refuse']); ?></span>
                    </div>
                </div>
            </div>
        </div>

        <!-- Manifestations Internationales -->
        <div class="col-lg-6 col-xl-4">
            <div class="investment-card">
                <div class="investment-card-header">
                    <div class="investment-icon bg-manifestation-internationale">
                        <i class="ri-global-line"></i>
                    </div>
                    <div>
                        <h4 class="investment-title">التظاهرات الدولية</h4>
                        <p class="investment-subtitle">طلبات التظاهرات الرياضية الدولية</p>
                    </div>
                </div>
                <div class="investment-stats">
                    <div class="stat-item">
                        <span class="stat-label">الإجمالي</span>
                        <span class="stat-number"><?php echo e($manifestationsInternationales['total']); ?></span>
                    </div>
                    <div class="stat-item stat-pending">
                        <span class="stat-label">قيد المعالجة</span>
                        <span class="stat-number"><?php echo e($manifestationsInternationales['en_cours']); ?></span>
                    </div>
                    <div class="stat-item stat-success">
                        <span class="stat-label">مقبولة</span>
                        <span class="stat-number"><?php echo e($manifestationsInternationales['accepte']); ?></span>
                    </div>
                    <div class="stat-item stat-danger">
                        <span class="stat-label">مرفوضة</span>
                        <span class="stat-number"><?php echo e($manifestationsInternationales['refuse']); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php endif; ?>

<?php if(($user->roles->pluck('id_roles')->contains(7) && $user->auberge) || $hasAubergePermission): ?>
    <!-- Section Réservations et Auberges -->
    <div class="section-divider mt-5 mb-4">
        <h3 class="section-title">
            <i class="ri-hotel-bed-line"></i>
            إحصائيات الحجوزات والإقامة
        </h3>
         <p class="section-subtitle">
            إدارة الحجوزات
            <?php if($user->roles->pluck('id_roles')->contains(7) && $user->auberge): ?>
                <?php echo e($user->auberge->nom_ar); ?>

            <?php else: ?>
                والمركبات ومراكز إقامة الشباب
            <?php endif; ?>
        </p>
        <button class="btn-toggle-details" data-section="reservations">
            <i class="ri-eye-line" id="icon-reservations"></i>
            <span id="text-reservations">عرض التفاصيل</span>
        </button>
    </div>

    <!-- KPI Globaux Réservations & Auberges -->
    <div class="stats-widgets mb-4">
        <div class="row g-3">
            <!-- Total des réservations -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-reservation-total">
                    <div class="widget-content">
                        <h3 class="widget-title">إجمالي الحجوزات</h3>
                        <div class="widget-value"><?php echo e($totauxReservations['total']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: 100%"></div>
                            <span class="progress-value">جميع الحجوزات</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-calendar-check-line"></i>
                    </div>
                </div>
            </div>

            <!-- Réservations en cours -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-blue">
                    <div class="widget-content">
                        <h3 class="widget-title">قيد المعالجة</h3>
                        <div class="widget-value"><?php echo e($totauxReservations['en_cours']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: <?php echo e($totauxReservations['total'] > 0 ? ($totauxReservations['en_cours'] / $totauxReservations['total'] * 100) : 0); ?>%"></div>
                            <span class="progress-value"><?php echo e($totauxReservations['total'] > 0 ? round($totauxReservations['en_cours'] / $totauxReservations['total'] * 100, 1) : 0); ?>%</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-time-line"></i>
                    </div>
                </div>
            </div>


            <!-- Total auberges -->
            <?php if(!($user->roles->pluck('id_roles')->contains(7) && $user->auberge)): ?>
                <div class="col-md-6 col-xl-3">
                    <div class="stat-widget gradient-auberge-total">
                        <div class="widget-content">
                            <h3 class="widget-title">مراكز الإقامة</h3>
                            <div class="widget-value"><?php echo e($totauxReservations['total_auberges']); ?></div>
                            <div class="widget-progress">
                                <div class="progress-bar" style="width: 100%"></div>
                                <span class="progress-value">مركز نشط</span>
                            </div>
                        </div>
                        <div class="widget-icon">
                            <i class="ri-hotel-line"></i>
                        </div>
                    </div>
                </div>
            <?php endif; ?>


            <!-- Capacité totale -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-capacity">
                    <div class="widget-content">
                        <h3 class="widget-title">السعة الإجمالية</h3>
                        <div class="widget-value"><?php echo e($totauxReservations['capacite_totale']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: 100%"></div>
                            <span class="progress-value">سرير</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-user-3-line"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <div class="row g-4 section-details section-hidden" id="details-reservations">
        <!-- Réservations -->
        <div class="col-lg-6 col-xl-4">
            <div class="investment-card">
                <div class="investment-card-header">
                    <div class="investment-icon bg-reservation">
                        <i class="ri-calendar-check-line"></i>
                    </div>
                    <div>
                        <h4 class="investment-title">إدارة الحجوزات</h4>
                        <p class="investment-subtitle">حجوزات مراكز الإقامة</p>
                    </div>
                </div>
                <div class="investment-stats">
                    <div class="stat-item">
                        <span class="stat-label">الإجمالي</span>
                        <span class="stat-number"><?php echo e($totauxReservations['total']); ?></span>
                    </div>
                    <div class="stat-item stat-pending">
                        <span class="stat-label">قيد المعالجة</span>
                        <span class="stat-number"><?php echo e($totauxReservations['en_cours']); ?></span>
                    </div>
                    <div class="stat-item stat-success">
                        <span class="stat-label">مقبولة</span>
                        <span class="stat-number"><?php echo e($totauxReservations['accepte']); ?></span>
                    </div>
                    <div class="stat-item stat-danger">
                        <span class="stat-label">مرفوضة</span>
                        <span class="stat-number"><?php echo e($totauxReservations['refuse']); ?></span>
                    </div>
                </div>
            </div>
        </div>


        <!-- Auberges -->
        <?php if(!($user->roles->pluck('id_roles')->contains(7) && $user->auberge)): ?>
            <div class="col-lg-6 col-xl-4">
                <div class="investment-card">
                    <div class="investment-card-header">
                        <div class="investment-icon bg-auberge">
                            <i class="ri-hotel-line"></i>
                        </div>
                        <div>
                            <h4 class="investment-title">مراكز الإقامة</h4>
                            <p class="investment-subtitle">المركبات ومراكز إقامة الشباب</p>
                        </div>
                    </div>
                    <div class="investment-stats">
                        <div class="stat-item">
                            <span class="stat-label">الإجمالي</span>
                            <span class="stat-number"><?php echo e($auberges['total']); ?></span>
                        </div>
                        <div class="stat-item stat-info">
                            <span class="stat-label">EPA</span>
                            <span class="stat-number"><?php echo e($auberges['epa']); ?></span>
                        </div>
                        <div class="stat-item stat-info">
                            <span class="stat-label">غير EPA</span>
                            <span class="stat-number"><?php echo e($auberges['non_epa']); ?></span>
                        </div>
                        <div class="stat-item stat-capacity">
                            <span class="stat-label">السعة الإجمالية</span>
                            <span class="stat-number"><?php echo e($auberges['capacite_totale']); ?></span>
                        </div>
                    </div>
                </div>
            </div>
        <?php endif; ?>


    </div>
<?php endif; ?>

<?php if($user && $user->hasPermission(1)): ?>
    <!-- Section Concours -->
    <div class="section-divider mt-5 mb-4">
        <h3 class="section-title">
            <i class="ri-medal-line"></i>
            إدارة المناظرات
        </h3>
        <p class="section-subtitle">المناظرات وطلبات الترشح</p>
        <button class="btn-toggle-details" data-section="concours">
            <i class="ri-eye-line" id="icon-concours"></i>
            <span id="text-concours">عرض التفاصيل</span>
        </button>
    </div>

    <!-- KPI Globaux Concours -->
    <div class="stats-widgets mb-4">
        <div class="row g-3">
            <!-- Total concours -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-concours-total">
                    <div class="widget-content">
                        <h3 class="widget-title">إجمالي المناظرات</h3>
                        <div class="widget-value"><?php echo e($totauxConcours['total_concours']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: 100%"></div>
                            <span class="progress-value">مناظرة مفتوحة</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-trophy-line"></i>
                    </div>
                </div>
            </div>

            <!-- Total candidats -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-candidats">
                    <div class="widget-content">
                        <h3 class="widget-title">إجمالي المترشحين</h3>
                        <div class="widget-value"><?php echo e($totauxConcours['total_candidats']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: 100%"></div>
                            <span class="progress-value">مترشح</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-user-star-line"></i>
                    </div>
                </div>
            </div>

            <!-- En cours -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-blue">
                    <div class="widget-content">
                        <h3 class="widget-title">قيد الدراسة</h3>
                        <div class="widget-value"><?php echo e($totauxConcours['en_cours']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: <?php echo e($totauxConcours['total_candidats'] > 0 ? ($totauxConcours['en_cours'] / $totauxConcours['total_candidats'] * 100) : 0); ?>%"></div>
                            <span class="progress-value"><?php echo e($totauxConcours['total_candidats'] > 0 ? round($totauxConcours['en_cours'] / $totauxConcours['total_candidats'] * 100, 1) : 0); ?>%</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-time-line"></i>
                    </div>
                </div>
            </div>

            <!-- Acceptés définitif -->
            <div class="col-md-6 col-xl-3">
                <div class="stat-widget gradient-green">
                    <div class="widget-content">
                        <h3 class="widget-title">قبول نهائي</h3>
                        <div class="widget-value"><?php echo e($totauxConcours['accepte_definitif']); ?></div>
                        <div class="widget-progress">
                            <div class="progress-bar" style="width: <?php echo e($totauxConcours['total_candidats'] > 0 ? ($totauxConcours['accepte_definitif'] / $totauxConcours['total_candidats'] * 100) : 0); ?>%"></div>
                            <span class="progress-value"><?php echo e($totauxConcours['total_candidats'] > 0 ? round($totauxConcours['accepte_definitif'] / $totauxConcours['total_candidats'] * 100, 1) : 0); ?>%</span>
                        </div>
                    </div>
                    <div class="widget-icon">
                        <i class="ri-checkbox-circle-line"></i>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Carte détaillée Concours -->
    <div class="row g-4 mb-5 section-details section-hidden" id="details-concours">
        <div class="col-lg-6 col-xl-4">
            <div class="investment-card">
                <div class="investment-card-header">
                    <div class="investment-icon bg-concours">
                        <i class="ri-medal-line"></i>
                    </div>
                    <div>
                        <h4 class="investment-title">المناظرات</h4>
                        <p class="investment-subtitle">إدارة المناظرات والمترشحين</p>
                    </div>
                </div>
                <div class="investment-stats">
                    <div class="stat-item">
                        <span class="stat-label">مترشحين</span>
                        <span class="stat-number"><?php echo e($concours['total_candidats']); ?></span>
                    </div>
                    <div class="stat-item stat-pending">
                        <span class="stat-label">قيد الدراسة</span>
                        <span class="stat-number"><?php echo e($concours['en_cours']); ?></span>
                    </div>
                    <div class="stat-item stat-success">
                        <span class="stat-label">قبول نهائي</span>
                        <span class="stat-number"><?php echo e($concours['accepte_definitif']); ?></span>
                    </div>
                    <div class="stat-item stat-danger">
                        <span class="stat-label">مرفوض</span>
                        <span class="stat-number"><?php echo e($concours['refuse']); ?></span>
                    </div>
                </div>
            </div>
        </div>
    </div>

<?php endif; ?>

    <style>
    /* ========== DASHBOARD HEADER ========== */
    .dashboard-header-section {
        margin-bottom: 2rem;
    }

    .dashboard-title {
        font-size: 1.75rem;
        font-weight: 700;
        color: #1a237e;
        font-family: 'Cairo', sans-serif;
        display: flex;
        align-items: center;
        gap: 0.75rem;
        margin-bottom: 0.5rem;
    }

    .dashboard-title i {
        color: #e42125;
    }

    .dashboard-subtitle {
        color: #666;
        font-size: 1rem;
        margin: 0;
    }

    /* ========== SECTION DIVIDER ========== */
    .section-divider {
        text-align: center;
        padding: 2rem 0;
        position: relative;
    }

    .btn-toggle-details {
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        padding: 0.6rem 1.5rem;
        margin-top: 1rem;
        background: linear-gradient(135deg, #667eea, #764ba2);
        color: white;
        border: none;
        border-radius: 50px;
        font-size: 0.95rem;
        font-weight: 600;
        cursor: pointer;
        transition: all 0.3s ease;
        box-shadow: 0 4px 15px rgba(102, 126, 234, 0.3);
    }

    .btn-toggle-details:hover {
        transform: translateY(-2px);
        box-shadow: 0 6px 20px rgba(102, 126, 234, 0.4);
        background: linear-gradient(135deg, #764ba2, #667eea);
    }

    .btn-toggle-details:active {
        transform: translateY(0);
    }

    .btn-toggle-details i {
        font-size: 1.1rem;
        transition: transform 0.3s ease;
    }

    .section-details {
        transition: all 0.4s ease;
        overflow: hidden;
    }

    .section-hidden {
        display: none !important;
    }

    .section-visible {
        display: flex !important;
    }

    .section-divider {
        text-align: center;
        padding: 2rem 0;
        position: relative;
    }

    .section-divider::before {
        content: '';
        position: absolute;
        top: 53%;
        left: 0;
        right: 0;
        height: 2px;
        background: linear-gradient(90deg, transparent, rgba(228, 33, 37, 0.2), transparent);
        z-index: 0;
    }

    .section-title {
        font-size: 1.5rem;
        font-weight: 700;
        color: #1a237e;
        font-family: 'Cairo', sans-serif;
        display: inline-flex;
        align-items: center;
        gap: 0.75rem;
        margin-bottom: 0.5rem;
        background: white;
        padding: 0 2rem;
        position: relative;
        z-index: 1;
    }

    .section-title i {
        color: #e42125;
        font-size: 1.75rem;
    }

    .section-subtitle {
        color: #666;
        font-size: 0.95rem;
        margin: 0.5rem 0 0 0;
        font-family: 'Cairo', sans-serif;
    }

    /* ========== KPI GLOBAUX ========== */
    .stats-widgets {
        padding: 1rem 0;
    }

    .stat-widget {
        position: relative;
        padding: 1.5rem;
        border-radius: 16px;
        overflow: hidden;
        color: white;
        min-height: 140px;
        box-shadow: 0 4px 20px rgba(0, 0, 0, 0.08);
        transition: all 0.3s ease;
    }

    .stat-widget:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
    }

    .gradient-purple {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
    }

    .gradient-blue {
        background: linear-gradient(135deg, #1a237e, #3f51b5);
    }

    .gradient-green {
        background: linear-gradient(135deg, #10b981, #059669);
    }

    .gradient-red {
        background: linear-gradient(135deg, #e42125, #c51b1f);
    }

    .gradient-manifestation-total {
        background: linear-gradient(135deg, #ffd89b, #19547b);
    }

    .gradient-reservation-total {
        background: linear-gradient(135deg, #fa709a, #fee140);
    }

    .gradient-auberge-total {
        background: linear-gradient(135deg, #30cfd0, #330867);
    }

    .gradient-capacity {
        background: linear-gradient(135deg, #43e97b, #38f9d7);
    }

    .gradient-financement-total {
        background: linear-gradient(135deg, #f093fb, #f5576c);
    }

    .gradient-concours-total {
        background: linear-gradient(135deg, #fbc2eb, #a6c1ee);
    }

    .gradient-candidats {
        background: linear-gradient(135deg, #fdcbf1, #e6dee9);
    }

    .widget-content {
        position: relative;
        z-index: 1;
    }

    .widget-title {
        font-size: 1rem;
        font-weight: 500;
        margin-bottom: 1rem;
        color: #ffffff !important;
        font-family: 'Cairo', sans-serif;
        opacity: 0.9;
    }

    .widget-value {
        font-size: 2.5rem;
        font-weight: 700;
        margin-bottom: 1rem;
        font-family: 'Cairo', sans-serif;
    }

    .widget-progress {
        display: flex;
        align-items: center;
        gap: 1rem;
    }

    .widget-progress .progress-bar {
        flex: 1;
        height: 6px;
        background: rgba(255, 255, 255, 0.3);
        border-radius: 3px;
        overflow: hidden;
    }

    .widget-progress .progress-value {
        font-size: 0.875rem;
        font-weight: 600;
        white-space: nowrap;
    }

    .widget-icon {
        position: absolute;
        left: 1.5rem;
        bottom: 1.5rem;
        font-size: 3.5rem;
        opacity: 0.15;
    }

    .stat-widget::before {
        content: '';
        position: absolute;
        top: 0;
        right: 0;
        width: 100%;
        height: 100%;
        background: radial-gradient(circle at top right, rgba(255,255,255,0.15) 0%, rgba(255,255,255,0) 70%);
    }

    /* ========== CARTES D'INVESTISSEMENT ========== */
    .investment-card {
        background: white;
        border-radius: 16px;
        padding: 1.5rem;
        box-shadow: 0 2px 15px rgba(0, 0, 0, 0.06);
        transition: all 0.3s ease;
        border: 1px solid rgba(0, 0, 0, 0.05);
        height: 100%;
        display: flex;
        flex-direction: column;
        min-height: 320px;
    }

    .investment-card:hover {
        transform: translateY(-5px);
        box-shadow: 0 8px 30px rgba(0, 0, 0, 0.12);
    }

    .investment-card-header {
        display: flex;
        align-items: center;
        gap: 1rem;
        margin-bottom: 1.5rem;
        padding-bottom: 1rem;
        border-bottom: 2px solid #f0f0f0;
    }

    .investment-icon {
        width: 60px;
        height: 60px;
        border-radius: 12px;
        display: flex;
        align-items: center;
        justify-content: center;
        font-size: 1.75rem;
        color: white;
        flex-shrink: 0;
    }

    .bg-sport {
        background: linear-gradient(135deg, #e42125, #c51b1f);
    }

    .bg-activity {
        background: linear-gradient(135deg, #1a237e, #3f51b5);
    }

    .bg-youth {
        background: linear-gradient(135deg, #667eea, #764ba2);
    }

    .bg-activities {
        background: linear-gradient(135deg, #f093fb, #f5576c);
    }

    .bg-children {
        background: linear-gradient(135deg, #4facfe, #00f2fe);
    }

    .bg-training {
        background: linear-gradient(135deg, #43e97b, #38f9d7);
    }

    .bg-reservation {
        background: linear-gradient(135deg, #fa709a, #fee140);
    }

    .bg-auberge {
        background: linear-gradient(135deg, #30cfd0, #330867);
    }

    .bg-manifestation-nationale {
        background: linear-gradient(135deg, #ffd89b, #19547b);
    }

    .bg-manifestation-internationale {
        background: linear-gradient(135deg, #a8edea, #fed6e3);
    }

    .bg-financement {
        background: linear-gradient(135deg, #f093fb, #f5576c);
    }

    .bg-concours {
        background: linear-gradient(135deg, #fbc2eb, #a6c1ee);
    }

    .investment-title {
        font-size: 1.25rem;
        font-weight: 700;
        color: #1a237e;
        margin: 0;
        font-family: 'Cairo', sans-serif;
    }

    .investment-subtitle {
        font-size: 0.875rem;
        color: #666;
        margin: 0.25rem 0 0 0;
        font-family: 'Cairo', sans-serif;
    }

    .investment-stats {
        display: grid;
        grid-template-columns: repeat(2, 1fr);
        gap: 1rem;
        flex: 1;
        align-content: start;
    }

    .stat-item {
        padding: 1rem;
        background: #f8f9fa;
        border-radius: 10px;
        text-align: center;
        transition: all 0.3s ease;
    }

    .stat-item:hover {
        background: #e8e9ea;
        transform: scale(1.05);
    }

    .stat-item.stat-pending {
        background: rgba(26, 35, 126, 0.05);
        border: 1px solid rgba(26, 35, 126, 0.1);
    }

    .stat-item.stat-success {
        background: rgba(16, 185, 129, 0.05);
        border: 1px solid rgba(16, 185, 129, 0.1);
    }

    .stat-item.stat-danger {
        background: rgba(228, 33, 37, 0.05);
        border: 1px solid rgba(228, 33, 37, 0.1);
    }

    .stat-item.stat-info {
        background: rgba(63, 81, 181, 0.05);
        border: 1px solid rgba(63, 81, 181, 0.1);
    }

    .stat-item.stat-capacity {
        background: rgba(67, 233, 123, 0.05);
        border: 1px solid rgba(67, 233, 123, 0.1);
    }

    .stat-label {
        display: block;
        font-size: 0.875rem;
        color: #666;
        margin-bottom: 0.5rem;
        font-family: 'Cairo', sans-serif;
    }

    .stat-number {
        display: block;
        font-size: 1.75rem;
        font-weight: 700;
        color: #1a237e;
        font-family: 'Cairo', sans-serif;
    }

    .stat-item.stat-pending .stat-number {
        color: #1a237e;
    }

    .stat-item.stat-success .stat-number {
        color: #10b981;
    }

    .stat-item.stat-danger .stat-number {
        color: #e42125;
    }

    .stat-item.stat-info .stat-number {
        color: #3f51b5;
    }

    .stat-item.stat-capacity .stat-number {
        color: #43e97b;
    }

    /* ========== RESPONSIVE ========== */
    @media (max-width: 1200px) {
        .investment-stats {
            grid-template-columns: repeat(2, 1fr);
        }
    }

    @media (max-width: 768px) {
        .dashboard-title {
            font-size: 1.5rem;
        }

        .widget-value {
            font-size: 2rem;
        }

        .investment-card-header {
            flex-direction: column;
            text-align: center;
        }

        .investment-stats {
            grid-template-columns: 1fr;
        }

        .stat-number {
            font-size: 1.5rem;
        }
    }

    /* ========== DARK MODE ========== */
    [data-theme='dark'] .dashboard-title {
        color: white;
    }

    [data-theme='dark'] .dashboard-subtitle {
        color: #888;
    }

    [data-theme='dark'] .section-title {
        color: white;
        background: #1a1a1a;
    }

    [data-theme='dark'] .section-subtitle {
        color: #888;
    }

    [data-theme='dark'] .investment-card {
        background: #1a1a1a;
        border-color: #333;
    }

    [data-theme='dark'] .investment-card-header {
        border-bottom-color: #333;
    }

    [data-theme='dark'] .investment-title {
        color: white;
    }

    [data-theme='dark'] .investment-subtitle {
        color: #888;
    }

    [data-theme='dark'] .stat-item {
        background: #2a2a2a;
    }

    [data-theme='dark'] .stat-item:hover {
        background: #333;
    }

    [data-theme='dark'] .stat-label {
        color: #888;
    }

    [data-theme='dark'] .stat-number {
        color: white;
    }

    /* ========== FILTRES ========== */
    .filters-container {
        margin-bottom: 2rem;
    }

    .filters-card {
        background: white;
        border-radius: 12px;
        box-shadow: 0 2px 12px rgba(0,0,0,0.08);
        overflow: hidden;
        border: 1px solid #e9ecef;
    }

    .filters-header {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        padding: 1rem 1.5rem;
        display: flex;
        align-items: center;
        gap: 0.75rem;
        color: white;
    }

    .filters-header i {
        font-size: 1.5rem;
    }

    .filters-header h3 {
        margin: 0;
        font-size: 1.1rem;
        font-weight: 600;
        font-family: 'Cairo', sans-serif;
    }

    .filters-body {
        padding: 1.5rem;
    }

    .filter-label {
        display: flex;
        align-items: center;
        gap: 0.5rem;
        font-size: 0.9rem;
        font-weight: 600;
        color: #495057;
        margin-bottom: 0.5rem;
        font-family: 'Cairo', sans-serif;
    }

    .filter-label i {
        color: #667eea;
        font-size: 1.1rem;
    }

    .filter-select,
    .filter-input {
        width: 100%;
        padding: 0.65rem 1rem;
        border: 2px solid #e9ecef;
        border-radius: 8px;
        font-size: 0.95rem;
        font-family: 'Cairo', sans-serif;
        transition: all 0.3s ease;
        background: white;
    }

    .filter-select:focus,
    .filter-input:focus {
        outline: none;
        border-color: #667eea;
        box-shadow: 0 0 0 3px rgba(102, 126, 234, 0.1);
    }

    .date-inputs {
        display: flex;
        gap: 0.5rem;
    }

    .date-inputs .filter-input {
        flex: 1;
    }

    .filters-actions {
        margin-top: 1.5rem;
        display: flex;
        gap: 1rem;
        justify-content: center;
    }

    .btn-filter {
        padding: 0.75rem 2rem;
        border-radius: 8px;
        font-size: 1rem;
        font-weight: 600;
        font-family: 'Cairo', sans-serif;
        border: none;
        cursor: pointer;
        display: inline-flex;
        align-items: center;
        gap: 0.5rem;
        transition: all 0.3s ease;
        text-decoration: none;
    }

    .btn-apply {
        background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        color: white;
    }

    .btn-apply:hover {
        transform: translateY(-2px);
        box-shadow: 0 4px 12px rgba(102, 126, 234, 0.4);
    }

    .btn-reset {
        background: #f8f9fa;
        color: #6c757d;
        border: 2px solid #e9ecef;
    }

    .btn-reset:hover {
        background: #e9ecef;
        color: #495057;
    }

    .btn-filter i {
        font-size: 1.1rem;
    }

    /* Dark mode pour les filtres */
    [data-theme='dark'] .filters-card {
        background: #1a1a1a;
        border-color: #333;
    }

    [data-theme='dark'] .filter-label {
        color: #e1e1e1;
    }

    [data-theme='dark'] .filter-select,
    [data-theme='dark'] .filter-input {
        background: #2a2a2a;
        border-color: #333;
        color: #e1e1e1;
    }

    [data-theme='dark'] .btn-reset {
        background: #2a2a2a;
        color: #e1e1e1;
        border-color: #333;
    }

    [data-theme='dark'] .btn-reset:hover {
        background: #333;
    }

    /* ========== RESPONSIVE MOBILE ========== */
    @media (max-width: 767px) {
        /* Dashboard Header */
        .dashboard-title {
            font-size: 1.4rem;
            gap: 0.5rem;
        }
        
        .dashboard-title i {
            font-size: 1.3rem;
        }
        
        .dashboard-subtitle {
            font-size: 0.9rem;
        }

        /* KPI Widgets Globaux */
        .stat-widget {
            padding: 1rem;
            margin-bottom: 0.75rem;
        }
        
        .widget-title {
            font-size: 0.85rem;
            margin-bottom: 0.4rem;
        }
        
        .widget-value {
            font-size: 1.6rem;
            margin-bottom: 0.5rem;
        }
        
        .widget-icon {
            width: 50px;
            height: 50px;
        }
        
        .widget-icon i {
            font-size: 1.5rem;
        }
        
        .widget-progress {
            margin-top: 0.5rem;
        }
        
        .progress-value {
            font-size: 0.75rem;
        }

        /* Section Divider */
        .section-divider {
            padding: 1.5rem 0;
        }
        
        .section-title {
            font-size: 1.2rem;
            padding: 0 1rem;
            gap: 0.5rem;
        }
        
        .section-title i {
            font-size: 1.4rem;
        }
        
        .section-subtitle {
            font-size: 0.85rem;
            padding: 0 1rem;
        }

        /* Boutons Toggle */
        .btn-toggle-details {
            padding: 0.5rem 1.2rem;
            font-size: 0.85rem;
            margin-top: 0.75rem;
        }
        
        .btn-toggle-details i {
            font-size: 1rem;
        }

        /* Investment Cards */
        .investment-card {
            margin-bottom: 1rem;
        }
        
        .investment-card-header {
            padding: 1rem;
        }
        
        .investment-icon {
            width: 45px;
            height: 45px;
            font-size: 1.3rem;
        }
        
        .investment-title {
            font-size: 1rem;
        }
        
        .investment-subtitle {
            font-size: 0.8rem;
        }
        
        .investment-stats {
            padding: 1rem;
            gap: 0.5rem;
        }
        
        .stat-item {
            padding: 0.75rem;
        }
        
        .stat-label {
            font-size: 0.75rem;
        }
        
        .stat-number {
            font-size: 1.3rem;
        }

        /* Optimisation grille mobile */
        .row.g-4 {
            gap: 0.75rem !important;
        }
    }

    /* Petits mobiles (< 576px) */
    @media (max-width: 575px) {
        .dashboard-header-section {
            margin-bottom: 1.5rem;
        }
        
        .dashboard-title {
            font-size: 1.25rem;
        }
        
        .widget-value {
            font-size: 1.4rem;
        }
        
        .section-title {
            font-size: 1.1rem;
        }
        
        .investment-title {
            font-size: 0.95rem;
        }
        
        .stat-number {
            font-size: 1.2rem;
        }
    }

    /* Tablettes (768px - 991px) */
    @media (min-width: 768px) and (max-width: 991px) {
        .stat-widget {
            padding: 1.25rem;
        }
        
        .widget-value {
            font-size: 1.8rem;
        }
        
        .investment-card {
            min-height: 280px;
        }
    }
    </style>

    <script>
    // Attacher les event listeners aux boutons
    document.addEventListener('DOMContentLoaded', function() {
        // Gestion de l'affichage des dates personnalisées
        const periodeSelect = document.getElementById('periodeSelect');
        const customDatesContainer = document.getElementById('customDatesContainer');
        
        if (periodeSelect && customDatesContainer) {
            periodeSelect.addEventListener('change', function() {
                if (this.value === 'custom') {
                    customDatesContainer.style.display = 'block';
                } else {
                    customDatesContainer.style.display = 'none';
                }
            });
        }

        // Gestion du filtre délégation en cascade avec gouvernorat
        const gouvernoratSelect = document.getElementById('gouvernoratSelect');
        const delegationContainer = document.getElementById('delegationContainer');
        const delegationSelect = document.getElementById('delegationSelect');
        
        if (gouvernoratSelect && delegationContainer && delegationSelect) {
            gouvernoratSelect.addEventListener('change', function() {
                const gouvernoratId = this.value;
                
                if (gouvernoratId === 'all') {
                    delegationContainer.style.display = 'none';
                    delegationSelect.value = 'all';
                } else {
                    // Charger les délégations via AJAX
                    fetch('/admin/delegations/' + gouvernoratId)
                        .then(response => response.json())
                        .then(data => {
                            delegationSelect.innerHTML = '<option value="all">كل المعتمديات</option>';
                            data.forEach(deleg => {
                                const option = document.createElement('option');
                                option.value = deleg.id_delegation;
                                option.textContent = deleg.nom_ar || deleg.nom_fr;
                                delegationSelect.appendChild(option);
                            });
                            delegationContainer.style.display = 'block';
                        })
                        .catch(error => console.error('Erreur:', error));
                }
            });
        }

        // Attacher les clicks aux boutons
        const toggleButtons = document.querySelectorAll('.btn-toggle-details');
        
        toggleButtons.forEach(button => {
            button.addEventListener('click', function(e) {
                e.preventDefault();
                e.stopPropagation();
                const sectionName = this.getAttribute('data-section');
                if (typeof window.toggleDashboardSection === 'function') {
                    window.toggleDashboardSection(sectionName);
                }
            });
        });
        
        // Restaurer l'état des sections
        const sections = ['investissement', 'financements', 'manifestations', 'reservations', 'concours'];
        
        sections.forEach(sectionName => {
            const state = localStorage.getItem('section-' + sectionName);
            
            if (state === 'open') {
                // Ouvrir la section sans animation
                const details = document.getElementById('details-' + sectionName);
                const icon = document.getElementById('icon-' + sectionName);
                const text = document.getElementById('text-' + sectionName);
                
                if (details && icon && text) {
                    details.classList.remove('section-hidden');
                    details.classList.add('section-visible');
                    details.style.opacity = '1';
                    details.style.transform = 'translateY(0)';
                    icon.className = 'ri-eye-off-line';
                    text.textContent = 'إخفاء التفاصيل';
                }
            }
        });
        

    });
    </script>
</div>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/dashboard-content.blade.php ENDPATH**/ ?>