<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire.css')); ?>">

<?php if(Auth::check()): ?>

<div class="container">
    <style>
        .numero-cadre {
            display: inline-block;
            width: 25px;
            height: 25px;
            line-height: 25px;
            margin-right: 5px;
            text-align: center;
            border-radius: 5px;
            font-family: Arial, sans-serif;
            font-weight: bold;
            font-size: 12px;
            color: #ffffff;
            background-color: #d82b2a;
            vertical-align: middle;
        }
    </style>
    
    <form action="<?php echo e(route('auberges.update', $auberge->id)); ?>" method="POST" enctype="multipart/form-data" lang="ar">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>  
        
        <h3 class="mb-4 text-center"> تعديل معلومات مركب أو مركز إقامة </h3>
        <h4 class="mt-3">المعطيات</h4>

        <div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> الإسم بالعربية<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input name="nom_ar" type="text" class="form-control <?php $__errorArgs = ['nom_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"  
					   value="<?php echo e(old('nom_ar', $auberge->nom_ar)); ?>">
				<?php $__errorArgs = ['nom_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>

			<label class="col-sm-2 col-form-label"> الإسم بالفرنسية<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input name="nom_fr" type="text" class="form-control <?php $__errorArgs = ['nom_fr'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"  
					   value="<?php echo e(old('nom_fr', $auberge->nom_fr)); ?>">
				<?php $__errorArgs = ['nom_fr'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> الإسم بالإنقليزية<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input name="nom_en" type="text" class="form-control <?php $__errorArgs = ['nom_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"  
					   value="<?php echo e(old('nom_en', $auberge->nom_en)); ?>">
				<?php $__errorArgs = ['nom_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>

			<label class="col-sm-2 col-form-label"> الصبغة <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="epa" class="form-control <?php $__errorArgs = ['epa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
					<option value="">-- اختر الصبغة --</option>
					<option value="EPA" <?php echo e(old('epa', $auberge->epa) == 'EPA' ? 'selected' : ''); ?>>EPA</option>
					<option value="Non EPA" <?php echo e(old('epa', $auberge->epa) == 'Non EPA' ? 'selected' : ''); ?>>Non EPA</option>
				</select>
				<?php $__errorArgs = ['epa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>
		</div>


        <div class="form-group mt-3">
			<label for="description_ar" class="col-sm-6 col-form-label">تعريف المركز بالعربية<span class="text-danger">*</span></label>
			<textarea name="description_ar" id="description_ar" class="form-control <?php $__errorArgs = ['description_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="4"><?php echo e(old('description_ar', $auberge->description_ar ?? '')); ?></textarea>
			<?php $__errorArgs = ['description_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
				<span class="text-danger small"><?php echo e($message); ?></span>
			<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
		</div>

		<div class="form-group mt-3">
			<label for="description_fr" class="col-sm-6 col-form-label">تعريف المركز بالفرنسية<span class="text-danger">*</span></label>
			<textarea name="description_fr" id="description_fr" class="form-control <?php $__errorArgs = ['description_fr'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="4"><?php echo e(old('description_fr', $auberge->description_fr ?? '')); ?></textarea>
			<?php $__errorArgs = ['description_fr'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
				<span class="text-danger small"><?php echo e($message); ?></span>
			<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
		</div>

		<div class="form-group mt-3">
			<label for="description_en" class="col-sm-6 col-form-label">تعريف المركز بالإنقليزية<span class="text-danger">*</span></label>
			<textarea name="description_en" id="description_en" class="form-control <?php $__errorArgs = ['description_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" rows="4"><?php echo e(old('description_en', $auberge->description_en ?? '')); ?></textarea>
			<?php $__errorArgs = ['description_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
				<span class="text-danger small"><?php echo e($message); ?></span>
			<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">خط العرض (Latitude)<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="latitude" class="form-control <?php $__errorArgs = ['latitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
					   value="<?php echo e(old('latitude', $auberge->latitude ?? '')); ?>"
					   placeholder="مثلاً: 36.8065">
				<?php $__errorArgs = ['latitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>

			<label class="col-sm-2 col-form-label">خط الطول (Longitude)<span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="longitude" class="form-control <?php $__errorArgs = ['longitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
					   value="<?php echo e(old('longitude', $auberge->longitude ?? '')); ?>"
					   placeholder="مثلاً: 10.1815">
				<?php $__errorArgs = ['longitude'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>
		</div>

		<div class="row mt-3">
			<div class="col-12">
				<h5 class="text-end">تحديد موقع المركز على الخريطة</h5>
			</div>
		</div>
		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">X (خط العرض) تلقائي</label>
			<div class="col-sm-4">
				<input type="text" name="x" 
					   class="form-control" 
					   value="<?php echo e(old('x', $auberge->x)); ?>">
				<?php $__errorArgs = ['x'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>
			<label class="col-sm-2 col-form-label">Y (خط الطول) تلقائي</label>
			<div class="col-sm-4">
				<input type="text" name="y" 
					   class="form-control" 
					   value="<?php echo e(old('y', $auberge->y)); ?>">
				<?php $__errorArgs = ['y'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>
		</div>
		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">رابط Google Map</label>
			<div class="col-sm-10">
				<input type="text" name="map_link" 
					   class="form-control" 
					   value="<?php echo e(old('map_link', $auberge->map_link ?: 'https://maps.google.com/?q='.$auberge->x.','.$auberge->y)); ?>">
			</div>
		</div>


        <div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">الوسط الذي توجد به المؤسسة <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="id_milieu_auberge" class="form-control <?php $__errorArgs = ['id_milieu_auberge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">
					<option value="">-- اختر الوسط --</option>
					<?php $__currentLoopData = $milieux; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $milieu): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<option value="<?php echo e($milieu->id_type); ?>" <?php echo e(old('id_milieu_auberge', $auberge->id_milieu_auberge) == $milieu->id_type ? 'selected' : ''); ?>>
							<?php echo e($milieu->type_ar); ?>

						</option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
				<?php $__errorArgs = ['id_milieu_auberge'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">العنوان <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="adresse" class="form-control <?php $__errorArgs = ['adresse'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
					   value="<?php echo e(old('adresse', $auberge->adresse)); ?>">
				<?php $__errorArgs = ['adresse'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>

			<label class="col-sm-2 col-form-label">الترقيم البريدي <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="code_postal" class="form-control <?php $__errorArgs = ['code_postal'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
					   value="<?php echo e(old('code_postal', $auberge->code_postal)); ?>">
				<?php $__errorArgs = ['code_postal'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">الولاية <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select class="form-control <?php $__errorArgs = ['gouvernorat_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="gouvernorat_id" name="gouvernorat_id">
					<option value="" disabled>اختر...</option>
					<?php $__currentLoopData = $gouvernorats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gouv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
						<option value="<?php echo e($gouv->id_gouver); ?>" <?php echo e(old('gouvernorat_id', $auberge->gouver_id) == $gouv->id_gouver ? 'selected' : ''); ?>>
							<?php echo e($gouv->nom_ar); ?>

						</option>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</select>
				<?php $__errorArgs = ['gouvernorat_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>

			<label class="col-sm-2 col-form-label">المعتمدية <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select class="form-control <?php $__errorArgs = ['delegation_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" id="delegation_id" name="delegation_id" <?php echo e($auberge->delegation_id ? '' : 'disabled'); ?>>
					<option value="" disabled <?php echo e(old('delegation_id', $auberge->delegation_id ?? '') ? '' : 'selected'); ?>>اختر...</option>
					<?php if($auberge->delegation_id): ?>
						<?php $__currentLoopData = $delegations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $del): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
							<option value="<?php echo e($del->id_delegation); ?>"
								<?php echo e(old('delegation_id', $auberge->delegation_id ?? '') == $del->id_delegation ? 'selected' : ''); ?>>
								<?php echo e($del->nom_ar); ?>

							</option>
						<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
					<?php endif; ?>
				</select>
				<?php $__errorArgs = ['delegation_id'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">الهاتف القار <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="contact_tel" class="form-control <?php $__errorArgs = ['contact_tel'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
					   value="<?php echo e(old('contact_tel', $auberge->contact_tel)); ?>">
				<?php $__errorArgs = ['contact_tel'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>

			<label class="col-sm-2 col-form-label">الفاكس <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="fax" class="form-control <?php $__errorArgs = ['fax'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
					   value="<?php echo e(old('fax', $auberge->fax)); ?>">
				<?php $__errorArgs = ['fax'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>
		</div>

		<div class="row mt-3 text-end align-items-start">
			<label class="col-sm-2 col-form-label">البريد الإلكتروني للمؤسسة <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="email" name="contact_email" class="form-control <?php $__errorArgs = ['contact_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
					   value="<?php echo e(old('contact_email', $auberge->contact_email ?? '')); ?>">
				<?php $__errorArgs = ['contact_email'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>

			<label for="image" class="col-sm-2 col-form-label">صورة المركب <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="file" name="image" id="image" class="form-control <?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" accept="image/*">
				<?php $__errorArgs = ['image'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>

				<?php if(!empty($auberge->image)): ?>
					<div class="mt-2 text-center">
						<img src="data:image/jpeg;base64,<?php echo e(base64_encode($auberge->image)); ?>"
							 alt="الصورة الحالية"
							 style="max-width: 200px; max-height: 150px; border-radius: 8px; object-fit: cover; box-shadow: 0 2px 5px rgba(0,0,0,0.1);">
					</div>
				<?php endif; ?>
			</div>
		</div>

        <!--div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">سعر الليلة (سرير) <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input hidden type="number" name="prix_lit" class="form-control" 
					value="<?php echo e(old('prix_lit', $auberge->prix_lit ?? '')); ?>" step="0.01" min="0">
				<?php $__errorArgs = ['prix_lit'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>
		</div-->
<input hidden type="number" name="prix_lit" class="form-control" value="<?php echo e(old('prix_lit', $auberge->prix_lit ?? '')); ?>" step="0.01" min="0">
		<h4 class="mt-3"> مدير المؤسسة </h4>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">  الإسم واللقب <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="nom_directeur" class="form-control"
					value="<?php echo e(old('nom_directeur', $auberge->nom_directeur)); ?>">
				<?php $__errorArgs = ['nom_directeur'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>

			<label class="col-sm-2 col-form-label"> الهاتف الجوال <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="text" name="tel_directeur" class="form-control"
					value="<?php echo e(old('tel_directeur', $auberge->tel_directeur)); ?>">
				<?php $__errorArgs = ['tel_directeur'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>
		</div>

		<h4 class="mt-3"> الخدمات</h4>
		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label"> هل يوجد فضاء للمشروبات ؟ <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="espace_boisson" id="espace_boisson" class="form-control" >
					<option value="" disabled <?php echo e(old('espace_boisson', $auberge->espace_boisson) === null ? 'selected' : ''); ?>>اختر...</option>
					<option value="1" <?php echo e(old('espace_boisson', $auberge->espace_boisson) == 1 ? 'selected' : ''); ?>>نعم</option>
					<option value="0" <?php echo e(old('espace_boisson', $auberge->espace_boisson) == 0 ? 'selected' : ''); ?>>لا</option>
				</select>
				<?php $__errorArgs = ['espace_boisson'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>
			
			<label class="col-sm-2 col-form-label"> مسبح  <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<select name="piscine" class="form-control" >
					<option value="" disabled <?php echo e(old('piscine', $auberge->piscine) === null ? 'selected' : ''); ?>>اختر...</option>
					<option value="1" <?php echo e(old('piscine', $auberge->piscine) == 1 ? 'selected' : ''); ?>>نعم</option>
					<option value="0" <?php echo e(old('piscine', $auberge->piscine) == 0 ? 'selected' : ''); ?>>لا</option>
				</select>
				<?php $__errorArgs = ['piscine'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
					<span class="text-danger small"><?php echo e($message); ?></span>
				<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
			</div>
		</div>













<div class="form-group row mt-4">

    <h5 class="text-center mb-3">تعريفات الإقامة</h5>

    <table id="tarifs-table" class="table table-bordered">
        <thead>
            <tr>
                <th></th>
                <th>فرادى / مجموعات</th>
                <th>نوع الوفد المقيم</th>
                <th>بالمباني</th>
                <th>تحت الخيام</th>
                <th>ملاحظات</th>
                <th>إجراء</th>
            </tr>
        </thead>

        <tbody id="tarifs-body">
            <!-- LIGNES STATIQUES ORIGINALES REQUIRED -->
            
            <tr>
                <td class="row-number">1</td>

                <td>
                    <select name="tarifs[0][categorie]" class="form-control">
                        <option>أفراد</option>
                        <option selected>مجموعات</option>
                    </select>
                </td>

                <td>
                    <select name="tarifs[0][type]" class="form-control">
					 <option> تونسيون من ذوي الإحتياجات الخاصة    </option>
					   <option> تونسيون طلبة و- تلاميذ   </option>
					    <option>  تونسيون  موظفون وغيرهم   </option>
						<option>  منخرطو مؤسسات الشباب من حاملي بطاقة شاب   </option>
						<option>  تونسيون منخرطون بالجمعية التونسية لمظائف وسياحة </option>
                        <option selected>المجموعات المنخرطة بمؤسسات الشباب</option>
                        <option>المجموعات الشبابية التابعة لجمعيات وهيئات وطنية</option>
                        <option>المجموعات الأجنبية (خارج إطار التبادل)</option>
                        <option>المجموعات الأجنبية (إطار التبادل)</option>
                        <option>المجموعات الأجنبية (الطرف الأجنبي يتحمل المعاليم)</option>
                    </select>
                </td>

                <td><input type="number" name="tarifs[0][hotel]" class="form-control" value="4000"></td>
                <td><input type="number" name="tarifs[0][tentes]" class="form-control" value="1500"></td>

                <td><input type="text" name="tarifs[0][note]" class="form-control"
                         value="وجوب تقديم قائمة اسمية للمجموعة مؤشرة من قبل مدير المؤسسة المستفيدة"></td>

                <td><button type="button" class="btn btn-danger btn-sm" onclick="removeTarifRow(this)">حذف</button></td>
            </tr>

            <!-- Ligne 2 -->
            <tr>
                <td class="row-number">2</td>

                <td>
                    <select name="tarifs[1][categorie]" class="form-control">
                        <option>أفراد</option>
                        <option selected>مجموعات</option>
                    </select>
                </td>

                <td>
                    <select name="tarifs[1][type]" class="form-control">
					 <option> تونسيون من ذوي الإحتياجات الخاصة    </option>
					   <option> تونسيون طلبة و- تلاميذ   </option>
					    <option>  تونسيون  موظفون وغيرهم   </option>
						<option>  منخرطو مؤسسات الشباب من حاملي بطاقة شاب   </option>
						<option>  تونسيون منخرطون بالجمعية التونسية لمظائف وسياحة </option>
                        <option>المجموعات المنخرطة بمؤسسات الشباب</option>
                        <option selected>المجموعات الشبابية التابعة لجمعيات وهيئات وطنية</option>
                        <option>المجموعات الأجنبية (خارج إطار التبادل)</option>
                        <option>المجموعات الأجنبية (إطار التبادل)</option>
                        <option>المجموعات الأجنبية (الطرف الأجنبي يتحمل المعاليم)</option>
                    </select>
                </td>

                <td><input type="number" name="tarifs[1][hotel]" class="form-control" value="6000"></td>
                <td><input type="number" name="tarifs[1][tentes]" class="form-control" value="2500"></td>

                <td><input type="text" name="tarifs[1][note]" class="form-control"
                         value="وجوب تقديم قائمة اسمية للمجموعة مؤشرة من قبل الهيكل أو الجمعية"></td>

                <td><button type="button" class="btn btn-danger btn-sm" onclick="removeTarifRow(this)">حذف</button></td>
            </tr>

<!-- Ligne 3 -->
            <tr>
			<td class="row-number">3</td>
                <td>
                    <select class="form-control">
                        <option>المجموعات</option>
                        <option selected>مجموعات</option>
                        <option>أفراد</option>
                    </select>
                </td>

                <td>
                    <select class="form-control">
					 <option> تونسيون من ذوي الإحتياجات الخاصة    </option>
					   <option> تونسيون طلبة و- تلاميذ   </option>
					    <option>  تونسيون  موظفون وغيرهم   </option>
						<option>  منخرطو مؤسسات الشباب من حاملي بطاقة شاب   </option>
						<option>  تونسيون منخرطون بالجمعية التونسية لمظائف وسياحة </option>
                        <option>المجموعات المنخرطة بمؤسسات الشباب</option>
                        <option>المجموعات الشبابية التابعة لجمعيات وهيئات وطنية</option>
                        <option selected>المجموعات الأجنبية (خارج إطار التبادل)</option>
                        <option>المجموعات الأجنبية (إطار التبادل)</option>
                        <option>المجموعات الأجنبية (الطرف الأجنبي يتحمل المعاليم)</option>
                    </select>
                </td>

                <td><input type="number" name="tarifs[1][hotel]" class="form-control" value="15000"></td>
                <td><input type="number" name="tarifs[1][tentes]" class="form-control" value="7000"></td>

                <td><input type="text" class="form-control" placeholder=""></td>

                <td><button class="btn btn-danger btn-sm" onclick="deleteRow(this)">حذف</button></td>
            </tr>

            <!-- Ligne 4 -->
            <tr>
			<td class="row-number">4</td>
                <td>
                    <select class="form-control">
                        <option>المجموعات</option>
                        <option selected>مجموعات</option>
                        <option>أفراد</option>
                    </select>
                </td>

                <td>
                    <select class="form-control">
					 <option> تونسيون من ذوي الإحتياجات الخاصة    </option>
					   <option> تونسيون طلبة و- تلاميذ   </option>
					    <option>  تونسيون  موظفون وغيرهم   </option>
						<option>  منخرطو مؤسسات الشباب من حاملي بطاقة شاب   </option>
						<option>  تونسيون منخرطون بالجمعية التونسية لمظائف وسياحة </option>
                        <option>المجموعات المنخرطة بمؤسسات الشباب</option>
                        <option>المجموعات الشبابية التابعة لجمعيات وهيئات وطنية</option>
                        <option>المجموعات الأجنبية (خارج إطار التبادل)</option>
                        <option selected>المجموعات الأجنبية (إطار التبادل)</option>
                        <option>المجموعات الأجنبية (الطرف الأجنبي يتحمل المعاليم)</option>
                    </select>
                </td>

                <td><input type="number" name="tarifs[1][hotel]" class="form-control" value="7000"></td>
                <td><input type="number" name="tarifs[1][tentes]" class="form-control" value="3500"></td>

                <td><input type="text" class="form-control" placeholder=""></td>

                <td><button class="btn btn-danger btn-sm" onclick="deleteRow(this)">حذف</button></td>
            </tr>

            <!-- Ligne 5 -->
            <tr>
			<td class="row-number">5</td>
                <td>
                    <select class="form-control">
                        <option>المجموعات</option>
                        <option selected>مجموعات</option>
                        <option>أفراد</option>
                    </select>
                </td>

                <td>
                    <select class="form-control">
					 <option> تونسيون من ذوي الإحتياجات الخاصة    </option>
					   <option> تونسيون طلبة و- تلاميذ   </option>
					    <option>  تونسيون  موظفون وغيرهم   </option>
						<option>  منخرطو مؤسسات الشباب من حاملي بطاقة شاب   </option>
						<option>  تونسيون منخرطون بالجمعية التونسية لمظائف وسياحة </option>
                        <option>المجموعات المنخرطة بمؤسسات الشباب</option>
                        <option>المجموعات الشبابية التابعة لجمعيات وهيئات وطنية</option>
                        <option>المجموعات الأجنبية (خارج إطار التبادل)</option>
                        <option>المجموعات الأجنبية (إطار التبادل)</option>
                        <option selected>المجموعات الأجنبية (الطرف الأجنبي يتحمل المعاليم)</option>
                    </select>
                </td>

                <td><input type="number" name="tarifs[1][hotel]" class="form-control" value="12000"></td>
                <td><input type="number" name="tarifs[1][tentes]" class="form-control" value="6000"></td>

                <td><input type="text" class="form-control" placeholder=""></td>

                <td><button class="btn btn-danger btn-sm" onclick="deleteRow(this)">حذف</button></td>
            </tr>        </tbody>
    </table>

    <button type="button" class="btn btn-success mt-2" onclick="addTarifRow()">إضافة تعريف جديد</button>
</div>

<div class="form-group row mt-4">

    <h5 class="text-center mb-3">وقف عربات التخييم داخل المركز (في اليوم الواحد) </h5>
    <div class="mb-4">
        <div class="d-inline-block ms-2" style="width:150px;">
            <input type="number" class="form-control" id="camping-fee" value="7000">
        </div>
        <div class="small-note mt-2">يمكن تعديل القيمة.</div>
    </div>

</div>

<script>
function updateTarifRowNumbers() {
    document.querySelectorAll("#tarifs-body .row-number").forEach((cell, index) => {
        cell.textContent = index + 1;
    });
}

function removeTarifRow(button) {
    button.closest("tr").remove();
    updateTarifRowNumbers();
}

function addTarifRow() {
    let tableBody = document.getElementById("tarifs-body");
    let index = tableBody.children.length;

    let row = `
        <tr>
            <td class="row-number">${index + 1}</td>

            <td>
                <select name="tarifs[${index}][categorie]" class="form-control">
                    <option>أفراد</option>
                    <option selected>مجموعات</option>
                </select>
            </td>

            <td>
                <select name="tarifs[${index}][type]" class="form-control">
				 <option> تونسيون من ذوي الإحتياجات الخاصة    </option>
					   <option> تونسيون طلبة و- تلاميذ   </option>
					    <option>  تونسيون  موظفون وغيرهم   </option>
						<option>  منخرطو مؤسسات الشباب من حاملي بطاقة شاب   </option>
						<option>  تونسيون منخرطون بالجمعية التونسية لمظائف وسياحة </option>
                    <option>المجموعات المنخرطة بمؤسسات الشباب</option>
                    <option>المجموعات الشبابية التابعة لجمعيات وهيئات وطنية</option>
                    <option>المجموعات الأجنبية (خارج إطار التبادل)</option>
                    <option>المجموعات الأجنبية (إطار التبادل)</option>
                    <option>المجموعات الأجنبية (الطرف الأجنبي يتحمل المعاليم)</option>
                </select>
            </td>

            <td><input type="number" name="tarifs[${index}][hotel]" class="form-control"></td>
            <td><input type="number" name="tarifs[${index}][tentes]" class="form-control"></td>

            <td><input type="text" name="tarifs[${index}][note]" class="form-control"></td>

            <td><button type="button" class="btn btn-danger btn-sm" onclick="removeTarifRow(this)">حذف</button></td>
        </tr>
    `;

    tableBody.insertAdjacentHTML('beforeend', row);
    updateTarifRowNumbers();
}
</script>


















        <div class="form-group row mt-4">
			<h5 class="text-center mb-3">الفضاءات المتوفرة</h5>

			<table id="espaces-table" class="table table-bordered">
				<thead>
					<tr>
						<th></th>
						<th>الإسم بالعربية</th>
						<th>الإسم بالفرنسية</th>
						<th>الإسم بالانقليزية</th>
						<th>إجراء</th>
					</tr>
				</thead>
				<tbody id="espaces-body">
					<?php
						// On prend soit les anciennes valeurs après validation, soit les espaces existants
						$oldEspaces = old('espaces', $auberge->espaces->toArray());
						$espaceIndex = 0;
					?>

					<?php $__currentLoopData = $oldEspaces; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $espace): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<tr>
						<td class="row-number"><?php echo e($loop->iteration); ?></td>
						<td>
							<input type="hidden" name="espaces[<?php echo e($espaceIndex); ?>][id_espace]" value="<?php echo e($espace['id_espace'] ?? ''); ?>">
							<input type="text" name="espaces[<?php echo e($espaceIndex); ?>][nom_ar]" class="form-control" value="<?php echo e($espace['nom_ar'] ?? ''); ?>" >
						</td>
						<td>
							<input type="text" name="espaces[<?php echo e($espaceIndex); ?>][nom_fr]" class="form-control" value="<?php echo e($espace['nom_fr'] ?? ''); ?>" >
						</td>
						<td>
							<input type="text" name="espaces[<?php echo e($espaceIndex); ?>][nom_en]" class="form-control" value="<?php echo e($espace['nom_en'] ?? ''); ?>" >
						</td>
						<td>
							<button type="button" class="btn btn-danger btn-sm" onclick="removeEspaceRow(this)">حذف</button>
						</td>
					</tr>
					<?php $espaceIndex++; ?>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</tbody>
			</table>

			<button type="button" class="btn btn-success mt-2" onclick="addEspaceRow()">إضافة فضاء جديد</button>
		</div>


        <div class="form-group row mt-4">
			<h5 class="text-center mb-3">الغرف <span class="text-danger">*</span></h5>
			<table id="chambres-table" class="custom-table">
				<thead>
					<tr>
						<th></th>
						<th>نوع الغرفة</th>
						<th>الطاقة الاستيعابية</th>
						<th>رقم الغرفة</th>
						<th>إجراء</th>
					</tr>
				</thead>

				<tbody id="chambres-body">
					<?php
						$oldChambres = old('chambres', isset($auberge) ? $auberge->chambres->toArray() : []);
					?>

					<?php $__currentLoopData = $oldChambres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $c): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
					<tr>
						<td class="row-number"><?php echo e($index + 1); ?></td>

						
						<td>
							<select name="chambres[<?php echo e($index); ?>][type_chambre_id]" class="form-control type-chambre" >
								<option value="">-- اختر --</option>
								<?php $__currentLoopData = $typesChambres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
									<option value="<?php echo e($t->id_type); ?>" 
										<?php echo e(($c['type_chambre_id'] ?? '') == $t->id_type ? 'selected' : ''); ?>>
										<?php echo e($t->type_ar); ?>

									</option>
								<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
							</select>
							<input type="hidden" name="chambres[<?php echo e($index); ?>][id_chambre_tente]" value="<?php echo e($c['id_chambre_tente'] ?? ''); ?>">
							<?php $__errorArgs = ["chambres.$index.type_chambre_id"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
								<span class="text-danger small"><?php echo e($message); ?></span>
							<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
						</td>

						
						<td>
							<input type="number" name="chambres[<?php echo e($index); ?>][capacite]" class="form-control nb-lits" value="<?php echo e($c['capacite'] ?? ''); ?>">
							<?php $__errorArgs = ["chambres.$index.capacite"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
								<span class="text-danger small"><?php echo e($message); ?></span>
							<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
						</td>

						
						<td>
							<input type="text" name="chambres[<?php echo e($index); ?>][num_chambre]" class="form-control" value="<?php echo e($c['num_chambre'] ?? ''); ?>">
							<?php $__errorArgs = ["chambres.$index.num_chambre"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
								<span class="text-danger small"><?php echo e($message); ?></span>
							<?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
						</td>

						<td>
							<button type="button" class="btn btn-danger btn-sm" onclick="removeChambreRow(this)">حذف</button>
						</td>
					</tr>
					<?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
				</tbody>
			</table>

			<button type="button" class="btn btn-success mt-2" onclick="addChambreRow()">إضافة غرفة</button>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">طاقة الإستيعاب تحت المباني <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="number" name="capacite_batiment" id="capacite_batiment" class="form-control" 
					value="<?php echo e(old('capacite_batiment', $auberge->capacite_batiment ?? 0)); ?>" readonly>
			</div>

			<label class="col-sm-2 col-form-label">عدد الغرف <span class="text-danger">*</span></label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres" id="nb_chambres" class="form-control" 
					value="<?php echo e(old('nb_chambres', $auberge->nb_chambres ?? 0)); ?>" readonly>
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">عدد الغرف الفردية</label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres_single" id="nb_chambres_single" class="form-control" 
					value="<?php echo e(old('nb_chambres_single', $auberge->nb_chambres_single ?? 0)); ?>" readonly>
			</div>

			<label class="col-sm-2 col-form-label">عدد الغرف ثنائي</label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres_double" id="nb_chambres_double" class="form-control" 
					value="<?php echo e(old('nb_chambres_double', $auberge->nb_chambres_double ?? 0)); ?>" readonly>
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">عدد الغرف ثلاثي</label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres_triple" id="nb_chambres_triple" class="form-control" 
					value="<?php echo e(old('nb_chambres_triple', $auberge->nb_chambres_triple ?? 0)); ?>" readonly>
			</div>

			<label class="col-sm-2 col-form-label">عدد الغرف رباعي</label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres_quadra" id="nb_chambres_quadra" class="form-control" 
					value="<?php echo e(old('nb_chambres_quadra', $auberge->nb_chambres_quadra ?? 0)); ?>" readonly>
			</div>
		</div>

		<div class="row mt-3 text-end">
			<label class="col-sm-2 col-form-label">عدد الغرف أكثر من رباعي</label>
			<div class="col-sm-4">
				<input type="number" name="nb_chambres_plus" id="nb_chambres_plus" class="form-control" 
					value="<?php echo e(old('nb_chambres_plus', $auberge->nb_chambres_plus ?? 0)); ?>" readonly>
			</div>

			<label class="col-sm-2 col-form-label">عدد الوحدات الصحية داخل الغرف</label>
			<div class="col-sm-4">
				<input type="number" name="nb_salles_de_bain" id="nb_salles_de_bain" class="form-control" 
					value="<?php echo e(old('nb_salles_de_bain', $auberge->nb_salles_de_bain ?? 0)); ?>">
			</div>
		</div>




        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            عدد الوحدات الصحية المشتركة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_salles_de_bain_comm" class="form-control" 
                    value="<?php echo e(old('nb_salles_de_bain_comm', $auberge->nb_salles_de_bain_comm)); ?>">
            </div>
            <label class="col-sm-2 col-form-label">
            عدد الغرف التي تحتوي على تلفاز</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_tv" class="form-control" 
                    value="<?php echo e(old('nb_chambres_tv', $auberge->nb_chambres_tv)); ?>">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            عدد الغرف المكيفة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_clim" class="form-control" 
                    value="<?php echo e(old('nb_chambres_clim', $auberge->nb_chambres_clim)); ?>">
            </div>
            <label class="col-sm-2 col-form-label">
            عدد الغرف التي تحتوي على ثلاجة</label>
            <div class="col-sm-4">
                <input type="number" name="nb_chambres_frigo" class="form-control" 
                    value="<?php echo e(old('nb_chambres_frigo', $auberge->nb_chambres_frigo)); ?>">
            </div>
        </div>

        <div class="row mt-3 text-end">
            <label class="col-sm-2 col-form-label">
            طاقة الإستيعاب تحت الخيام إن وجدت</label>
            <div class="col-sm-4">
                <input type="number" name="capacite_tentes" class="form-control" 
                    value="<?php echo e(old('capacite_tentes', $auberge->capacite_tentes)); ?>">
            </div>
            <label for="cuisine_fonctionnelle" class="col-sm-2 col-form-label">المطبخ وظيفي</label>
            <div class="col-sm-4">
                <select name="cuisine_fonctionnelle" id="cuisine_fonctionnelle" class="form-control">
                    <option value="" disabled>اختر...</option>
                    <option value="1" <?php echo e(old('cuisine_fonctionnelle', $auberge->cuisine_fonctionnelle) == '1' ? 'selected' : ''); ?>>نعم</option>
                    <option value="0" <?php echo e(old('cuisine_fonctionnelle', $auberge->cuisine_fonctionnelle) == '0' ? 'selected' : ''); ?>>لا</option>
                </select>
            </div>
        </div>


       

                <div class="form-group row mt-4">
    <h5 class="text-center mb-3">الملاعب الرياضية</h5>

    <table id="terrains-table" class="table table-bordered">
        <thead>
            <tr>
                <th></th>
                <th>الإسم بالعربية</th>
                <th>الإسم بالفرنسية</th>
                <th>الإسم بالانقليزية</th>
                <th>إجراء</th>
            </tr>
        </thead>
        <tbody id="terrains-body">
            <?php
                $oldterrains = old('terrains', $auberge->terrains->toArray());
                $terrainsIndex = 0;
            ?>

            <?php $__currentLoopData = $oldterrains; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $terrain): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td class="row-number"><?php echo e($loop->iteration); ?></td>
                <td>
                    <input type="hidden" name="terrains[<?php echo e($terrainsIndex); ?>][id_terrain]" value="<?php echo e($terrain['id_terrain'] ?? ''); ?>">
                    <input type="text" name="terrains[<?php echo e($terrainsIndex); ?>][nom_ar]" class="form-control" value="<?php echo e($terrain['nom_ar'] ?? ''); ?>" >
                </td>
                <td>
                    <input type="text" name="terrains[<?php echo e($terrainsIndex); ?>][nom_fr]" class="form-control" value="<?php echo e($terrain['nom_fr'] ?? ''); ?>" >
                </td>
                <td>
                    <input type="text" name="terrains[<?php echo e($terrainsIndex); ?>][nom_en]" class="form-control" value="<?php echo e($terrain['nom_en'] ?? ''); ?>" >
                </td>
                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeterrainsRow(this)">حذف</button>
                </td>
            </tr>
            <?php $terrainsIndex++; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <button type="button" class="btn btn-success mt-2" onclick="addterrainsRow()">إضافة فضاء جديد</button>
</div>

<script>
let terrainsIndex = <?php echo e($terrainsIndex ?? 0); ?>;

function addterrainsRow() {
    let tableBody = document.getElementById('terrains-body');

    let newRow = `
        <tr>
            <td class="row-number">${terrainsIndex + 1}</td>
            <td>
                <input type="hidden" name="terrains[${terrainsIndex}][id_terrain]" value="">
                <input type="text" name="terrains[${terrainsIndex}][nom_ar]" class="form-control" >
            </td>
            <td>
                <input type="text" name="terrains[${terrainsIndex}][nom_fr]" class="form-control" >
            </td>
            <td>
                <input type="text" name="terrains[${terrainsIndex}][nom_en]" class="form-control" >
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeterrainsRow(this)">حذف</button>
            </td>
        </tr>
    `;
    tableBody.insertAdjacentHTML('beforeend', newRow);
    terrainsIndex++;
    updateterrainsRowNumbers();
}

function removeterrainsRow(button) {
    button.closest('tr').remove();
    updateterrainsRowNumbers();
}

function updateterrainsRowNumbers() {
    document.querySelectorAll('#terrains-body .row-number')
        .forEach((cell, index) => cell.textContent = index + 1);
}
</script>

        


        <div class="form-group row mt-4">
    <h5 class="text-center mb-3">الخدمات المقدمة من طرف المؤسسة</h5>

    <table id="services_auberge-table" class="table table-bordered">
        <thead>
            <tr>
                <th></th>
                <th>الإسم بالعربية</th>
                <th>الإسم بالفرنسية</th>
                <th>الإسم بالانقليزية</th>
                <th>إجراء</th>
            </tr>
        </thead>
        <tbody id="services_auberge-body">
            <?php
                $oldservices_auberge = old('services_auberge', $auberge->services_auberge->toArray());
                $services_aubergeIndex = 0;
            ?>

            <?php $__currentLoopData = $oldservices_auberge; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $services_auberge): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td class="row-number"><?php echo e($loop->iteration); ?></td>
                <td>
                    <input type="hidden" name="services_auberge[<?php echo e($services_aubergeIndex); ?>][id_service]" value="<?php echo e($services_auberge['id_service'] ?? ''); ?>">
                    <input type="text" name="services_auberge[<?php echo e($services_aubergeIndex); ?>][nom_ar]" class="form-control" value="<?php echo e($services_auberge['nom_ar'] ?? ''); ?>" >
                </td>
                <td>
                    <input type="text" name="services_auberge[<?php echo e($services_aubergeIndex); ?>][nom_fr]" class="form-control" value="<?php echo e($services_auberge['nom_fr'] ?? ''); ?>" >
                </td>
                <td>
                    <input type="text" name="services_auberge[<?php echo e($services_aubergeIndex); ?>][nom_en]" class="form-control" value="<?php echo e($services_auberge['nom_en'] ?? ''); ?>" >
                </td>
                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeservices_aubergeRow(this)">حذف</button>
                </td>
            </tr>
            <?php $services_aubergeIndex++; ?>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>

    <button type="button" class="btn btn-success mt-2" onclick="addservices_aubergeRow()">إضافة فضاء جديد</button>
</div>

<script>
let services_aubergeIndex = <?php echo e($services_aubergeIndex ?? 0); ?>;

function addservices_aubergeRow() {
    let tableBody = document.getElementById('services_auberge-body');

    let newRow = `
        <tr>
            <td class="row-number">${services_aubergeIndex + 1}</td>
            <td>
                <input type="hidden" name="services_auberge[${services_aubergeIndex}][id_service]" value="">
                <input type="text" name="services_auberge[${services_aubergeIndex}][nom_ar]" class="form-control" >
            </td>
            <td>
                <input type="text" name="services_auberge[${services_aubergeIndex}][nom_fr]" class="form-control" >
            </td>
            <td>
                <input type="text" name="services_auberge[${services_aubergeIndex}][nom_en]" class="form-control" >
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeservices_aubergeRow(this)">حذف</button>
            </td>
        </tr>
    `;
    tableBody.insertAdjacentHTML('beforeend', newRow);
    services_aubergeIndex++;
    updateservices_aubergeRowNumbers();
}

function removeservices_aubergeRow(button) {
    button.closest('tr').remove();
    updateservices_aubergeRowNumbers();
}

function updateservices_aubergeRowNumbers() {
    document.querySelectorAll('#services_auberge-body .row-number')
        .forEach((cell, index) => cell.textContent = index + 1);
}
</script>


    <div class="form-group row mt-4">
        <h5 class="text-center mb-3">🍽️ قسم خدمات المطعم</h5>
        <table id="restauration-table" class="custom-table">
            <thead>
                <tr>
                    <th></th>
                    <th>الإسم بالعربية</th>
                    <th>الإسم بالفرنسية</th>
                    <th>الإسم بالإنجليزية</th>
                    <th>الوصف بالعربية</th>
                    <th>الوصف بالفرنسية</th>
                    <th>الوصف بالإنجليزية</th>
                    <th>التعريفة (د.ت)</th>
                    <th>إجراء</th> 
                </tr>
            </thead>
            <tbody id="restauration-body">
                <?php $__currentLoopData = $auberge->restaurations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td class="row-number"></td>
                        <td>
                            <input type="hidden" name="restaurations[<?php echo e($i); ?>][id_rest]" value="<?php echo e($res->id_rest); ?>">
                            <input type="text" name="restaurations[<?php echo e($i); ?>][nom_ar]" value="<?php echo e($res->nom_ar); ?>" class="form-control"></td>
                        <td><input type="text" name="restaurations[<?php echo e($i); ?>][nom_fr]" value="<?php echo e($res->nom_fr); ?>" class="form-control"></td>
                        <td><input type="text" name="restaurations[<?php echo e($i); ?>][nom_en]" value="<?php echo e($res->nom_en); ?>" class="form-control"></td>
                        <td><textarea name="restaurations[<?php echo e($i); ?>][description_ar]" class="form-control"><?php echo e($res->description_ar); ?></textarea></td>
                        <td><textarea name="restaurations[<?php echo e($i); ?>][description_fr]" class="form-control"><?php echo e($res->description_fr); ?></textarea></td>
                        <td><textarea name="restaurations[<?php echo e($i); ?>][description_en]" class="form-control"><?php echo e($res->description_en); ?></textarea></td>
                        <td><input type="number" step="0.01" name="restaurations[<?php echo e($i); ?>][tarif]" value="<?php echo e($res->tarif); ?>" class="form-control"></td>
                        <td>
                            <button type="button" class="btn btn-danger btn-sm" onclick="removeRestaurationRow(this)">حذف</button>
                        </td>
                    </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </tbody>

        </table>
        <button type="button" class="btn btn-success mt-2" onclick="addRestaurationRow()">إضافة خدمة جديدة</button>
    </div>

        <div class="form-group mt-3">
            <label for="lieux_culturels" class="col-sm-6 col-form-label">المعالم الأثرية والمتاحف والفضاءات الثقافية المجاورة للمؤسسة</label>
            <textarea name="lieux_culturels" id="lieux_culturels" class="form-control" rows="4"><?php echo e(old('lieux_culturels', $auberge->lieux_culturels)); ?></textarea>
        </div>

        <div class="form-group mt-3">
            <label for="autres_services" class="col-sm-6 col-form-label"> خدمات أخرى </label>
            <textarea name="autres_services" placeholder="أذكر الخدمات الإضافية إن وجدت..." id="autres_services" class="form-control" rows="4"><?php echo e(old('autres_services', $auberge->autres_services)); ?></textarea>
        </div>

        <div class="text-center mt-4">
            <button type="submit" class="btn btn-success mx-2">
                <i class="la la-save"></i> حفظ التعديلات
            </button>

            <a href="<?php echo e(route('auberges.index')); ?>" class="btn btn-secondary mx-2">
                <i class="la la-arrow-right"></i> رجوع
            </a>
        </div>

    </form>
</div>

<script>
    let restaurationIndex = <?php echo e(count($auberge->restaurations)); ?>;
    function addRestaurationRow() {
        let tableBody = document.getElementById('restauration-body');
        let newRow = `
            <tr>
                <td class="row-number"></td>

                <td><input type="text" name="restaurations[${restaurationIndex}][nom_ar]" class="form-control" ></td>
                <td><input type="text" name="restaurations[${restaurationIndex}][nom_fr]" class="form-control" ></td>
                <td><input type="text" name="restaurations[${restaurationIndex}][nom_en]" class="form-control" ></td>

                <td><textarea name="restaurations[${restaurationIndex}][description_ar]" class="form-control" rows="1"></textarea></td>
                <td><textarea name="restaurations[${restaurationIndex}][description_fr]" class="form-control" rows="1"></textarea></td>
                <td><textarea name="restaurations[${restaurationIndex}][description_en]" class="form-control" rows="1"></textarea></td>

                <td><input type="number" step="0.01" name="restaurations[${restaurationIndex}][tarif]" class="form-control" ></td>

                <td>
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRestaurationRow(this)">حذف</button>
                </td>
            </tr>
        `;
        tableBody.insertAdjacentHTML('beforeend', newRow);
        restaurationIndex++;
        updateRowNumbers();
    }
    function removeRestaurationRow(button) {
        button.closest('tr').remove();
        updateRowNumbers();
    }
    function updateRowNumbers() {
        document.querySelectorAll('#restauration-body .row-number')
            .forEach((cell, index) => cell.textContent = index + 1);
    }
    updateRowNumbers();
</script>


<script>
document.addEventListener("DOMContentLoaded", function () {

    const gouvSelect = document.getElementById('gouvernorat_id');
    const delSelect  = document.getElementById('delegation_id');

    gouvSelect.addEventListener('change', function () {

        let gouvId = this.value;

        delSelect.innerHTML = '';
        delSelect.disabled = true;

        delSelect.innerHTML = '<option disabled selected>تحميل...</option>';

        let url = "<?php echo e(route('delegations.get', ['gouvernoratId' => 'ID_PLACEHOLDER'])); ?>";
        url = url.replace("ID_PLACEHOLDER", gouvId);

        fetch(url)
            .then(response => response.json())
            .then(data => {

                
                delSelect.innerHTML = '<option disabled selected>اختر...</option>';

                
                data.forEach(d => {
                    let option = document.createElement('option');
                    option.value = d.id_delegation;
                    option.text  = d.nom_ar;
                    delSelect.appendChild(option);
                });

                delSelect.disabled = false;
            });
    });

});
</script>
<script>
let espaceIndex = <?php echo e($espaceIndex ?? 0); ?>;

function addEspaceRow() {
    let tableBody = document.getElementById('espaces-body');

    let newRow = `
        <tr>
            <td class="row-number">${espaceIndex + 1}</td>
            <td>
                <input type="hidden" name="espaces[${espaceIndex}][id_espace]" value="">
                <input type="text" name="espaces[${espaceIndex}][nom_ar]" class="form-control" >
            </td>
            <td>
                <input type="text" name="espaces[${espaceIndex}][nom_fr]" class="form-control" >
            </td>
            <td>
                <input type="text" name="espaces[${espaceIndex}][nom_en]" class="form-control" >
            </td>
            <td>
                <button type="button" class="btn btn-danger btn-sm" onclick="removeEspaceRow(this)">حذف</button>
            </td>
        </tr>
    `;
    tableBody.insertAdjacentHTML('beforeend', newRow);
    espaceIndex++;
    updateEspaceRowNumbers();
}

function removeEspaceRow(button) {
    button.closest('tr').remove();
    updateEspaceRowNumbers();
}

function updateEspaceRowNumbers() {
    document.querySelectorAll('#espaces-body .row-number')
        .forEach((cell, index) => cell.textContent = index + 1);
}
</script>

<script>
function updateRowNumbers() {
    document.querySelectorAll('#chambres-body tr .row-number').forEach((td, i) => td.textContent = i + 1);
}

function recalculer() {
    const rows = document.querySelectorAll('#chambres-body tr');
    let totalChambres = 0, capaciteTotale = 0;
    let nb_single = 0, nb_double = 0, nb_triple = 0, nb_quadra = 0, nb_plus = 0;

    rows.forEach(row => {
        const typeEl = row.querySelector('.type-chambre');
        const litsEl = row.querySelector('.nb-lits');

        if (!typeEl || !litsEl) return;

        const type = typeEl.value;
        const lits = parseInt(litsEl.value || 0);

        totalChambres++;
        capaciteTotale += lits;

        switch(type){
            case "1": nb_single++; break;
            case "2": nb_double++; break;
            case "3": nb_triple++; break;
            case "4": nb_quadra++; break;
            case "6": nb_plus++; break;
        }
    });

    document.getElementById('nb_chambres').value = totalChambres;
    document.getElementById('capacite_batiment').value = capaciteTotale;
    document.getElementById('nb_chambres_single').value = nb_single;
    document.getElementById('nb_chambres_double').value = nb_double;
    document.getElementById('nb_chambres_triple').value = nb_triple;
    document.getElementById('nb_chambres_quadra').value = nb_quadra;
    document.getElementById('nb_chambres_plus').value = nb_plus;
}

function addChambreRow() {
    const tbody = document.getElementById("chambres-body");
    const index = tbody.rows.length;

    const tr = document.createElement('tr');
    tr.innerHTML = `
        <td class="row-number">${index + 1}</td>
        <td>
            <select name="chambres[${index}][type_chambre_id]" class="form-control type-chambre" >
                <option value="">-- اختر --</option>
                <?php $__currentLoopData = $typesChambres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $t): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <option value="<?php echo e($t->id_type); ?>"><?php echo e($t->type_ar); ?></option>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            </select>
            <input type="hidden" name="chambres[${index}][id_chambre_tente]" value="">
        </td>
        <td><input type="number" name="chambres[${index}][capacite]" class="form-control nb-lits" ></td>
        <td><input type="text" name="chambres[${index}][num_chambre]" class="form-control" ></td>
        <td><button type="button" class="btn btn-danger btn-sm" onclick="removeChambreRow(this)">حذف</button></td>
    `;
    tbody.appendChild(tr);
    updateRowNumbers();
    recalculer();
}

function removeChambreRow(btn) {
    btn.closest("tr").remove();
    updateRowNumbers();
    recalculer();
}

document.addEventListener('input', e => {
    if (e.target.classList.contains('type-chambre') || e.target.classList.contains('nb-lits')) {
        recalculer();
    }
});
document.addEventListener('change', e => {
    if (e.target.classList.contains('type-chambre')) {
        recalculer();
    }
});
document.addEventListener('DOMContentLoaded', () => {
    updateRowNumbers();
    recalculer();
});
</script>

<?php $__env->stopSection(); ?>

<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('login')); ?>";
    </script>
<?php endif; ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/auberges/creation_centre/edit.blade.php ENDPATH**/ ?>