<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire.css')); ?>">
<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>
<?php if(Auth::check()): ?>

<div class="container">
    <form action="<?php echo e(route('admin.jeunesse.update', $institution->id_inst)); ?>" method="POST" enctype="multipart/form-data" lang="ar">
    <?php echo csrf_field(); ?>
    <?php echo method_field('PUT'); ?>
        <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire->id_type); ?>">
           <h3><?php echo e($formulaire->type_ar); ?></h3>
        <h4 style="text-align:center;">تحيين الاستمارة</h4>

        <div class="card shadow-lg border-0 mb-4 rounded-4">
                                 <div class="card-header bg-custom-gray text-dark d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-bold">الوضعية الحالية:</h5>
                <?php if($institution->id_statut == 1): ?>
                    <span class="status-badge status-badge--success">موافقة </span>
                <?php elseif($institution->id_statut== 3): ?>
                    <span class="status-badge status-badge--danger">عدم موافقة</span>
                <?php elseif($institution->id_statut == 4): ?>
                    <span class="status-badge status-badge--pending">موافقة شريطة</span>
                <?php elseif($institution->id_statut== 5): ?>
                    <span class="status-badge status-badge--pending">ارجاء لابداء الراي</span>
                <?php else: ?>
                    <span class="status-badge status-badge--pending">في الانتظار</span>
                <?php endif; ?>
            </div>
            <div class="card-body">
                <p class="text-muted mb-4 text-center fs-6">
                    إذا كنت ترغب في تعديل الوضعية الحالية، يرجى الاختيار من القائمة أدناه:
                </p>
               <div class="form-group row align-items-center mb-3">
    <label for="id_statut" class="col-sm-2 col-form-label fw-bold">تغيير الوضعية</label>
    <div class="col-sm-4">
        <select class="form-control" id="id_statut" name="id_statut" onchange="toggleMotifInput()">
            <option value="">اختر...</option>
            <?php $__currentLoopData = $statuts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <?php
                    $statutId = $s->id_statut ?? $s->id ?? null;
                    // hide Pending(2) and Draft(6) if you still want to (same as debutActivite)
                    if (in_array($statutId, [2, 6])) continue;
                    $label = $s->libelle_ar ?? $s->statut_ar ?? $s->label ?? $s->name ?? $s->statut ?? '—';
                    $selected = (string) old('id_statut', $institution->id_statut ?? '') === (string) $statutId;
                ?>
                <option value="<?php echo e($statutId); ?>" <?php echo e($selected ? 'selected' : ''); ?>><?php echo e($label); ?></option>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
    </div>
</div>
   
<div class="mb-3 d-none" id="motifDivStatus">
  <label class="form-label fw-bold text-warning">سبب / تعليق</label>
  <textarea name="commentaire_status"
            id="commentaire_status"
            class="form-control border-warning shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال السبب أو التعليق"></textarea>
</div>


<div class="mb-3 d-none" id="motifDiv">
  <label for="commentaire_refus" class="form-label fw-bold text-danger">سبب الرفض</label>
  <textarea name="commentaire_refus"
            id="commentaire_refus"
            class="form-control border-danger shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال سبب الرفض"></textarea>
</div>
            </div>
        </div>

<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-light py-2"><h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h5></div>

  <div class="card-body p-2" dir="rtl">
    <?php if(! isset($institution->statutHistories) || $institution->statutHistories->isEmpty()): ?>
      <p class="text-muted mb-0">لا توجد تغييرات سابقة.</p>
    <?php else: ?>
      <div class="compact-timeline">
        <?php $__currentLoopData = $institution->statutHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php
            $from = optional($hist->fromStatut)->statut_ar ?? optional($hist->fromStatut)->libelle_ar ?? '—';
            $to = optional($hist->toStatut)->statut_ar ?? optional($hist->toStatut)->libelle_ar ?? '—';
            $toId = optional($hist->toStatut)->id_statut;
            $badgeClass = $toId === 1 ? 'badge-success' : ($toId === 3 ? 'badge-danger' : 'badge-muted');
            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
          ?>

          <div class="compact-item">
            <div class="compact-row d-flex align-items-center justify-content-between w-100">
              <div class="left-block text-end">
                <div class="small text-muted compact-date"><?php echo e($hist->created_at->format('d/m/Y H:i')); ?></div>
                <div class="very-small text-muted compact-user">بواسطة: <?php echo e($changer); ?></div>
              </div>

              <div class="right-block text-right flex-fill">
                <span class="compact-from small text-muted"><?php echo e($from); ?></span>
                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                <span class="compact-to small <?php echo e($badgeClass); ?>"><?php echo e($to); ?></span>
              </div>
            </div>

            <?php if($hist->commentaire): ?>
              <details class="compact-comment mt-1">
                <summary class="very-small text-danger">سبب / تعليق</summary>
                <div class="very-small text-muted mt-1"><?php echo e($hist->commentaire); ?></div>
              </details>
            <?php endif; ?>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    <?php endif; ?>
  </div>
</div>
<style>
/* compact styles (same as earlier) */
.compact-timeline { display:flex; flex-direction:column; gap:6px; }
.compact-item { padding:6px 4px; border-bottom:1px solid rgba(0,0,0,0.06); }
.left-block { width:160px; min-width:120px; margin-left:12px; }
.compact-date { font-size:12px; color:#6c757d; }
.compact-user { font-size:11px; color:#8a8f94; margin-top:2px; }
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color:#6c757d; font-size:13px; }
.compact-arrow { color:#6c757d; font-size:14px; margin:0 4px; }
.compact-to { font-size:13px; padding:3px 8px; border-radius:10px; }
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }
.compact-comment summary { list-style:none; cursor:pointer; outline:none; padding:0; }
</style>
        <div class="form-section">
            <h4>المستثمر</h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="nom_prenom" 
                            value="<?php echo e(old('nom_prenom', $institution->investissements->first()?->utilisateur->nom_prenom)); ?>" 
                            placeholder="الاسم و اللقب" maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">مكان الولادة</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="lieu_naissance" 
                           value="<?php echo e(old('lieu_naissance', $institution->investissements->first()?->utilisateur->lieu_naissance)); ?>" 
                           placeholder="مكان الولادة">
                </div>

                <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                <div class="col-sm-4">
                    <input required type="date" class="form-control" name="date_naissance" 
                           value="<?php echo e(old('date_naissance', $institution->investissements->first()?->utilisateur->date_naissance)); ?>">
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                <div class="col-sm-4">
                    <select required class="form-control" id="id_type_identite" name="id_type_identite" onchange="showTypeIdentiteInput3()">
                        <option value="" disabled>اختر...</option>
                        <?php $__currentLoopData = $typesIdentite; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type->id_type); ?>" 
                                <?php echo e(old('id_type_identite', $institution->investissements->first()?->utilisateur->id_type_identite) == $type->id_type ? 'selected' : ''); ?>>
                                <?php echo e($type->type_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <div class="col-sm-6" id="cin_input_wrapper" style="display:<?php echo e($institution->investissements->first()?->utilisateur->id_type_identite == 1 ? 'block' : 'none'); ?>;">
                    <input type="text" class="form-control" id="cin_input" name="cin" 
                           value="<?php echo e(old('cin', $institution->investissements->first()?->utilisateur->cin)); ?>" 
                           placeholder="أدخل رقم بطاقة التعريف" pattern="^\d{8}$" maxlength="8">
                </div>
                <div class="col-sm-6" id="passport_field" style="display:<?php echo e($institution->investissements->first()?->utilisateur->id_type_identite == 2 ? 'block' : 'none'); ?>;">
                    <input type="text" class="form-control" id="passport_input" name="passport" 
                           value="<?php echo e(old('passport', $institution->investissements->first()?->utilisateur->passport)); ?>" 
                           placeholder="أدخل رقم جواز السفر" pattern="^\d{8,12}$" minlength="8" maxlength="12">
                </div>
                <div class="col-sm-6" id="fiscal_field" style="display:<?php echo e($institution->investissements->first()?->utilisateur->id_type_identite == 3 ? 'block' : 'none'); ?>;">
                    <input type="text" class="form-control" id="num_fiscal_input" name="num_fiscal" 
                           value="<?php echo e(old('num_fiscal', $institution->investissements->first()?->utilisateur->num_fiscal)); ?>" 
                           placeholder="أدخل رقم المعرف الجبائي" pattern="^\d{12}$" maxlength="12">
                </div>
            </div>

            <div class="form-group row mb-3" id="cin_extra_fields" style="display:<?php echo e($institution->investissements->first()?->utilisateur->id_type_identite == 1 ? 'flex' : 'none'); ?>;">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance_cin" name="date_delivrance_cin" 
                           value="<?php echo e(old('date_delivrance_cin', $institution->investissements->first()?->utilisateur->date_delivrance_cin)); ?>">
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance_cin" name="lieu_delivrance_cin" 
                           value="<?php echo e(old('lieu_delivrance_cin', $institution->investissements->first()?->utilisateur->lieu_delivrance_cin)); ?>">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" 
                           value="<?php echo e(old('adresse', $institution->investissements->first()?->utilisateur->adresse)); ?>" 
                           placeholder=" العنوان الشخصي " maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" 
                           value="<?php echo e(old('niveau_etude', $institution->investissements->first()?->utilisateur->niveau_etude)); ?>" 
                           placeholder=" المستوى التعليمي ">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome" 
                           value="<?php echo e(old('dernier_diplome', $institution->investissements->first()?->utilisateur->dernier_diplome)); ?>" 
                           placeholder="آخر شهادة متحصل عليها">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الاقدمية في تعاطي النشاط </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="experience" 
                           value="<?php echo e(old('experience', $institution->investissements->first()?->utilisateur->experience)); ?>" 
                           placeholder="الاقدمية في تعاطي النشاط" maxlength="50">
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4> خاصيات النشاط </h4>
            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <strong> المؤسسة الشبابية الخاصة</strong>
                    </label>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label">
                        <strong> الرجاء الاختبار </strong>
                    </label>
                </div>
        
                <div class="col-sm-4">
                    <select required class="form-control" id="type_espace_id" name="type_espace_id">
                        <option value="" disabled>اختر...</option>
                        <?php $__currentLoopData = $types_espace; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type->id_type); ?>"
                                <?php echo e(old('type_espace_id', $institution->type_espace_id) == $type->id_type ? 'selected' : ''); ?>>
                                <?php echo e($type->type_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u> مميزات الفضاء  </u>
                    </label>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> عدد الغرف </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_chambre" name="nbr_chambre" 
                        min="1"
                        value="<?php echo e(old('nbr_chambre', $institution->nbr_chambre)); ?>">
                </div>

                <label class="col-sm-2 col-form-label"> عدد القاعات </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_salles" name="nbr_salles" 
                        min="1"
                        value="<?php echo e(old('nbr_salles', $institution->nbr_salles)); ?>">
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u>طاقة الاستعاب</u>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">  بالمبيت </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="capacite_accueil_hebergement" 
                        name="capacite_accueil_hebergement" min="1"
                        value="<?php echo e(old('capacite_accueil_hebergement', $institution->capacite_accueil_hebergement)); ?>">
                </div>

                <label class="col-sm-2 col-form-label">  تحت الخيام </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="capacite_accueil_sous_tente" 
                        name="capacite_accueil_sous_tente" min="1"
                        value="<?php echo e(old('capacite_accueil_sous_tente', $institution->capacite_accueil_sous_tente)); ?>">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">  بفضاءات التنشيط </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="capacite_accueil_espace_animation" 
                        name="capacite_accueil_espace_animation" min="1"
                        value="<?php echo e(old('capacite_accueil_espace_animation', $institution->capacite_accueil_espace_animation)); ?>">
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label">
                        <u> الخدمات التي تؤمنها المؤسسة  </u>
                    </label>
                </div>
            </div>
            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="heberg_rest" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="heberg_rest" 
                    name="heberg_rest" value="1"
                    <?php echo e(old('heberg_rest', $institution->heberg_rest) == 1 ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="heberg_rest">
                    الإقامة والتغذية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="heberg_stage_activ" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="heberg_stage_activ" 
                    name="heberg_stage_activ" value="1"
                    <?php echo e(old('heberg_stage_activ', $institution->heberg_stage_activ) == 1 ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="heberg_stage_activ">
                    إيواء التربصات والأنشطة التكوينية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="camping" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="camping" name="camping" value="1"
                    <?php echo e(old('camping', $institution->camping) == 1 ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="camping">
                    التخييم
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="activ_educative" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="activ_educative" name="activ_educative" value="1"
                    <?php echo e(old('activ_educative', $institution->activ_educative) == 1 ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="activ_educative">
                    التنشيط التربوي والإجتماعي والثقافي
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="voyage" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="voyage" name="voyage" value="1"
                    <?php echo e(old('voyage', $institution->voyage) == 1 ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="voyage">
                    الرحلات الداخلية والخارجية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="evenement" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="evenement" name="evenement" value="1"
                    <?php echo e(old('evenement', $institution->evenement) == 1 ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="evenement">
                    التظاهرات الثقافية والحفلات
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="autre" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="autre" name="autre" value="1"
                    <?php echo e(old('autre', $institution->autre) == 1 ? 'checked' : ''); ?>>
                <label class="col-sm-6 col-form-label" for="autre">
                    غير ذلك
                </label>
            </div>

            <div class="form-group row mb-3 align-items-center">
                <label class="col-sm-2 col-form-label">الاسم التجاري للمشروع</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="nom_projet" 
                        placeholder="الاسم التجاري للمشروع" maxlength="50"
                        value="<?php echo e(old('nom_projet', $institution->nom_projet)); ?>">
                </div>

                <label class="col-sm-2 col-form-label" for="nature_projet_id">طبيعة المشروع</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="nature_projet_id" name="nature_projet_id">
                        <option value="" disabled>اختر...</option>
                        <?php $__currentLoopData = $nature_projet; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $nature): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($nature->id_nature_p); ?>"
                                <?php echo e(old('nature_projet_id', $institution->nature_projet_id) == $nature->id_nature_p ? 'selected' : ''); ?>>
                                <?php echo e($nature->nature_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">عدد مواطن الشغل</label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_emplois" name="nbr_emplois" min="1"
                        value="<?php echo e(old('nbr_emplois', $institution->nbr_emplois)); ?>">
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u>مدير المؤسسة</u>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="nom_prenom_d" maxlength="50"
                        placeholder="الاسم و اللقب"
                        value="<?php echo e(old('nom_prenom_d', $institution->directeur->nom_prenom_d ?? '')); ?>">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">رقم بطاقة التعريف الوطنية</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="num_cin" maxlength="8"
                        value="<?php echo e(old('num_cin', $institution->directeur->num_cin ?? '')); ?>">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance" name="date_delivrance"
                        value="<?php echo e(old('date_delivrance', $institution->directeur->date_delivrance ?? '')); ?>">
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance" name="lieu_delivrance" placeholder="مكان الإصدار"
                        value="<?php echo e(old('lieu_delivrance', $institution->directeur->lieu_delivrance ?? '')); ?>">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">المستوى التعليمي</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="niveau_etude" placeholder="المستوى التعليمي"
                        value="<?php echo e(old('niveau_etude', $institution->directeur->niveau_etude ?? '')); ?>">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="dernier_diplome_obtenu" placeholder="آخر شهادة متحصل عليها"
                        value="<?php echo e(old('dernier_diplome_obtenu', $institution->directeur->dernier_diplome_obtenu ?? '')); ?>">
                </div>
            </div>
        </div>
        <h4>جدول الاستثمار و التمويل</h4>
        <div class="form-group row">
            <table id="investissement-table" class="custom-table">
                <thead>
                    <tr>
                        <th>الإستثمار</th>
                        <th>مبلغ الإستثمار</th>
                        <th>مصادر التمويل</th>
                        <th>مبلغ التمويل</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody id="investissement-body">
                    <?php $__currentLoopData = $institution->investissements; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $inv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <tr>
                        <td data-label="الإستثمار">
                            <select class="form-control" name="investissements[<?php echo e($index); ?>][secteur_invest_id]" id="secteur_invest_id_<?php echo e($index); ?>">
                                <option value="" disabled>اختر...</option>
                                <?php $__currentLoopData = $secteurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $secteur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($secteur->id_secteur); ?>" 
                                        <?php echo e($inv->secteur_invest_id == $secteur->id_secteur ? 'selected' : ''); ?>>
                                        <?php echo e($secteur->secteur_ar); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </td>
                        <td data-label="مبلغ الإستثمار">
                            <input type="number" name="investissements[<?php echo e($index); ?>][montant_inv]" 
                                class="form-control" min=1 value="<?php echo e($inv->montant_inv); ?>">
                        </td>
                        <td data-label="مصادر التمويل">
                            <select class="form-control" name="investissements[<?php echo e($index); ?>][id_source_financement]" id="id_source_financement_<?php echo e($index); ?>">
                                <option value="" disabled>اختر...</option>
                                <?php $__currentLoopData = $source_fin; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $source): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                    <option value="<?php echo e($source->id_source); ?>" 
                                        <?php echo e($inv->id_source_financement == $source->id_source ? 'selected' : ''); ?>>
                                        <?php echo e($source->source_ar); ?>

                                    </option>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                            </select>
                        </td>
                        <td data-label="مبلغ التمويل">
                            <input type="number" name="investissements[<?php echo e($index); ?>][montant_fin]" 
                                class="form-control" min=1 value="<?php echo e($inv->montant_fin); ?>">
                        </td>
                        <td class="action-buttons">
                            <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </tbody>
            </table>

            <button type="button" class="btn btn-primary mt-2" onclick="addInvestissementRow()" 
                    style="background-color: #28a745; border-color: #28a745;">
                إضافة صف
            </button>
        </div>

        <div class="mt-3">
            <h4>تصريح على الشرف</h4>
            <span>
                إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4> ملاحظات خاصة بالمندوبية الجهوية : </h4>
            <textarea class="form-control mt-2" name="remarques" rows="6" placeholder="اكتب ملاحظاتك هنا..."><?php echo e(old('remarques', $institution->remarques)); ?></textarea>
        </div>

       
		  <div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                <button type="submit" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill">
                <i class="bx bx-save"></i> حفظ
                </button>
                <a href="<?php echo e(route('admin.jeunesse.index')); ?>" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    </form>
</div>


<script>
    let investIndex = <?php echo e(count($institution->investissements)); ?>; 

    function addInvestissementRow() {
        let tableBody = document.getElementById('investissement-body');

        let newRow = `
            <tr>
                <td data-label="الإستثمار">
                    <select class="form-control" name="investissements[${investIndex}][secteur_invest_id]" id="secteur_invest_id_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        <?php $__currentLoopData = $secteurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $secteur): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($secteur->id_secteur); ?>"><?php echo e($secteur->secteur_ar); ?></option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
                <td data-label="مبلغ الإستثمار">
                    <input type="number" name="investissements[${investIndex}][montant_inv]" class="form-control" min=1>
                </td>
                <td data-label="مصادر التمويل">
                    <select class="form-control" name="investissements[${investIndex}][id_source_financement]" id="id_source_financement_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        <?php $__currentLoopData = $source_fin; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $source): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($source->id_source); ?>"><?php echo e($source->source_ar); ?></option>
                         <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </td>
                <td data-label="مبلغ التمويل">
                    <input type="number" name="investissements[${investIndex}][montant_fin]" class="form-control" min=1>
                </td>
                <td class="action-buttons">
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                </td>
            </tr>
        `;

        tableBody.insertAdjacentHTML('beforeend', newRow);
        investIndex++;
    }

    function removeRow(button) {
        let row = button.closest('tr');
        row.remove();
    }
</script>

<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('login')); ?>";
    </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/investissement/gestion_jeunesse/edit.blade.php ENDPATH**/ ?>