<?php $__env->startSection('content'); ?>
<!--link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire.css')); ?>"-->
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire_edit.css')); ?>">

<?php if(Auth::check()): ?>
    <style>
        /* Styles pour le stepper */
        .stepper-wrapper {
            margin-top: 20px;
            margin-bottom: 20px;
        }
        
        .step-content {
            display: none;
        }
        
        .step-content.active {
            display: block;
        }
        
        .stepper-nav {
            display: flex;
            justify-content: space-between;
            margin-top: 20px;
            padding: 10px;
        }
        
        .step-indicator {
            text-align: center;
            margin-bottom: 20px;
            direction: rtl;
        }
        
        .step-indicator span {
            display: inline-block;
            margin: 0 10px;
            padding: 5px 15px;
            background-color: #f8f9fa;
            border-radius: 15px;
        }
        
        .step-indicator span.active {
            background-color: #007bff;
            color: white;
        }
        /* Taille des boutons réduite */
        .form-group button,
        .form-group a {
            min-width: 140px;
            font-weight: bold;
            border: none;
            border-radius: 8px;
            font-size: 14px;
            padding: 6px 10px;
            box-shadow: 0 3px 6px rgba(0,0,0,0.1);
            transition: all 0.2s ease-in-out;
        }

        .form-group button:hover,
        .form-group a:hover {
            transform: translateY(-2px);
            box-shadow: 0 4px 8px rgba(0,0,0,0.15);
        }

        /* Dégradé orange pour "حفظ كمسودة" */
        .btn-orange-gradient {
            background: linear-gradient(135deg, #ff9f43, #e96b05);
            color: #fff;
        }
        .btn-orange-gradient:hover {
            background: linear-gradient(135deg, #ffa94d, #ff7b1a);
        }

        /* Bouton Retour bleu */
        .btn-primary {
            background-color: #007bff;
        }
        .btn-primary:hover {
            background-color: #0069d9;
        }

        /* Responsive - garder même ligne si possible */
        @media (max-width: 768px) {
            .form-group .d-flex {
                flex-wrap: wrap;
                justify-content: center;
            }
            .form-group button,
            .form-group a {
                min-width: 120px;
                font-size: 13px;
                padding: 5px 8px;
            }
        }
    	
        .text-danger2 {
            color: #dc3545;
            font-size: 15px;
            margin-top: 4px;
            display: block;
            font-weight: 600;
        }

        .is-invalid {
            border-color: #dc3545 !important;
            background-color: #fff5f5 !important;
        }

        .is-invalid:hover {
            border-color: #ff0000 !important;
            background-color: #ffe8e8 !important;
        }
    </style>

    <script>
        let currentStep = 1;
        const totalSteps = 3;

        function showStep(step) {
            // Cacher tous les contenus
            document.querySelectorAll('.step-content').forEach(content => {
                content.classList.remove('active');
            });
            
            // Afficher le contenu actuel
            document.querySelector(`#step${step}`).classList.add('active');
            
            // Mettre à jour les indicateurs
            document.querySelectorAll('.step-indicator span').forEach(indicator => {
                indicator.classList.remove('active');
            });
            document.querySelector(`#step${step}-indicator`).classList.add('active');
            
            // Gérer l'affichage des boutons
            document.getElementById('prevBtn').style.display = step === 1 ? 'none' : 'block';
            document.getElementById('nextBtn').textContent = step === totalSteps ? 'إنهاء' : 'التالي';
        }

        function nextStep() {
            if (currentStep < totalSteps) {
                currentStep++;
                showStep(currentStep);
            } else {
                // Si on est à la dernière étape, soumettre le formulaire
                document.querySelector('form').submit();
            }
        }

        function prevStep() {
            if (currentStep > 1) {
                currentStep--;
                showStep(currentStep);
            }
        }

        // Initialiser le stepper
        document.addEventListener('DOMContentLoaded', () => {
            showStep(1);
        });
    </script>

    <div class="salle-sport-edit">
        <form action="<?php echo e(route('financement.storeAll')); ?>" method="POST" enctype="multipart/form-data" lang="ar">
            <?php echo csrf_field(); ?>
            <div class="stepper-wrapper">
                <div class="step-indicator">
                    <span class="active" id="step1-indicator">الخطوة 1</span>
                    <span id="step2-indicator">الخطوة 2</span>
                    <span id="step3-indicator">الخطوة 3</span>
                </div>

                

<div id="step1" class="step-content active">
        <div class="container" lang="ar" dir="rtl">
                        <input type="hidden" name="id_association" value="<?php echo e($association->id_association ?? ''); ?>">
                        <input type="hidden" name="id_demande" value="<?php echo e($demande_id ?? ''); ?>">
                        <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire->id_type); ?>">

                        <h2 class="text-center">الجمهورية 2  التونسية</h2>
                        <h3 class="text-center">وزارة شؤون الشباب و الرياضة</h3>
                        <h4 class="text-center mt-4">اللجنة الفنية للنظر في مطالب التمويل العمومي</h4>

                        <div class="card mt-4 shadow-sm">
                            <div class="card-header text-center bg-white">
                                <div class="row mb-3 align-items-center">
                                    <label  style="color:black;"    class="col-sm-3 col-form-label">إسم الجمعية</label>
                                    <div class="col-sm-9">
<input type="text" name="nom_association"
                                            class="form-control step1-field <?php $__errorArgs = ['nom_association'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            value="<?php echo e(old('nom_association', $association->nom_association ?? '')); ?>">
                                        <?php $__errorArgs = ['nom_association'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>                                    </div>
                                </div>
                            </div>
                            <div class="card-header text-center bg-light">
                                <h5 class="mb-0"><?php echo e($formulaire->type_ar); ?></h5>
                                
                            </div>
                            <div class="card-body">
                                <div class="row">

                                 <?php
        // valeurs précédentes : priorise old(), sinon selectedTypes fourni par le contrôleur
        $oldTypes = old('types_financement', $selectedTypes ?? []);
        if (!is_array($oldTypes)) {
            $oldTypes = [];
        }
        $hasTypesError = $errors->has('types_financement');
    ?>


                                    <?php $__currentLoopData = $type_financement; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="col-md-4 col-sm-6 mb-2 text-center">
            <div class="form-check d-flex justify-content-start" dir="rtl">
                <input
                    class="form-check-input me-2 text-center step1-field <?php echo e($hasTypesError ? 'is-invalid' : ''); ?>"
                    type="checkbox" require
                    name="types_financement[]"
                    value="<?php echo e($type->id_type_fin); ?>"
                    <?php echo e(in_array($type->id_type_fin, $oldTypes) ? 'checked' : ''); ?>>
                <label class="col-sm-12 col-form-label" style="color:black;">
                    <?php echo e($type->type_ar); ?>

                </label>
            </div>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                </div>

                                <?php if($errors->has('types_financement')): ?>
    <small class="text-danger2 d-block mt-1"><?php echo e($errors->first('types_financement')); ?></small>
<?php endif; ?>

                            </div>
                        </div>

                        <div class="card mt-4 shadow-sm">
                            <div class="card-header text-center bg-light">
                                <h5 class="mb-0">المعطيات الخاصة بالجمعية</h5>
                            </div>
                            <div class="card-body">
                                <div class="row mb-3 align-items-center">
                                    <label style="color:black;" class="col-sm-3 col-form-label">عنوان الجمعية</label>
                                    <div class="col-sm-9">
                                        <input type="text" name="adresse"
                                            class="form-control step1-field <?php $__errorArgs = ['adresse'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            value="<?php echo e(old('adresse', $association->adresse ?? '')); ?>">
                                        <?php $__errorArgs = ['adresse'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">الترقيم البريدي</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="code_postal"
                                            class="form-control step1-field <?php $__errorArgs = ['code_postal'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            value="<?php echo e(old('code_postal', $association->code_postal ?? '')); ?>">
                                        <?php $__errorArgs = ['code_postal'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <label style="color:black;" class="col-sm-2 col-form-label">الهاتف</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="tel"
                                            class="form-control step1-field <?php $__errorArgs = ['tel'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            value="<?php echo e(old('tel', $association->tel ?? '')); ?>">
                                        <?php $__errorArgs = ['tel'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">الفاكس</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="fax" class="form-control step1-field" value="<?php echo e(old('fax', $association->fax ?? '')); ?>" >
                                    <?php $__errorArgs = ['fax'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">تاريخ التأسيس</label>
                                    <div class="col-sm-4">
                                        <input type="date" name="date_creation" class="form-control step1-field" value="<?php echo e(old('date_creation', $association->date_creation ?? '')); ?>" >
                                     <?php $__errorArgs = ['date_creation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    
                                </div>

                                <div class="form-group row mb-3">
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">رقم التأشيرة</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="num_visa" class="form-control step1-field" value="<?php echo e(old('num_visa', $association->num_visa ?? '')); ?>" >
                                    <?php $__errorArgs = ['num_visa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                    <label  style="color:black;"    class="col-sm-2 col-form-label">تاريخ التأشيرة</label>
                                    <div class="col-sm-4">
                                        <input type="date" name="date_visa" class="form-control step1-field" value="<?php echo e(old('date_visa', $association->date_visa ?? '')); ?>" >
                                    <?php $__errorArgs = ['date_visa'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">رقم المعرف الجبائي</label>
                                    <div class="col-sm-10">
                                        <input type="text" name="num_identification_fiscale"
                                            class="form-control step1-field <?php $__errorArgs = ['num_identification_fiscale'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            value="<?php echo e(old('num_identification_fiscale', $association->num_identification_fiscale ?? '')); ?>">
                                        <?php $__errorArgs = ['num_identification_fiscale'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">رقم الحساب الجاري</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="num_compte_courant"
                                            class="form-control step1-field <?php $__errorArgs = ['num_compte_courant'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            value="<?php echo e(old('num_compte_courant', $association->num_compte_courant ?? '')); ?>">
                                        <?php $__errorArgs = ['num_compte_courant'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <label style="color:black;" class="col-sm-2 col-form-label">البنك</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="banque"
                                            class="form-control step1-field <?php $__errorArgs = ['banque'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            value="<?php echo e(old('banque', $association->banque ?? '')); ?>">
                                        <?php $__errorArgs = ['banque'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">البريد الإلكتروني</label>
                                    <div class="col-sm-4">
                                        <input type="email" name="adresse_mail"
                                            class="form-control step1-field <?php $__errorArgs = ['adresse_mail'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            value="<?php echo e(old('adresse_mail', $association->adresse_mail ?? '')); ?>">
                                        <?php $__errorArgs = ['adresse_mail'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <label style="color:black;" class="col-sm-2 col-form-label">عنوان موقع الواب</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="adresse_site_internet"
                                            class="form-control step1-field <?php $__errorArgs = ['adresse_site_internet'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            value="<?php echo e(old('adresse_site_internet', $association->adresse_site_internet ?? '')); ?>">
                                        <?php $__errorArgs = ['adresse_site_internet'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">إسم رئيس الجمعية</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="nom_president_association"
                                            class="form-control step1-field <?php $__errorArgs = ['nom_president_association'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            value="<?php echo e(old('nom_president_association', $association->nom_president_association ?? '')); ?>">
                                        <?php $__errorArgs = ['nom_president_association'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <label style="color:black;" class="col-sm-2 col-form-label">الهاتف الشخصي</label>
                                    <div class="col-sm-4">
                                        <input type="text" name="tel_personnel"
                                            class="form-control step1-field <?php $__errorArgs = ['tel_personnel'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            value="<?php echo e(old('tel_personnel', $association->tel_personnel ?? '')); ?>">
                                        <?php $__errorArgs = ['tel_personnel'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">عدد أعضاء المكتب الوطني للجمعية</label>
                                    <div class="col-sm-4">
                                        <input type="number" name="num_membre_bureau_national_a"
                                            class="form-control step1-field <?php $__errorArgs = ['num_membre_bureau_national_a'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            value="<?php echo e(old('num_membre_bureau_national_a', $association->num_membre_bureau_national_a ?? '')); ?>">
                                        <?php $__errorArgs = ['num_membre_bureau_national_a'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>

                                    <label style="color:black;" class="col-sm-2 col-form-label">عدد المكاتب الجهوية ان وجدت</label>
                                    <div class="col-sm-4">
                                        <input type="number" name="num_bureaux_regionaux"
                                            class="form-control step1-field <?php $__errorArgs = ['num_bureaux_regionaux'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            value="<?php echo e(old('num_bureaux_regionaux', $association->num_bureaux_regionaux ?? '')); ?>">
                                        <?php $__errorArgs = ['num_bureaux_regionaux'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>

                                <div class="form-group row mb-3">
                                    <label style="color:black;" class="col-sm-2 col-form-label">عدد المنخرطين الاجمالي</label>
                                    <div class="col-sm-4">
                                        <input type="number" name="num_total_membre"
                                            class="form-control step1-field <?php $__errorArgs = ['num_total_membre'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                            value="<?php echo e(old('num_total_membre', $association->num_total_membre ?? '')); ?>">
                                        <?php $__errorArgs = ['num_total_membre'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    </div>
                                </div>
                            </div>
                        </div>
                </div>
            
        </div>
    <div id="step2" class="step-content">
        <div class="container" lang="ar" dir="rtl">
                    <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire2->id_type); ?>">
                    <input type="hidden" name="id_demande" value="<?php echo e($demande_id); ?>">
                    <h2 class="text-center">الجمهورية التونسية</h2>
                    <h2 class="text-center">وزارة الشباب و الرياضة</h2>
                    <h3 class="text-center" style="font-size:25px;"><?php echo e($formulaire2->type_ar); ?></h3>
                    <h4 class="text-center pt-3">جذاذة فنية</h4>
                    <br>

                    <div class="form-section">
                        <h4>  المعطيات البيداغوجية</h4>
                        <div class="form-group row mb-3"  style="padding-top:20px;">
                            <label class="col-sm-2 col-form-label"> اسم و لقب المشرف على التنفيذ </label>
                            <div class="col-sm-4">
                                <input type="text"
                                    class="form-control step2-field <?php $__errorArgs = ['nom_prenom_sup'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="nom_prenom_sup"
                                    placeholder="الاسم و اللقب"
                                    maxlength="100"
                                    value="<?php echo e(old('nom_prenom_sup')); ?>">
                                <?php $__errorArgs = ['nom_prenom_sup'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <label class="col-sm-2 col-form-label">  المهنة </label>
                            <div class="col-sm-4">
                                <input type="text"
                                    class="form-control step2-field <?php $__errorArgs = ['profession_sup'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="profession_sup"
                                    placeholder="المهنة"
                                    maxlength="100"
                                    value="<?php echo e(old('profession_sup')); ?>">
                                <?php $__errorArgs = ['profession_sup'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-group row align-items-center">
                            <label class="col-sm-2 col-form-label"> الصفة في الجمعية</label>  
                            <div class="col-sm-4">
                                <input type="text"
                                    class="form-control step2-field <?php $__errorArgs = ['role_sup'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="role_sup"
                                    placeholder="الصفة"
                                    maxlength="100"
                                    value="<?php echo e(old('role_sup')); ?>">
                                <?php $__errorArgs = ['role_sup'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                            <label class="col-sm-2 col-form-label">  الهاتف </label>
                            <div class="col-sm-4">
                                <input type="text"
                                    class="form-control step2-field <?php $__errorArgs = ['tel_sup'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="tel_sup"
                                    maxlength="12"
                                    value="<?php echo e(old('tel_sup')); ?>">
                                <?php $__errorArgs = ['tel_sup'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">  البريد الالكتروني </label>
                            <div class="col-sm-4">
                                <input type="email"
                                    class="form-control step2-field <?php $__errorArgs = ['email_sup'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="email_sup"
                                    value="<?php echo e(old('email_sup')); ?>">
                                <?php $__errorArgs = ['email_sup'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label"> اسم المشروع / التظاهرة / النشاط </label>
                            <div class="col-sm-10">
                                <input type="text"
                                    class="form-control step2-field <?php $__errorArgs = ['nom_projet'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                    name="nom_projet"
                                    maxlength="255"
                                    value="<?php echo e(old('nom_projet')); ?>">
                                <?php $__errorArgs = ['nom_projet'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">مبررات الانجاز</label>
                            <div class="col-sm-10">
                                <textarea class="form-control step2-field <?php $__errorArgs = ['justification_realisation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="justification_realisation"
                                        maxlength="255"
                                        rows="4"
                                        placeholder="ادخل مبررات الانجاز"><?php echo e(old('justification_realisation')); ?></textarea>
                                <?php $__errorArgs = ['justification_realisation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>
                        <div class="form-group row mb-3">
                            <label class="col-sm-2 col-form-label">الاهداف</label>
                            <div class="col-sm-10">
                                <textarea class="form-control step2-field <?php $__errorArgs = ['objectives'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                                        name="objectives"
                                        rows="4"
                                        placeholder="ادخل الاهداف"><?php echo e(old('objectives')); ?></textarea>
                                <?php $__errorArgs = ['objectives'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                    <small class="text-danger2 d-block mb-1"><?php echo e($message); ?></small>
                                <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                            </div>
                        </div>

                        <div class="form-group row mb-3">
    <label class="col-sm-6 col-form-label">وصف الفقرات أو المراحل</label>
</div>

<div class="form-group row" style="direction: rtl; text-align: right;">
    <table id="phase-table" class="table table-bordered text-center align-middle shadow-sm">
        <thead class="table-success">
            <tr>
                <th style="width:5%">#</th>
                <th style="width:35%">أهم الفقرات أو المراحل</th>
                <th style="width:20%">تاريخ الإنجاز</th>
                <th style="width:30%">مكان الإنجاز</th>
                <th style="width:10%">إجراء</th>
            </tr>
        </thead>

        <?php
$oldPhases = old('phases', []);

// Si oldPhases est vide ou toutes les lignes sont vides, alors on initialise avec une ligne vide
$allEmpty = true;
if (is_array($oldPhases) && count($oldPhases) > 0) {
    foreach($oldPhases as $phase) {
        if (!empty($phase['description']) || !empty($phase['completion_date']) || !empty($phase['completion_location'])) {
            $allEmpty = false;
            break;
        }
    }
}

if (!is_array($oldPhases) || count($oldPhases) === 0 || $allEmpty) {
    $oldPhases = [
        ['description' => '', 'completion_date' => '', 'completion_location' => '']
    ];
}
?>
        <tbody id="phase-body">
            <?php $__currentLoopData = $oldPhases; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $p): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <tr>
                    
<td class="row-number fw-bold"><?php echo e((int)$i + 1); ?></td>
                    <td>
                        <input type="text"
                               name="phases[<?php echo e($i); ?>][description]"
                               class="form-control step2-field <?php $__errorArgs = ["phases.{$i}.description"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               placeholder="أدخل الفقرة"
                               maxlength="200"
                               value="<?php echo e(old("phases.{$i}.description", $p['description'] ?? '')); ?>">
                        <?php if($errors->has("phases.{$i}.description")): ?>
                            <small class="text-danger2 d-block mt-1"><?php echo e($errors->first("phases.{$i}.description")); ?></small>
                        <?php endif; ?>
                    </td>

                    <td>
                        <input type="date"
                               name="phases[<?php echo e($i); ?>][completion_date]"
                               class="form-control step2-field <?php $__errorArgs = ["phases.{$i}.completion_date"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               value="<?php echo e(old("phases.{$i}.completion_date", $p['completion_date'] ?? '')); ?>">
                        <?php if($errors->has("phases.{$i}.completion_date")): ?>
                            <small class="text-danger2 d-block mt-1"><?php echo e($errors->first("phases.{$i}.completion_date")); ?></small>
                        <?php endif; ?>
                    </td>

                    <td>
                        <input type="text"
                               name="phases[<?php echo e($i); ?>][completion_location]"
                               class="form-control step2-field <?php $__errorArgs = ["phases.{$i}.completion_location"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                               placeholder="أدخل المكان"
                               maxlength="100"
                               value="<?php echo e(old("phases.{$i}.completion_location", $p['completion_location'] ?? '')); ?>">
                        <?php if($errors->has("phases.{$i}.completion_location")): ?>
                            <small class="text-danger2 d-block mt-1"><?php echo e($errors->first("phases.{$i}.completion_location")); ?></small>
                        <?php endif; ?>
                    </td>

                    <td class="text-center action-buttons" style="white-space: nowrap;">
                        <div class="d-flex gap-2 justify-content-center align-items-center">
                            <button type="button" class="btn btn-outline-danger btn-circle" onclick="removePhaseRow(this)" title="حذف">
                                <i class="bx bx-trash fs-5"></i>
                            </button>
                            <button type="button" class="btn btn-outline-success btn-circle" onclick="addPhaseRow()" title="إضافة">
                                <i class="bx bx-plus fs-5"></i>
                            </button>
                        </div>
                    </td>
                </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>
<script>
function addPhaseRow() {
    const tbody = document.getElementById('phase-body');
    const rowCount = tbody.rows.length;

    const newRow = document.createElement('tr');
    newRow.innerHTML = `
        <td class="row-number fw-bold">${rowCount + 1}</td>
        <td><input type="text" name="phases[${rowCount}][description]" class="form-control step2-field" placeholder="أدخل الفقرة" maxlength="200"></td>
        <td><input type="date" name="phases[${rowCount}][completion_date]" class="form-control step2-field"></td>
        <td><input type="text" name="phases[${rowCount}][completion_location]" class="form-control step2-field" placeholder="أدخل المكان" maxlength="100"></td>
        <td class="text-center action-buttons" style="white-space: nowrap;">
            <div class="d-flex gap-2 justify-content-center align-items-center">
                <button type="button" class="btn btn-outline-danger btn-circle" onclick="removePhaseRow(this)" title="حذف">
                    <i class="bx bx-trash fs-5"></i>
                </button>
                <button type="button" class="btn btn-outline-success btn-circle" onclick="addPhaseRow()" title="إضافة">
                    <i class="bx bx-plus fs-5"></i>
                </button>
            </div>
        </td>
    `;
    tbody.appendChild(newRow);
}


function removePhaseRow(button) {
    const row = button.closest('tr');
    const tbody = row.closest('tbody');
    row.remove();
    updatePhaseRowNumbers();
}

function updatePhaseRowNumbers() {
    const tbody = document.getElementById('phase-body');
    // mettre à jour les numéros visibles
    [...tbody.querySelectorAll('.row-number')].forEach((cell, i) => {
        cell.textContent = i + 1;
    });

    // renommer les name pour indices consécutifs (important pour la validation)
    [...tbody.querySelectorAll('tr')].forEach((tr, i) => {
        const desc = tr.querySelector('input[name*="[description]"]');
        if (desc) desc.name = `phases[${i}][description]`;
        const date = tr.querySelector('input[name*="[completion_date]"]');
        if (date) date.name = `phases[${i}][completion_date]`;
        const loc = tr.querySelector('input[name*="[completion_location]"]');
        if (loc) loc.name = `phases[${i}][completion_location]`;
    });
}

document.addEventListener('DOMContentLoaded', updatePhaseRowNumbers);
</script>






                        <div class="form-group row mb-3">
    <label class="col-sm-2 col-form-label">الجمهور المستفيد</label>
    <div class="col-sm-10">
        <input type="text" class="form-control step2-field <?php $__errorArgs = ['public'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
               name="public"
               maxlength="255"
               value="<?php echo e(old('public', $association->public ?? '')); ?>">
        <?php $__errorArgs = ['public'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <small class="text-danger2 d-block mt-1"><?php echo e($message); ?></small>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>
</div>

<div class="form-group row mb-3">
    <label class="col-sm-2 col-form-label">العدد التقريبي للجمهور</label>
    <div class="col-sm-10">
        <input type="number" class="form-control step2-field <?php $__errorArgs = ['nombre_spectateur'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
               name="nombre_spectateur"
               value="<?php echo e(old('nombre_spectateur', $association->nombre_spectateur ?? '')); ?>">
        <?php $__errorArgs = ['nombre_spectateur'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <small class="text-danger2 d-block mt-1"><?php echo e($message); ?></small>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>
</div>

<div class="form-group row mb-3 align-items-center">
    <label class="col-sm-2 col-form-label">الشريحة العمرية المستهدفة</label>
    <div class="col-sm-5 d-flex align-items-center">
        <label class="col-form-label mb-0 me-3">من</label>
        <input type="number" class="form-control step2-field <?php $__errorArgs = ['tranch_age_min'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
               name="tranch_age_min"
               value="<?php echo e(old('tranch_age_min', $association->tranch_age_min ?? '')); ?>">
        <?php $__errorArgs = ['tranch_age_min'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <small class="text-danger2 d-block mt-1"><?php echo e($message); ?></small>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>

    <div class="col-sm-5 d-flex align-items-center">
        <label class="col-form-label mb-0 me-3">الى</label>
        <input type="number" class="form-control step2-field <?php $__errorArgs = ['tranch_age_max'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
               name="tranch_age_max"
               value="<?php echo e(old('tranch_age_max', $association->tranch_age_max ?? '')); ?>">
        <?php $__errorArgs = ['tranch_age_max'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <small class="text-danger2 d-block mt-1"><?php echo e($message); ?></small>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>
</div>

<div class="form-group row mb-3">
    <label class="col-sm-6 col-form-label">الأطراف المشاركة في الإنجاز</label>
    <div class="col-sm-12">
        <textarea class="form-control step2-field <?php $__errorArgs = ['parties_realisation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                  name="parties_realisation"
                  rows="4"><?php echo e(old('parties_realisation', $association->parties_realisation ?? '')); ?></textarea>
        <?php $__errorArgs = ['parties_realisation'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <small class="text-danger2 d-block mt-1"><?php echo e($message); ?></small>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>
</div>
                        <div class="form-group row mb-3">
    <label class="col-sm-6 col-form-label">النتائج المرتقب تحقيقها</label>
</div>

<div class="form-group row mb-3">
    <label class="col-sm-6 col-form-label">1- النتائج الكمية</label>
    <div class="col-sm-12">
        <textarea class="form-control step2-field <?php $__errorArgs = ['resultat_quantitatif'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                  name="resultat_quantitatif"
                  rows="4"><?php echo e(old('resultat_quantitatif', $association->resultat_quantitatif ?? '')); ?></textarea>
        <?php $__errorArgs = ['resultat_quantitatif'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <small class="text-danger2 d-block mt-1"><?php echo e($message); ?></small>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>
</div>

<div class="form-group row mb-3">
    <label class="col-sm-6 col-form-label">2- النتائج النوعية</label>
    <div class="col-sm-12">
        <textarea class="form-control step2-field <?php $__errorArgs = ['resultat_qualitatif'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                  name="resultat_qualitatif"
                  rows="4"><?php echo e(old('resultat_qualitatif', $association->resultat_qualitatif ?? '')); ?></textarea>
        <?php $__errorArgs = ['resultat_qualitatif'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <small class="text-danger2 d-block mt-1"><?php echo e($message); ?></small>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>
</div>

<div class="form-group row mb-3">
    <label class="col-sm-6 col-form-label">الآفاق المنتظرة</label>
    <div class="col-sm-12">
        <textarea class="form-control step2-field <?php $__errorArgs = ['perspectives'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                  name="perspectives"
                  rows="4"><?php echo e(old('perspectives', $association->perspectives ?? '')); ?></textarea>
        <?php $__errorArgs = ['perspectives'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
            <small class="text-danger2 d-block mt-1"><?php echo e($message); ?></small>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>
</div>

                    </div>

<div class="form-section">
    <h4>الموازنة المالية</h4>
    <label class="col-sm-6 col-form-label">الميزانية التقديرية</label>

    <div class="form-group row">
        <table class="table table-bordered text-center align-middle shadow-sm">
            <thead class="table-success">
                <tr>
                    <th rowspan="2">الكلفة الجملية التقديرية<br>(المبلغ بالدينار التونسي)</th>
                    <th colspan="2">حجم التمويل الذاتي</th>
                    <th colspan="2">حجم الدعم المطلوب من الوزارة</th>
                </tr>
                <tr>
                    <th>النسبة المائوية</th>
                    <th>المبلغ بالدينار</th>
                    <th>المبلغ بالدينار</th>
                    <th>النسبة المائوية</th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td>
                        <input type="number" name="budget[0][total_cost]" 
                            class="form-control step2-field <?php $__errorArgs = ['budget.0.total_cost'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            value="<?php echo e(old('budget.0.total_cost')); ?>">
                        <?php $__errorArgs = ['budget.0.total_cost'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger2 d-block mt-1"><?php echo e($message); ?></small>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </td>
                    <td>
                        <input type="number" name="budget[0][self_percent]" 
                            class="form-control step2-field <?php $__errorArgs = ['budget.0.self_percent'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            value="<?php echo e(old('budget.0.self_percent')); ?>">
                        <?php $__errorArgs = ['budget.0.self_percent'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger2 d-block mt-1"><?php echo e($message); ?></small>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </td>
                    <td>
                        <input type="number" name="budget[0][self_amount]" 
                            class="form-control step2-field <?php $__errorArgs = ['budget.0.self_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            value="<?php echo e(old('budget.0.self_amount')); ?>">
                        <?php $__errorArgs = ['budget.0.self_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger2 d-block mt-1"><?php echo e($message); ?></small>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </td>
                    <td>
                        <input type="number" name="budget[0][ministry_amount]" 
                            class="form-control step2-field <?php $__errorArgs = ['budget.0.ministry_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            value="<?php echo e(old('budget.0.ministry_amount')); ?>">
                        <?php $__errorArgs = ['budget.0.ministry_amount'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger2 d-block mt-1"><?php echo e($message); ?></small>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </td>
                    <td>
                        <input type="number" name="budget[0][ministry_percent]" 
                            class="form-control step2-field <?php $__errorArgs = ['budget.0.ministry_percent'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                            value="<?php echo e(old('budget.0.ministry_percent')); ?>">
                        <?php $__errorArgs = ['budget.0.ministry_percent'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                            <small class="text-danger2 d-block mt-1"><?php echo e($message); ?></small>
                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                    </td>
                </tr>
            </tbody>
        </table>
    </div>

     <label class="col-sm-6 col-form-label fw-bold">الأطراف المساهمة في الدعم</label>
    <div class="form-group row" style="direction: rtl; text-align: right;">
    <table id="supporters-table" class="table table-bordered align-middle text-center shadow-sm">
        <thead class="table-success">
            <tr>
                <th style="width: 5%">ع/ر</th>
                <th style="width: 35%">الطرف المساهم</th>
                <th style="width: 20%">المبلغ بالدينار</th>
                <th style="width: 20%">النسبة المائوية</th>
                <th style="width: 10%">إجراء</th>
            </tr>
        </thead>

        <?php
        $oldSupporters = old('budget.0.supporters', []);
        if (!is_array($oldSupporters) || count($oldSupporters) === 0) {
            $oldSupporters = [
                ['name' => '', 'amount' => '', 'percent' => '']
            ];
        }
        ?>

        <tbody id="supporters-body">
            <?php $__currentLoopData = $oldSupporters; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td class="row-number fw-bold"><?php echo e($i + 1); ?></td>
                <td>
                    <input type="text" 
                           name="budget[0][supporters][<?php echo e($i); ?>][name]" 
                           class="form-control step2-field <?php $__errorArgs = ["budget.0.supporters.$i.name"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           placeholder="اسم الطرف"
                           value="<?php echo e(old("budget.0.supporters.$i.name", $s['name'] ?? '')); ?>">
                    <?php if($errors->has("budget.0.supporters.$i.name")): ?>
                        <small class="text-danger2 d-block mt-1"><?php echo e($errors->first("budget.0.supporters.$i.name")); ?></small>
                    <?php endif; ?>
                </td>
                <td>
                    <input type="number" 
                           name="budget[0][supporters][<?php echo e($i); ?>][amount]" 
                           class="form-control step2-field <?php $__errorArgs = ["budget.0.supporters.$i.amount"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           placeholder="0.000"
                           value="<?php echo e(old("budget.0.supporters.$i.amount", $s['amount'] ?? '')); ?>">
                    <?php if($errors->has("budget.0.supporters.$i.amount")): ?>
                        <small class="text-danger2 d-block mt-1"><?php echo e($errors->first("budget.0.supporters.$i.amount")); ?></small>
                    <?php endif; ?>
                </td>
                <td>
                    <input type="number" 
                           name="budget[0][supporters][<?php echo e($i); ?>][percent]" 
                           class="form-control step2-field <?php $__errorArgs = ["budget.0.supporters.$i.percent"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           placeholder="%"
                           value="<?php echo e(old("budget.0.supporters.$i.percent", $s['percent'] ?? '')); ?>">
                    <?php if($errors->has("budget.0.supporters.$i.percent")): ?>
                        <small class="text-danger2 d-block mt-1"><?php echo e($errors->first("budget.0.supporters.$i.percent")); ?></small>
                    <?php endif; ?>
                </td>
                <td class="text-center">
                    <div class="d-flex gap-2 justify-content-center align-items-center">
                        <button type="button" class="btn btn-outline-danger btn-circle" onclick="removeSupporter2Row(this)">
                            <i class="bx bx-x fs-5"></i>
                        </button>
                        <button type="button" class="btn btn-outline-success btn-circle" onclick="addSupporter2Row(0)">
                            <i class="bx bx-plus fs-5"></i>
                        </button>
                    </div>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>

<script>
function addSupporter2Row(index) {
    const tbody = document.getElementById('supporters-body');
    const rowCount = tbody.rows.length;
    const newRow = document.createElement('tr');

    newRow.innerHTML = `
        <td class="row-number fw-bold">${rowCount + 1}</td>
        <td><input type="text" name="budget[${index}][supporters][${rowCount}][name]" class="form-control step2-field" placeholder="اسم الطرف"></td>
        <td><input type="number" name="budget[${index}][supporters][${rowCount}][amount]" class="form-control step2-field" placeholder="0.000"></td>
        <td><input type="number" name="budget[${index}][supporters][${rowCount}][percent]" class="form-control step2-field" placeholder="%"></td>
        <td class="text-center">
            <div class="d-flex gap-2 justify-content-center align-items-center">
                <button type="button" class="btn btn-outline-danger btn-circle" onclick="removeSupporter2Row(this)">
                    <i class="bx bx-x fs-5"></i>
                </button>
                <button type="button" class="btn btn-outline-success btn-circle" onclick="addSupporter2Row(${index})">
                    <i class="bx bx-plus fs-5"></i>
                </button>
            </div>
        </td>
    `;
    tbody.appendChild(newRow);
}

function removeSupporter2Row(button) {
    const row = button.closest('tr');
    const tbody = row.closest('tbody');
    row.remove();

    // Mise à jour des numéros visibles et des indices
    [...tbody.querySelectorAll('tr')].forEach((tr, i) => {
        tr.querySelector('.row-number').textContent = i + 1;
        tr.querySelector('input[name*="[name]"]').name = `budget[0][supporters][${i}][name]`;
        tr.querySelector('input[name*="[amount]"]').name = `budget[0][supporters][${i}][amount]`;
        tr.querySelector('input[name*="[percent]"]').name = `budget[0][supporters][${i}][percent]`;
    });
}
</script>

</div>

                        <label class="col-sm-6 col-form-label fw-bold">أبواب صرف الميزانية</label>

<div class="form-group row" style="direction: rtl; text-align: right;">
    <table id="depenses-table" class="table table-bordered text-center align-middle shadow-sm">
        <thead class="table-success">
            <tr>
                <th style="width:5%">#</th>
                <th style="width:30%">الفقرات</th>
                <th style="width:30%">مستلزمات الفقرات</th>
                <th style="width:20%">التكلفة (د)</th>
                <th style="width:5%">إجراء</th>
            </tr>
        </thead>

        <?php
        $oldDepenses = old('depenses', []);
        if (!is_array($oldDepenses) || count($oldDepenses) === 0) {
            $oldDepenses = [
                ['libelle_depense' => '', 'description' => '', 'cout' => '']
            ];
        }
        ?>

        <tbody id="depenses-body">
            <?php $__currentLoopData = $oldDepenses; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $d): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td class="row-number fw-bold"><?php echo e($i + 1); ?></td>

                <td>
                    <input type="text" 
                           name="depenses[<?php echo e($i); ?>][libelle_depense]" 
                           class="form-control step2-field <?php $__errorArgs = ["depenses.$i.libelle_depense"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           placeholder="أدخل الفقرة" 
                           value="<?php echo e(old("depenses.$i.libelle_depense", $d['libelle_depense'] ?? '')); ?>">
                    <?php if($errors->has("depenses.$i.libelle_depense")): ?>
                        <small class="text-danger2 d-block mt-1"><?php echo e($errors->first("depenses.$i.libelle_depense")); ?></small>
                    <?php endif; ?>
                </td>

                <td>
                    <input type="text" 
                           name="depenses[<?php echo e($i); ?>][description]" 
                           class="form-control step2-field <?php $__errorArgs = ["depenses.$i.description"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           placeholder="أدخل المستلزمات"
                           value="<?php echo e(old("depenses.$i.description", $d['description'] ?? '')); ?>">
                    <?php if($errors->has("depenses.$i.description")): ?>
                        <small class="text-danger2 d-block mt-1"><?php echo e($errors->first("depenses.$i.description")); ?></small>
                    <?php endif; ?>
                </td>

                <td>
                    <input type="number" 
                           name="depenses[<?php echo e($i); ?>][cout]" 
                           class="form-control step2-field <?php $__errorArgs = ["depenses.$i.cout"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" 
                           placeholder="0.000"
                           value="<?php echo e(old("depenses.$i.cout", $d['cout'] ?? '')); ?>">
                    <?php if($errors->has("depenses.$i.cout")): ?>
                        <small class="text-danger2 d-block mt-1"><?php echo e($errors->first("depenses.$i.cout")); ?></small>
                    <?php endif; ?>
                </td>

                <td style="white-space: nowrap;">
                    <div class="d-flex gap-2 justify-content-center align-items-center">
                        <button type="button" class="btn btn-outline-danger btn-circle" onclick="removeDepenses2Row(this)">
                            <i class="bx bx-trash fs-5"></i>
                        </button>
                        <button type="button" class="btn btn-outline-success btn-circle" onclick="addDepenses2Row()">
                            <i class="bx bx-plus fs-5"></i>
                        </button>
                    </div>
                </td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>

<script>
function addDepenses2Row() {
    const tbody = document.getElementById('depenses-body');
    const rowCount = tbody.rows.length;
    const newRow = document.createElement('tr');

    newRow.innerHTML = `
        <td class="row-number fw-bold">${rowCount + 1}</td>
        <td><input type="text" name="depenses[${rowCount}][libelle_depense]" class="form-control step2-field" placeholder="أدخل الفقرة"></td>
        <td><input type="text" name="depenses[${rowCount}][description]" class="form-control step2-field" placeholder="أدخل المستلزمات"></td>
        <td><input type="number" name="depenses[${rowCount}][cout]" class="form-control step2-field" placeholder="0.000"></td>
        <td class="text-center action-buttons">
            <div class="d-flex gap-2 justify-content-center align-items-center">
                <button type="button" class="btn btn-outline-danger btn-circle" onclick="removeDepenses2Row(this)">
                    <i class="bx bx-x fs-5"></i>
                </button>
                <button type="button" class="btn btn-outline-success btn-circle" onclick="addDepenses2Row()">
                    <i class="bx bx-plus fs-5"></i>
                </button>
            </div>
        </td>
    `;
    tbody.appendChild(newRow);
}

function removeDepenses2Row(button) {
    const row = button.closest('tr');
    const tbody = row.closest('tbody');
    row.remove();

    [...tbody.querySelectorAll('.row-number')].forEach((cell, i) => {
        cell.textContent = i + 1;
    });

    // Renommer les inputs pour garder les indices consécutifs
    [...tbody.querySelectorAll('tr')].forEach((tr, i) => {
        tr.querySelector('input[name*="[libelle_depense]"]').name = `depenses[${i}][libelle_depense]`;
        tr.querySelector('input[name*="[description]"]').name = `depenses[${i}][description]`;
        tr.querySelector('input[name*="[cout]"]').name = `depenses[${i}][cout]`;
    });
}
</script>
<style>
    /* Table design */
#depenses-table {
    background: #fff;
    border-radius: 10px;
    overflow: hidden;
}
#depenses-table th {
    background: #e9f7ef;
    font-weight: 600;
    color: #333;
    vertical-align: middle;
}
#depenses-table td {
    vertical-align: middle;
}

/* Boutons circulaires */
.btn-circle {
    border-radius: 50%;
    width: 36px;
    height: 36px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    margin: 0 3px;
    transition: all 0.2s ease-in-out;
}

/* Supprimer : rouge */
.btn-outline-danger.btn-circle {
    color: #fff;
    border-color: #dc3545;
}
.btn-outline-danger.btn-circle:hover {
    background-color: #dc3545;
    color: #fff;
}

/* Ajouter : vert */
.btn-outline-success.btn-circle {
    color: #fff;
    border-color: #28a745;
}
.btn-outline-success.btn-circle:hover {
    background-color: #28a745;
    color: #fff;
}

/* Inputs */
#depenses-table input {
    border-radius: 8px;
}

</style>
                        <span>
                            (1) :  مستلزمات كل فقرة على حدة مثلا / مستلزمات الندوة او المعرض او الورشة او العرض 
                        </span>
                    </div>
            </div>
     


   
    <div id="step3" class="step-content">
        <div class="container" lang="ar" dir="rtl">
            <?php
                $form1_complete = $form1_complete ?? false;
                $form2_complete = $form2_complete ?? false;
            ?>

            <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire3->id_type); ?>">
            <input type="hidden" name="id_projet" value="<?php echo e($id_projet); ?>">
            <h2 class="text-center">الجمهورية التونسية</h2>
            <h2 class="text-center">وزارة الشباب و الرياضة</h2>
            <h3 class="text-center" style="font-size:25px;"><?php echo e($formulaire3->type_ar); ?></h3>
            <br>
            <div class="form-section">
                <div class="form-group row">
                    <table id="phase-table" class="custom-table table table-bordered text-center">
                        <thead>
                            <tr>
                                <th>#</th> 
                                <th> الوثائق حسب الامر عدد 5183 </th>
                                <th> الوثائق </th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $typedocum; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <tr>
                                <td class="row-number"><?php echo e($index + 1); ?></td>
                                
                                <td data-label="الوثائق حسب الامر عدد 5183">
                                    <?php echo e($doc->type_ar); ?>

                                    <input type="hidden" name="doc_fin[<?php echo e($index); ?>][id_doc]" value="<?php echo e($doc->id_type_doc); ?>">
                                </td>

                                <td data-label="الوثائق">
                                    <?php
                                        $docExist = $documents->where('id_doc', $doc->id_type_doc)->first();
                                    ?>

                                    <?php if($doc->id_type_doc == 15): ?>
                                        <span class="doc-status" data-step="2">⚠️ يجب إتمام تعبئة الخطوة الثانية أولاً</span>
                                    
                                    <?php elseif($doc->id_type_doc == 16): ?>
                                        <div style="display:flex; align-items:center; gap:10px;">
                                            <a href="<?php echo e(asset('storage/documents_financement/التزام_وتصريح_على_الشرف.pdf')); ?>" 
                                            target="_blank" 
                                            class="btn btn-sm btn-secondary" 
                                            title="Télécharger le document">
                                                📤
                                            </a>
                                            

                                            <input type="file" 
                                            name="doc_fin[<?php echo e($index); ?>][file]" 
                                            class="form-control <?php $__errorArgs = ["doc_fin.$index.file"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>" style="flex:1">

                                            <?php $__errorArgs = ["doc_fin.$index.file"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                                <small class="text-danger d-block mt-1"><?php echo e($message); ?></small>
                                            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                        </div>

                                    <?php elseif($doc->id_type_doc == 17): ?>
                                        <span class="doc-status" data-step="1">⚠️ يجب إتمام تعبئة الخطوة الأولى أولاً</span>

                                    <?php else: ?>
                                        <input type="file" 
                                            name="doc_fin[<?php echo e($index); ?>][file]" 
                                            class="form-control <?php $__errorArgs = ["doc_fin.$index.file"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>">

                                        <?php $__errorArgs = ["doc_fin.$index.file"];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                                            <small class="text-danger d-block mt-1"><?php echo e($message); ?></small>
                                        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
                                    <?php endif; ?>

                                </td>
                            </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>

    <div class="stepper-nav">
        <button type="button" class="btn btn-primary" id="prevBtn" style="display: none;" onclick="prevStep()">السابق</button>
        <button type="button" class="btn btn-primary" id="nextBtn" onclick="nextStep()">التالي</button>
    </div>
</div>

<script>
document.addEventListener('DOMContentLoaded', function() {
    function checkStepComplete(stepClass) {
        let allFilled = true;
        document.querySelectorAll(stepClass).forEach(input => {
            if (input.value.trim() === '') {
                allFilled = false;
            }
        });
        return allFilled;
    }

    function updateDocMessages() {
        document.querySelectorAll('.doc-status').forEach(el => {
            const step = el.getAttribute('data-step');
            if (step === '1' && checkStepComplete('.step1-field')) {
                el.textContent = '✅ هذا الملف متوفر بالفعل';
                el.style.color = 'green';
            } 
            else if (step === '2' && checkStepComplete('.step2-field')) {
                el.textContent = '✅ هذا الملف متوفر بالفعل';
                el.style.color = 'green';
            } 
            else if (step === '1') {
                el.textContent = '⚠️ يجب إتمام الخطوة الأولى أولاً';
                el.style.color = 'red';
            } 
            else if (step === '2') {
                el.textContent = '⚠️ يجب إتمام الخطوة الثانية أولاً';
                el.style.color = 'red';
            }
        });
    }

    document.querySelectorAll('.step1-field, .step2-field').forEach(input => {
        input.addEventListener('input', updateDocMessages);
    });

    updateDocMessages();
});
</script>





            <div class="form-group text-center mt-5">
                <input type="hidden" id="brouillon" name="brouillon" value="0">

                <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                    <!-- Enregistrer -->
                    <button type="submit" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill"
                            onclick="document.getElementById('brouillon').value = 0;">
                        <i class="bx bx-save"></i> حفظ
                    </button>

                    <!-- Enregistrer comme brouillon -->
                    <button type="submit" class="btn btn-orange-gradient text-white d-flex align-items-center justify-content-center gap-1 flex-fill"
                            onclick="document.getElementById('brouillon').value = 1;">
                        <i class="bx bx-edit-alt"></i> حفظ كمسودة
                    </button>
                </div>
            </div>
            
            <link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">

            <div id="global-block-msg" class="alert alert-danger" style="display:none">
                يوجد مستندات مفقودة أو يلزم تعبئة خطوات سابقة — لن يتم حفظ الطلب حتى تكتمل الشروط.
            </div>
        </form>
    </div>
<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('login')); ?>";
    </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/financement/documents_financement/create.blade.php ENDPATH**/ ?>