

<?php $__env->startSection('content'); ?>

<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0">

                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title pb-0">📂 وثائق التمويل العمومي (لجنة التمويل العمومي)</h2>

                    
                    <a class="btn btn-success font-weight-medium" href="<?php echo e(route('stepper.create')); ?>">
                        <i class="la la-plus mr-1"></i> إضافة وثائق جديدة
                    </a>
                </div>

                <div class="block-card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
                        </div>
                    <?php endif; ?>

                    <div class="my-table table-responsive">
                        <table class="table align-items-center table-flush mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>إسم المشروع</th>
                                    <th>الحالة</th>
                                    <th>إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $documents; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $doc): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                <tr>
                                    <td><?php echo e($index + 1); ?></td>
                                    <td><?php echo e($doc->projet?->nom_projet ?? '---'); ?></td>
                                    <td>
                                        <span class="badge 
                                            <?php echo e($doc->id_statut1 == 1 ? 'badge-success' : ($doc->id_statut1 == 3 ? 'badge-danger' : 'badge-secondary')); ?>">
                                            <?php echo e($doc->statut1?->statut_ar ?? 'في الانتظار'); ?>

                                        </span>
                                    </td>

                                    <td class="btn-group">
                                        <a class="btn btn-info btn-sm mr-2" href="<?php echo e(route('doc_fin.show', $doc->id_doc_list)); ?>">
                                            <i class="la la-eye mr-1"></i> عرض
                                        </a>

                                        <?php if($doc->id_statut1 == 2): ?>
                                            <a class="btn btn-orange btn-sm mr-2" style="color:white;"
                                                onclick="confirmEdit('<?php echo e(route('doc_fin.edit', $doc->id_doc_list)); ?>')">
                                                <i class="la la-edit mr-1"></i> تعديل
                                            </a>


                                            <form action="<?php echo e(route('doc_fin.toggle_statut', $doc->id_doc_list)); ?>" 
                                                method="POST" 
                                                class="form-modifier-statut mr-2" 
                                                style="display:inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('PATCH'); ?>
                                                <button type="button" 
                                                        onclick="confirmStatusChange4(this.closest('form'), '<?php echo e($doc->statut1?->statut_ar); ?>')" 
                                                        class="btn btn-sm btn-secondary">
                                                    <i class="la la-toggle-on mr-1"></i> تغيير الحالة
                                                </button>

                                            </form>


                                            <form action="<?php echo e(route('doc_fin.destroy', $doc->id_doc_list)); ?>" method="POST" style="display:inline;">
                                                <?php echo csrf_field(); ?>
                                                <?php echo method_field('DELETE'); ?>
                                                <button type="button" 
                                                        onclick="confirmDelete(this.closest('form'))" 
                                                        class="btn btn-danger btn-sm mr-2">
                                                    <i class="la la-trash mr-1"></i> حذف
                                                </button>

                                            </form>

                                        <?php endif; ?>
                                    </td>
                                </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                <tr>
                                    <td colspan="4" class="text-center">لا توجد وثائق حالياً</td>
                                </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    <div class="mt-3">
                        <?php echo e($documents->links('pagination::bootstrap-5')); ?>

                    </div>
                </div>

            </div>
        </div>
    </div>
</div>
<script>
    function confirmEdit(url) {
    Swal.fire({
        icon: 'question',
        title: 'هل تريد حقًا تعديل هذه الوثيقة؟',
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء',
        reverseButtons: true,
        buttonsStyling: false,
        customClass: {
            confirmButton: 'btn btn-primary mx-2',
            cancelButton: 'btn btn-secondary'
        }
    }).then((result) => {
        if (result.isConfirmed) {
            window.location.href = url; // redirige vers la page edit
        }
    });
}

function confirmDelete(form) {
    Swal.fire({
        icon: 'warning',
        title: 'هل تريد حذف هذه الوثيقة؟',
        showCancelButton: true,
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء',
        reverseButtons: true,
        buttonsStyling: false,
        customClass: {
            confirmButton: 'btn btn-danger mx-2',
            cancelButton: 'btn btn-secondary'
        }
    }).then((result) => {
        if (result.isConfirmed) {
            form.submit();
        }
    });
}


</script>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Dell\Desktop\projet MJS\back\back\resources\views/backoffice/financement/documents_financement/index.blade.php ENDPATH**/ ?>