

<?php $__env->startSection('content'); ?>

<?php if(Auth::check()): ?>

<div class="container-fluid dashboard-inner-body-container">
  <div class="row">
    <div class="col-lg-12">
      <div class="block-card dashboard-card mb-4 px-0">

        <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
          <h2 class="widget-title pb-0">طلبات التظاهرات الرياضية الوطنية</h2>
          <a class="btn btn-success font-weight-medium" href="<?php echo e(route('admin.manifestation.create')); ?>">
            <i class="la la-plus mr-1"></i> إضافة طلب
          </a>
        </div>

        <div class="block-card-header px-4 border-bottom-0 pb-0">
          <form method="GET" action="<?php echo e(route('admin.manifestation.index')); ?>">
            <div class="form-row align-items-center">
              <div class="col-auto" style="width: 200px;">
                <select class="form-control" name="search_option" onchange="showSearchInput(this.value)">
                  <option value="">اختر نوع البحث</option>
                  <option value="date" <?php echo e(request('search_option') == 'date' ? 'selected' : ''); ?>>تاريخ التقديم</option>
                  <option value="type_identite" <?php echo e(request('search_option') == 'type_identite' ? 'selected' : ''); ?>>نوع الهوية</option>
                </select>
              </div>
              <div class="col-auto" id="searchByDate" style="display:none; width: 180px;">
                <input type="date" class="form-control" name="date" value="<?php echo e(request('date')); ?>">
              </div>
              <div class="col-auto" id="searchByTypeIdentite" style="display:none; width: 200px;">
                <select class="form-control" name="type_identite">
                  <option value="">-- اختر نوع الهوية --</option>
                  <?php $__currentLoopData = $typesIdentite; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($type->id_type); ?>" <?php echo e(request('type_identite') == $type->id_type ? 'selected' : ''); ?>>
                      <?php echo e($type->type_ar); ?>

                    </option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>
              <div class="col-auto">
                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium" style="width: 100px;">بحث</button>
                <a href="<?php echo e(route('admin.manifestation.index')); ?>" class="btn btn-secondary font-weight-medium" style="width: 100px;">إعادة تعيين</a>
              </div>
            </div>
          </form>
        </div>

        <div class="block-card-body">
          <?php if(session('success')): ?>
            <div class="alert alert-success alert-dismissible fade show" role="alert">
              <?php echo e(session('success')); ?>

              <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
          <?php endif; ?>

          <div class="my-table table-responsive" style="direction: rtl; text-align: right;">
            <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">
                <thead class="thead-light">
                    <tr>
                        <th>#</th>
                        <th>رقم الملف</th>
                        <th>اسم الهيكل</th>
                        <th>اسم التظاهرة</th>
                        <th>التاريخ</th>
                        <th>الساعة</th>
                        <th>الولاية</th>
                        <th>البلدية</th>
                        <th>الحالة</th>
                        <th width="15%">إجراءات</th>
                    </tr>
                </thead>
                <tbody>
                    <?php $__empty_1 = true; $__currentLoopData = $rows; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $i => $row): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                    <tr>
                        <td><?php echo e($i + 1); ?></td>
                        <td><?php echo e($row->num_dossier); ?></td>
                        <td><?php echo e($row->nom_organisme ?? '-'); ?></td>
                        <td><?php echo e($row->nom_evenement ?? '-'); ?></td>
                        <td><?php echo e($row->date_even ?? '-'); ?></td>
                        <td><?php echo e($row->heure_even ?? '-'); ?></td>
                        <td><?php echo e($row->gouvernorat ?? ($row->raw->evenementSportifs->first()?->gouvernorat->nom_ar ?? '-')); ?></td>
                        <td><?php echo e($row->delegation ?? ($row->raw->evenementSportifs->first()?->delegation->nom_ar ?? '-')); ?></td>
                        <td>
                          <span class="status-badge 
                            <?php echo e($row->statut?->statut_ar == 'قبول' ? 'status-badge--success' : 
                              ($row->statut?->statut_ar == 'رفض' ? 'status-badge--danger' : 'status-badge--pending')); ?>">
                              <?php echo e($row->statut?->statut_ar ?? 'في الانتظار'); ?>

                          </span>
                        </td>
                        <td class="text-center">
                            <div class="d-flex flex-wrap gap-2 justify-content-center">
                                <a href="<?php echo e(route('admin.manifestation.show', $row->id_demande)); ?>"
                                  class="btn-icon btn-icon--info" title="عرض">
                                    <i class="la la-eye"></i> 
                                </a>
                                <?php if($row->raw->id_type == 2): ?>
                                  <a href="<?php echo e(route('admin.manifestation.edit', $row->id_demande)); ?>"
                                    class="btn-icon btn-icon--warning" title="تعديل">
                                      <i class="la la-edit"></i> 
                                  </a>

                                  <form action="<?php echo e(route('admin.manifestation.toggle_statut', $row->id_demande)); ?>" enctype="multipart/form-data"  method="POST" class="d-inline">
                                      <?php echo csrf_field(); ?>
                                      <?php echo method_field('PATCH'); ?>
                                      <button type="button"
                                              onclick="confirmStatusChange10(this.closest('form'), '<?php echo e($row->statut->statut_ar); ?>')"
                                              class="btn-icon btn-icon--secondary"
                                              title="تغيير الحالة" aria-label="تغيير الحالة">
                                          <i class="la la-toggle-on"></i>
                                      </button>
                                  </form>

                                  <form action="<?php echo e(route('admin.manifestation.destroy', $row->id_demande)); ?>" method="POST" style="display: inline;">
                                      <?php echo csrf_field(); ?>
                                      <?php echo method_field('DELETE'); ?>
                                      <button type="submit"
                                          class="btn-icon btn-icon--danger"
                                          title="حذف"
                                          onclick="return confirm('هل أنت متأكد من الحذف؟')">
                                          <i class="la la-trash"></i> 
                                      </button>
                                  </form>
                              <?php endif; ?>

                            </div>
                        </td>
                    </tr>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                    <tr>
                        <td colspan="10" class="text-center">لا توجد طلبات تظاهرات رياضية.</td>
                    </tr>
                    <?php endif; ?>
                </tbody>
            </table>
        </div>


        <div class="mt-3">
            <?php echo e($demandes->links('pagination::bootstrap-5')); ?>

        </div>
    </div>
</div>
</div>
</div>
</div>
<style>
  .btn-icon {
    width: 30px;       /* plus petit */
    height: 30px;
    border-radius: 6px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    font-size: 15px;   /* icône plus fine */
    transition: all 0.2s ease;
    border: none;
    background-color: #f8f9fa;
    cursor: pointer;
}

/* Effet hover */
.btn-icon:hover {
    transform: translateY(-1px);
    box-shadow: 0 2px 5px rgba(0,0,0,0.15);
}

/* Couleurs pastel */
.btn-icon--primary {
    background-color: #e3f2fd;
    color: #0d6efd;
}
.btn-icon--warning {
    background-color: #fff3cd;
    color: #ffc107;
}
.btn-icon--danger {
    background-color: #f8d7da;
    color: #dc3545;
}
.btn-icon--secondary {
    background-color: #e2e3e5;
    color: #6c757d;
}
   /* Table globale */
.table th, .table td {
    vertical-align: middle;
    text-align: center;
    font-size: 12px;       /* texte un peu plus petit */
    padding: 6px 8px;      /* moins de padding pour réduire la taille */
}

.table-hover tbody tr:hover {
    background-color: #f9f9f9;
}

/* Badges de statut */
.status-badge {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 3px 6px;      /* réduit le padding */
    font-size: 10px;       /* réduit la taille de la police */
    border-radius: 6px;
    font-weight: 600;
    min-width: 60px;       /* réduit la largeur minimale */
    text-align: center;
}

.status-badge--success { background-color: #e8f9ee; color: #27ae60; }
.status-badge--danger  { background-color: #fde8ea; color: #e74c3c; }
.status-badge--pending { background-color: #fff8e1; color: #d4a017; }

/* Boutons modernes */
.btn-modern {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    gap: 4px;
    border: none;
    border-radius: 6px;
    padding: 3px 6px;      /* réduit le padding */
    font-size: 10px;       /* réduit la police */
    font-weight: 600;
    cursor: pointer;
    transition: all 0.25s ease;
}

.btn-modern--info { background-color: #e3f2fd; color: #0d6efd; }
.btn-modern--warning { background-color: #fff8e1; color: #d4a017; }
.btn-modern--danger { background-color: #fde8ea; color: #e74c3c; }

/* Responsive pour petits écrans */
@media (max-width: 768px) {
    .table-responsive { overflow-x: auto; }
    .btn-modern { font-size: 9px; padding: 2px 4px; }
    .status-badge { font-size: 9px; padding: 2px 4px; min-width: auto; }
    .table th, .table td { font-size: 10px; padding: 4px 6px; }
}

.swal2-popup {
  border-radius: 14px !important;
  padding: 32px 28px !important;
  font-family: "Tajawal", "Cairo", "Helvetica", sans-serif;
  direction: rtl;
  text-align: center;
  max-width: 520px;
  box-shadow: 0 8px 30px rgba(0,0,0,0.12) !important;
}

/* Custom circular icon (use in html block) */
.swal2-icon-custom {
  width: 92px;
  height: 92px;
  border-radius: 999px;
  display: inline-flex;
  align-items: center;
  justify-content: center;
  margin: 0 auto 14px;
  background: linear-gradient(180deg, rgba(246,178,137,0.12), rgba(246,178,137,0.06));
  border: 4px solid rgba(246,178,137,0.35);
  color: #f28c4a;
  font-size: 44px;
  box-shadow: 0 6px 18px rgba(242,140,74,0.12);
}

/* Title and text */
.swal2-title {
  font-size: 22px !important;
  font-weight: 700 !important;
  margin: 6px 0 6px !important;
  color: #333;
}
.swal2-html-container {
  font-size: 15px;
  color: #666;
  margin-top: 6px;
  line-height: 1.45;
  text-align: center;
}

/* Actions: force horizontal alignment, centered, with gap */
.swal2-actions {
  margin-top: 18px !important;
  display: flex !important;
  justify-content: center;
  gap: 12px;
  flex-wrap: nowrap; /* évite le retour à la ligne */
  align-items: center;
}

/* Bouton "confirmer" violet */
.btn-swal-confirm {
  background: linear-gradient(180deg,#6C63FF,#5B4BEE) !important;
  border: none !important;
  color: #fff !important;
  padding: .55rem 1.05rem !important;
  border-radius: 10px !important;
  font-weight: 700 !important;
  box-shadow: 0 6px 18px rgba(108,99,255,0.18) !important;
}

/* Bouton "annuler" gris */
.btn-swal-cancel {
  background: #6c757d !important;
  color: #fff !important;
  border: none !important;
  padding: .45rem .9rem !important;
  border-radius: 8px !important;
  font-weight: 600 !important;
  opacity: 0.95;
}

/* Small screens: reduce sizes */
@media (max-width:480px){
  .swal2-popup { padding: 22px 18px; }
  .swal2-icon-custom { width:78px; height:78px; font-size:36px; }
  .swal2-title { font-size:18px; }
  .swal2-actions { gap:10px; }
  .btn-swal-confirm, .btn-swal-cancel { padding: .45rem .8rem !important; }
}
</style>

<script>
    function showSearchInput(value) {
        document.getElementById('searchByDate').style.display = (value == 'date') ? 'block' : 'none';
        document.getElementById('searchByTypeIdentite').style.display = (value == 'type_identite') ? 'block' : 'none';
    }
</script>
<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">

<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<script src="<?php echo e(asset('assets/js/index.js')); ?>"></script>
<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.2/dist/js/bootstrap.bundle.min.js"></script>

<!-- Assure-toi d'avoir SweetAlert2 -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
async function confirmStatusChange10(form, currentStatus) {
    const formData = new FormData(form);

    // Étape 1️⃣ : الإدارة الفرعية
    const { value: id_statut } = await Swal.fire({
        title: 'تغيير الحالة من قبل الإدارة الفرعية',
        input: 'radio',
        inputOptions: { '1': 'قبول', '3': 'رفض' },
        inputValidator: (v) => !v && 'اختر الحالة الجديدة!',
        showCancelButton: true,
        confirmButtonText: 'التالي',
        cancelButtonText: 'إلغاء',
        reverseButtons: true
    });
    if (!id_statut) return;
    formData.append('id_statut', id_statut);

    if (id_statut == '3') {
        const { value: motif } = await Swal.fire({
            title: 'سبب الرفض من الإدارة الفرعية',
            input: 'textarea',
            inputPlaceholder: 'الرجاء إدخال سبب الرفض',
            inputValidator: (v) => !v && 'يجب إدخال سبب الرفض!',
            showCancelButton: true,
            confirmButtonText: 'تأكيد',
            cancelButtonText: 'إلغاء',
            reverseButtons: true
        });
        if (!motif) return;
        formData.append('commentaire_motif', motif);
        return submitFormData(form.action, formData);
    }

    // Étape 2️⃣ : الجامعة
    const { value: statut_id } = await Swal.fire({
        title: 'تغيير الحالة من قبل الجامعة',
        input: 'radio',
        inputOptions: { '1': 'قبول', '3': 'رفض' },
        inputValidator: (v) => !v && 'اختر الحالة!',
        showCancelButton: true,
        confirmButtonText: 'التالي',
        cancelButtonText: 'إلغاء',
        reverseButtons: true
    });
    if (!statut_id) return;
    formData.append('statut_id', statut_id);

    if (statut_id == '3') {
        const { value: motif2 } = await Swal.fire({
            title: 'سبب الرفض من الجامعة',
            input: 'textarea',
            inputPlaceholder: 'الرجاء إدخال سبب الرفض',
            inputValidator: (v) => !v && 'يجب إدخال سبب الرفض!',
            showCancelButton: true,
            confirmButtonText: 'تأكيد',
            cancelButtonText: 'إلغاء',
            reverseButtons: true
        });
        if (!motif2) return;
        formData.append('commentaire_motif2', motif2);
        return submitFormData(form.action, formData);
    }

    // Étape 3️⃣ : اللجنة الوطنية المختلطة
    const { value: statut2_id } = await Swal.fire({
        title: 'تغيير الحالة من قبل اللجنة الوطنية المختلطة',
        input: 'radio',
        inputOptions: { '1': 'قبول', '3': 'رفض' },
        inputValidator: (v) => !v && 'اختر الحالة!',
        showCancelButton: true,
        confirmButtonText: 'التالي',
        cancelButtonText: 'إلغاء',
        reverseButtons: true
    });
    if (!statut2_id) return;
    formData.append('statut2_id', statut2_id);

    if (statut2_id == '3') {
        const { value: motif3 } = await Swal.fire({
            title: 'سبب الرفض من اللجنة الوطنية المختلطة',
            input: 'textarea',
            inputPlaceholder: 'الرجاء إدخال سبب الرفض',
            inputValidator: (v) => !v && 'يجب إدخال سبب الرفض!',
            showCancelButton: true,
            confirmButtonText: 'تأكيد',
            cancelButtonText: 'إلغاء',
            reverseButtons: true
        });
        if (!motif3) return;
        formData.append('commentaire_motif3', motif3);
        return submitFormData(form.action, formData);
    }

    // Étape 4️⃣ : إدراج الترخيص (fichier réel)
    const { value: file } = await Swal.fire({
        title: 'أضف الترخيص (PDF أو صورة)',
        html: '<input type="file" id="fileInput" class="swal2-input" accept=".pdf,.jpg,.png,.jpeg">',
        showCancelButton: true,
        confirmButtonText: 'رفع الملف',
        cancelButtonText: 'تخطي',
        reverseButtons: true,
        preConfirm: () => {
            const input = document.getElementById("fileInput");
            return input.files.length > 0 ? input.files[0] : null;
        }
    });

    if (file) {
        formData.append('file', file); // 🔥 vrai fichier
    }

    submitFormData(form.action, formData);
}

// 🔹 Envoi du FormData avec Fetch
async function submitFormData(url, formData) {
    const response = await fetch(url, {
        method: 'POST',
        body: formData,
        headers: {
            'X-CSRF-TOKEN': document.querySelector('input[name="_token"]').value,
            'X-HTTP-Method-Override': 'PATCH'
        }
    });

    if (response.ok) {
        Swal.fire({
            icon: 'success',
            title: 'تم تحديث الحالة بنجاح',
            confirmButtonText: 'حسناً'
        }).then(() => location.reload());
    } else {
        Swal.fire({
            icon: 'error',
            title: 'حدث خطأ أثناء الحفظ',
            confirmButtonText: 'موافق'
        });
    }
}
</script>




<?php else: ?>
<script> window.location.href = "<?php echo e(route('admin')); ?>"; </script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH C:\Users\Dell\Desktop\projet MJS\back\back\resources\views/backoffice/manifestation_sport/demande/index.blade.php ENDPATH**/ ?>