<?php $__env->startSection('content'); ?>

<?php if(session('status')): ?>
    <div class="alert alert-success"><?php echo e(session('status')); ?></div>
<?php endif; ?>

<?php if(session('error')): ?>
    <div class="alert alert-danger"><?php echo e(session('error')); ?></div>
<?php endif; ?>

<?php if(Auth::check()): ?>
<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <div class="block-card mb-4">
                    <div class="block-card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h2 class="widget-title mb-0">ملف المستخدم</h2>
                            <a href="<?php echo e(route('utilisateurs.editprofil', $utilisateur->id)); ?>" 
                               class="btn btn-outline-secondary custom-hover">
                                <i class="fas fa-edit"></i> تعديل ملف المستخدم
                            </a>
                        </div>
                        <div class="stroke-shape"></div>
                    </div>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="input-box">
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <th>الاسم الكامل</th>
                                            <td><?php echo e($utilisateur->nom_prenom); ?></td>
                                        </tr>

                                        <tr>
                                            <th>رقم بطاقة التعريف</th>
                                            <td><?php echo e($utilisateur->cin); ?></td>
                                        </tr>

                                        <tr>
                                            <th>تاريخ الإصدار</th>
                                            <td><?php echo e(\Carbon\Carbon::parse($utilisateur->date_delivrance_cin)->format('d/m/Y')); ?></td>
                                        </tr>

                                        <tr>
                                            <th>مكان الإصدار</th>
                                            <td><?php echo e($utilisateur->lieu_delivrance_cin); ?></td>
                                        </tr>

                                        <tr>
                                            <th>البريد الإلكتروني</th>
                                            <td><?php echo e($utilisateur->email); ?></td>
                                        </tr>

                                        <tr>
                                            <th>رقم الهاتف</th>
                                            <td><?php echo e($utilisateur->tel ?? 'غير محدد'); ?></td>
                                        </tr>

                                        <tr>
                                            <th>العنوان</th>
                                            <td><?php echo e($utilisateur->adresse ?? 'غير محدد'); ?></td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('admin')); ?>";
    </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/back/resources/views/backoffice/role-permission/user/profile.blade.php ENDPATH**/ ?>