<?php $__env->startSection('content'); ?>

<style>
.card-resume { border-radius: 10px; box-shadow: 0 6px 18px rgba(0,0,0,0.06); }
.small-muted { font-size: .85rem; color:#6c757d; }
.form-label { font-weight: 600; }

/* cards restauration */
.resto-card {
    border-radius: 8px;
    box-shadow: 0 4px 12px rgba(0,0,0,0.04);
    padding: 10px;
    margin-bottom: 10px;
    direction: rtl;
    background: #fff;
}
.resto-card .resto-header { display:flex; justify-content:space-between; align-items:center; gap:10px; }
.resto-card .resto-name { font-weight:700; }
.resto-card .resto-price { font-weight:700; }
.resto-card .resto-desc { color:#555; margin-top:6px; white-space:pre-wrap; }
.empty-placeholder { color:#6c757d; font-size:.95rem; padding:8px; }

.status-badge {
    display: inline-flex;
    align-items: center;
    justify-content: center;
    padding: 6px 12px;
    font-size: 13px;
    border-radius: 8px;
    font-weight: 600;
    min-width: 75px;
    text-align: center;
    transition: 0.3s;
    box-shadow: 0 2px 6px rgba(0,0,0,0.05);
}

.status-badge--success {
    background-color: #e8f9ee;
    color: #27ae60;
}
.status-badge--danger {
    background-color: #fde8ea;
    color: #e74c3c;
}
.status-badge--pending {
    background-color: #fff8e1;
    color: #d4a017;
}
</style>

<div class="container mt-4" dir="rtl">
    <div class="card p-4 shadow-sm">

        <h3 class="mb-4 text-center" style="color:#d82b2a;">تفاصيل الحجز</h3>

        <div class="row">

            <div class="col-lg-8">
                <div class="card p-3 mb-3">
                    <div class="row">

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"   class="form-label">الإسم و اللقب</label>
                            <input style="text-transform: none; direction: rtl;"  type="text" class="form-control bg-white"
                                value="<?php echo e($reservation->user->nom_prenom ?? '-'); ?>" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">البريد الإلكتروني</label>
                            <input style="text-transform: none; direction: rtl;"  type="email" class="form-control bg-white"
                                value="<?php echo e($reservation->user->email ?? '-'); ?>" readonly>
                        </div>
						
						<div class="col-md-6 mb-3">
							<label style="color:black;" class="form-label">الجنسية</label>
							<input type="text" class="form-control bg-white" 
								   value="<?php echo e($reservation->user->id_type_identite == 1 ? 'تونسية' : ($user->id_type_identite == 2 ? 'أجنبي' : 'غير محدد')); ?>" 
								   readonly>
						</div>
						

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">رقم الهاتف</label>
                            <input style="text-transform: none; direction: rtl;"  type="text" class="form-control bg-white"
                                value="<?php echo e($reservation->user->tel ?? '-'); ?>" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">العنوان</label>
                            <input style="text-transform: none; direction: rtl;"  type="text" class="form-control bg-white"
                                value="<?php echo e($reservation->user->adresse ?? '-'); ?>" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">تاريخ الوصول</label>
                            <input style="text-transform: none; direction: rtl;"  type="text" class="form-control bg-white"
                                value="<?php echo e($reservation->date_arrive); ?>" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">تاريخ المغادرة</label>
                            <input style="text-transform: none; direction: rtl;"  type="text" class="form-control bg-white"
                                value="<?php echo e($reservation->date_depart); ?>" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">عدد الذكور</label>
                            <input style="text-transform: none; direction: rtl;"  type="number" class="form-control bg-white"
                                value="<?php echo e($reservation->nbr_h); ?>" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">عدد الاناث</label>
                            <input style="text-transform: none; direction: rtl;"  type="number" class="form-control bg-white"
                                value="<?php echo e($reservation->nbr_f); ?>" readonly>
                        </div>

                        <?php
                            $nights = \Carbon\Carbon::parse($reservation->date_arrive)
                                ->diffInDays(\Carbon\Carbon::parse($reservation->date_depart));
                            $basePrice = ($reservation->auberge->prix_lit ?? 0)
                                * ($reservation->nbr_personnes ?? 0)
                                * $nights;
                            $restoTotal = $reservation->restaurations->sum(fn($r) => $r->pivot->tarif ?? 0);
                            $calculatedTotal = $basePrice + $restoTotal;
                            $selectedIds = $reservation->restaurations->pluck('id_rest')->toArray();
                        ?>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">عدد الليالي</label>
                            <input style="text-transform: none; direction: rtl;"  type="number" class="form-control bg-white"
                                value="<?php echo e($nights); ?>" readonly>
                        </div>

                        <div class="col-md-6 mb-3">
                            <label style="color:black;"  class="form-label">عدد النزلاء</label>
                            <input style="text-transform: none; direction: rtl;"  type="number" class="form-control bg-white"
                                value="<?php echo e($reservation->nbr_personnes); ?>" readonly>
                        </div>

                        <div class="col-12 mb-3">
                            <label style="color:black;"  class="form-label">إضافة خدمات الطعام (اختياري)</label>

                            <?php $__currentLoopData = $restaurations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $res): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <div class="form-check mb-2">
                                    <input style="text-transform: none; direction: rtl;"  class="form-check-input" type="checkbox"
                                        id="resto_<?php echo e($res->id_rest); ?>"
                                        <?php if(in_array($res->id_rest, $selectedIds)): ?> checked <?php endif; ?>
                                        disabled>
                                    <label style="color:black;"  class="form-check-label" for="resto_<?php echo e($res->id_rest); ?>">
                                        <?php echo e($res->nom_ar); ?>

                                        <small class="small-muted d-block"><?php echo e(number_format($res->tarif, 2)); ?> د</small>
                                    </label>
                                </div>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

                            <div id="restoDetails" class="mt-3">
                                <?php if($reservation->restaurations->isEmpty()): ?>
                                    <div class="empty-placeholder">لا توجد خدمات إضافية</div>
                                <?php else: ?>
                                    <?php $__currentLoopData = $reservation->restaurations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $resto): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                        <div class="resto-card">
                                            <div class="resto-header">
                                                <div class="resto-name"><?php echo e($resto->nom_ar); ?></div>
                                                <div class="resto-price"><?php echo e(number_format($resto->pivot->tarif, 2)); ?> د</div>
                                            </div>
                                            <div class="resto-desc"><?php echo nl2br(e($resto->description_ar ?? '—')); ?></div>
                                        </div>
                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                <?php endif; ?>
                            </div>
                        </div>

                        <div class="col-12 mb-3">
                            <label style="color:black;"  class="form-label">الملاحظات</label>
                            <div class="mt-2 p-2 border border-gray rounded bg-white">
                            <p rows="3" readonly class="form-label bg-white"><?php echo e($reservation->remarque ?? '—'); ?></p>
                        </div>
                        </div>

                         
                    </div>
                </div>
            </div>

            <div class="col-lg-4">

    <div class="card p-3 card-resume mb-3">
        <h5 class="mb-2" style="color:#d82b2a;">ملخص الحجز</h5>

        <p class="small-muted mb-1">
            المؤسسة: <strong><?php echo e($reservation->auberge->nom_ar ?? '-'); ?></strong>
        </p>

        <p hidden class="small-muted mb-1">
            سعر الليلة: <strong><?php echo e(number_format($reservation->auberge->prix_lit ?? 0, 2)); ?></strong> د
        </p>

        <p class="small-muted mb-1">عدد الليالي: <strong><?php echo e($nights); ?></strong></p>

        
        <div class="mt-2 p-2 border border-gray rounded bg-white">
            <strong class="text-black"> الملاحظات:</strong>
            <p class="mb-0"><?php echo e($reservation->remarque ?? '—'); ?></p>
        </div>
        


        <hr>

        <p class="small-muted mb-1">
            السعر الأساسي: <strong><?php echo e(number_format($basePrice, 2)); ?> د</strong>
        </p>

        <p class="small-muted mb-1">
            خدمات الطعام: <strong><?php echo e(number_format($restoTotal, 2)); ?> د</strong>
        </p>

        <p class="mb-3">
            المجموع الكلي: <strong><?php echo e(number_format($calculatedTotal, 2)); ?> د</strong>
        </p>

        <p>
            حالة الحجز:

            <span class="status-badge 
                <?php echo e($reservation->statut_id == 1 ? 'status-badge--success' : 
                    ($reservation->statut_id == 3 ? 'status-badge--danger' : 'status-badge--pending')); ?>">
                <?php echo e($reservation->statut?->statut_ar ?? 'في الانتظار'); ?>

            </span>
        </p>

        <?php if($reservation->statut_id == 3 && !empty($reservation->commentaire_motif)): ?>
            <div class="mt-2 p-2 border border-danger rounded bg-light">
                <strong class="text-danger">سبب الرفض:</strong>
                <p class="mb-0"><?php echo e($reservation->commentaire_motif); ?></p>
            </div>
        <?php endif; ?>


        <a href="<?php echo e(route('reservation.index')); ?>"
            class="btn btn-secondary mt-3 w-100" style="background-color:#1a237e;">
            رجوع إلى قائمة الحجوزات
        </a>
    </div>



    <?php if($reservation->statut_id == 2): ?>

        <?php
            $currentStatus = old('statut_id', $reservation->statut_id ?? '');
            $currentMotif  = old('commentaire_motif', $reservation->commentaire_motif ?? '');
        ?>

        <div class="card shadow-lg border-0 rounded-4 p-3 mb-3">

            <h5 class="mb-3 fw-bold">الوضعية الحالية</h5>

            <p class="text-muted mb-3">
                يمكنك تعديل وضعية الحجز من هنا:
            </p>
            <form action="<?php echo e(route('reservation.updateStatus', $reservation->id_reserv)); ?>" method="POST">
                <?php echo csrf_field(); ?>
                <?php echo method_field('PUT'); ?>
                <label style="color:black;"  class="form-label fw-bold">تغيير الوضعية</label>
                <select class="form-control" id="statut_id" name="statut_id" onchange="toggleMotifInputReservation()">
                    <option value="">اختر...</option>
                    <option value="1" <?php echo e($currentStatus == 1 ? 'selected' : ''); ?>>قبول</option>
                    <option value="3" <?php echo e($currentStatus == 3 ? 'selected' : ''); ?>>رفض</option>
                </select>

                <div class="mt-3 <?php echo e($currentStatus == 3 ? '' : 'd-none'); ?>" id="motifDiv">
                    <label style="color:black;"  class="form-label text-danger fw-bold">سبب الرفض</label>
                    <textarea name="commentaire_motif" class="form-control border-danger" rows="3"><?php echo e($currentMotif); ?></textarea>
                </div>

                <button  class="btn btn-secondary mt-3 w-100" style="background-color:#1a237e;">تحديث الوضعية</button>
            </form>

        </div>

    <?php endif; ?>

</div>



        </div>
    </div>
</div>

<script>
function toggleMotifInputReservation() {
    let status = document.getElementById("statut_id").value;
    let motif = document.getElementById("motifDiv");

    if (status == 3) {
        motif.classList.remove("d-none");
    } else {
        motif.classList.add("d-none");
    }
}
</script>
 
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/auberges/reservation/show.blade.php ENDPATH**/ ?>