<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <style>
        body {
            font-family: dejavusans;
            direction: rtl;
            text-align: right;
            font-size: 12px;
        }

        h3 {
            text-align: center;
            margin-bottom: 15px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            border: 1px solid #000;
            padding: 6px;
            text-align: center;
        }

        th {
            background: #f2f2f2;
        }
    </style>
</head>
<body>

<h3>قائمة استمارات مشاريع الترفيه للشباب و الأطفال</h3>

<table>
    <thead>
        <tr>
            <th>المعرف</th>
            <th>تاريخ الإيداع</th>
            <th>الاسم و اللقب</th>
            <th>طبيعة المشروع</th>
            <th>وضعية الطلب</th>
        </tr>
    </thead>
    <tbody>
        <?php $__currentLoopData = $projets; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $projet): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($projet->id_projet); ?></td>
                <td><?php echo e($projet->created_at->format('Y-m-d')); ?></td>
                <td><?php echo e($projet->investissements->first()?->utilisateur?->nom_prenom ?? '---'); ?></td>
                <td><?php echo e($projet->natureProjet?->nature_ar ?? '---'); ?></td>
                <td><?php echo e($projet->statut?->statut_ar ?? 'في الانتظار'); ?></td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </tbody>
</table>

</body>
</html>
<?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/investissement/gestion_jeune_enfant/exports/jeune_enfant_pdf.blade.php ENDPATH**/ ?>