<?php $__env->startSection('content'); ?>

<style>
    .actions-cell {
        display: flex;
        justify-content: center;
        align-items: center;
        flex-wrap: nowrap;
        gap: 6px;
    }

    .btn-icon {
        width: 30px;
        height: 30px;
        border-radius: 6px;
        display: inline-flex;
        align-items: center;
        justify-content: center;
        font-size: 15px;
        transition: all 0.2s ease;
        border: none;
        cursor: pointer;
        background-color: #f8f9fa;
    }

    .btn-icon:hover {
        transform: translateY(-1px);
        box-shadow: 0 2px 5px rgba(0,0,0,0.15);
    }

    .btn-icon--primary { background-color: #e3f2fd; color: #0d6efd; }
    .btn-icon--warning { background-color: #fff3cd; color: #856404; }
    .btn-icon--danger  { background-color: #f8d7da; color: #dc3545; }
    .btn-icon--info    { background-color: #d1ecf1; color: #0c5460; } 
</style>

<div class="container-fluid dashboard-inner-body-container">

    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0">

                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title pb-0">
                        الغرف الخاصة بـ :  
                        <strong class="text-primary"><?php echo e($auberge->nom); ?></strong>
                    </h2>

                    <a class="btn btn-success font-weight-medium"
                        href="<?php echo e(route('chambres.create', $auberge->id)); ?>">
                        <i class="la la-plus mr-1"></i> إضافة غرفة
                    </a>
                </div>

                <div class="block-card-body">

                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <div class="my-table table-responsive">
                        <table class="table align-items-center table-flush mb-0">
                            <thead class="thead-light">
                                <tr>
                                    <th>#</th>
                                    <th>رقم الغرفة</th>
                                    <th>النوع</th>
                                    <th>نوع الغرفة</th>
                                    <th>الطاقة الاستيعابية</th>
                                    <th>إجراءات</th>
                                </tr>
                            </thead>

                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $chambres; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $index => $chambre): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($index + 1); ?></td>
                                        <td><?php echo e($chambre->num_chambre); ?></td>
                                        <td>
                                            <?php if($chambre->type == 'chambre'): ?>
                                                غرفة
                                            <?php elseif($chambre->type == 'tente'): ?>
                                                خيمة
                                            <?php else: ?>
                                                -
                                            <?php endif; ?>
                                        </td>
                                        <td><?php echo e($chambre->typeChambre?->type_ar ?? '-'); ?></td>
                                        <td><?php echo e($chambre->capacite); ?></td>
                                        <td class="text-center">
                                            <div class="actions-cell">
                                                
                                                <button type="button"
                                                    class="btn-icon btn-icon--warning"
													onclick="window.location='<?php echo e(route('chambres.edit', $chambre->id_chambre_tente)); ?>'"
                                                    
                                                    title="تعديل" aria-label="تعديل">
                                                    <i class="la la-edit"></i>
                                                </button>

                                                <form action="<?php echo e(route('chambres.destroy', $chambre->id_chambre_tente)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button"
                                                        onclick="return confirmAction('هل تريد حقًا حذف هذه الغرفة؟', null, this.closest('form'))"
                                                        class="btn-icon btn-icon--danger"
                                                        title="حذف" aria-label="حذف">
                                                        <i class="la la-trash"></i>
                                                    </button>
                                                </form>

                                                <!--a href="<?php echo e(route('chambres.disponibilite', $chambre->id_chambre_tente)); ?>"
                                                    class="btn-icon btn-icon--info"
                                                    title="عرض التوافر" aria-label="عرض التوافر">
                                                    <i class="la la-calendar-check"></i>
                                                </a-->
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="6" class="text-center">لا توجد غرف حاليا</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/auberges/chambres/index.blade.php ENDPATH**/ ?>