<!DOCTYPE html>
<html lang="ar" dir="rtl" data-theme="light">
<head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="author" content="TechyDevs">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>وزارة الشباب و الرياضة</title>
    <link rel="icon" href="/FrontOfficeAR/images/favicon.png">
    <link href="https://fonts.googleapis.com/css2?family=Be+Vietnam:wght@100;300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/bootstrap-rtl.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/line-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/owl.theme.default.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/animated-headline_.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/datedropper.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/jquery-ui.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/jquery.fancybox.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/chosen.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/style-rtl.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/css.css')); ?>">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <style>
        :root {
            --primary-color: #e42125;
			--primary-red: #e42125;
            --primary-color-light: rgba(228, 33, 37, 0.1);
            --text-color: #333;
            --bg-color: #f8f9fa;
            --sidebar-bg: rgba(255, 255, 255, 0.95);
            --card-bg: rgba(255, 255, 255, 0.9);
            --border-color: rgba(0, 0, 0, 0.1);
            --shadow-color: rgba(0, 0, 0, 0.1);
        }

        [data-theme='dark'] {
            --text-color: #e1e1e1;
            --bg-color: #1a1a1a;
            --sidebar-bg: rgba(30, 30, 30, 0.95);
            --card-bg: rgba(40, 40, 40, 0.9);
            --border-color: rgba(255, 255, 255, 0.1);
            --shadow-color: rgba(0, 0, 0, 0.3);
        }

        body {
            position: relative;
            min-height: 100vh;
            background-color: var(--bg-color);
            overflow-x: hidden;
            color: var(--text-color);
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .dashboard-container {
            display: flex;
            min-height: 100vh;
            position: relative;
        }

        .dashboard-sidebar {
            width: 280px;
            flex-shrink: 0;
            position: fixed;
            top: 0;
            right: 0;
            height: 100vh;
            overflow-y: auto;
            z-index: 1000;
            background: var(--sidebar-bg);
            backdrop-filter: blur(10px);
            box-shadow: 0 0 15px var(--shadow-color);
            transition: transform 0.3s ease, background 0.3s ease;
        }

        .dashboard-sidebar::-webkit-scrollbar {
            width: 5px;
        }

        .dashboard-sidebar::-webkit-scrollbar-thumb {
            background: var(--primary-color);
            border-radius: 10px;
        }

        .dashboard-main {
            flex-grow: 1;
            margin-right: 280px;
            width: calc(100% - 280px);
            transition: margin-right 0.3s ease;
        }

        .dashboard-sidebar.collapsed {
            transform: translateX(280px);
        }

        .dashboard-main.expanded {
            margin-right: 0;
            width: 100%;
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            background-image: url('<?php echo e(asset('assets/img/shape/project-1-1.png')); ?>');
            background-size: contain;
            background-repeat: no-repeat;
            background-position: center right;
            opacity: 0.05;
            z-index: -1;
            pointer-events: none;
        }

        .dashboard-inner-body-container {
            background: var(--card-bg);
            backdrop-filter: blur(10px);
            border-radius: 15px;
            box-shadow: 0 0 20px var(--shadow-color);
            padding: 20px;
            margin: 20px;
            transition: background 0.3s ease, box-shadow 0.3s ease;
        }

        .nav-link {
            transition: all 0.3s ease;
            border-radius: 8px;
            margin: 5px 0;
            padding: 0.75rem 1rem;
            color: var(--text-color);
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .nav-link i {
            font-size: 1.2rem;
            min-width: 24px;
            text-align: center;
        }

        .dropdown-menu {
            border: none;
            border-radius: 10px;
            box-shadow: 0 2px 15px var(--shadow-color);
            padding: 0.5rem;
            margin-top: 0;
            background: var(--sidebar-bg);
            border: 1px solid var(--border-color);
            animation: fadeIn 0.2s ease;
        }

        .dropdown-item {
            padding: 0.75rem 1rem;
            border-radius: 6px;
            transition: all 0.2s ease;
            color: var(--text-color);
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .dropdown-item:hover, .dropdown-item:focus, .dropdown-item.active {
            background: var(--primary-color-light);
            color: var(--primary-color);
            transform: translateX(-5px);
        }

        .dropdown-toggle::after {
            margin-right: 0.5rem;
            transition: transform 0.2s ease;
        }

        .show .dropdown-toggle::after {
            transform: rotate(180deg);
        }

        .nav-link:hover {
            background: var(--primary-color-light);
            color: var(--primary-color);
            transform: translateX(-5px);
        }

        .navbar {
            border-radius: 15px;
            margin: 15px;
            background: var(--card-bg);
            box-shadow: 0 0 15px var(--shadow-color);
            transition: background 0.3s ease, box-shadow 0.3s ease;
        }

        .theme-switch {
            position: fixed;
            bottom: 20px;
            left: 20px;
            background: var(--card-bg);
            border-radius: 50%;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            box-shadow: 0 2px 10px var(--shadow-color);
            transition: all 0.3s ease;
            z-index: 1000;
        }

        .theme-switch:hover {
            transform: scale(1.1);
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .loader-container {
            background: var(--bg-color);
            transition: background 0.3s ease;
        }

        .sidebar-brand img {
            transition: filter 0.3s ease;
        }

        [data-theme='dark'] .sidebar-brand img {
            filter: brightness(2);
        }
    </style>
</head>
<body>
    <div class="loader-container">
        <div class="loader-ripple">
            <div></div>
            <div></div>
        </div>
    </div>
    <div class="dashboard-wrapper">
        <style>
            @import url('https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600&display=swap');

            .dashboard-header {
                font-family: 'Cairo', sans-serif;
                background: white;
                padding: 0.75rem 1.5rem;
                box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
                display: flex;
                align-items: center;
                justify-content: space-between;
                position: fixed;
                top: 15px;
                right: 295px;
                left: 15px;
                z-index: 1100;
                border-radius: 15px;
                border-bottom: 2px solid #e42125;
            }

            .header-left, .header-right {
                display: flex;
                align-items: center;
                gap: 1rem;
            }

            .header-icon-btn {
                width: 40px;
                height: 40px;
                border-radius: 10px;
                display: flex;
                align-items: center;
                justify-content: center;
                border: none;
                background: var(--light-navy);
                color: var(--navy-blue);
                cursor: pointer;
                transition: all 0.3s ease;
                position: relative;
            }

            .header-icon-btn:hover,
            .header-icon-btn.notification-badge:hover {
                background: #1a237e !important;
                color: white !important;
                transform: translateY(-2px);
                box-shadow: 0 4px 15px rgba(26, 35, 126, 0.3);
            }

            .header-icon-btn i {
                font-size: 1.25rem;
            }

            .search-box {
                position: relative;
            }

            .search-input {
                width: 250px;
                padding: 0.75rem 1rem 0.75rem 2.5rem;
                border: 1px solid #eee;
                border-radius: 10px;
                font-size: 1rem;
                transition: all 0.3s ease;
                background: white;
                color: var(--navy-blue);
            }

            .search-input::placeholder {
                color: #666;
            }

            .search-input:focus {
                width: 300px;
                border-color: var(--navy-blue);
                outline: none;
                box-shadow: 0 0 0 2px var(--light-navy);
            }

            .search-icon {
                position: absolute;
                left: 0.75rem;
                top: 50%;
                transform: translateY(-50%);
                color: var(--navy-blue);
            }

            .user-info {
                display: flex;
                align-items: center;
                gap: 1rem;
                padding: 0.5rem 1rem;
                border-radius: 10px;
                cursor: pointer;
                transition: all 0.3s ease;
                background: rgba(255, 255, 255, 0.15);
                backdrop-filter: blur(5px);
                border: 1px solid rgba(255, 255, 255, 0.3);
            }

            .user-info:hover {
                background: #1a237e;
                transform: translateY(-2px);
                box-shadow: 0 4px 15px rgba(26, 35, 126, 0.3);
            }

            .user-avatar {
                width: 40px;
                height: 40px;
                border-radius: 10px;
                background: #1a237e;
                color: white;
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 1.2rem;
                border: 2px solid rgba(255, 255, 255, 0.3);
                box-shadow: 0 4px 15px rgba(26, 35, 126, 0.3);
            }

            .user-details {
                text-align: right;
            }

            .user-name {
                font-weight: 600;
                color: var(--navy-blue);
                font-size: 1rem;
            }

            .user-role {
                color: #666;
                font-size: 0.9rem;
            }

            .notification-badge {
                position: relative;
            }

            .badge {
                position: absolute;
                top: -5px;
                right: -5px;
                background: var(--primary-red);
                color: white;
                width: 18px;
                height: 18px;
                border-radius: 50%;
                font-size: 0.75rem;
                display: flex;
                align-items: center;
                justify-content: center;
                border: 2px solid white;
                box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            }

            .dashboard-main {
                padding-top: 90px;
            }

            .header-left {
                display: flex;
                align-items: center;
                gap: 1rem;
            }

            .header-right {
                display: flex;
                align-items: center;
                gap: 1.5rem;
            }

            .header-icon-btn {
                width: 40px;
            }

            .dashboard-inner-body-container {
                background: var(--card-bg);
                backdrop-filter: blur(10px);
                border-radius: 15px;
                box-shadow: 0 0 20px var(--shadow-color);
                padding: 20px;
                margin: 20px;
                transition: background 0.3s ease, box-shadow 0.3s ease;
            }

            .nav-link {
                transition: all 0.3s ease;
                border-radius: 8px;
                margin: 5px 0;
                padding: 0.75rem 1rem;
                color: var(--text-color);
                display: flex;
                align-items: center;
                gap: 10px;
            }

            .nav-link i {
                font-size: 1.2rem;
                min-width: 24px;
                text-align: center;
            }

            .dropdown-menu {
                border: none;
                border-radius: 10px;
                box-shadow: 0 2px 15px var(--shadow-color);
                padding: 0.5rem;
                margin-top: 0;
                background: var(--sidebar-bg);
                border: 1px solid var(--border-color);
                animation: fadeIn 0.2s ease;
            }

            .dropdown-item {
                padding: 0.75rem 1rem;
                border-radius: 6px;
                transition: all 0.2s ease;
                color: var(--text-color);
                display: flex;
                align-items: center;
                gap: 10px;
            .user-name {
                font-weight: 600;
                color: #333;
                font-size: 1rem;
            }

            .user-role {
                color: #666;
                font-size: 0.9rem;
            }

            .notification-badge {
                position: relative;
            }

            .badge {
                position: absolute;
                top: -5px;
                right: -5px;
                background: var(--primary-red);
                color: white;
                width: 18px;
                height: 18px;
                border-radius: 50%;
                font-size: 0.75rem;
                display: flex;
                align-items: center;
                justify-content: center;
                border: 2px solid white;
                box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            }

            [data-theme='dark'] .dashboard-header {
                background: #1a1a1a;
                border-color: var(--navy-blue);
            }

            [data-theme='dark'] .search-input {
                background: #2a2a2a;
                border-color: #333;
                color: white;
            }

            [data-theme='dark'] .search-input::placeholder {
                color: #888;
            }

            [data-theme='dark'] .user-name {
                color: white;
            }

            [data-theme='dark'] .user-role {
                color: #888;
            }

            [data-theme='dark'] .header-icon-btn {
                background: rgba(255, 255, 255, 0.05);
                color: white;
            }

            [data-theme='dark'] .header-icon-btn:hover,
            [data-theme='dark'] .header-icon-btn.notification-badge:hover {
                background: var(--navy-blue) !important;
                color: white !important;
                box-shadow: 0 4px 15px rgba(26, 35, 126, 0.3);
            }

            [data-theme='dark'] .search-input {
                background: #2a2a2a;
                border-color: #333;
                color: #fff;
            }

            [data-theme='dark'] .search-input::placeholder {
                color: #888;
            }

            [data-theme='dark'] .user-info {
                background: #2a2a2a;
            }

            [data-theme='dark'] .user-name {
                color: #fff;
            }

            [data-theme='dark'] .user-role {
                color: #888;
            }
        </style>

        <header class="dashboard-header">
            <div class="header-left">
                <button class="header-icon-btn" id="sidebar-toggle">
                    <i class="ri-menu-line"></i>
                </button>
                <div class="search-box">
                    <i class="ri-search-line search-icon"></i>
                    <input type="text" class="search-input" placeholder="بحث سريع...">
                </div>
            </div>

            <div class="header-right">
                <button class="header-icon-btn" id="theme-toggle">
                    <i class="ri-sun-line"></i>
                </button>

                <button class="header-icon-btn notification-badge">
                    <i class="ri-notification-3-line"></i>
                    <span class="badge">3</span>
                </button>

                <?php if(auth()->guard()->check()): ?>
                <div class="user-info">
                    <div class="user-details">
                        <div class="user-name"><?php echo e(auth()->user()->nom_prenom ?? 'زائر'); ?></div>
                       
                    </div>
                    <div class="user-avatar">
                        <i class="ri-user-line"></i>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </header>

        <div class="dashboard-container d-flex">
            <?php echo $__env->make('backoffice.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <div class="dashboard-main flex-grow-1 d-flex flex-column min-vh-100">
                <div class="dashboard-content flex-grow-1">
                    <div class="container-fluid p-4">
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                </div>

                <footer class="dashboard-footer py-3 bg-white">
                    <div class="container-fluid text-center">
                        <p class="mb-0">
                            <span>جميع الحقوق محفوظة &copy; <?php echo e(date('Y')); ?></span>
                            <strong class="ms-2">وزارة الشباب و الرياضة</strong>
                        </p>
                    </div>
                </footer>
            </div>
        </div>
    </div>
    <script src="<?php echo e(asset('BackOfficeAR/js/jquery-3.4.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('BackOfficeAR/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('BackOfficeAR/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('BackOfficeAR/js/chart.min.js')); ?>"></script>
    <script src="<?php echo e(asset('BackOfficeAR/js/main-rtl.js')); ?>"></script>
    <script src="<?php echo e(asset('BackOfficeAR/js/script.js')); ?>"></script>



    <script>
    $(document).ready(function() {
        // Initialize dropdowns
        $('.dropdown-toggle').dropdown();

        // Add hover effect for dropdown items
        $('.dropdown-item').hover(
            function() { $(this).addClass('active'); },
            function() { $(this).removeClass('active'); }
        );

        // Keep dropdown open on hover
        $('.nav-item.dropdown').hover(
            function() { $(this).find('.dropdown-menu').stop(true, true).delay(100).fadeIn(300); },
            function() { $(this).find('.dropdown-menu').stop(true, true).delay(100).fadeOut(300); }
        );

        // Sidebar toggle
        $('#sidebar-close').click(function() {
            $('.dashboard-sidebar').toggleClass('collapsed');
            $('.dashboard-main').toggleClass('expanded');
        });

        // Theme switcher
        const themeToggle = document.getElementById('theme-toggle');
        const html = document.documentElement;
        const icon = themeToggle.querySelector('i');

        // Check for saved theme preference
        const savedTheme = localStorage.getItem('theme') || 'light';
        html.setAttribute('data-theme', savedTheme);
        updateThemeIcon(savedTheme);

        themeToggle.addEventListener('click', () => {
            const currentTheme = html.getAttribute('data-theme');
            const newTheme = currentTheme === 'light' ? 'dark' : 'light';
            
            html.setAttribute('data-theme', newTheme);
            localStorage.setItem('theme', newTheme);
            updateThemeIcon(newTheme);
        });

        function updateThemeIcon(theme) {
            icon.className = theme === 'light' ? 'ri-sun-line' : 'ri-moon-line';
        }

        // Sidebar toggle
        const sidebarToggle = document.getElementById('sidebar-toggle');
        sidebarToggle.addEventListener('click', () => {
            const sidebar = document.querySelector('.dashboard-sidebar');
            const main = document.querySelector('.dashboard-main');
            sidebar.classList.toggle('collapsed');
            main.classList.toggle('expanded');
        });
    });
    </script>
</body>
</html>
<?php /**PATH D:\mounir pc\projet MJS\back\resources\views/backoffice/dashboard.blade.php ENDPATH**/ ?>