<?php $__env->startSection('content'); ?>

<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire.css')); ?>">
<div class="container">
    <form action="<?php echo e(route('admin.debut_activite.update', $debutActivite->id_debut)); ?>" method="POST" id="myForm" lang="ar" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?> 
        <input type="hidden" name="immobilier_id" value="<?php echo e($debutActivite->immobilier_id ?? ''); ?>">
        <input type="hidden" name="utilisateur_id" id="utilisateur_id" value="<?php echo e($debutActivite->immobilier->utilisateur->id ?? ''); ?>">

      
        <h3>استمارة الاعلام ببداية النشاط</h3>


<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-custom-gray text-dark d-flex justify-content-between align-items-center">
    <h5 class="mb-0 fw-bold">الوضعية الحالية:</h5>
    <?php switch($debutActivite->id_statut):
      case (1): ?><span class="status-badge status-badge--success">مقبول</span><?php break; ?>
      <?php case (3): ?><span class="status-badge status-badge--danger">مرفوض</span><?php break; ?>
      <?php case (4): ?><span class="status-badge status-badge--warning">موافقة شريطة</span><?php break; ?>
      <?php case (5): ?><span class="status-badge status-badge--info">إرجاء لإبداء الرأي</span><?php break; ?>
      <?php case (2): ?><span class="status-badge status-badge--pending">في الانتظار</span><?php break; ?>
      <?php case (6): ?><span class="status-badge status-badge--secondary">مسودّة</span><?php break; ?>
      <?php default: ?> <span class="status-badge status-badge--secondary">غير محدد</span>
    <?php endswitch; ?>
  </div>

  <div class="card-body">
    <p class="text-muted mb-4 text-center fs-6">إذا كنت ترغب في تعديل الوضعية الحالية، يرجى الاختيار من القائمة أدناه:</p>

    <div class="form-group row align-items-center mb-3">
      <label for="id_statut" class="col-sm-2 col-form-label fw-bold">تغيير الوضعية</label>
      <div class="col-sm-4">
        <select required class="form-control" id="id_statut" name="id_statut" onchange="toggleMotifInput()">
          <option value="">اختر...</option>
          <?php $__currentLoopData = $statuts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <?php
              $statutId = $s->id_statut ?? $s->id ?? null;
              // hide pending(2) and draft(6) from selection list
              if (in_array($statutId, [2, 6])) continue;
              $label = $s->libelle_ar ?? $s->statut_ar ?? $s->label ?? $s->name ?? $s->statut ?? '—';
              $selected = (string) old('id_statut', $debutActivite->id_statut ?? '') === (string) $statutId;
            ?>
            <option value="<?php echo e($statutId); ?>" <?php echo e($selected ? 'selected' : ''); ?>><?php echo e($label); ?></option>
          <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </select>
      </div>
    </div>

   
<div class="mb-3 d-none" id="motifDivStatus">
  <label class="form-label fw-bold text-warning">سبب / تعليق</label>
  <textarea name="commentaire_status"
            id="commentaire_status"
            class="form-control border-warning shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال السبب أو التعليق">
	</textarea>
</div>


<div class="mb-3 d-none" id="motifDiv">
  <label for="commentaire_refus" class="form-label fw-bold text-danger">سبب الرفض</label>
    <textarea name="commentaire_refus"
            id="commentaire_refus"
            class="form-control border-danger shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال سبب الرفض">
	</textarea>
</div>
  </div>
</div>


<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-light py-2">
       <h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h5>
  </div>

  <div class="card-body p-2" dir="rtl">
    <?php if($debutActivite->statutHistories->isEmpty()): ?>
      <p class="text-muted mb-0">لا توجد تغييرات سابقة.</p>
    <?php else: ?>
      <div class="compact-timeline">
        <?php $__currentLoopData = $debutActivite->statutHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php
            $from = optional($hist->fromStatut)->statut_ar ?? optional($hist->fromStatut)->libelle_ar ?? '—';
            $to = optional($hist->toStatut)->statut_ar ?? optional($hist->toStatut)->libelle_ar ?? '—';
            $toId = optional($hist->toStatut)->id_statut;
            $badgeClass = $toId === 1 ? 'badge-success' : ($toId === 3 ? 'badge-danger' : 'badge-muted');
            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
          ?>

          <div class="compact-item">
            <div class="compact-row d-flex align-items-center justify-content-between w-100">
              <div class="left-block text-end">
                <div class="small text-muted compact-date"><?php echo e($hist->created_at->format('d/m/Y H:i')); ?></div>
                <div class="very-small text-muted compact-user">بواسطة: <?php echo e($changer); ?></div>
              </div>

              <div class="right-block text-right flex-fill">
                <span class="compact-from small text-muted"><?php echo e($from); ?></span>
                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                <span class="compact-to small <?php echo e($badgeClass); ?>"><?php echo e($to); ?></span>
              </div>
            </div>

            <?php if($hist->commentaire): ?>
              <details class="compact-comment mt-1">
                <summary class="very-small text-danger">سبب / تعليق</summary>
                <div class="very-small text-muted mt-1"><?php echo e($hist->commentaire); ?></div>
              </details>
            <?php endif; ?>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    <?php endif; ?>
  </div>
</div>

<style>
/* compact styles (same as earlier) */
.compact-timeline { display:flex; flex-direction:column; gap:6px; }
.compact-item { padding:6px 4px; border-bottom:1px solid rgba(0,0,0,0.06); }
.left-block { width:160px; min-width:120px; margin-left:12px; }
.compact-date { font-size:12px; color:#6c757d; }
.compact-user { font-size:11px; color:#8a8f94; margin-top:2px; }
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color:#6c757d; font-size:13px; }
.compact-arrow { color:#6c757d; font-size:14px; margin:0 4px; }
.compact-to { font-size:13px; padding:3px 8px; border-radius:10px; }
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }
.compact-comment summary { list-style:none; cursor:pointer; outline:none; padding:0; }
</style>


        <div class="form-section">
            <h4>هوية الباعث</h4> 
            <div class="form-group row align-items-center mb-3">
                <label class="col-sm-2 col-form-label">نوع الهوية</label>
                <div class="col-sm-4">
                    <span class="form-control">
                        <?php echo e($debutActivite->immobilier->utilisateur->cin ? 'بطاقة تعريف وطنية (CIN)' : 
                            ($debutActivite->immobilier->utilisateur->passport ? 'جواز سفر (Passport)' : 
                            ($debutActivite->immobilier->utilisateur->num_fiscal ? 'رقم تعريفي جبائي (Num Fiscal)' : '---'))); ?>

                    </span>
                </div>

                <div class="col-sm-4">
                    <input type="text" class="form-control" id="identifiant" value="<?php echo e($debutActivite->immobilier->utilisateur->cin ?? $debutActivite->immobilier->utilisateur->passport ?? $debutActivite->immobilier->utilisateur->num_fiscal ?? ''); ?>">
                </div>
                
            </div>

            <div id="sectionIdentite" class="d-block">
                <h5>بيانات الباعث</h5>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">الاسم و اللقب أو الاسم التجاري</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="nom_prenom" name="nom_prenom" value="<?php echo e($debutActivite->immobilier->utilisateur->nom_prenom ?? ''); ?>" readonly>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">رقم الهوية</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="identifiantAffiche" value="<?php echo e($debutActivite->immobilier->utilisateur->cin ?? $debutActivite->immobilier->utilisateur->passport ?? $debutActivite->immobilier->utilisateur->num_fiscal ?? ''); ?>" readonly>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">المندوبية الجهوية للشباب و الرياضة</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="mandoubia" value="<?php echo e($debutActivite->immobilier->gouvernorat->nom_ar ?? ''); ?>" readonly>
                    </div>
                </div>
            </div>

            <h4>تاريخ بداية النشاط</h4>
            <div class="form-group row">
                <div class="col-sm-11">
                    <input required type="date" class="form-control" id="date_debut_activite" name="date_debut_activite" value="<?php echo e($debutActivite->date_debut_activite ? $debutActivite->date_debut_activite->format('Y-m-d') : ''); ?>">
                </div>
            </div>
            <span>تاريخ بداية النشاط يجب ان يكون بعد 15 يوما من تاريخ استلام وصل التسجيل.</span>

            <h4>إضافة الوثائق المطلوبة</h4>
            <?php
                $docs = [
                    'preuve_propriete_location' => 'نسخة من شهادة الملكية او عقد بيع او عقد كراء ...',
                    'plan_architectural' => 'مثال هندسي معد من قبل مهندس معماري ...',
                    'declaration_investissement' => 'شهادة تصريح بالاستثمار ...',
                    'identification' => 'بطاقة تعريف جبائية',
                    'extrait_registre_national_entreprise' => 'مضمون السجل الوطني للمؤسسات',
                    'certificat_prevention' => 'شهادة وقاية مسلمة من المصالح الجهوية ...',
                    'contrat_assurance' => 'عقد التامين',
                    'approbation_autorite_minicipale' => 'عقود الشغل مع الاعوان ...'
                ];
            ?>

            <?php $__currentLoopData = $docs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="form-group row">
                    <label for="<?php echo e($field); ?>" class="col-sm-8 col-form-label"><?php echo e($label); ?></label>
                    <div class="col-sm-3">
                        <input type="file" class="form-control" id="<?php echo e($field); ?>" name="<?php echo e($field); ?>">
                        <?php if(!empty($debutActivite->$field)): ?>
							<a href="<?php echo e(route('debutActivite.download', ['id' => $debutActivite->id_debut, 'field' => $field])); ?>" target="_blank">الملف الحالي</a>
						<?php endif; ?>

                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

          
  <div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                <button type="submit" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill">
                <i class="bx bx-save"></i> حفظ
                </button>
                <a href="<?php echo e(route('salle-sport.index')); ?>" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
			
		
        </div>   
    </form>
</div>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/investissement/gestion_salle_sport/debut_activite/edit.blade.php ENDPATH**/ ?>