<?php $__env->startSection('content'); ?>
<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire.css')); ?>">
<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>
<?php if(Auth::check()): ?>

<div class="container">
    <form action="<?php echo e(route('salle-sport.update', $immobilier->id_imm)); ?>" method="POST" enctype="multipart/form-data" lang="ar">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

        <input type="hidden" name="id_formulaire" value="<?php echo e($formulaire->id_type); ?>">

        <h3><?php echo e($formulaire->type_ar); ?></h3>
        <h4 style="text-align:center;">تحيين الاستمارة</h4>
        <div class="card shadow-lg border-0 mb-4 rounded-4">
           <div class="card-header bg-custom-gray text-dark d-flex justify-content-between align-items-center">
    <h5 class="mb-0 fw-bold">الوضعية الحالية:</h5>

    <?php switch($immobilier->id_statut):

        case (1): ?>
            <span class="status-badge status-badge--success">مقبول</span>
            <?php break; ?>

        <?php case (3): ?>
            <span class="status-badge status-badge--danger">مرفوض</span>
            <?php break; ?>

        <?php case (4): ?>
            <span class="status-badge status-badge--warning">
                موافقة شريطة
            </span>
            <?php break; ?>

        <?php case (5): ?>
            <span class="status-badge status-badge--info">
                إرجاء لإبداء الرأي
            </span>
            <?php break; ?>

        <?php case (2): ?>
            <span class="status-badge status-badge--pending">
                في الانتظار
            </span>
            <?php break; ?>

        <?php case (6): ?>
            <span class="status-badge status-badge--secondary">
                مسودّة
            </span>
            <?php break; ?>

        <?php default: ?>
            <span class="status-badge status-badge--secondary">
                غير محدد
            </span>

    <?php endswitch; ?>
</div>

           <div class="card-body">
                 <p class="text-muted mb-4 text-center fs-6">
                              إذا كنت ترغب في تعديل الوضعية الحالية، يرجى الاختيار من القائمة أدناه:
                 </p>

    
<div class="form-group row align-items-center mb-3">
  <label for="id_statut" class="col-sm-2 col-form-label fw-bold">تغيير الوضعية</label>
  <div class="col-sm-4">
<select required
        class="form-control"
        id="id_statut"
        name="id_statut"
        onchange="toggleMotifInput()">

    <option value="">اختر...</option>

    <?php $__currentLoopData = $statuts; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $s): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <?php
            $statutId = $s->id_statut ?? $s->id ?? $s->ID ?? null;

            // Exclude Pending (2) and Draft (6)
            if (in_array($statutId, [2, 6])) {
                continue;
            }

            $label = $s->libelle_ar
                    ?? $s->statut_ar
                    ?? $s->label
                    ?? $s->name
                    ?? $s->statut
                    ?? '—';

            $selected = (string) old('id_statut', $immobilier->id_statut ?? '') === (string) $statutId;
        ?>

        <option value="<?php echo e($statutId); ?>" <?php echo e($selected ? 'selected' : ''); ?>>
            <?php echo e($label); ?>

        </option>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
</select>

  </div>
</div>


<div class="mb-3 d-none" id="motifDivStatus">
  <label class="form-label fw-bold text-warning">سبب / تعليق</label>
  <textarea name="commentaire_status"
            id="commentaire_status"
            class="form-control border-warning shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال السبب أو التعليق"></textarea>
</div>


<div class="mb-3 d-none" id="motifDiv">
  <label for="commentaire_refus" class="form-label fw-bold text-danger">سبب الرفض</label>
  <textarea name="commentaire_refus"
            id="commentaire_refus"
            class="form-control border-danger shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال سبب الرفض"></textarea>
</div>


          </div>
       </div>
        


<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-light py-2">
    <h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h6>
  </div>

  <div class="card-body p-2" dir="rtl">
    <?php if($immobilier->statutHistories->isEmpty()): ?>
      <p class="text-muted mb-0 ">لا توجد تغييرات سابقة.</p>
    <?php else: ?>
      <div class="compact-timeline">
        <?php $__currentLoopData = $immobilier->statutHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php
            $from = optional($hist->fromStatut)->statut_ar
                    ?? optional($hist->fromStatut)->libelle_ar
                    ?? '—';
            $to = optional($hist->toStatut)->statut_ar
                  ?? optional($hist->toStatut)->libelle_ar
                  ?? '—';
            $toId = optional($hist->toStatut)->id_statut;
            $badgeClass = $toId === 1 ? 'badge-success'
                         : ($toId === 3 ? 'badge-danger' : 'badge-muted');
            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
          ?>

          <div class="compact-item">
            <div class="compact-row d-flex align-items-center justify-content-between w-100">
              <div class="left-block text-end">
                <div class="small text-muted compact-date"><?php echo e($hist->created_at->format('d/m/Y H:i')); ?></div>
                <div class="very-small text-muted compact-user">بواسطة: <?php echo e($changer); ?></div>
              </div>

              <div class="right-block text-right flex-fill">
                <span class="compact-from small text-muted"><?php echo e($from); ?></span>
                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                <span class="compact-to small <?php echo e($badgeClass); ?>"><?php echo e($to); ?></span>
              </div>
            </div>

            <?php if($hist->commentaire): ?>
              <details class="compact-comment mt-1">
                <summary class="very-small text-danger">سبب / تعليق</summary>
                <div class="very-small text-muted mt-1"><?php echo e($hist->commentaire); ?></div>
              </details>
            <?php endif; ?>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    <?php endif; ?>
  </div>
</div>

<style>
/* Compact timeline styles (RTL) */
.compact-timeline { display: flex; flex-direction: column; gap: 6px; }
.compact-item { padding: 6px 4px; border-bottom: 1px solid rgba(0,0,0,0.06); }

.compact-row { gap: 8px; align-items: flex-start; }

/* left block (date + user) placed on the right visually because of RTL */
.left-block { width: 160px; min-width: 120px; margin-left: 12px; }
.compact-date { font-size: 12px; color: #6c757d; }
.compact-user { font-size: 11px; color: #8a8f94; margin-top: 2px; }

/* main labels */
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color: #6c757d; font-size: 13px; }
.compact-arrow { color: #6c757d; font-size: 14px; margin: 0 4px; }
.compact-to { font-size: 13px; padding: 3px 8px; border-radius: 10px; }

/* small badge color helpers */
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }

/* comment details (very compact) */
.compact-comment summary {
  list-style: none;
  cursor: pointer;
  outline: none;
  padding: 0;
}

</style>


      <div class="form-section">
            <h4>هوية الباعث</h4>  
            <div class="form-group row">
                <label class="col-sm-2 col-form-label">الاسم و اللقب أو الاسم التجاري</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="nom_prenom" 
                        placeholder="الاسم و اللقب أو الاسم التجاري" maxlength="50"
                        value="<?php echo e(old('nom_prenom', $immobilier->utilisateur->nom_prenom ?? '')); ?>">
                </div>
            </div>  

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                <div class="col-sm-4">
                    <select required class="form-control" id="id_type_identite" name="id_type_identite" onchange="showTypeIdentiteInput2()">
                        <option value="" disabled>اختر...</option>
                        <?php $__currentLoopData = $typesIdentite; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type->id_type); ?>" 
                                <?php echo e(old('id_type_identite', $immobilier->utilisateur->id_type_identite ?? '') == $type->id_type ? 'selected' : ''); ?>>
                                <?php echo e($type->type_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>
                <div class="col-sm-6" id="identite-fields">
                    <input type="text" class="form-control identite-field" id="cin_input" name="cin" 
                        placeholder="أدخل رقم بطاقة التعريف" pattern="^\d{8}$" maxlength="8"
                        style="display:none;"
                        value="<?php echo e(old('cin', $immobilier->utilisateur->cin ?? '')); ?>">
                    <input type="text" class="form-control identite-field" id="passport_input" name="passport" 
                        placeholder="أدخل رقم جواز السفر" pattern="^\d{8,12}$" minlength="8" maxlength="12"
                        style="display:none;"
                        value="<?php echo e(old('passport', $immobilier->utilisateur->passport ?? '')); ?>">
                    <input type="text" class="form-control identite-field" id="num_fiscal_input" name="num_fiscal" 
                        placeholder="أدخل رقم المعرف الجبائي" pattern="^\d{12}$" maxlength="12"
                        style="display:none;"
                        value="<?php echo e(old('num_fiscal', $immobilier->utilisateur->num_fiscal ?? '')); ?>">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">رقم الهاتف الشخصي</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="tel" placeholder="رقم الهاتف الشخصي" maxlength="12"
                        value="<?php echo e(old('tel', $immobilier->utilisateur->tel ?? '')); ?>">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">البريد الالكتروني</label>
                <div class="col-sm-10">
                    <input required type="email" class="form-control" name="email" placeholder=" "
                        value="<?php echo e(old('email', $immobilier->utilisateur->email ?? '')); ?>">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">العنوان الشخصي</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" placeholder=" " maxlength="100"
                        value="<?php echo e(old('adresse', $immobilier->utilisateur->adresse ?? '')); ?>">
                </div>
            </div>

            <h4>هوية العقار</h4> 
            <div class="form-group row">
                <label for="adresse_imm" class="col-sm-2 col-form-label">عنوان العقار</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" id="adresse_imm" name="adresse_imm" placeholder=" "
                        value="<?php echo e(old('adresse_imm', $immobilier->adresse_imm ?? '')); ?>"
                        oninvalid="this.setCustomValidity('يجب ألا يتجاوز عنوان العقار 100 حرفاً')" 
                        oninput="this.setCustomValidity('')">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label">الولاية</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="gouvernorat_id" name="gouvernorat_id">
                        <option value="" disabled <?php echo e(old('gouvernorat_id', $immobilier->gouvernorat_id ?? '') ? '' : 'selected'); ?>>اختر...</option>
                        <?php $__currentLoopData = $gouvernorats; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $gouv): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($gouv->id_gouver); ?>"
                                <?php echo e(old('gouvernorat_id', $immobilier->gouvernorat_id ?? '') == $gouv->id_gouver ? 'selected' : ''); ?>>
                                <?php echo e($gouv->nom_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <label class="col-sm-2 col-form-label">البلدية</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="delegation_id" name="delegation_id" <?php echo e($immobilier->delegation_id ? '' : 'disabled'); ?>>
                        <option value="" disabled <?php echo e(old('delegation_id', $immobilier->delegation_id ?? '') ? '' : 'selected'); ?>>اختر...</option>
                        <?php if($immobilier->delegation_id): ?>
                            <?php $__currentLoopData = $delegations; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $del): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <option value="<?php echo e($del->id_delegation); ?>"
                                    <?php echo e(old('delegation_id', $immobilier->delegation_id ?? '') == $del->id_delegation ? 'selected' : ''); ?>>
                                    <?php echo e($del->nom_ar); ?>

                                </option>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        <?php endif; ?>
                    </select>
                </div>
            </div>

            <div class="form-group row">
                <label for="type_imm_id" class="col-sm-2 col-form-label">صيغة العقار</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="type_imm_id" name="type_imm_id">
                        <option value="" disabled <?php echo e(old('type_imm_id', $immobilier->type_imm_id ?? '') ? '' : 'selected'); ?>>اختر...</option>
                        <?php $__currentLoopData = $typesImmobilier; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $type): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($type->id_type); ?>"
                                <?php echo e(old('type_imm_id', $immobilier->type_imm_id ?? '') == $type->id_type ? 'selected' : ''); ?>>
                                <?php echo e($type->type_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <label for="superfici_m2" class="col-sm-2 col-form-label">المساحة الجملية للعقار بالم2</label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" id="superfici_m2" name="superfici_m2" placeholder=" "
                        value="<?php echo e(old('superfici_m2', $immobilier->superfici_m2 ?? '')); ?>"
                        oninvalid="this.setCustomValidity('المساحة يجب ان لا تتجاوز 100م2')" 
                        oninput="this.setCustomValidity('')" min="100">
                    <span>المساحة يجب ان تكون 100م2 على الاقل.</span>
                </div>                
            </div>

            <div class="form-group row">
                <label for="usage_id" class="col-sm-2 col-form-label">صيغة استغلال العقار</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="usage_id" name="usage_id">
                        <option value="" disabled <?php echo e(old('usage_id', $immobilier->usage_id ?? '') ? '' : 'selected'); ?>>اختر...</option>
                        <?php $__currentLoopData = $usagesImmobilier; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $usage): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                            <option value="<?php echo e($usage->id_usage_imm); ?>"
                                <?php echo e(old('usage_id', $immobilier->usage_id ?? '') == $usage->id_usage_imm ? 'selected' : ''); ?>>
                                <?php echo e($usage->usage_ar); ?>

                            </option>
                        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                    </select>
                </div>

                <label for="document_propriete" class="col-sm-2 col-form-label">نسخة العقد/الملكية</label>
                <div class="col-sm-4">
                    <input type="file" class="form-control" id="document_propriete" name="document_propriete">
                    <?php if($immobilier->document_propriete): ?>
                        <small>الملف الحالي: <a href="<?php echo e(asset('storage/'.$immobilier->document_propriete)); ?>" target="_blank">عرض</a></small>
                    <?php endif; ?>
                </div>
            </div>
            <h4>مكونات العقار</h4>

            <?php
              $components = [
    'salle_exercice','piscine','vestiaire','unitaires_sanitaire',
    'stockage_conservation','espace_exterieur','garage'
];

            ?>
            <?php $__currentLoopData = $components; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                <div class="form-group row">
                    <label for="<?php echo e($comp); ?>" class="col-sm-2 col-form-label">
                        <?php switch($comp):
                            case ('salle_exercice'): ?> قاعة التمارين <?php break; ?>
                            <?php case ('piscine'): ?> حوض مائي <?php break; ?>
                            <?php case ('vestiaire'): ?> حجرات ملابس <?php break; ?>
                            <?php case ('unitaires_sanitaire'): ?> وحدات صحية <?php break; ?>
                            <?php case ('stockage_conservation'): ?> فضاء للخزن و حفض الاثاث و المعدات <?php break; ?>
                            <?php case ('espace_exterieur'): ?> فضاء خارجي <?php break; ?>
                            <?php case ('garage'): ?> ماوى سيارات <?php break; ?>
                        <?php endswitch; ?>
                    </label>
                    <div class="col-sm-4">
                        <select required class="form-control" id="<?php echo e($comp); ?>" name="<?php echo e($comp); ?>" onchange="toggleSection('<?php echo e($comp); ?>','id_<?php echo e($comp); ?>')">
                            <option value="" disabled <?php echo e(old($comp, $immobilier->$comp ?? '') === null ? 'selected' : ''); ?>>اختر...</option>
                            <option value="1" <?php echo e(old($comp, $immobilier->$comp ?? '') == 1 ? 'selected' : ''); ?>>نعم</option>
                            <option value="0" <?php echo e(old($comp, $immobilier->$comp ?? '') == 0 ? 'selected' : ''); ?>>لا</option>
                        </select>
                    </div>

                    <div class="col-sm-6" id="id_<?php echo e($comp); ?>" style="display: <?php echo e(old($comp, $immobilier->$comp ?? '') == 1 ? 'block' : 'none'); ?>;">
                          <?php if(in_array($comp, ['salle_exercice','piscine','vestiaire'])): ?>
            <div class="mb-2">
                <input type="number" class="form-control" id="nbr_<?php echo e($comp); ?>" name="nbr_<?php echo e($comp); ?>" placeholder="عدد"
                    value="<?php echo e(old('nbr_'.$comp, $immobilier->{'nbr_'.$comp} ?? '')); ?>">
            </div>
            <div>
                <input type="number" class="form-control" id="superface_<?php echo e($comp); ?>" name="superface_<?php echo e($comp); ?>" placeholder="مساحة"
                    value="<?php echo e(old('superface_'.$comp, $immobilier->{'superface_'.$comp} ?? '')); ?>">
            </div>
        <?php else: ?>
            <input type="number" class="form-control" id="superface_<?php echo e($comp); ?>" name="superface_<?php echo e($comp); ?>" placeholder="مساحة"
                value="<?php echo e(old('superface_'.$comp, $immobilier->{'superface_'.$comp} ?? '')); ?>">
        <?php endif; ?>
                    </div>
                </div>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
            <div class="form-group row">
                <label for="autres_surfaces" class="col-sm-2 col-form-label">مساحات اخرى</label>
                <div class="col-sm-10">
                    <input required type="number" class="form-control" id="autres_surfaces" name="autres_surfaces" 
                        value="<?php echo e(old('autres_surfaces', $immobilier->autres_surfaces ?? '')); ?>">
                </div>
            </div>
            
        </div>
        <div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                <button type="submit" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill">
                <i class="bx bx-save"></i> حفظ
                </button>
                <a href="<?php echo e(route('salle-sport.index')); ?>" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">


    </form>
</div><script>document.addEventListener("DOMContentLoaded", function () {    const gouvSelect = document.getElementById('gouvernorat_id');    const delSelect  = document.getElementById('delegation_id');    gouvSelect.addEventListener('change', function () {        let gouvId = this.value;        delSelect.innerHTML = '';        delSelect.disabled = true;        delSelect.innerHTML = '<option disabled selected>تحميل...</option>';        let url = "<?php echo e(route('delegations.get', ['gouvernoratId' => 'ID_PLACEHOLDER'])); ?>";        url = url.replace("ID_PLACEHOLDER", gouvId);        fetch(url)            .then(response => response.json())            .then(data => {                                delSelect.innerHTML = '<option disabled selected>اختر...</option>';                                data.forEach(d => {                    let option = document.createElement('option');                    option.value = d.id_delegation;                    option.text  = d.nom_ar;                    delSelect.appendChild(option);                });                delSelect.disabled = false;            });    });});</script>
<script>
    document.addEventListener('DOMContentLoaded', function() {
        <?php $__currentLoopData = $components; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comp): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            toggleSection('<?php echo e($comp); ?>','id_<?php echo e($comp); ?>');
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    });
</script>

<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('admin')); ?>";
    </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>
<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/investissement/gestion_salle_sport/salle_sport/edit.blade.php ENDPATH**/ ?>