<?php $__env->startSection('content'); ?>
<div class="container py-4" dir="rtl" lang="ar">
  <div class="row justify-content-center">
    <div class="col-xl-8 col-lg-10">
      <div class="card shadow-sm border-0 rounded-3 overflow-hidden">
        <!-- Header -->
        <div class="card-header bg-white text-center py-4">
          <h4 class="mb-1"><?php echo e($fieldDefinition->exists ? 'تعديل الحقل' : 'إضافة حقل جديد للنموذج'); ?></h4>
          <p class="text-muted small mb-0">الحقول التي تحمل علامة <span class="text-danger">*</span> إلزامية. يمكنك معاينة مفتاح الحقل الذي سيُنشأ تلقائياً.</p>
        </div>

        <div class="card-body p-4">
          <?php if($errors->any()): ?>
            <div class="alert alert-danger text-end">
              <ul class="mb-0">
                <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $err): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                  <li><?php echo e($err); ?></li>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
              </ul>
            </div>
          <?php endif; ?>

          <form action="<?php echo e($fieldDefinition->exists ? route('backoffice.field_definitions.update', $fieldDefinition) : route('field_definitions.store')); ?>" method="POST" novalidate>
            <?php echo csrf_field(); ?>
            <?php if($fieldDefinition->exists): ?> <?php echo method_field('PUT'); ?> <?php endif; ?>

            
        <div class="mb-3">
  <label class="form-label d-block text-end fw-semibold">التسمية (label) <span class="text-danger">*</span></label>
  <input id="fld_label" name="label" value="<?php echo e(old('label', $fieldDefinition->label)); ?>" class="form-control form-control-lg shadow-sm" required placeholder="التسمية الظاهرة للمستخدم">

  <div class="d-flex justify-content-between align-items-center mt-2">
    <small class="text-muted">مفتاح الحقل المتوقع: </small>
    <small id="key_preview" class="text-muted"><?php echo e(old('label', $fieldDefinition->label) ? \Illuminate\Support\Str::slug(mb_strtolower(old('label', $fieldDefinition->label)), '_') : 'field'); ?></small>
  </div>
</div>

            
            <div class="row g-3 mb-3">
              <div class="col-md-7">
                <label class="form-label d-block text-end fw-semibold">نوع الحقل (input_type) <span class="text-danger">*</span></label>
                 <select id="input_type" name="input_type" class="form-control form-control-lg shadow-sm" aria-label="نوع الحقل">
               
                <?php
                    $types = ['text'=>'نص','textarea'=>'منطقة نص','date'=>'تاريخ','number'=>'رقم','file'=>'ملف','email'=>'بريد إلكتروني','select'=>'قائمة (اختيار)','multiselect'=>'قائمة متعددة','radio'=>'اختيارات راديو','checkbox'=>'مربعات اختيار'];
                   $curType = old('input_type', $fieldDefinition->input_type);
                  ?>
                  <?php $__currentLoopData = $types; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $k => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                    <option value="<?php echo e($k); ?>" <?php echo e($curType === $k ? 'selected' : ''); ?>><?php echo e($label); ?></option>
                  <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
              </div>

              <div class="col-md-5">
                <label class="form-label d-block text-end fw-semibold">ترتيب العرض</label>
                <input type="number" name="sort_order" class="form-control form-control-lg shadow-sm" value="<?php echo e(old('sort_order', $fieldDefinition->sort_order ?? 100)); ?>" min="1">
                <div class="form-text text-muted text-end small">قيمة أصغر تعني عرضاً أعلى في الاستمارة</div>
              </div>
            </div>

            
           
<div id="options_wrapper" class="mb-3"
     style="<?php echo e(in_array($curType, ['select','multiselect','radio','checkbox']) ? '' : 'display:none;'); ?>">
  <label class="form-label d-block text-end fw-semibold">خيارات (select / radio / checkbox) — كل خيار في سطر جديد أو مفصول بفاصلة</label>
  <textarea name="options_json" class="form-control shadow-sm" rows="4" placeholder="مثال: خيار1&#10;خيار2"><?php echo e(old('options_json', is_array($fieldDefinition->options()) ? implode("\n", $fieldDefinition->options()) : $fieldDefinition->options_json)); ?></textarea>
  <div class="form-text text-muted text-end small">يمكنك إدخال JSON array أو كل خيار في سطر جديد أو فاصلة تفصل بين الخيارات.</div>
</div>


            
            <div class="row g-2 align-items-center mb-4">
              <div class="col-auto">
                <div class="form-check form-switch d-flex align-items-center">
                  <input class="form-check-input" id="is_visible" name="is_visible" type="checkbox" value="1" <?php echo e(old('is_visible', $fieldDefinition->is_visible) ? 'checked' : ''); ?>>
                  <label class="form-check-label ms-2" for="is_visible">مرئي في الاستمارة</label>
                </div>
              </div>

              <div class="col-auto">
                <div class="form-check form-switch d-flex align-items-center">
                  <input class="form-check-input" id="is_required" name="is_required" type="checkbox" value="1" <?php echo e(old('is_required', $fieldDefinition->is_required) ? 'checked' : ''); ?>>
                  <label class="form-check-label ms-2" for="is_required">إلزامي</label>
                </div>
              </div>

              <div class="col text-muted small text-end">
                
              </div>
            </div>

            
            <div class="d-flex justify-content-between">
                        <button type="submit" class="btn btn-primary shadow-sm">
                <i class="bi bi-check-lg me-2"></i><?php echo e($fieldDefinition->exists ? 'حفظ التغييرات' : 'حفظ الحقل'); ?>

              </button>

              <a href="<?php echo e(route('backoffice.field_definitions.index')); ?>" class="btn btn-secondary shadow-sm">
               العودة
              </a>
            </div>
          </form>
        </div>

        <div class="card-footer bg-white text-center small text-muted py-3">
          يتم تخزين المعلومات بشكل آمن. لأي استفسار تواصل مع المسؤول.
        </div>
      </div>
    </div>
  </div>
</div>

<?php $__env->startPush('styles'); ?>
<style>
  /* visual polish */
  .card { border-radius: .8rem; }
  .form-control, .form-select { border-radius: .5rem; }
  .form-control:focus, .form-select:focus { box-shadow: 0 6px 18px rgba(13,110,253,0.08); outline: none; }
  .card-header { border-bottom: 1px solid rgba(0,0,0,0.04); }
  .fw-semibold { font-weight: 600 !important; }
  /* make small icons & spacing consistent (Bootstrap icons used if available) */
  /* .btn i { vertical-align: -0.125em; } */
  /* ensure long option content doesn't break layout */
  textarea.form-control { resize: vertical; min-height: 96px; }
</style>
<?php $__env->stopPush(); ?>

<?php $__env->startPush('scripts'); ?>
<?php $__env->startPush('scripts'); ?>
<script>
document.addEventListener('DOMContentLoaded', function () {
  try {
    const labelInput = document.getElementById('fld_label');
    const keyPreview = document.getElementById('key_preview');
    const inputType = document.getElementById('input_type');
    const optionsWrapper = document.getElementById('options_wrapper');

    function slugKey(value) {
      if (!value) return 'field';
      let s = value.trim().toLowerCase();
      s = s.normalize('NFKD').replace(/[^\w\u0600-\u06FF]+/g, '_');
      s = s.replace(/^_+|_+$/g, '').replace(/__+/g, '_');
      return s || 'field';
    }

    if (labelInput && keyPreview) {
      labelInput.addEventListener('input', function () {
        keyPreview.textContent = slugKey(this.value);
      });
    }

    function toggleOptionsVisibility() {
      if (!inputType || !optionsWrapper) return;
      const t = inputType.value;
      const needsOptions = ['select','multiselect','radio','checkbox'].includes(t);
      optionsWrapper.style.display = needsOptions ? 'block' : 'none';
      optionsWrapper.setAttribute('aria-hidden', !needsOptions);
    }

    if (inputType) {
      inputType.addEventListener('change', toggleOptionsVisibility);
      // initial
      toggleOptionsVisibility();
    }
  } catch (err) {
    // keep form usable even if JS fails
    console.error('Field form script error:', err);
  }
});
</script>
<?php $__env->stopPush(); ?>


<script>
(function(){
  // run the same small toggle if DOM already loaded and <?php echo $__env->yieldPushContent('scripts'); ?> wasn't present
  if (!document.getElementById('input_type')) return;
  try {
    const inputType = document.getElementById('input_type');
    const optionsWrapper = document.getElementById('options_wrapper');
    function toggleOptionsVisibility() {
      if (!inputType || !optionsWrapper) return;
      const t = inputType.value;
      const needsOptions = ['select','multiselect','radio','checkbox'].includes(t);
      optionsWrapper.style.display = needsOptions ? 'block' : 'none';
      optionsWrapper.setAttribute('aria-hidden', !needsOptions);
    }
    inputType.addEventListener('change', toggleOptionsVisibility);
    toggleOptionsVisibility();
  } catch(e) { console.warn(e); }
})();
</script>

<?php $__env->stopPush(); ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/concours_ext/edit_field.blade.php ENDPATH**/ ?>