
<?php $__env->startSection('content'); ?>

<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire.css')); ?>">
<div class="container">
    <form action="<?php echo e(route('admin.debut_activite.update', $debutActivite->id_debut)); ?>" method="POST" id="myForm" lang="ar" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

    <div class="header-print-container mb-4">
        <div class="header-center text-center">
            <h2>الجمهورية التونسية</h2>
            <h2>وزارة الشباب و الرياضة</h2>
            <h3>استمارة الإعلام ببداية النشاط</h3>
        </div>
        <div class="header-side header-right no-print">
            <button type="button" onclick="window.print()" class="btn btn-success">
                <i class="fas fa-print" style="margin-right:5px;"></i> طباعة
            </button>
        </div>
    </div>

    <div class="card shadow-lg border-0 mb-4 rounded-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0 fw-bold">الوضعية الحالية:</h5>
            <?php if($debutActivite->id_statut == 1): ?>
                <span class="badge bg-success fs-6">مقبول</span>
            <?php elseif($debutActivite->id_statut == 3): ?>
                <span class="badge bg-danger fs-6">مرفوض</span>
            <?php else: ?>
                <span class="badge bg-warning text-dark fs-6">في الانتظار</span>
            <?php endif; ?>
        </div>

        <?php if($debutActivite->id_statut == 3 && $debutActivite->commentaire_motif): ?>
            <div class="card-body">
                <p class="text-danger fw-bold">سبب الرفض:</p>
                <p><?php echo e($debutActivite->commentaire_motif); ?></p>
            </div>
        <?php endif; ?>
    </div>

    <h4 class="mb-3 fw-bold">هوية الباعث</h4>
    <div class="row mb-3">
        <div class="col-md-6">
            <label class="fw-bold">الاسم و اللقب أو الاسم التجاري</label>
            <input type="text" class="form-control" value="<?php echo e($debutActivite->immobilier->utilisateur->nom_prenom ?? '-'); ?>" readonly>
        </div>
        <div class="col-md-6">
            <label class="fw-bold">رقم الهوية</label>
            <input type="text" class="form-control" value="<?php echo e($debutActivite->immobilier->utilisateur->cin ?? $debutActivite->immobilier->utilisateur->passport ?? $debutActivite->immobilier->utilisateur->num_fiscal ?? '-'); ?>" readonly>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-md-6">
            <label class="fw-bold">الهاتف</label>
            <input type="text" class="form-control" value="<?php echo e($debutActivite->immobilier->utilisateur->tel ?? '-'); ?>" readonly>
        </div>
        <div class="col-md-6">
            <label class="fw-bold">البريد الإلكتروني</label>
            <input type="text" class="form-control" value="<?php echo e($debutActivite->immobilier->utilisateur->email ?? '-'); ?>" readonly>
        </div>
    </div>

    <h4>تاريخ بداية النشاط</h4>
            <div class="form-group row">
                <div class="col-sm-11">
                    <input required type="date" class="form-control" id="date_debut_activite" name="date_debut_activite" value="<?php echo e($debutActivite->date_debut_activite ? $debutActivite->date_debut_activite->format('Y-m-d') : ''); ?>" readonly>
                </div>
            </div>
            <span>تاريخ بداية النشاط يجب ان يكون بعد 15 يوما من تاريخ استلام وصل التسجيل.</span>


    <h4 class="mb-3 fw-bold">الوثائق المرفقة</h4>
    <?php
        $docs = [
            'preuve_propriete_location' => 'نسخة من شهادة الملكية أو عقد الكراء ...',
            'plan_architectural' => 'مخطط معماري ...',
            'declaration_investissement' => 'شهادة تصريح بالاستثمار ...',
            'identification' => 'بطاقة تعريف / جواز ...',
            'extrait_registre_national_entreprise' => 'السجل الوطني للمؤسسات ...',
            'certificat_prevention' => 'شهادة الوقاية ...',
            'contrat_assurance' => 'عقد التأمين ...',
            'approbation_autorite_minicipale' => 'اعتماد السلطة المحلية ...'
        ];
    ?>

    <?php $__currentLoopData = $docs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="mb-2">
            <strong><?php echo e($label); ?>: </strong>
            <?php if($debutActivite->$field): ?>
                <a href="<?php echo e(asset('storage/'.$debutActivite->$field)); ?>" target="_blank">عرض الملف</a>
            <?php else: ?>
                <span>-</span>
            <?php endif; ?>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

    <div class="mt-4 text-center no-print">
        <a href="<?php echo e(route('admin.debut_activite.index')); ?>" class="btn btn-primary">
            <i class="bi bi-arrow-left"></i> رجوع
        </a>
        <button type="button" onclick="window.print()" class="btn btn-success">
            <i class="fa fa-print"></i> طباعة
        </button>
    </div>

</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH D:\mounir pc\projet MJS\back\resources\views/backoffice/investissement/gestion_salle_sport/debut_activite/show.blade.php ENDPATH**/ ?>