<?php $__env->startSection('content'); ?>

<link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/formulaire.css')); ?>">
<div class="container">
    <form action="<?php echo e(route('admin.debut_activite.update', $debutActivite->id_debut)); ?>" method="POST" id="myForm" lang="ar" enctype="multipart/form-data">
        <?php echo csrf_field(); ?>
        <?php echo method_field('PUT'); ?>

    <div class="header-print-container mb-4">
        <div class="header-center text-center">
         
            <h3>استمارة الإعلام ببداية النشاط</h3>
        </div>
        <div class="mt-4 text-center no-print">
			<a href="<?php echo e(route('admin.debut_activite.pdf', $debutActivite->id_debut)); ?>" target="_blank" class="btn btn-danger">
				<i class="fa fa-file-pdf"></i> تحميل PDF
			</a>
		</div>

    </div>

    <div class="card shadow-lg border-0 mb-4 rounded-4">
        <div class="card-header d-flex justify-content-between align-items-center">
            <h5 class="mb-0 fw-bold">الوضعية الحالية:</h5>
            <?php if($debutActivite->id_statut == 1): ?>
                <span class="status-badge status-badge--success">مقبول</span>
            <?php elseif($debutActivite->id_statut == 3): ?>
                <span class="status-badge status-badge--danger">مرفوض</span>
            <?php else: ?>
                <span class="status-badge status-badge--pending">في الانتظار</span>
            <?php endif; ?>
        </div>

        <?php if($debutActivite->id_statut == 3 && $debutActivite->commentaire_motif): ?>
            <div class="card-body">
                <p class="text-danger fw-bold">سبب الرفض:</p>
                <p><?php echo e($debutActivite->commentaire_motif); ?></p>
            </div>
        <?php endif; ?>
    </div>

<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-light py-2"><h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h5></div>

  <div class="card-body p-2" dir="rtl">
    <?php if($debutActivite->statutHistories->isEmpty()): ?>
      <p class="text-muted mb-0">لا توجد تغييرات سابقة.</p>
    <?php else: ?>
      <div class="compact-timeline">
        <?php $__currentLoopData = $debutActivite->statutHistories; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $hist): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
          <?php
            $from = optional($hist->fromStatut)->statut_ar ?? optional($hist->fromStatut)->libelle_ar ?? '—';
            $to = optional($hist->toStatut)->statut_ar ?? optional($hist->toStatut)->libelle_ar ?? '—';
            $toId = optional($hist->toStatut)->id_statut;
            $badgeClass = $toId === 1 ? 'badge-success' : ($toId === 3 ? 'badge-danger' : 'badge-muted');
            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
          ?>

          <div class="compact-item">
            <div class="compact-row d-flex align-items-center justify-content-between w-100">
              <div class="left-block text-end">
                <div class="small text-muted compact-date"><?php echo e($hist->created_at->format('d/m/Y H:i')); ?></div>
                <div class="very-small text-muted compact-user">بواسطة: <?php echo e($changer); ?></div>
              </div>

              <div class="right-block text-right flex-fill">
                <span class="compact-from small text-muted"><?php echo e($from); ?></span>
                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                <span class="compact-to small <?php echo e($badgeClass); ?>"><?php echo e($to); ?></span>
              </div>
            </div>

            <?php if($hist->commentaire): ?>
              <details class="compact-comment mt-1">
                <summary class="very-small text-danger">سبب / تعليق</summary>
                <div class="very-small text-muted mt-1"><?php echo e($hist->commentaire); ?></div>
              </details>
            <?php endif; ?>
          </div>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
      </div>
    <?php endif; ?>
  </div>
</div>

<style>
/* compact styles (same as earlier) */
.compact-timeline { display:flex; flex-direction:column; gap:6px; }
.compact-item { padding:6px 4px; border-bottom:1px solid rgba(0,0,0,0.06); }
.left-block { width:160px; min-width:120px; margin-left:12px; }
.compact-date { font-size:12px; color:#6c757d; }
.compact-user { font-size:11px; color:#8a8f94; margin-top:2px; }
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color:#6c757d; font-size:13px; }
.compact-arrow { color:#6c757d; font-size:14px; margin:0 4px; }
.compact-to { font-size:13px; padding:3px 8px; border-radius:10px; }
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }
.compact-comment summary { list-style:none; cursor:pointer; outline:none; padding:0; }
</style>
    <h4 class="mb-3 fw-bold">هوية الباعث</h4>
    <div class="row mb-3">
        <div class="col-md-6">
            <label class="fw-bold">الاسم و اللقب أو الاسم التجاري</label>
            <input type="text" class="form-control" value="<?php echo e($debutActivite->immobilier->utilisateur->nom_prenom ?? '-'); ?>" readonly>
        </div>
        <div class="col-md-6">
            <label class="fw-bold">رقم الهوية</label>
            <input type="text" class="form-control" value="<?php echo e($debutActivite->immobilier->utilisateur->cin ?? $debutActivite->immobilier->utilisateur->passport ?? $debutActivite->immobilier->utilisateur->num_fiscal ?? '-'); ?>" readonly>
        </div>
    </div>

    <div class="row mb-3">
        <div class="col-md-6">
            <label class="fw-bold">الهاتف</label>
            <input type="text" class="form-control" value="<?php echo e($debutActivite->immobilier->utilisateur->tel ?? '-'); ?>" readonly>
        </div>
        <div class="col-md-6">
            <label class="fw-bold">البريد الإلكتروني</label>
            <input type="text" class="form-control" value="<?php echo e($debutActivite->immobilier->utilisateur->email ?? '-'); ?>" readonly>
        </div>
    </div>

    <h4>تاريخ بداية النشاط</h4>
            <div class="form-group row">
                <div class="col-sm-11">
                    <input required type="date" class="form-control" id="date_debut_activite" name="date_debut_activite" value="<?php echo e($debutActivite->date_debut_activite ? $debutActivite->date_debut_activite->format('Y-m-d') : ''); ?>" readonly>
                </div>
            </div>
            <span>تاريخ بداية النشاط يجب ان يكون بعد 15 يوما من تاريخ استلام وصل التسجيل.</span>


    <h4 class="mb-3 fw-bold">الوثائق المرفقة</h4>
    <?php
        $docs = [
            'preuve_propriete_location' => 'نسخة من شهادة الملكية أو عقد الكراء ...',
            'plan_architectural' => 'مخطط معماري ...',
            'declaration_investissement' => 'شهادة تصريح بالاستثمار ...',
            'identification' => 'بطاقة تعريف / جواز ...',
            'extrait_registre_national_entreprise' => 'السجل الوطني للمؤسسات ...',
            'certificat_prevention' => 'شهادة الوقاية ...',
            'contrat_assurance' => 'عقد التأمين ...',
            'approbation_autorite_minicipale' => 'اعتماد السلطة المحلية ...'
        ];
    ?>

    <?php $__currentLoopData = $docs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
        <div class="mb-2">
            <strong><?php echo e($label); ?>: </strong>
            <?php if($debutActivite->$field): ?>
                <!--a href="<?php echo e(asset('storage/'.$debutActivite->$field)); ?>" target="_blank">عرض الملف</a-->
				<a href="<?php echo e(route('debutActivite.download', ['id' => $debutActivite->id_debut, 'field' => $field])); ?>" target="_blank">عرض الملف</a>
            <?php else: ?>
                <span>-</span>
            <?php endif; ?>
        </div>
    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>

   
	<div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
              <a href="<?php echo e(route('admin.debut_activite.pdf', $debutActivite->id_debut)); ?>" target="_blank" class="btn btn-danger d-flex align-items-center justify-content-center gap-1 flex-fill">
				<i class="fa fa-file-pdf"></i> تحميل PDF
			</a>
                <a href="<?php echo e(route('admin.debut_activite.index')); ?>"  class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">


</div>

<?php $__env->stopSection(); ?>
<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/investissement/gestion_salle_sport/debut_activite/show.blade.php ENDPATH**/ ?>