

<?php $__env->startSection('content'); ?>

<?php if($errors->any()): ?>
    <ul class="alert alert-warning">
        <?php $__currentLoopData = $errors->all(); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $error): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <li><?php echo e($error); ?></li>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
    </ul>
<?php endif; ?>

<?php if(Auth::check()): ?>

<div class="container">
    <section class="add-listing-area section-padding">
        <div class="container">
            <div class="row">
                <div class="col-lg-10 mx-auto">
                    <form method="POST" action="<?php echo e(route('guides.store')); ?>">
                        <?php echo csrf_field(); ?>

                        <div class="block-card mb-4">
                            <div class="block-card-header">
                                <h2 class="widget-title">إضافة دليل  </h2>
                                <div class="stroke-shape"></div>
                            </div>

                            <div class="block-card-body">

                                <div class="form-group">
                                    <label>العنوان بالعربية<span class="text-danger">*</span></label>
                                    <input type="text" name="titre_G" class="form-control" value="<?php echo e(old('titre_G')); ?>" required>
                                </div>

                                <div class="form-group">
                                    <label>العنوان بالفرنسية<span class="text-danger">*</span></label>
                                    <input type="text" name="titre_fr" class="form-control" value="<?php echo e(old('titre_fr')); ?>" required>
                                </div>

                                <div class="form-group">
                                    <label>العنوان بالانقليزية<span class="text-danger">*</span></label>
                                    <input type="text" name="titre_en" class="form-control" value="<?php echo e(old('titre_en')); ?>" required>
                                </div>

                                <div class="form-group">
                                    <label>نوع الدليل <span class="text-danger">*</span></label>
                                    <select id="type" name="type" class="form-control" required>
                                        <option value="" disabled selected>اختر...</option>
                                        <option value="menu_principal" <?php echo e(old('type') == 'menu_principal' ? 'selected' : ''); ?>>قائمة رئيسية</option>
                                        <option value="sous_menu" <?php echo e(old('type') == 'sous_menu' ? 'selected' : ''); ?>>قائمة فرعية</option>
                                    </select>
                                </div>

                                <div id="menuPrincipalSection" style="display: none;">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>الترتيب <span class="text-danger">*</span></label>
                                                <input type="number" name="ordre" class="form-control" value="<?php echo e(old('ordre')); ?>">
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>نوع المحتوى <span class="text-danger">*</span></label>
                                                <select id="type_contenu_menu" name="type_contenu_menu" class="form-control">
                                                    <option value="" disabled selected>اختر...</option>
                                                    <option value="none" <?php echo e(old('type_contenu', '') == 'none' ? 'selected' : ''); ?>>بدون محتوى (قائمة رئيسية)</option>
                                                    <option value="lien" <?php echo e(old('type_contenu', '') == 'lien' ? 'selected' : ''); ?>>رابط خارجي</option>
                                                    <option value="builder" <?php echo e(old('type_contenu', '') == 'builder' ? 'selected' : ''); ?>>صفحة داخلية (منشئ الصفحات)</option>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div id="builderSection_menu" class="form-group mt-3" style="display: none;">
                                        <label>اختيار الصفحة الداخلية (Builder)</label>
                                        <select name="builder_id_menu" class="form-control">
                                            <option value="" selected disabled>اختر صفحة...</option>
                                            
                                        </select>
                                    </div>
                                    <div id="lienSection_menu" class="form-group mt-3" style="display: none;">
                                        <label>أدخل الرابط (رابط خارجي)</label>
                                        <input type="url" name="lien" class="form-control" placeholder="https://exemple.com" value="<?php echo e(old('lien')); ?>">
                                    </div>
                                </div>

                                <div id="sousMenuSection" style="display: none;">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>الترتيب <span class="text-danger">*</span></label>
                                                <input type="number" name="ordre_sous" class="form-control" value="<?php echo e(old('ordre')); ?>">
                                            </div>
                                        </div>

                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>الدليل الأب (اختياري)</label>
                                                <select name="id_parent" class="form-control">
                                                    <option value="" selected disabled>اختر الدليل الأب...</option>
                                                    <?php $__currentLoopData = $parentGuides; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $guide): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                                        <option value="<?php echo e($guide['id_G']); ?>" <?php echo e(old('id_parent') == $guide['id_G'] ? 'selected' : ''); ?>>
                                                            <?php echo e($guide['titre_G']); ?>

                                                        </option>
                                                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                                                </select>
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row mt-2 align-items-end">
                                        <div class="col-md-6">
                                            <div class="form-group">
                                                <label>نوع المحتوى <span class="text-danger">*</span></label>
                                                <select id="type_contenu_sous" name="type_contenu_sous" class="form-control">
                                                    <option value="" disabled selected>اختر...</option>
                                                    <option value="none" <?php echo e(old('type_contenu', '') == 'none' ? 'selected' : ''); ?>>بدون محتوى</option>
                                                    <option value="lien" <?php echo e(old('type_contenu', '') == 'lien' ? 'selected' : ''); ?>>رابط خارجي</option>
                                                    <option value="builder" <?php echo e(old('type_contenu', '') == 'builder' ? 'selected' : ''); ?>>صفحة داخلية (منشئ الصفحات)</option>
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-6" id="builderSection_sous" style="display: none;">
                                            <div class="form-group">
                                                <label>اختيار الصفحة الداخلية (Builder)</label>
                                                <select name="builder_id_sous" class="form-control">
                                                    <option value="" selected disabled>اختر صفحة...</option>
                                                    
                                                </select>
                                            </div>
                                        </div>

                                        <div class="col-md-6" id="lienSection_sous" style="display: none;">
                                            <div class="form-group">
                                                <label>أدخل الرابط (رابط خارجي)</label>
                                                <input type="url" name="lien" class="form-control" placeholder="https://exemple.com" value="<?php echo e(old('lien')); ?>">
                                            </div>
                                        </div>
                                    </div>
                                </div>

                        <div class="block-card-footer mt-3 mb-3 text-center">
                                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium">
                                    <i class="la la-save mr-1"></i> حفظ
                                </button>
                                <a href="<?php echo e(route('guides.index')); ?>" class="btn bg-rgb-primary1 font-weight-medium">
                                    <i class="la la-times mr-1"></i> إلغاء
                                </a>

                            </div>

                    </form>
                </div>
            </div>
        </div>
    </section>
</div>

<!--script>
    document.addEventListener('DOMContentLoaded', function() {
        const selectType = document.getElementById('type_contenu');
        const builderSection = document.getElementById('builderSection');

        function toggleBuilderSection() {
            if (selectType.value === 'builder') {
                builderSection.style.display = 'block';
            } else {
                builderSection.style.display = 'none';
            }
        }
        selectType.addEventListener('change', toggleBuilderSection);
        toggleBuilderSection();
    });
</!--script-->

<script>
    document.addEventListener('DOMContentLoaded', function() {
        const selectType = document.getElementById('type');

        // menu principal
        const menuPrincipalSection = document.getElementById('menuPrincipalSection');
        const typeContenuMenu = document.getElementById('type_contenu_menu');
        const builderMenu = document.getElementById('builderSection_menu');
        const lienMenu = document.getElementById('lienSection_menu');

        // sous menu
        const sousMenuSection = document.getElementById('sousMenuSection');
        const typeContenuSous = document.getElementById('type_contenu_sous');
        const builderSous = document.getElementById('builderSection_sous');
        const lienSous = document.getElementById('lienSection_sous');

        function toggleMainVsSub() {
            const type = selectType ? selectType.value : '';
            menuPrincipalSection.style.display = (type === 'menu_principal') ? 'block' : 'none';
            sousMenuSection.style.display = (type === 'sous_menu') ? 'block' : 'none';
        }

        function toggleBuilderMenu() {
            if (typeContenuMenu) {
                builderMenu.style.display = (typeContenuMenu.value === 'builder') ? 'block' : 'none';
                lienMenu.style.display = (typeContenuMenu.value === 'lien') ? 'block' : 'none';
            }
        }

        function toggleBuilderSous() {
            if (typeContenuSous) {
                builderSous.style.display = (typeContenuSous.value === 'builder') ? 'block' : 'none';
                lienSous.style.display = (typeContenuSous.value === 'lien') ? 'block' : 'none';
            }
        }

        if (selectType) selectType.addEventListener('change', toggleMainVsSub);
        if (typeContenuMenu) typeContenuMenu.addEventListener('change', toggleBuilderMenu);
        if (typeContenuSous) typeContenuSous.addEventListener('change', toggleBuilderSous);

        // initialisation au chargement
        toggleMainVsSub();
        toggleBuilderMenu();
        toggleBuilderSous();
    });
</script>



<?php else: ?>
<script>
    window.location.href = "<?php echo e(route('admin')); ?>";
</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/back/resources/views/backoffice/gestion_guide/create.blade.php ENDPATH**/ ?>