<?php $__env->startSection('content'); ?>
<div class="container my-5">
<?php if(session('success')): ?>
    <div class="alert alert-success alert-dismissible fade show d-flex align-items-center justify-content-between shadow-sm rounded-3 py-2 px-3 mb-4" role="alert">
        <div class="d-flex align-items-center gap-2">
            <i class="bi bi-check-circle-fill fs-5"></i> <!-- icône bootstrap -->
            <span><?php echo e(session('success')); ?></span>
        </div>
        <button type="button" class="btn-close" data-bs-dismiss="alert" aria-label="Close"></button>
    </div>

    <script>
        // disparition automatique après 4 secondes
        setTimeout(() => {
            const alertNode = document.querySelector('.alert');
            if(alertNode){
                const bsAlert = new bootstrap.Alert(alertNode);
                bsAlert.close();
            }
        }, 4000);
    </script>
<?php endif; ?>

    <div class="card shadow border-0 rounded-4 overflow-hidden">
        <div class="row g-0" dir="rtl">

            <!-- IMAGE (LEFT) -->
            <div class="col-md-6 position-relative min-h-400"> <!-- image plus large -->
                <img src="data:image/*;base64,<?php echo e(base64_encode($auberge->image)); ?>"
                     class="img-fluid h-100 w-100 object-fit-cover"
                     alt="<?php echo e($auberge->nom_ar); ?>">
                <div class="position-absolute top-0 start-0 w-100 h-100 gradient-overlay"></div>
            </div>

            <!-- INFO (RIGHT) -->
            <div class="col-md-6 p-3 d-flex flex-column justify-content-between">
                <div>
                    <div class="d-flex justify-content-between align-items-start mb-3">
                        <h2 class="fw-bold text-primary"><?php echo e($auberge->nom_ar); ?></h2>
                        <a href="<?php echo e(route('auberges2.edit', $auberge->id)); ?>" 
                           class="btn btn-sm shadow-sm edit-btn">
                            تعديل
                        </a>
                    </div>

                    <ul class="list-group list-group-flush">
                        <li class="list-group-item d-flex align-items-center gap-2 border-0 px-0 py-1">
                            <span class="fw-semibold text-muted">العنوان :</span>
                            <span><?php echo e($auberge->adresse); ?></span>
                        </li>

                        <li class="list-group-item d-flex align-items-center gap-2 border-0 px-0 py-1">
                            <span class="fw-semibold text-muted">الهاتف :</span>
                            <span dir="rtl"><?php echo e($auberge->contact_tel); ?></span>
                        </li>

                        <li class="list-group-item d-flex align-items-center gap-2 border-0 px-0 py-1">
                            <span class="fw-semibold text-muted">البريد الإلكتروني :</span>
                            <span><?php echo e($auberge->contact_email); ?></span>
                        </li>

                        <li class="list-group-item d-flex align-items-center gap-2 border-0 px-0 py-1">
                            <span class="fw-semibold text-muted">الولاية :</span>
                            <span><?php echo e($auberge->gouvernorat->nom_ar ?? '-'); ?></span>
                        </li>

                        <li class="list-group-item d-flex align-items-center gap-2 border-0 px-0 py-1">
                            <span class="fw-semibold text-muted">المعتمدية :</span>
                            <span><?php echo e($auberge->delegation->nom_ar ?? '-'); ?></span>
                        </li>
                    </ul>
                </div>
            </div>

        </div>
    </div>

</div>

<style>
/* hauteur minimale de l’image */
.min-h-400 {
    min-height: 400px;
}

/* image avec effet hover */
.object-fit-cover {
    object-fit: cover;
    height: 100%;
    border-radius: 0.5rem 0 0 0.5rem;
    transition: transform 0.3s ease;
}
.object-fit-cover:hover {
    transform: scale(1.05);
}

/* overlay gradient plus doux */
.gradient-overlay {
    background: linear-gradient(to left, rgba(0,0,0,0.15), rgba(0,0,0,0));
}

/* liste info auberge */
.list-group-item span {
    font-size: 0.95rem;
    text-align: right;
    display: inline-block;
}
.list-group-item {
    padding: 0.4rem 0.75rem;
}

/* carte avec hover léger */
.card {
    transition: transform 0.2s ease, box-shadow 0.2s ease;
}
.card:hover {
    transform: translateY(-3px);
    box-shadow: 0 10px 20px rgba(0,0,0,0.1);
}

/* bouton "تعديل" personnalisé */
.edit-btn {
    background-color: #fff8e1;
    color: #d9a92c;
    font-weight: 500;
    padding: 0.25rem 0.6rem;
    border-radius: 0.25rem;
    border: none;
}
.edit-btn:hover {
    background-color: #fff3cd;
    color: #b78823;
}
</style>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/auberges/creation_centre/show2.blade.php ENDPATH**/ ?>