<!DOCTYPE html>
<html lang="ar" dir="rtl" data-theme="light">
<head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="author" content="TechyDevs">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    
    <!-- Cache Optimization -->
    <meta http-equiv="Cache-Control" content="public, max-age=31536000">
    <meta http-equiv="Expires" content="31536000">
    <title>وزارة الشباب و الرياضة</title>
     <link rel="shortcut icon" type="image/x-icon" href="https://mjsadmin.preprod.tn/assets/img/logo/logo.png">
    <link href="https://fonts.googleapis.com/css2?family=Be+Vietnam:wght@100;300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/bootstrap-rtl.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/line-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/owl.theme.default.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/animated-headline_.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/datedropper.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/jquery-ui.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/jquery.fancybox.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/chosen.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/style-rtl.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/css.css')); ?>">
    <link href="https://cdn.jsdelivr.net/npm/remixicon@3.5.0/fonts/remixicon.css" rel="stylesheet">
    <style>
        /* ========== PRELOADER & FADE-IN TRANSITIONS ========== */
        /* Preloader overlay */
        #page-preloader {
            position: fixed;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: var(--bg-color, #f8f9fa);
            display: flex;
            flex-direction: column;
            justify-content: center;
            align-items: center;
            z-index: 99999;
            transition: opacity 0.5s ease, visibility 0.5s ease;
        }

        #page-preloader.fade-out {
            opacity: 0;
            visibility: hidden;
        }

        .preloader-logo {
            width: 120px;
            height: auto;
            margin-bottom: 30px;
            animation: pulse 2s ease-in-out infinite;
        }

        .preloader-spinner {
            width: 50px;
            height: 50px;
            border: 4px solid rgba(228, 33, 37, 0.1);
            border-top-color: #e42125;
            border-radius: 50%;
            animation: spin 1s linear infinite;
        }

        .preloader-text {
            margin-top: 20px;
            color: var(--text-color, #333);
            font-size: 14px;
            font-family: 'Cairo', sans-serif;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        @keyframes pulse {
            0%, 100% { opacity: 1; transform: scale(1); }
            50% { opacity: 0.8; transform: scale(0.95); }
        }

        /* Fade-in pour le contenu principal */
        .dashboard-container {
            opacity: 0;
            transition: opacity 0.6s ease-in;
        }

        .dashboard-container.fade-in {
            opacity: 1;
        }

        /* Dark mode pour le preloader */
        [data-theme='dark'] #page-preloader {
            background: #1a1a1a;
        }
	
        :root {
            --primary-color: #e42125;
			--primary-red: #e42125;
            --primary-color-light: rgba(228, 33, 37, 0.1);
            --text-color: #333;
            --bg-color: #f8f9fa;
            --sidebar-bg: rgba(255, 255, 255, 0.95);
            --card-bg: rgba(255, 255, 255, 0.9);
            --border-color: rgba(0, 0, 0, 0.1);
            --shadow-color: rgba(0, 0, 0, 0.1);
        }

        [data-theme='dark'] {
            --text-color: #e1e1e1;
            --bg-color: #1a1a1a;
            --sidebar-bg: rgba(30, 30, 30, 0.95);
            --card-bg: rgba(40, 40, 40, 0.9);
            --border-color: rgba(255, 255, 255, 0.1);
            --shadow-color: rgba(0, 0, 0, 0.3);
        }

        body {
            position: relative;
            min-height: 100vh;
            background-color: var(--bg-color);
            overflow-x: hidden;
            color: var(--text-color);
            transition: background-color 0.3s ease, color 0.3s ease;
        }

        .dashboard-container {
            display: flex;
            min-height: 100vh;
            position: relative;
        }

        .dashboard-sidebar {
            width: 280px;
            flex-shrink: 0;
            position: fixed;
            top: 0;
            right: 0;
            height: 100vh;
            overflow-y: auto;
            z-index: 1000;
            background: var(--sidebar-bg);
            backdrop-filter: blur(10px);
            box-shadow: 0 0 15px var(--shadow-color);
            transition: transform 0.3s ease, background 0.3s ease;
        }
	header.dashboard-header.expanded {
    
    right: 15px !important;
}
        .dashboard-sidebar::-webkit-scrollbar {
            width: 5px;
        }

        .dashboard-sidebar::-webkit-scrollbar-thumb {
            background: var(--primary-color);
            border-radius: 10px;
        }

        .dashboard-main {
            flex-grow: 1;
            margin-right: 280px;
            width: calc(100% - 280px);
            transition: margin-right 0.3s ease;
        }

        .dashboard-sidebar.collapsed {
            transform: translateX(280px);
        }

        .dashboard-main.expanded {
            margin-right: 0;
            width: 100%;
        }

        body::before {
            content: '';
            position: fixed;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            background-image: url('<?php echo e(asset('assets/img/shape/project-1-1.png')); ?>');
            background-size: contain;
            background-repeat: no-repeat;
            background-position: center right;
            opacity: 0.05;
            z-index: -1;
            pointer-events: none;
        }

              .nav-link {
            transition: all 0.3s ease;
            border-radius: 8px;
            margin: 5px 0;
            padding: 0.75rem 1rem;
            color: var(--text-color);
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .nav-link i {
            font-size: 1.2rem;
            min-width: 24px;
            text-align: center;
        }

        .dropdown-menu {
            border: none;
            border-radius: 10px;
            box-shadow: 0 2px 15px var(--shadow-color);
            padding: 0.5rem;
            margin-top: 0;
            background: var(--sidebar-bg);
            border: 1px solid var(--border-color);
            animation: fadeIn 0.2s ease;
        }

        .dropdown-item {
            padding: 0.75rem 1rem;
            border-radius: 6px;
            transition: all 0.2s ease;
            color: var(--text-color);
            display: flex;
            align-items: center;
            gap: 10px;
        }

        .dropdown-item:hover, .dropdown-item:focus, .dropdown-item.active {
            background: var(--primary-color-light);
            color: var(--primary-color);
            transform: translateX(-5px);
        }

        .dropdown-toggle::after {
            margin-right: 0.5rem;
            transition: transform 0.2s ease;
        }

        .show .dropdown-toggle::after {
            transform: rotate(180deg);
        }

        .nav-link:hover {
            background: var(--primary-color-light);
            color: var(--primary-color);
            transform: translateX(-5px);
        }

        .navbar {
            border-radius: 15px;
            margin: 15px;
            background: var(--card-bg);
            box-shadow: 0 0 15px var(--shadow-color);
            transition: background 0.3s ease, box-shadow 0.3s ease;
        }

        .theme-switch {
            position: fixed;
            bottom: 20px;
            left: 20px;
            background: var(--card-bg);
            border-radius: 50%;
            width: 40px;
            height: 40px;
            display: flex;
            align-items: center;
            justify-content: center;
            cursor: pointer;
            box-shadow: 0 2px 10px var(--shadow-color);
            transition: all 0.3s ease;
            z-index: 1000;
        }

        .theme-switch:hover {
            transform: scale(1.1);
        }

        @keyframes fadeIn {
            from { opacity: 0; transform: translateY(10px); }
            to { opacity: 1; transform: translateY(0); }
        }

        .loader-container {
            background: var(--bg-color);
            transition: background 0.3s ease;
        }

        .sidebar-brand img {
            transition: filter 0.3s ease;
        }

        [data-theme='dark'] .sidebar-brand img {
            filter: brightness(2);
        }

        /* ========== ANIMATIONS ========== */
        @keyframes slideInFromRight {
            from {
                transform: translateX(100%);
                opacity: 0.8;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
        
        @keyframes fadeIn {
            from { opacity: 0; }
            to { opacity: 1; }
        }

        /* ========== RESPONSIVE MOBILE ========== */
        @media (max-width: 991px) {
            /* Sidebar cachée par défaut sur mobile */
            .dashboard-sidebar {
                transform: translateX(100%);
                z-index: 9999;
                width: 320px !important;
                box-shadow: -5px 0 25px rgba(0, 0, 0, 0.3);
                transition: transform 0.3s cubic-bezier(0.4, 0, 0.2, 1);
            }

            .dashboard-sidebar.mobile-open {
                transform: translateX(0);
                animation: slideInFromRight 0.3s ease-out;
            }

            /* Main content pleine largeur */
            .dashboard-main {
                margin-right: 0 !important;
                width: 100% !important;
            }

            /* Header responsive */
            .dashboard-header {
                right: 0 !important;
                left: 0 !important;
                width: 100% !important;
                margin: 0 !important;
                border-radius: 0 !important;
                padding: 10px 15px !important;
            }

            /* Cacher la recherche sur mobile */
            .header-search {
                display: none !important;
            }

            /* User info compact */
            .user-details {
                display: none;
            }

            .user-avatar {
                width: 35px !important;
                height: 35px !important;
            }

            /* Boutons header plus petits */
            .header-icon-btn {
                width: 38px !important;
                height: 38px !important;
                font-size: 1.1rem !important;
            }
            
            /* Bouton burger plus visible et attractif sur mobile */
            #sidebar-toggle {
                background: linear-gradient(135deg, var(--primary-color), #c51b1f) !important;
                color: white !important;
                box-shadow: 0 2px 8px rgba(228, 33, 37, 0.3);
                position: relative;
                overflow: hidden;
            }
            
            #sidebar-toggle::before {
                content: '';
                position: absolute;
                top: 50%;
                left: 50%;
                width: 0;
                height: 0;
                border-radius: 50%;
                background: rgba(255, 255, 255, 0.3);
                transform: translate(-50%, -50%);
                transition: width 0.3s, height 0.3s;
            }
            
            #sidebar-toggle:active::before {
                width: 100px;
                height: 100px;
            }
            
            #sidebar-toggle:hover {
                background: linear-gradient(135deg, #c51b1f, #a01619) !important;
                transform: scale(1.05);
                box-shadow: 0 4px 12px rgba(228, 33, 37, 0.4);
            }
            
            /* Animation de pulsation pour attirer l'attention */
            @keyframes pulse {
                0%, 100% { transform: scale(1); }
                50% { transform: scale(1.05); }
            }

            /* Dashboard content */
            .dashboard-content {
                padding: 10px !important;
            }

            .container-fluid {
                padding: 10px !important;
            }

            /* Cards */
            .card {
                margin-bottom: 15px !important;
            }

            .card-body {
                padding: 15px !important;
            }

            /* Sidebar brand */
            .sidebar-brand {
                padding: 15px !important;
            }

            .ministry-logo {
                width: 45px !important;
                height: 45px !important;
            }

            .ministry-title {
                font-size: 13px !important;
            }

            .ministry-subtitle {
                font-size: 11px !important;
            }

            /* Nav links */
            .nav-link {
                padding: 10px 15px !important;
                font-size: 0.95rem !important;
            }

            /* Bouton de fermeture du sidebar sur mobile */
            #sidebar-close {
                display: flex !important;
                align-items: center;
                justify-content: center;
                width: 40px;
                height: 40px;
                border-radius: 50%;
                background: rgba(228, 33, 37, 0.1);
                color: var(--primary-color);
                cursor: pointer;
                transition: all 0.3s ease;
                margin: 10px;
            }
            
            #sidebar-close:hover {
                background: var(--primary-color);
                color: white;
                transform: rotate(90deg);
            }
            
            #sidebar-close i {
                font-size: 1.5rem;
            }

            /* Overlay pour fermer le menu */
            body.menu-open::before {
                content: '';
                position: fixed;
                top: 0;
                left: 0;
                right: 0;
                bottom: 0;
                background: rgba(0, 0, 0, 0.6);
                z-index: 9998;
                animation: fadeIn 0.3s ease;
                backdrop-filter: blur(2px);
            }

            body.menu-open {
                overflow: hidden;
            }
        }

        @media (max-width: 575px) {
            .dashboard-sidebar {
                width: 90% !important;
                max-width: 300px !important;
            }
            
            .dashboard-header {
                padding: 0.5rem 0.75rem !important;
            }
            
            .header-icon-btn {
                width: 36px !important;
                height: 36px !important;
                font-size: 1rem !important;
            }

            .card-body {
                padding: 10px !important;
            }
            
            .nav-link {
                padding: 8px 12px !important;
                font-size: 0.9rem !important;
            }
            
            .ministry-title {
                font-size: 12px !important;
            }
            
            .ministry-subtitle {
                font-size: 10px !important;
            }

            h1, .h1 { font-size: 1.5rem !important; }
            h2, .h2 { font-size: 1.3rem !important; }
            h3, .h3 { font-size: 1.1rem !important; }
        }
        
        /* Amélioration pour tablettes */
        @media (min-width: 768px) and (max-width: 991px) {
            .dashboard-sidebar {
                width: 280px !important;
            }
            
            .dashboard-header {
                padding: 0.75rem 1.25rem !important;
            }
        }
    </style>
</head>
<body>
    <div class="loader-container">
        <div class="loader-ripple">
            <div></div>
            <div></div>
        </div>
    </div>
    <div class="dashboard-wrapper">
        <style>
            @import url('https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600&display=swap');

            .dashboard-header {
                font-family: 'Cairo', sans-serif;
                background: white;
                padding: 0.75rem 1.5rem;
                box-shadow: 0 4px 15px rgba(0, 0, 0, 0.05);
                display: flex;
                align-items: center;
                justify-content: space-between;
                position: fixed;
                top: 15px;
                right: 295px;
			
                left: 15px;
                z-index: 1100;
                border-radius: 15px;
                border-bottom: 2px solid #e42125;
            }

            .header-left, .header-right {
                display: flex;
                align-items: center;
                gap: 1rem;
            }

            .header-icon-btn {
                width: 40px;
                height: 40px;
                border-radius: 10px;
                display: flex;
                align-items: center;
                justify-content: center;
                border: none;
                background: rgba(26, 35, 126, 0.1) !important;
                color: #1a237e;
                cursor: pointer;
                transition: all 0.3s ease;
                position: relative;
            }

            .header-icon-btn:hover,
            .header-icon-btn.notification-badge:hover {
                background: #1a237e !important;
                color: white !important;
                transform: translateY(-2px);
                box-shadow: 0 4px 15px rgba(26, 35, 126, 0.3);
            }

            .header-icon-btn i {
                font-size: 1.25rem;
            }

            .search-box {
                position: relative;
            }

            .search-input {
                width: 250px;
                padding: 0.75rem 1rem 0.75rem 2.5rem;
                border: 1px solid #eee;
                border-radius: 10px;
                font-size: 1rem;
                transition: all 0.3s ease;
                background: white;
                color: var(--navy-blue);
            }

            .search-input::placeholder {
                color: #666;
            }

            .search-input:focus {
                width: 300px;
                border-color: var(--navy-blue);
                outline: none;
                box-shadow: 0 0 0 2px var(--light-navy);
            }

            .search-icon {
                position: absolute;
                left: 0.75rem;
                top: 50%;
                transform: translateY(-50%);
                color: var(--navy-blue);
            }

            .user-info {
                display: flex;
                align-items: center;
                gap: 1rem;
                padding: 0.5rem 1rem;
                border-radius: 10px;
                cursor: pointer;
                transition: all 0.3s ease;
                background: rgba(255, 255, 255, 0.15);
                backdrop-filter: blur(5px);
                border: 1px solid rgba(255, 255, 255, 0.3);
            }

            .user-info:hover {
                background: #1a237e;
                transform: translateY(-2px);
                box-shadow: 0 4px 15px rgba(26, 35, 126, 0.3);
            }

            .user-avatar {
                width: 40px;
                height: 40px;
                border-radius: 10px;
                background: #1a237e;
                color: white;
                display: flex;
                align-items: center;
                justify-content: center;
                font-size: 1.2rem;
                border: 2px solid rgba(255, 255, 255, 0.3);
                box-shadow: 0 4px 15px rgba(26, 35, 126, 0.3);
            }

            .user-details {
                text-align: right;
            }
.user-info:hover .user-name {
    color: #ffffff;
}
            .user-name {
                font-weight: 600;
                color: var(--navy-blue);
                font-size: 1rem;
            }
			   .user-name:hover {
               
                color: #ffffff;
             
            }

            .user-role {
                color: #666;
                font-size: 0.9rem;
            }

            .notification-badge {
                position: relative;
            }

            .badge {
                position: absolute;
                top: -5px;
                right: -5px;
                background: var(--primary-red);
                color: white;
                width: 18px;
                height: 18px;
                border-radius: 50%;
                font-size: 0.75rem;
                display: flex;
                align-items: center;
                justify-content: center;
                border: 2px solid white;
                box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            }

            .dashboard-main {
                padding-top: 90px;
            }

            .header-left {
                display: flex;
                align-items: center;
                gap: 1rem;
            }

            .header-right {
                display: flex;
                align-items: center;
                gap: 1.5rem;
            }

            .header-icon-btn {
                width: 40px;
            }

            .dashboard-inner-body-container {
                background: #ffffff;
                backdrop-filter: blur(10px);
                border-radius: 15px;
                box-shadow: 0 0 20px var(--shadow-color);
                padding: 7px;
                margin: 5px 1px;
                transition: background 0.3s ease, box-shadow 0.3s ease;
            }

            .nav-link {
                transition: all 0.3s ease;
                border-radius: 8px;
                margin: 5px 0;
                padding: 0.75rem 1rem;
                color: var(--text-color);
                display: flex;
                align-items: center;
                gap: 10px;
            }

            .nav-link i {
                font-size: 1.2rem;
                min-width: 24px;
                text-align: center;
            }

            .dropdown-menu {
                border: none;
                border-radius: 10px;
                box-shadow: 0 2px 15px var(--shadow-color);
                padding: 0.5rem;
                margin-top: 0;
                background: var(--sidebar-bg);
                border: 1px solid var(--border-color);
                animation: fadeIn 0.2s ease;
            }

            .dropdown-item {
                padding: 0.75rem 1rem;
                border-radius: 6px;
                transition: all 0.2s ease;
                color: var(--text-color);
                display: flex;
                align-items: center;
                gap: 10px;
            .user-name {
                font-weight: 600;
                color: #333;
                font-size: 1rem;
            }

            .user-role {
                color: #666;
                font-size: 0.9rem;
            }

            .notification-badge {
                position: relative;
            }

            .badge {
                position: absolute;
                top: -5px;
                right: -5px;
                background: var(--primary-red);
                color: white;
                width: 18px;
                height: 18px;
                border-radius: 50%;
                font-size: 0.75rem;
                display: flex;
                align-items: center;
                justify-content: center;
                border: 2px solid white;
                box-shadow: 0 2px 5px rgba(0,0,0,0.1);
            }

            [data-theme='dark'] .dashboard-header {
                background: #1a1a1a;
                border-color: var(--navy-blue);
            }

            [data-theme='dark'] .search-input {
                background: #2a2a2a;
                border-color: #333;
                color: white;
            }

            [data-theme='dark'] .search-input::placeholder {
                color: #888;
            }

            [data-theme='dark'] .user-name {
                color: white;
            }

            [data-theme='dark'] .user-role {
                color: #888;
            }

            [data-theme='dark'] .header-icon-btn {
                background: rgba(255, 255, 255, 0.05);
                color: white;
            }

            [data-theme='dark'] .header-icon-btn:hover,
            [data-theme='dark'] .header-icon-btn.notification-badge:hover {
                background: var(--navy-blue) !important;
                color: white !important;
                box-shadow: 0 4px 15px rgba(26, 35, 126, 0.3);
            }

            [data-theme='dark'] .search-input {
                background: #2a2a2a;
                border-color: #333;
                color: #fff;
            }

            [data-theme='dark'] .search-input::placeholder {
                color: #888;
            }

            [data-theme='dark'] .user-info {
                background: #2a2a2a;
            }

            [data-theme='dark'] .user-name {
                color: #fff;
            }

            [data-theme='dark'] .user-role {
                color: #888;
            }

		
        </style>

        <!-- Page Preloader -->
        <div id="page-preloader">
            <img src="<?php echo e(asset('assets/img/logo/logo.png')); ?>" alt="Logo" class="preloader-logo">
            <div class="preloader-spinner"></div>
            <p class="preloader-text">جاري التحميل...</p>
        </div>

        <header class="dashboard-header">
            <div class="header-left">
                <button class="header-icon-btn" id="sidebar-toggle">
                    <i class="ri-menu-line"></i>
                </button>
                <!-- div class="search-box">
                    <i class="ri-search-line search-icon"></i>
                    <input type="text" class="search-input" placeholder="بحث سريع...">
                </div -->
            </div>

            <!--div class="header-right">
              
                <button class="header-icon-btn notification-badge">
                    <i class="ri-notification-3-line"></i>
                    <span class="badge">3</span>
                </button>

                <?php if(auth()->guard()->check()): ?>
                <div class="user-info">
                    <div class="user-details">
                        <div class="user-name"><?php echo e(auth()->user()->nom_prenom ?? 'زائر'); ?></div>
                       
                    </div>
                    <div class="user-avatar">
                        <i class="ri-user-line"></i>
                    </div>
                </div>
                <?php endif; ?>
            </div-->
			
			<div class="header-right">
			
			<?php if(auth()->guard()->check()): ?>
				<?php
					$user = auth()->user()->loadMissing('gouvernorat', 'auberge', 'roles');
					$roleId = $user->roles->pluck('id_roles')->first();
				?>

				<?php if($roleId == 7 && $user->auberge): ?>
					<div style="margin-right:15px; font-weight:bold;">
						<?php echo e($user->auberge->nom_ar); ?>

					</div>
				<?php endif; ?>

				<?php if($roleId == 8 && $user->gouvernorat): ?>
					<div style="margin-right:15px; font-weight:bold;">
					المندوبية الجهوية للشباب والرياضة بـ<?php echo e($user->gouvernorat->nom_ar); ?>

					</div>
				<?php endif; ?>
				<?php endif; ?>

				<div class="notification-wrapper" style="position: relative;">
    <button class="header-icon-btn notification-badge" id="notifToggle">
        <i class="ri-notification-3-line"></i>
        <span class="badge"><?php echo e(auth()->user()->unreadNotifications->count()); ?></span>
    </button>

    <?php if(auth()->guard()->check()): ?>
    <div class="notification-dropdown" id="notifDropdown"
         style="
            display:none;
            position:absolute;
            top:45px;
            left:0;
            width:300px;
            max-height:400px;
            overflow-y:auto;
            background:white;
            border:1px solid #ddd;
            box-shadow:0 4px 8px rgba(0,0,0,0.1);
            border-radius:6px;
            z-index:1000;
         ">
        <?php $__empty_1 = true; $__currentLoopData = auth()->user()->notifications; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $notif): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
        <a href="<?php echo e(route('notifications.open', $notif->id)); ?>"
           class="notif-item"
           style="
                display:block;
                padding:10px 12px;
                border-bottom:1px solid #eee;
                text-decoration:none;
                color:#333;
                background: <?php echo e($notif->read_at ? '#f8f9fa' : '#e9f2ff'); ?>;
           ">
            <i class="ri-notification-3-line"></i>
            <?php echo e($notif->data['message'] ?? 'إشعار جديد'); ?>

            <br>
            <small class="text-muted"><?php echo e($notif->created_at->diffForHumans()); ?></small>
        </a>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
        <div style="padding:12px; text-align:center; color:#666;">
            لا توجد إشعارات
        </div>
        <?php endif; ?>
    </div>
    <?php endif; ?>
</div>
				<?php if(auth()->guard()->check()): ?>
				<div class="user-info">
					<div class="user-details">
						<div class="user-name"><?php echo e(auth()->user()->nom_prenom ?? 'زائر'); ?></div>
					</div>
					<div class="user-avatar">
						<i class="ri-user-line"></i>
					</div>
				</div>
				<?php endif; ?>

			</div>
        </header>

        <div class="dashboard-container d-flex">
            <?php echo $__env->make('backoffice.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <div class="dashboard-main flex-grow-1 d-flex flex-column min-vh-100">
                <div class="dashboard-content flex-grow-1">
                    <div class="container-fluid p-4">
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                </div>

                <footer class="dashboard-footer py-3 bg-white">
                    <div class="container-fluid text-center">
                        <p class="mb-0">
                            <span>جميع الحقوق محفوظة &copy; <?php echo e(date('Y')); ?></span>
                            <strong class="ms-2"> <a href="https://www.data-era.co" target="_blank">DataEra</a> </strong>
                        </p>
                    </div>
                </footer>
            </div>
        </div>
    </div>
    <script src="<?php echo e(asset('BackOfficeAR/js/jquery-3.4.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('BackOfficeAR/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('BackOfficeAR/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('BackOfficeAR/js/chart.min.js')); ?>"></script>
    <script src="<?php echo e(asset('BackOfficeAR/js/main-rtl.js')); ?>"></script>
    <script src="<?php echo e(asset('BackOfficeAR/js/script.js')); ?>"></script>



    <script>
    // ========== PRELOADER & FADE-IN MANAGEMENT ==========
    // Hide preloader and show content with fade-in effect
    window.addEventListener('load', function() {
        const preloader = document.getElementById('page-preloader');
        const container = document.querySelector('.dashboard-container');
        
        // Add fade-out class to preloader
        preloader.classList.add('fade-out');
        
        // Add fade-in class to container
        if (container) {
            container.classList.add('fade-in');
        }
        
        // Remove preloader from DOM after animation
        setTimeout(function() {
            preloader.style.display = 'none';
        }, 500);
    });

    $(document).ready(function() {
        // Initialize dropdowns
        $('.dropdown-toggle').dropdown();

        // Add hover effect for dropdown items
        $('.dropdown-item').hover(
            function() { $(this).addClass('active'); },
            function() { $(this).removeClass('active'); }
        );

        // Keep dropdown open on hover
        $('.nav-item.dropdown').hover(
            function() { $(this).find('.dropdown-menu').stop(true, true).delay(100).fadeIn(300); },
            function() { $(this).find('.dropdown-menu').stop(true, true).delay(100).fadeOut(300); }
        );

        // Sidebar toggle
        $('#sidebar-close').click(function() {
            $('.dashboard-sidebar').toggleClass('collapsed');
            $('.dashboard-main').toggleClass('expanded');
        });

        // Theme switcher (seulement si le bouton existe)
        const themeToggle = document.getElementById('theme-toggle');
        
        if (themeToggle) {
            const html = document.documentElement;
            const icon = themeToggle.querySelector('i');

            // Check for saved theme preference
            const savedTheme = localStorage.getItem('theme') || 'light';
            html.setAttribute('data-theme', savedTheme);
            updateThemeIcon(savedTheme);

            themeToggle.addEventListener('click', () => {
                const currentTheme = html.getAttribute('data-theme');
                const newTheme = currentTheme === 'light' ? 'dark' : 'light';
                
                html.setAttribute('data-theme', newTheme);
                localStorage.setItem('theme', newTheme);
                updateThemeIcon(newTheme);
            });

            function updateThemeIcon(theme) {
                icon.className = theme === 'light' ? 'ri-sun-line' : 'ri-moon-line';
            }
        }

        // Sidebar toggle pour mobile et desktop
        const sidebarToggle = document.getElementById('sidebar-toggle');
        
        console.log('=== INIT SIDEBAR TOGGLE ===');
        console.log('Sidebar toggle button:', sidebarToggle);
        
        if (!sidebarToggle) {
            console.error('❌ Bouton sidebar-toggle introuvable !');
            return;
        }
        
        console.log('✅ Bouton sidebar-toggle trouvé !');

        sidebarToggle.addEventListener('click', function(e) {
            e.preventDefault();
            e.stopPropagation();
            
            console.log('\n=== CLIC SUR BURGER ===');
            
            const sidebar = document.querySelector('.dashboard-sidebar');
            const main = document.querySelector('.dashboard-main');
            const header = document.querySelector('.dashboard-header');
            const isMobile = window.innerWidth <= 991;
            
            console.log('Largeur écran:', window.innerWidth + 'px');
            console.log('Mode:', isMobile ? 'MOBILE' : 'DESKTOP');
            console.log('Sidebar trouvé:', !!sidebar);
            
            if (!sidebar) {
                console.error('❌ Sidebar introuvable !');
                return;
            }

            if (isMobile) {
                // Sur mobile : toggle la classe mobile-open
                console.log('📱 Mode MOBILE - Toggle mobile-open');
                sidebar.classList.toggle('mobile-open');
                document.body.classList.toggle('menu-open');
                console.log('Sidebar classes:', sidebar.className);
                console.log('Body classes:', document.body.className);
                console.log('Sidebar has mobile-open:', sidebar.classList.contains('mobile-open'));
            } else {
                // Sur desktop : toggle collapsed
                console.log('🖥️ Mode DESKTOP - Toggle collapsed');
                sidebar.classList.toggle('collapsed');
                if (main) main.classList.toggle('expanded');
                if (header) header.classList.toggle('expanded');
                console.log('Sidebar classes:', sidebar.className);
                console.log('Sidebar has collapsed:', sidebar.classList.contains('collapsed'));
            }
        });

        // Fermer le menu mobile en cliquant sur l'overlay
        document.body.addEventListener('click', (e) => {
            if (window.innerWidth <= 991 && 
                document.body.classList.contains('menu-open') &&
                !e.target.closest('.dashboard-sidebar') &&
                !e.target.closest('#sidebar-toggle')) {
                document.querySelector('.dashboard-sidebar').classList.remove('mobile-open');
                document.body.classList.remove('menu-open');
            }
        });

        // Fermer le menu avec le bouton X
        $('#sidebar-close').click(function() {
            if (window.innerWidth <= 991) {
                $('.dashboard-sidebar').removeClass('mobile-open');
                $('body').removeClass('menu-open');
            } else {
                $('.dashboard-sidebar').toggleClass('collapsed');
                $('.dashboard-main').toggleClass('expanded');
            }
        });
    });
    </script>
	
	
	
	
	<script>
		document.getElementById('notifToggle').addEventListener('click', function () {
			const dropdown = document.getElementById('notifDropdown');
			dropdown.style.display = dropdown.style.display === 'none' ? 'block' : 'none';
		});

		// Fermer si on clique ailleurs
		document.addEventListener('click', function (e) {
			const toggle = document.getElementById('notifToggle');
			const dropdown = document.getElementById('notifDropdown');
			if (!toggle.contains(e.target) && !dropdown.contains(e.target)) {
				dropdown.style.display = 'none';
			}
		});
	</script>

<script>document.querySelectorAll('.notif-item').forEach(item => {
    item.addEventListener('click', function(e){
        e.preventDefault();
        let url = this.href;
        fetch(url).then(() => {
            let badge = document.querySelector('.notification-badge .badge');
            if(badge){
                let count = parseInt(badge.innerText) - 1;
                badge.innerText = count > 0 ? count : '';
            }
            window.location.href = url;
        });
    });
});
</script>
</body>
</html>
<?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/dashboard.blade.php ENDPATH**/ ?>