<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <style>
        body { font-family: "amiri", serif; font-size:13px; text-align:right; direction:rtl; }
        h1,h2,h3,h4,h5 { text-align:center; font-family:"amiri", serif; }
        table { width:100%; border-collapse: collapse; margin-bottom:10px; }
        th, td { border:1px solid #000; padding:6px; text-align:right; vertical-align:middle; }
        .section { border:1px solid #000; padding:10px; margin-bottom:15px; }
        .section-title { font-weight:bold; margin-bottom:8px; text-decoration:underline; }
    </style>
</head>
<body>

<div class="header">
    <table width="100%" style="border: none;">
        <tr>
            <td style="width:120px; text-align:right; border:none;">
                <img src="<?php echo e(public_path('storage/logo.png')); ?>"
                     style="width:90px; height:auto;">
            </td>

            <td style="text-align:center; border:none;">
                <div style="display:inline-block; text-align:center;">
                    <h1>الجمهورية التونسية</h1>
                    <h2>وزارة الشباب و الرياضة</h2>
                   <h3>استمارة الإعلام ببداية النشاط</h3>
                </div>
            </td>

            <td style="width:120px; border:none;"></td>
        </tr>
    </table>
</div>

<div class="section">
    <div class="section-title">الوضعية</div>
    <table>
        <tr>
            <td>حالة الطلب</td>
            <td>
                <?php if($debutActivite->id_statut == 1): ?>
                    مقبول
                <?php elseif($debutActivite->id_statut == 3): ?>
                    مرفوض
                <?php else: ?>
                    في الانتظار
                <?php endif; ?>
            </td>
        </tr>
        <?php if($debutActivite->id_statut == 3 && $debutActivite->commentaire_motif): ?>
        <tr>
            <td>سبب الرفض</td>
            <td><?php echo e($debutActivite->commentaire_motif); ?></td>
        </tr>
        <?php endif; ?>
    </table>
</div>

<div class="section">
    <div class="section-title">هوية الباعث</div>
    <table>
        <tr>
            <td>الاسم و اللقب أو الاسم التجاري</td>
            <td><?php echo e($debutActivite->immobilier->utilisateur->nom_prenom ?? '-'); ?></td>
        </tr>
        <tr>
            <td>رقم الهوية</td>
            <td><?php echo e($debutActivite->immobilier->utilisateur->cin ?? $debutActivite->immobilier->utilisateur->passport ?? $debutActivite->immobilier->utilisateur->num_fiscal ?? '-'); ?></td>
        </tr>
        <tr>
            <td>الهاتف</td>
            <td><?php echo e($debutActivite->immobilier->utilisateur->tel ?? '-'); ?></td>
        </tr>
        <tr>
            <td>البريد الإلكتروني</td>
            <td><?php echo e($debutActivite->immobilier->utilisateur->email ?? '-'); ?></td>
        </tr>
    </table>
</div>

<div class="section">
    <div class="section-title">تاريخ بداية النشاط</div>
    <table>
        <tr>
            <td>تاريخ البداية</td>
            <td><?php echo e($debutActivite->date_debut_activite ? $debutActivite->date_debut_activite->format('d/m/Y') : '-'); ?></td>
        </tr>
    </table>
</div>

<div class="section">
    <div class="section-title">الوثائق المرفقة</div>
    <?php
        $docs = [
            'preuve_propriete_location' => 'نسخة من شهادة الملكية أو عقد الكراء ...',
            'plan_architectural' => 'مخطط معماري ...',
            'declaration_investissement' => 'شهادة تصريح بالاستثمار ...',
            'identification' => 'بطاقة تعريف / جواز ...',
            'extrait_registre_national_entreprise' => 'السجل الوطني للمؤسسات ...',
            'certificat_prevention' => 'شهادة الوقاية ...',
            'contrat_assurance' => 'عقد التأمين ...',
            'approbation_autorite_minicipale' => 'اعتماد السلطة المحلية ...'
        ];
    ?>
    <table>
        <thead>
            <tr>
                <th>الوثيقة</th>
                <th>عرض الملف</th>
            </tr>
        </thead>
        <tbody>
        <?php $__currentLoopData = $docs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $field => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($label); ?></td>
                <td>
                    <?php if($debutActivite->$field): ?>
                        <a href="<?php echo e(route('debutActivite.download', ['id' => $debutActivite->id_debut, 'field' => $field])); ?>" target="_blank">عرض الملف</a>
                    <?php else: ?>
                        -
                    <?php endif; ?>
                </td>
            </tr>
        <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
</div>

</body>
</html>
<?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/investissement/gestion_salle_sport/debut_activite/pdf.blade.php ENDPATH**/ ?>