<?php $__env->startSection('title', 'إدارة وصف الولايات'); ?>

<?php $__env->startSection('content'); ?>

<?php if(Auth::check()): ?>
<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">

<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0 shadow-sm rounded-3 border-0">

                
                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
                    <h2 class="widget-title m-0">قائمة وصف الولايات</h2>
                    <a class="btn btn-success btn-sm px-3" href="<?php echo e(route('desc_gouvr.create')); ?>">
                        <i class="la la-plus me-1"></i> إضافة وصف ولاية
                    </a>
                </div>

                
                <div class="block-card-header px-4 border-bottom-0 pb-3">
                    <form method="GET" action="<?php echo e(route('desc_gouvr.index')); ?>">
                        <div class="form-row align-items-center" style="direction: rtl;">
                            <div class="col-auto" style="width: 250px;">
                                <input 
                                    type="text" 
                                    name="q" 
                                    class="form-control" 
                                    placeholder="بحث باسم الولاية بالعربية، الفرنسية أو الإنجليزية" 
                                    value="<?php echo e($search ?? ''); ?>"
                                >
                            </div>
                            <div class="col d-flex">
                                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">
                                    بحث
                                </button>
                                <a href="<?php echo e(route('desc_gouvr.index')); ?>"
                                   class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
                                   style="width: 45px; height: 38px; margin-right: 5px; padding: 0;">
                                    <i class="fa-solid fa-rotate-right"></i>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>

                
                <div class="block-card-body">
                    <?php if(session('success')): ?>
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            <?php echo e(session('success')); ?>

                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    <?php endif; ?>

                    <div class="my-table table-responsive" style="direction: rtl; text-align: right;">
                        <table class="table align-items-center table-flush mb-0 table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th>المعرف</th>
                                    <th>المستخدم</th>
                                    <th>الولاية</th>
                                    <th>الصورة الرئيسية</th>
                                    <th>إجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                <?php $__empty_1 = true; $__currentLoopData = $desc_gouvr; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $item): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                                    <tr>
                                        <td><?php echo e($item->id_desc); ?></td>
                                        <td><?php echo e($item->utilisateur?->nom_prenom ?? 'غير محدد'); ?></td>
                                        <td><?php echo e($item->gouvernorat?->nom_ar ?? 'غير محدد'); ?></td>
                                        <td>
                                            <?php if($item->image_gouv): ?>
                                                <img src="data:image/jpeg;base64,<?php echo e(base64_encode($item->image_gouv)); ?>"
                                                     alt="صورة الولاية"
                                                     class="rounded shadow-sm border"
                                                     style="width: 80px; height: 60px; object-fit: cover;">
                                            <?php else: ?>
                                                <span class="text-muted">—</span>
                                            <?php endif; ?>
                                        </td>
                                        <td>
                                            <div class="d-flex justify-content-center gap-2">
                                                <a href="<?php echo e(route('desc_gouvr.edit', $item)); ?>" class="btn-icon btn-icon--warning" title="تعديل">
                                                    <i class="la la-edit"></i>
                                                </a>

                                                <form action="<?php echo e(route('desc_gouvr.destroy', $item)); ?>" method="POST" class="d-inline">
                                                    <?php echo csrf_field(); ?>
                                                    <?php echo method_field('DELETE'); ?>
                                                    <button type="button"
                                                            onclick="return confirmAction('هل تريد حذف هذا الوصف؟', null, this.closest('form'))"
                                                            class="btn-icon btn-icon--danger"
                                                            title="حذف">
                                                        <i class="la la-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                                    <tr>
                                        <td colspan="5" class="py-4 text-center text-muted">لا توجد وصف حالياً</td>
                                    </tr>
                                <?php endif; ?>
                            </tbody>
                        </table>
                    </div>

                    
                    <div class="d-flex justify-content-between align-items-center mt-3">
                        <?php echo e($desc_gouvr->links('pagination::bootstrap-5')); ?>

                    </div>
                </div>

            </div>
        </div>
    </div>
</div>


<link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/sweetalert2@11/dist/sweetalert2.min.css">
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>

<style>
.table-hover th, 
.table-hover td {
    vertical-align: middle;
    text-align: center;
}

.table-hover th:nth-child(2),
.table-hover td:nth-child(2),
.table-hover th:nth-child(3),
.table-hover td:nth-child(3) {
    text-align: right !important;
    direction: rtl;
}

.btn-icon {
    width: 30px;
    height: 30px;
    border-radius: 6px;
    display: inline-flex;
    align-items: center;
    justify-content: center;
    border: none;
    cursor: pointer;
    background-color: #f8f9fa;
    font-size: 16px;
    transition: 0.2s;
}

.btn-icon--warning { background-color: #fff3cd; color: #856404; }
.btn-icon--danger { background-color: #f8d7da; color: #dc3545; }
</style>

<?php else: ?>
<script>window.location.href = "<?php echo e(route('admin')); ?>";</script>
<?php endif; ?>

<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/desc_gouvr/index.blade.php ENDPATH**/ ?>