<?php echo csrf_field(); ?>
<style>
  .field-error { color: #d9534f; font-size: .9rem; margin-top: .25rem; display: none; }
  .is-invalid { border-color: #d9534f !important; }
</style>

<div class="block-card mb-4">
  <div class="block-card-header">
    <h2 class="widget-title"><?php echo e($formTitle ?? 'نموذج الخبر'); ?></h2>
    <div class="stroke-shape"></div>
  </div>

  <div class="block-card-body">
    <div class="form-group row mb-3">
        <div class="col-md-6">
            <label>التاريخ <span class="text-danger">*</span></label>
            <input type="date" name="date" id="date"
                    class="form-control <?php $__errorArgs = ['date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?> is-invalid <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>"
                    value="<?php echo e(old('date', $news->date ?? '')); ?>">
            <?php $__errorArgs = ['date'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="field-error d-block"><?php echo e($message); ?></span>
            <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
        </div>

      <div class="col-md-6">
        <label>العنوان بالعربية <span class="text-danger">*</span></label>
        <input type="text" name="title" id="title" class="form-control" value="<?php echo e(old('title', $news->title ?? '')); ?>" required>
        <?php $__errorArgs = ['title'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="field-error d-block"><?php echo e($message); ?></span>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
      </div>
    </div>

    <div class="form-group row mb-3">
      <div class="col-md-6">
        <label>العنوان بالفرنسية <span class="text-danger">*</span></label>
        <input type="text" name="title_fr" id="title_fr" class="form-control" value="<?php echo e(old('title_fr', $news->title_fr ?? '')); ?>" required>
        <?php $__errorArgs = ['title_fr'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="field-error d-block"><?php echo e($message); ?></span>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
      </div>

      <div class="col-md-6">
        <label>العنوان بالإنجليزية <span class="text-danger">*</span></label>
        <input type="text" name="title_en" id="title_en" class="form-control" value="<?php echo e(old('title_en', $news->title_en ?? '')); ?>" required>
        <?php $__errorArgs = ['title_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="field-error d-block"><?php echo e($message); ?></span>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
      </div>
    </div>

    <div class="form-group mb-3" dir="rtl">
      <label class="fw-bold mb-2">المحتوى بالعربية<span class="text-danger">*</span></label>
      <textarea name="content" id="editor_ar" class="form-control" rows="10"><?php echo e(old('content', $news->content ?? '')); ?></textarea>
      <?php $__errorArgs = ['content'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="field-error d-block"><?php echo e($message); ?></span>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>

    <div class="form-group mb-3" dir="rtl">
      <label class="fw-bold mb-2">الملخّص بالعربية<span class="text-danger">*</span></label>
      <textarea name="resume_ar" id="resume_ar" class="form-control" rows="3" required><?php echo e(old('resume_ar', $news->resume_ar ?? '')); ?></textarea>
      <?php $__errorArgs = ['resume_ar'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="field-error d-block"><?php echo e($message); ?></span>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>

    <div class="form-group mb-3">
      <label class="fw-bold mb-2">المحتوى بالفرنسية<span class="text-danger">*</span></label>
      <textarea name="content_fr" id="editor_fr" class="form-control" rows="10"><?php echo e(old('content_fr', $news->content_fr ?? '')); ?></textarea>
      <?php $__errorArgs = ['content_fr'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="field-error d-block"><?php echo e($message); ?></span>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>

    <div class="form-group mb-3" dir="rtl">
      <label class="fw-bold mb-2">الملخّص بالفرنسية<span class="text-danger">*</span></label>
      <textarea name="resume_fr" id="resume_fr" class="form-control" rows="3" required><?php echo e(old('resume_fr', $news->resume_fr ?? '')); ?></textarea>
      <?php $__errorArgs = ['resume_fr'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="field-error d-block"><?php echo e($message); ?></span>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>

    <div class="form-group mb-3">
      <label class="fw-bold mb-2">المحتوى بالانقليزية<span class="text-danger">*</span></label>
      <textarea name="content_en" id="editor_en" class="form-control" rows="10"><?php echo e(old('content_en', $news->content_en ?? '')); ?></textarea>
      <?php $__errorArgs = ['content_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="field-error d-block"><?php echo e($message); ?></span>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>

    <div class="form-group mb-3" dir="rtl">
      <label class="fw-bold mb-2">الملخّص بالانقليزية<span class="text-danger">*</span></label>
      <textarea name="resume_en" id="resume_en" class="form-control" rows="3" required><?php echo e(old('resume_en', $news->resume_en ?? '')); ?></textarea>
      <?php $__errorArgs = ['resume_en'];
$__bag = $errors->getBag($__errorArgs[1] ?? 'default');
if ($__bag->has($__errorArgs[0])) :
if (isset($message)) { $__messageOriginal = $message; }
$message = $__bag->first($__errorArgs[0]); ?>
                <span class="field-error d-block"><?php echo e($message); ?></span>
        <?php unset($message);
if (isset($__messageOriginal)) { $message = $__messageOriginal; }
endif;
unset($__errorArgs, $__bag); ?>
    </div>

    <div class="form-group mb-3">
      <label>صورة الخبر</label>
      <input type="file" name="image" class="form-control" accept="image/*">
      <?php if(!empty($news->image)): ?>
        <div class="mt-2">
          <img src="data:image/jpeg;base64,<?php echo e(base64_encode($news->image)); ?>" alt="صورة الخبر" style="height:100px; border-radius:8px;">
        </div>
      <?php endif; ?>
    </div>

    <div class="form-group mb-3">
      <label>رابط YouTube</label>
      <input type="text" name="youtube_url" id="youtube_url" class="form-control" value="<?php echo e(old('youtube_url', $news->youtube_url ?? '')); ?>" placeholder="https://www.youtube.com/watch?v=...">
    </div>

    <div class="form-check mb-3">
      <input type="hidden" name="published" value="0">
      <input type="checkbox" name="published" value="1" class="form-check-input" id="published" <?php echo e(old('published', $news->published ?? false) ? 'checked' : ''); ?>>
      <label for="published" class="form-check-label">منشور</label>
    </div>
  </div>

  <div class="block-card-footer mt-3 mb-3 text-center">
    <button type="submit" id="submitBtn" class="btn bg-rgb-primary1 font-weight-medium">
      <i class="la la-save mr-1"></i> حفظ
    </button>
    <a href="<?php echo e(route('news.index')); ?>" class="btn bg-rgb-primary1 font-weight-medium">
      <i class="la la-times mr-1"></i> إلغاء
    </a>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/tinymce@6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
  tinymce.init({
    selector: '#editor_ar',
    directionality: 'rtl',
    height: 350,
    plugins: 'advlist autolink lists link image charmap preview anchor searchreplace visualblocks code fullscreen table',
    toolbar: 'undo redo | formatselect | bold italic | forecolor backcolor | alignleft aligncenter alignright alignjustify | bullist numlist | link image | code',
    forced_root_block: false,
  });
  tinymce.init({
    selector: '#editor_fr',
    height: 350,
    plugins: 'advlist autolink lists link image charmap preview anchor searchreplace visualblocks code fullscreen table',
    toolbar: 'undo redo | formatselect | bold italic | forecolor backcolor | alignleft aligncenter alignright alignjustify | bullist numlist | link image | code',
    forced_root_block: false,
  });
  tinymce.init({
    selector: '#editor_en',
    height: 350,
    plugins: 'advlist autolink lists link image charmap preview anchor searchreplace visualblocks code fullscreen table',
    toolbar: 'undo redo | formatselect | bold italic | forecolor backcolor | alignleft aligncenter alignright alignjustify | bullist numlist | link image | code',
    forced_root_block: false,
  });
  function stripHtml(html){
    const tmp = document.createElement("DIV");
    tmp.innerHTML = html || "";
    return tmp.textContent || tmp.innerText || "";
  }

  document.querySelector('form').addEventListener('submit', function (e) {
    document.querySelectorAll('.field-error').forEach(el => el.style.display = 'none');
    document.querySelectorAll('.is-invalid').forEach(el => el.classList.remove('is-invalid'));
    let firstError = null;
    function showError(elSelector, msgId) {
      const el = document.querySelector(elSelector);
      if (el) el.classList.add('is-invalid');
      const msg = document.getElementById(msgId);
      if (msg) msg.style.display = 'block';
      if (!firstError) firstError = el || msg;
    }

    const date = document.getElementById('date').value.trim();
    if (!date) showError('#date', 'error_date');
    const title = document.getElementById('title').value.trim();
    if (!title) showError('#title', 'error_title');
    const titleFr = document.getElementById('title_fr').value.trim();
    if (!titleFr) showError('#title_fr', 'error_title_fr');
    const titleEn = document.getElementById('title_en').value.trim();
    if (!titleEn) showError('#title_en', 'error_title_en');
    const resumeAr = document.getElementById('resume_ar').value.trim();
    if (!resumeAr) showError('#resume_ar', 'error_resume_ar');
    const resumeFr = document.getElementById('resume_fr').value.trim();
    if (!resumeFr) showError('#resume_fr', 'error_resume_fr');
    const resumeEn = document.getElementById('resume_en').value.trim();
    if (!resumeEn) showError('#resume_en', 'error_resume_en');
    const arContent = stripHtml(tinymce.get('editor_ar') ? tinymce.get('editor_ar').getContent() : document.getElementById('editor_ar').value).trim();
    if (!arContent) showError('#editor_ar', 'error_content_ar');
    const frContent = stripHtml(tinymce.get('editor_fr') ? tinymce.get('editor_fr').getContent() : document.getElementById('editor_fr').value).trim();
    if (!frContent) showError('#editor_fr', 'error_content_fr');
    const enContent = stripHtml(tinymce.get('editor_en') ? tinymce.get('editor_en').getContent() : document.getElementById('editor_en').value).trim();
    if (!enContent) showError('#editor_en', 'error_content_en');
    if (firstError) {
      e.preventDefault();
      firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
      return false;
    }
    if (tinymce.get('editor_ar')) document.querySelector('textarea[name="content"]').value = tinymce.get('editor_ar').getContent();
    if (tinymce.get('editor_fr')) document.querySelector('textarea[name="content_fr"]').value = tinymce.get('editor_fr').getContent();
    if (tinymce.get('editor_en')) document.querySelector('textarea[name="content_en"]').value = tinymce.get('editor_en').getContent();
  });
</script>
<?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/news/form.blade.php ENDPATH**/ ?>