<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta http-equiv="content-type" content="text/html; charset=utf-8">
    <meta name="author" content="TechyDevs">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <meta http-equiv="X-UA-Compatible" content="ie=edge">
    <meta name="csrf-token" content="<?php echo e(csrf_token()); ?>">
    <title>وزارة الشباب و الرياضة</title>
    <link rel="icon" href="/FrontOfficeAR/images/favicon.png">
    <link href="https://fonts.googleapis.com/css2?family=Be+Vietnam:wght@100;300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/bootstrap.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/bootstrap-rtl.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/line-awesome.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/owl.carousel.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/owl.theme.default.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/animated-headline_.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/datedropper.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/jquery-ui.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/jquery.fancybox.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/chosen.min.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/style.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/style-rtl.css')); ?>">
    <link rel="stylesheet" href="<?php echo e(asset('BackOfficeAR/css/css.css')); ?>">
    <style>
        body {
            position: relative;
            min-height: 100vh;
            background-color: #f8f9fa;
            overflow-x: hidden;
        }

        .dashboard-container {
            display: flex;
            min-height: 100vh;
        }

        .dashboard-sidebar {
            width: 280px;
            flex-shrink: 0;
            position: fixed;
            top: 0;
            right: 0;
            height: 100vh;
            overflow-y: auto;
            z-index: 1000;
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
        }

        .dashboard-main {
            flex-grow: 1;
            margin-right: 280px;
            width: calc(100% - 280px);
        }
        body::before {
            content: '';
            position: absolute;
            top: 0;
            right: 0;
            width: 100%;
            height: 100%;
            background-image: url('<?php echo e(asset('assets/img/shape/project-1-1.png')); ?>');
            background-size: contain;
            background-repeat: no-repeat;
            background-position: center right;
            opacity: 0.1;
            z-index: -1;
        }
        .dashboard-sidebar {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
        }
        .dashboard-inner-body-container {
            background: rgba(255, 255, 255, 0.9);
            backdrop-filter: blur(10px);
            border-radius: 15px;
            box-shadow: 0 0 20px rgba(0,0,0,0.1);
            padding: 20px;
            margin: 20px;
        }
        .nav-link {
            transition: all 0.3s ease;
            border-radius: 8px;
            margin: 5px 0;
            padding: 0.5rem 1rem;
        }

        .dropdown-menu {
            border: none;
            border-radius: 10px;
            box-shadow: 0 2px 15px rgba(0,0,0,0.1);
            padding: 0.5rem;
            margin-top: 0;
            background: rgba(255, 255, 255, 0.98);
        }

        .dropdown-item {
            padding: 0.5rem 1rem;
            border-radius: 6px;
            transition: all 0.2s ease;
            color: #333;
        }

        .dropdown-item:hover, .dropdown-item:focus, .dropdown-item.active {
            background: rgba(228, 33, 37, 0.1);
            color: #e42125;
        }

        .dropdown-toggle::after {
            margin-right: 0.5rem;
        }
        .nav-link:hover {
            background: rgba(228, 33, 37, 0.1);
            transform: translateX(-5px);
        }
        .navbar {
            border-radius: 15px;
            margin: 15px;
            box-shadow: 0 0 15px rgba(0,0,0,0.1);
        }
    </style>
</head>
<body>
    <div class="loader-container">
        <div class="loader-ripple">
            <div></div>
            <div></div>
        </div>
    </div>
    <div class="dashboard-wrapper">
        <div class="dashboard-container d-flex">
            <?php echo $__env->make('backoffice.partials.sidebar', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?>

            <div class="dashboard-main flex-grow-1 d-flex flex-column min-vh-100">
                <div class="dashboard-content flex-grow-1">
                    <div class="container-fluid p-4">
                        <?php echo $__env->yieldContent('content'); ?>
                    </div>
                </div>

                <footer class="dashboard-footer py-3 bg-white">
                    <div class="container-fluid text-center">
                        <p class="mb-0">
                            <span>جميع الحقوق محفوظة &copy; <?php echo e(date('Y')); ?></span>
                            <strong class="ms-2">وزارة الشباب و الرياضة</strong>
                        </p>
                    </div>
                </footer>
            </div>
        </div>
    </div>
    <script src="<?php echo e(asset('BackOfficeAR/js/jquery-3.4.1.min.js')); ?>"></script>
    <script src="<?php echo e(asset('BackOfficeAR/js/popper.min.js')); ?>"></script>
    <script src="<?php echo e(asset('BackOfficeAR/js/bootstrap.min.js')); ?>"></script>
    <script src="<?php echo e(asset('BackOfficeAR/js/chart.min.js')); ?>"></script>
    <script src="<?php echo e(asset('BackOfficeAR/js/main-rtl.js')); ?>"></script>
    <script src="<?php echo e(asset('BackOfficeAR/js/script.js')); ?>"></script>

    <script>
    $(document).ready(function() {
        // Initialize dropdowns
        $('.dropdown-toggle').dropdown();

        // Add hover effect for dropdown items
        $('.dropdown-item').hover(
            function() { $(this).addClass('active'); },
            function() { $(this).removeClass('active'); }
        );

        // Keep dropdown open on hover
        $('.nav-item.dropdown').hover(
            function() { $(this).find('.dropdown-menu').stop(true, true).delay(100).fadeIn(300); },
            function() { $(this).find('.dropdown-menu').stop(true, true).delay(100).fadeOut(300); }
        );
    });
    </script>
</body>
</html>
<?php /**PATH C:\Users\Dell\Desktop\projet MJS\back\back\resources\views/backoffice/dashboard.blade.php ENDPATH**/ ?>