<!-- Sidebar -->
<?php
    $user = Auth::user();
?>

<?php
            use App\Models\Type;
            $types_G = Type::orderBy('id_type', 'asc')->get();
?>

<?php
    $hasInvestmentPermission = $user->hasPermission(20) || $user->hasPermission(31) || $user->hasPermission(36) ||  $user->hasPermission(42) || $user->hasPermission(48) || $user->hasPermission(54) || $user->hasPermission(60);
    $hasFinPermission = $user->hasPermission(66) || $user->hasPermission(72);
    $hasManifestationPermission = $user->hasPermission(77) || $user->hasPermission(83);
	$hasAubergePermission = $user->hasPermission(115) || $user->hasPermission(117) || $user->hasPermission(119);
?>

<style>
    /* Reset des styles de menu */
    .nav-menu {
        list-style: none;
        padding: 0;
        margin: 0;
		border-left: 2px solid #e42327;
    }

    .nav-item {
        position: relative;
    }

    .nav-link {
        display: flex;
        align-items: center;
        padding: 12px 20px;
        color: #444;
        text-decoration: none;
        transition: all 0.3s ease;
        border-radius: 8px;
        margin: 5px 15px;
    }

    .nav-link i {
        margin-left: 10px;
        font-size: 1.2rem;
        color: var(--navy-blue);
    }

    .nav-link:hover {
        background: var(--light-navy);
        color: var(--navy-blue);
    }

    /* Styles pour les sous-menus */
    .sub-menu {
        padding: 10px;
        margin: 0 15px;
        background: white;
        border: 1px solid #eee;
        border-radius: 8px;
        box-shadow: 0 2px 15px rgba(0,0,0,0.05);
        display: none;
    }

    .sub-menu-link {
        display: flex;
        align-items: center;
        padding: 10px 15px;
        color: #444;
        text-decoration: none;
        border-radius: 6px;
        transition: all 0.3s ease;
        margin: 2px 0;
    }

    .sub-menu-link i {
        margin-left: 10px;
        font-size: 1.1rem;
        color: var(--navy-blue);
    }

    .sub-menu-link:hover {
        background: var(--light-navy);
        color: var(--navy-blue);
    }

    .has-submenu > .nav-link::after {
        content: '▼';
        display: inline-block;
        margin-right: 10px;
        font-size: 10px;
        transition: transform 0.3s;
    }

    .has-submenu.active > .nav-link::after {
        transform: rotate(180deg);
    }

    .nav-link {
        cursor: pointer;
    }
    /* Styles pour désactiver le hover */
    .dropdown-menu {
        display: none !important;
        pointer-events: none !important;
    }

    .dropdown.show > .dropdown-menu {
        display: block !important;
        pointer-events: auto !important;
    }

    /* Désactiver le hover sur les dropdowns */
    .dropdown:hover > .dropdown-menu,
    .dropdown-toggle:hover + .dropdown-menu,
    .dropdown-menu:hover {
        display: none !important;
    }

    /* Force le menu à rester fermé sauf si .show est présent */
    .dropdown:not(.show) > .dropdown-menu {
        display: none !important;
        opacity: 0 !important;
        visibility: hidden !important;
    }
    .dropdown-menu {
        margin: 0 15px !important;
        padding: 10px !important;
        border-radius: 8px !important;
        border: 1px solid #eee !important;
        box-shadow: 0 2px 15px rgba(0,0,0,0.05) !important;
        background: white !important;
    }

    .dropdown-menu .dropdown-item {
        padding: 10px 15px !important;
        border-radius: 6px !important;
        margin: 2px 0 !important;
        color: #444 !important;
        font-size: 1rem !important;
        white-space: normal !important;
        word-wrap: break-word !important;
    }

    .dropdown-menu .dropdown-item:hover,
    .dropdown-menu .dropdown-item:focus,
    .dropdown-menu .dropdown-item.active {
        background: var(--light-navy) !important;
        color: var(--navy-blue) !important;
    }

    .dropdown-toggle::after {
        transition: transform 0.2s !important;
    }

    .show .dropdown-toggle::after {
        transform: rotate(180deg) !important;
    }

    .dropdown-menu.show {
        display: block !important;
        opacity: 1 !important;
        visibility: visible !important;
        transform: none !important;
    }
    @import url('https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600&display=swap');

    .dashboard-sidebar {
        --navy-blue: #1a237e;
        --light-navy: rgba(26, 35, 126, 0.1);
        --primary-red: #e42125;
        --light-red: rgba(228, 33, 37, 0.1);
        font-family: 'Cairo', sans-serif;
        background: white;
    }

    .sidebar-brand-wrapper {
        display: flex;
        align-items: center;
        padding: 15px 0;
        margin: 10px;
        background-color: white;
    }

    /* Override du style du background rouge */
    .sidebar-brand {
        background-color: transparent !important;
        padding: 0 !important;
        margin-right: 15px !important;
    }

    .ministry-info {
        text-align: right;
        display: flex;
        flex-direction: column;
        justify-content: center;
        margin-right: 10px;
    }

    .ministry-title {
        color: var(--navy-blue);
        font-size: 15px;
        font-weight: 600;
		font-family: 'Cairo';
        margin-bottom: 5px;
        line-height: 1.2;
    }

    .ministry-subtitle {
        color: var(--primary-red);
        font-size: 13px;
		font-family: 'Cairo';
        font-weight: 500;
        margin-top: 5px;
        line-height: 1.2;
    }

    .sidebar-brand {
        display: block;
        padding: 0;
        margin: 0;
        border-bottom: 1px solid #eee;
    }

    .nav-link {
        color: #444 !important;
        font-size: 1.1rem;
        font-weight: 500;
        padding: 12px 20px;
        margin: 5px 15px;
        border-radius: 8px;
        transition: all 0.3s ease;
    }

    .nav-link:hover {
        color: var(--navy-blue) !important;
        background: var(--light-navy) !important;
        transform: translateX(-5px);
    }

    .dropdown-item {
        color: #444 !important;
        font-size: 1rem;
        font-weight: 400;
        padding: 10px 15px;
        margin: 5px;
        border-radius: 6px;
    }

    .dropdown-item:hover, .dropdown-item:focus, .dropdown-item.active {
        background: var(--light-navy) !important;
        color: var(--navy-blue) !important;
    }

    .nav-item.dropdown .dropdown-menu {
        display: none;
        background: white;
        border: 1px solid #eee;
        box-shadow: 0 2px 15px rgba(0,0,0,0.05);
        margin: 0 15px;
        padding: 10px;
        position: static !important;
        float: none !important;
        width: auto !important;
        transform: none !important;
    }

    .dropdown-menu .dropdown-item {
        white-space: normal;
        word-wrap: break-word;
    }

    .nav-item.dropdown.show .dropdown-menu {
        display: block;
    }

    .sidebar-toggle i {
        color: var(--navy-blue);
        font-size: 1.5rem;
    }

    .nav-item.dropdown .dropdown-toggle::after {
        color: #666;
        transition: transform 0.3s ease;
    }

    .nav-item.dropdown.show .dropdown-toggle::after {
        transform: rotate(180deg);
    }

    .nav-link i, .dropdown-item i {
        color: var(--navy-blue);
        font-size: 1.2rem;
        margin-left: 10px;
        width: 20px;
        text-align: center;
    }

    .dropdown-item.active {
        background: var(--light-navy) !important;
        color: var(--navy-blue) !important;
    }

    .nav-item.active > .nav-link {
        background: var(--light-navy) !important;
        color: var(--navy-blue) !important;
        font-weight: 600;
    }
    
    /* ========== RESPONSIVE SIDEBAR ========== */
    @media (max-width: 991px) {
        /* Ajustements pour le sidebar sur mobile */
        .nav-link {
            padding: 10px 15px;
            margin: 3px 10px;
            font-size: 0.95rem;
        }
        
        .sub-menu {
            margin: 0 10px;
            padding: 8px;
        }
        
        .sub-menu-link {
            padding: 8px 12px;
            font-size: 0.9rem;
        }
        
        .nav-link i,
        .sub-menu-link i {
            font-size: 1.1rem;
        }
        
        /* Sidebar brand responsive */
        .sidebar-brand-wrapper {
            padding: 12px !important;
        }
        
        .sidebar-brand img {
            height: 60px !important;
        }
    }
    
    @media (max-width: 575px) {
        /* Très petits écrans */
        .nav-link {
            padding: 8px 12px;
            margin: 2px 8px;
            font-size: 0.9rem;
        }
        
        .sub-menu-link {
            padding: 6px 10px;
            font-size: 0.85rem;
        }
        
        .sidebar-brand img {
            height: 50px !important;
        }
        
        .nav-link i,
        .sub-menu-link i {
            font-size: 1rem;
            margin-left: 8px;
        }
    }
</style>

    <script>
    // Test de la structure HTML
    function testStructure() {
        const links = document.querySelectorAll('.has-submenu .nav-link');
        const submenus = document.querySelectorAll('.sub-menu');
        console.log('Structure HTML :');
        console.log('- Nombre de liens de menu:', links.length);
        console.log('- Nombre de sous-menus:', submenus.length);
        links.forEach((link, index) => {
            console.log(`Menu ${index + 1}:`);
            console.log('- Texte:', link.textContent.trim());
            console.log('- Parent has-submenu:', !!link.closest('.has-submenu'));
            console.log('- Sous-menu suivant:', !!link.nextElementSibling);
        });
    }

    document.addEventListener('DOMContentLoaded', function() {
        console.log('=== Démarrage du script ===');
        testStructure();
        console.log('Script chargé');

        // Sélectionner tous les liens de menu
        const menuLinks = document.querySelectorAll('.has-submenu .nav-link');
        console.log('Nombre de liens trouvés:', menuLinks.length);

        // Cacher tous les sous-menus au démarrage
        document.querySelectorAll('.sub-menu').forEach(menu => {
            menu.style.display = 'none';
        });

        // Ajouter les écouteurs de clic sur chaque lien
        menuLinks.forEach(link => {
            link.addEventListener('click', function(e) {
                console.log('Clic sur le lien:', this.textContent);
                e.preventDefault();
                e.stopPropagation();

                const submenu = this.nextElementSibling;
                const parent = this.parentElement;
                const isOpen = submenu.style.display === 'block';

                console.log('Sous-menu trouvé:', submenu);
                console.log('Est ouvert:', isOpen);

                // Fermer tous les autres menus
                document.querySelectorAll('.sub-menu').forEach(menu => {
                    menu.style.display = 'none';
                });
                document.querySelectorAll('.has-submenu').forEach(item => {
                    item.classList.remove('active');
                });

                // Si le menu était fermé, l'ouvrir
                if (!isOpen) {
                    submenu.style.display = 'block';
                    parent.classList.add('active');
                    console.log('Menu ouvert');
                } else {
                    console.log('Menu fermé');
                }
            });
        });

        // Fermer les menus au clic en dehors
        document.addEventListener('click', function(e) {
            if (!e.target.closest('.has-submenu')) {
                document.querySelectorAll('.sub-menu').forEach(menu => {
                    menu.style.display = 'none';
                });
                document.querySelectorAll('.has-submenu').forEach(item => {
                    item.classList.remove('active');
                });
            }
        });
    });
    </script>

<!-- Sidebar -->

<ul class="navbar-nav dashboard-sidebar">
    <li>
        <span id="sidebar-close">
            <i class="la la-times"></i>
        </span>
    </li>
 
	 <li>
        <div class="sidebar-brand-wrapper">
           
            <a class="sidebar-brand" href="<?php echo e(route('admin.dashboard')); ?>">
                <img src="<?php echo e(asset('assets/img/logo/logo.png')); ?>" height="80" alt="logo">
            </a>
			 <div class="ministry-info">
                <h4 class="ministry-title">الجمهورية التونسية</h4>
                <h5 class="ministry-subtitle">وزارة الشباب و الرياضة</h5>
            </div>
        </div>
    </li>
    <li class="nav-item">
        <a class="nav-link" href="<?php echo e(route('admin.dashboard')); ?>">
            <i class="la la-dashboard font-size-18 mr-1"></i>
            <span>لوحة القيادة</span>
        </a>
    </li>
    

        <?php if($user && $user->hasPermission(1)): ?> 
            <li class="nav-item has-submenu">
                <a class="nav-link" href="#" id="navbarDropdownAccessManagement"
                    role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="la la-shield font-size-18 mr-1"></i>
                    <span>إدارة حقوق الوصول</span>
                </a>
                <div class="sub-menu" aria-labelledby="navbarDropdownAccessManagement">
                   
                        <a class="sub-menu-link" href="<?php echo e(route('permissions.index')); ?>">
                            <i class="la la-key font-size-18 mr-1"></i>
                            <span>إدارة الصلاحيات</span>
                        </a>

                    <?php if($user->hasPermission(10)): ?> 
                        <a class="sub-menu-link" href="<?php echo e(route('roles.index')); ?>">
                            <i class="la la-user-tag font-size-18 mr-1"></i>
                            <span>إدارة الأدوار</span>
                        </a>
                    <?php endif; ?>

                    <?php if($user->hasPermission(1)): ?> 
                        <a class="sub-menu-link" href="<?php echo e(route('utilisateurs.index')); ?>">
                            <i class="la la-user font-size-18 mr-1"></i>
                            <span>إدارة المستخدمين</span>
                        </a>
                    <?php endif; ?>
                </div>
            </li>
        <?php endif; ?>

        <?php if($user && $hasInvestmentPermission): ?>
      <li class="nav-item has-submenu">
            <a class="nav-link" href="#" id="navbarDropdownInvestments"
                role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="la la-chart-line font-size-18 mr-1"></i>
                <span>إدارة الاستثمارات</span>
            </a>
            <div class="sub-menu" aria-labelledby="navbarDropdownInvestments">
            <?php if($user->hasPermission(20)): ?>
                <a class="sub-menu-link" href="<?php echo e(route('salle-sport.index')); ?>">
                    <i class="la la-dumbbell font-size-18 mr-1"></i>
                    <span>كراس شروط لإحداث قاعة خاصة<br> للرياضة</span>
                </a>
            <?php endif; ?>

            <?php if($user->hasPermission(31)): ?>
                <a class="sub-menu-link" href="<?php echo e(route('admin.debut_activite.index')); ?>">
                    <i class="la la-play-circle font-size-18 mr-1"></i>
                    <span>إستمارة الإعلام ببداية النشاط</span>
                </a>
            <?php endif; ?>

            <?php if($user->hasPermission(36)): ?>
                <a class="sub-menu-link" href="<?php echo e(route('admin.jeune_enfant.index')); ?>">
                    <i class="la la-child font-size-18 mr-1"></i>
                    <span>الفضاءات الترفيهية للشباب و الطفولة</span>
                </a>
            <?php endif; ?>

            <?php if($user->hasPermission(42)): ?>
                <a class="sub-menu-link" href="<?php echo e(route('admin.jeunesse.index')); ?>">
                    <i class="la la-users font-size-18 mr-1"></i>
                    <span>المؤسسات الشبابية الخاصة</span>
                </a>
            <?php endif; ?>

            <?php if($user->hasPermission(48)): ?>
                <a class="sub-menu-link" href="<?php echo e(route('admin.jeunesse2.index')); ?>">
                    <i class="la la-smile font-size-18 mr-1"></i>
                    <span>تنظيم الأنشطة الترفيهية للشباب والطفولة</span>
                </a>
            <?php endif; ?>

            <?php if($user->hasPermission(54)): ?>
                <a class="sub-menu-link" href="<?php echo e(route('admin.formation.index')); ?>">
                    <i class="la la-graduation-cap font-size-18 mr-1"></i>
                    <span>مركز التربصات وتكوين الرياضيين</span>
                </a>
            <?php endif; ?>

            <?php if($user->hasPermission(60)): ?>
                <a class="sub-menu-link" href="<?php echo e(route('admin.exoneration.index')); ?>">
                    <i class="la la-file-invoice-dollar font-size-18 mr-1"></i>
                    <span>مشاريع الإعفاء الجبائي</span>
                </a>
            <?php endif; ?>

            </div>
        </li>
        <?php endif; ?>

       <?php if($user && $hasFinPermission): ?>
            <li class="nav-item has-submenu">
                <a class="nav-link" href="#" id="navbarDropdownFunding"
                    role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="la la-money-bill-wave font-size-18 mr-1"></i>
                    <span>إدارة التمويلات</span>
                </a>

                <div class="sub-menu" aria-labelledby="navbarDropdownFunding">

                    <?php if($user->hasPermission(66)): ?>
                        <a class="sub-menu-link" href="<?php echo e(route('doc_fin.index')); ?>">
                            <i class="la la-coins font-size-18 mr-1"></i>
                            <span>
                                مطلب في التمويل العمومي <br>
                                (لجنة التمويل العمومي)
                            </span>
                        </a>
                    <?php endif; ?>

                    <?php if($user->hasPermission(72)): ?>
                        <a class="sub-menu-link" href="<?php echo e(route('admin.doc_fin2.index')); ?>">
                            <i class="la la-hand-holding-usd font-size-18 mr-1"></i>
                            <span>
                                مطلب في التمويل العمومي <br>
                                (اللجنة الفنية)
                            </span>
                        </a>
                    <?php endif; ?>

                </div>
            </li>
        <?php endif; ?>
        
        <?php if($user && $hasManifestationPermission): ?>
        <li class="nav-item has-submenu">
            <a class="nav-link" href="#" id="navbarDropdownEvents"
                role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="la la-trophy font-size-18 mr-1"></i>
                <span>إدارة تنظيم التظاهرات الرياضية</span>
            </a>
            <div class="sub-menu" aria-labelledby="navbarDropdownEvents">
                
                <?php if($user->hasPermission(77)): ?>
                    <a class="sub-menu-link" href="<?php echo e(route('admin.manifestation.index')); ?>">
                        <i class="la la-flag font-size-18 mr-1"></i>
                        <span> طلبات التظاهرات الرياضية الوطنية </span>
                    </a>
                <?php endif; ?>

                <?php if($user->hasPermission(83)): ?>
                    <a class="sub-menu-link" href="<?php echo e(route('admin.manifestation2.index')); ?>">
                        <i class="la la-globe font-size-18 mr-1"></i>
                        <span> طلبات التظاهرات الرياضية الدولية </span>
                    </a>
                <?php endif; ?>
                 
            </div>  
        </li>
<?php endif; ?>


    
    

    <?php if($user && $user->hasPermission(93)): ?>
        <li class="nav-item dropdown">
            <a class="nav-link" href="<?php echo e(route('guides.index')); ?>"
                role="button">
                <i class="la la-list-alt font-size-18 mr-1"></i>
               <span>إدارة القوائم</span>
            </a>
        </li>
    <?php endif; ?>

    <?php if($user && $user->hasPermission(97)): ?>
        <li class="nav-item dropdown">
            <a class="nav-link" href="<?php echo e(route('news.index')); ?>"
                role="button">
                <i class="la la-newspaper font-size-18 mr-1"></i>
               <span>إدارة الأخبار</span>
            </a>
        </li>
    <?php endif; ?>

    <?php if($user && $user->hasPermission(102)): ?>
        <li class="nav-item dropdown">
            <a class="nav-link" href="<?php echo e(route('trophee_sportif.index')); ?>"
                role="button">
                <i class="la la-medal font-size-18 mr-1"></i>
               <span>إدارة التتويجات الرياضية</span>
            </a>
        </li>
    <?php endif; ?>
    
    <?php if($user && $user->hasPermission(107)): ?>
        <li class="nav-item dropdown">
            <a class="nav-link" href="<?php echo e(route('sliders.index')); ?>"
                role="button">
                <i class="la la-images font-size-18 mr-1"></i>
               <span>إدارة الواجهة الامامية</span>
            </a>
        </li>
    <?php endif; ?>

	<?php if($user && $user->hasPermission(1)): ?>
		<li class="nav-item dropdown">
            <a class="nav-link" href="<?php echo e(route('concours.index')); ?>"
                role="button">
                 <i class="la la-user-graduate font-size-18 mr-1"></i>
             <span>ادارة الترشحات للمناظرات الخارجية</span>
            </a>
        </li>
    <?php endif; ?>
	
	<?php if($user && $hasAubergePermission): ?>
        <li class="nav-item has-submenu">
            <a class="nav-link" href="#" id="navbarDropdownTerritorial"
                role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                <i class="la la-hotel font-size-18 mr-1"></i>
                <span>الحجوزات والإقامة</span>
            </a>
            <div class="sub-menu" aria-labelledby="navbarDropdownTerritorial">
                <?php if($user && $user->hasPermission(115)): ?>
                    <a class="sub-menu-link" href="<?php echo e(route('auberges.index')); ?>">
                        <i class="la la-building font-size-18 mr-1"></i>
                        <span>إدارة المركبات و مراكز اقامة الشباب</span>
                    </a>
                <?php endif; ?>
				
				<?php if($user && $user->hasPermission(129)): ?>
					<a class="sub-menu-link" href="<?php echo e(route('auberges2.show', $user->auberge_id)); ?>">
						<i class="la la-building font-size-18 mr-1"></i>
						<span>إدارة <?php echo e($user->auberge->nom_ar); ?></span>
					</a>
				<?php endif; ?>

				
				<?php if($user && $user->hasPermission(117)): ?>
					<a class="sub-menu-link" href="<?php echo e(route('reservation.index')); ?>">
						<i class="la la-calendar-check font-size-18 mr-1"></i>
						<span>إدارة الحجوزات</span>
					</a>
				<?php endif; ?>
				
				<?php if($user && $user->hasPermission(119)): ?>
					<a class="sub-menu-link" href="<?php echo e(route('desc_gouvr.index')); ?>">
						<i class="la la-map font-size-18 mr-1"></i>
						<span>إدارة الولايات</span>
					</a>
				<?php endif; ?>
            </div>  
        </li>
	<?php endif; ?>
	
	
        <!--li class="nav-item dropdown">
            <a class="nav-link" href="<?php echo e(route('avis.index')); ?>"
                role="button">
                <i class="la la-bookmark font-size-18 mr-1"></i>
                <span> إدارة الآراء</span>
            </a>
        </li-->
		
		<?php if($user && $user->hasPermission(124)): ?>
			<li class="nav-item dropdown">
				<a class="nav-link" href="<?php echo e(route('builder.index')); ?>"
					role="button">
					<i class="la la-file-code font-size-18 mr-1"></i>
					<span> إدارة الصفحات الجديدة</span>
				</a>
			</li>
		<?php endif; ?>
		
        <?php if($user && $user->hasPermission(1)): ?> 
             <li class="nav-item has-submenu">
                <a class="nav-link" href="#" id="navbarDropdownAccessManagement"
                    role="button" data-toggle="dropdown" aria-haspopup="true" aria-expanded="false">
                    <i class="la la-bookmark font-size-18 mr-1"></i>
                    <span>إدارة  الرسائل و الاشتراكات</span>
                </a>
                <div class="sub-menu" aria-labelledby="navbarDropdownAccessManagement">
                   
                        <a class="sub-menu-link" href="<?php echo e(route('newsletters.index')); ?>">
                            <i class="la la-key font-size-18 mr-1"></i>
                            <span>إدارة الاشتراكات</span>
                        </a>

                       <a class="sub-menu-link" href="<?php echo e(route('contacts.index')); ?>">
                            <i class="la la-user-tag font-size-18 mr-1"></i>
                            <span>إدارة الرسائل</span>
                        </a>

                </div>
            </li>
        <?php endif; ?>
    <li>
        <hr class="sidebar-divider border-top-color">
    </li>
    
    <?php if(auth()->guard()->check()): ?>
    <li class="nav-item">
        <a class="nav-link" href="<?php echo e(route('utilisateurs.profil', auth()->user()->id)); ?>">
            <i class="la la-user font-size-18 mr-1"></i>
            <span>ملفي</span>
        </a>
    </li>
    <?php endif; ?>

    <?php if(auth()->guard()->guest()): ?>
    <li class="nav-item">
        <a class="nav-link" href="<?php echo e(route('admin')); ?>">
            <i class="la la-sign-in-alt font-size-18 mr-1"></i>
            <span>تسجيل الدخول</span>
        </a>
    </li>
    <?php endif; ?>
    <li class="nav-item">
        <a class="nav-link" href=""
            onclick="event.preventDefault(); document.getElementById('logoutFormadmin').submit();">
            <i class="la la-power-off font-size-18 mr-1"></i>
            <span>تسجيل خروج</span>
        </a>
        <form id="logoutFormadmin" action="<?php echo e(route('logout_admin')); ?>" method="POST" style="display: none;">
            <?php echo csrf_field(); ?>
        </form>
    </li>
</ul>
<?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/partials/sidebar.blade.php ENDPATH**/ ?>