<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <style>
        body {
            font-family: "amiri", serif;
            direction: rtl;
            text-align: right;
            font-size: 13px;
        }
        h1,h2,h3,h4,h5 {
            font-family: "amiri", serif;
            text-align: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            direction: rtl;
            margin-bottom: 10px;
        }
        th, td {
            border: 1px solid #000;
            padding: 6px;
            text-align: right;
            vertical-align: middle;
            font-family: "amiri", serif;
        }
        .section {
            border: 1px solid #000;
            padding: 10px;
            margin-bottom: 15px;
        }
        .section-title {
            font-weight: bold;
            margin-bottom: 8px;
            text-decoration: underline;
        }
    </style>
</head>
<body>

<div class="header">
    <table width="100%" style="border: none;">
        <tr>
            <td style="width:120px; text-align:right; border:none;">
                <img src="<?php echo e(public_path('storage/logo.png')); ?>"
                     style="width:90px; height:auto;">
            </td>

            <td style="text-align:center; border:none;">
                <div style="display:inline-block; text-align:center;">
                    <h1>الجمهورية التونسية</h1>
                    <h2>وزارة الشباب و الرياضة</h2>
                    <h3>استمارة إيداع كراس الشروط لإحداث قاعة خاصة للرياضة</h3>
                </div>
            </td>

            <td style="width:120px; border:none;"></td>
        </tr>
    </table>
</div>



<div class="section">
    <div class="section-title">الوضعية</div>
    <table>
        <tr>
            <td>حالة المطلب</td>
            <td>
                <?php if($immobilier->id_statut == 1): ?>
                    قبول
                <?php elseif($immobilier->id_statut == 3): ?>
                    رفض
                <?php else: ?>
                    في الانتظار
                <?php endif; ?>
            </td>
        </tr>
        <?php if($immobilier->id_statut == 3 && !empty($immobilier->commentaire_motif)): ?>
        <tr>
            <td>سبب الرفض</td>
            <td><?php echo e($immobilier->commentaire_motif); ?></td>
        </tr>
        <?php endif; ?>
    </table>
</div>

<div class="section">
    <div class="section-title">هوية الباعث</div>
    <table>
        <tr>
            <td>الاسم و اللقب أو الاسم التجاري</td>
            <td><?php echo e($immobilier->utilisateur->nom_prenom ?? '-'); ?></td>
        </tr>
        <tr>
            <td>رقم الهاتف</td>
            <td><?php echo e($immobilier->utilisateur->tel ?? '-'); ?></td>
        </tr>
        <tr>
            <td>البريد الإلكتروني</td>
            <td><?php echo e($immobilier->utilisateur->email ?? '-'); ?></td>
        </tr>
        <tr>
            <td>العنوان الشخصي</td>
            <td><?php echo e($immobilier->utilisateur->adresse ?? '-'); ?></td>
        </tr>
        <tr>
            <td>الهوية الشخصية</td>
            <td><?php echo e($typesIdentite->where('id_type', $immobilier->utilisateur->id_type_identite ?? '')->first()->type_ar ?? '-'); ?></td>
        </tr>
    </table>
</div>

<div class="section">
    <div class="section-title">هوية العقار</div>
    <table>
        <tr>
            <td>عنوان العقار</td>
            <td><?php echo e($immobilier->adresse_imm ?? '-'); ?></td>
        </tr>
        <tr>
            <td>الولاية</td>
            <td><?php echo e($gouvernorats->where('id_gouver', $immobilier->gouvernorat_id ?? '')->first()->nom_ar ?? '-'); ?></td>
        </tr>
        <tr>
            <td>البلدية</td>
            <td><?php echo e($delegations->where('id_delegation', $immobilier->delegation_id ?? '')->first()->nom_ar ?? '-'); ?></td>
        </tr>
        <tr>
            <td>صيغة العقار</td>
            <td><?php echo e($typesImmobilier->where('id_type', $immobilier->type_imm_id ?? '')->first()->type_ar ?? '-'); ?></td>
        </tr>
        <tr>
            <td>المساحة الجملية للعقار</td>
            <td><?php echo e($immobilier->superfici_m2 ?? '-'); ?> م²</td>
        </tr>
        <tr>
            <td>صيغة استغلال العقار</td>
            <td><?php echo e($usagesImmobilier->where('id_usage_imm', $immobilier->usage_id ?? '')->first()->usage_ar ?? '-'); ?></td>
        </tr>
    </table>
</div>


<div class="section">
    <div class="section-title">مكونات العقار</div>
    <table>
        <thead>
            <tr>
                <th>المكوّن</th>
                <th>نعم / لا</th>
                <th>العدد</th>
                <th>المساحة</th>
            </tr>
        </thead>
        <tbody>
            <?php
            $components = [
                'salle_exercice' => 'قاعة التمارين',
                'piscine' => 'حوض مائي',
                'vestiaire' => 'حجرات ملابس',
                'unitaires_sanitaire' => 'وحدات صحية',
                'stockage_conser' => 'فضاء للخزن وحفظ الأثاث والمعدات',
                'espace_exterieur' => 'فضاء خارجي',
                'garage' => 'مأوى سيارات'
            ];
            ?>
            <?php $__currentLoopData = $components; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $comp => $label): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
            <tr>
                <td><?php echo e($label); ?></td>
                <td><?php if($immobilier->$comp == 1): ?> نعم <?php elseif($immobilier->$comp == 0): ?> لا <?php else: ?> - <?php endif; ?></td>
                <td><?php if($immobilier->$comp == 1 && in_array($comp, ['salle_exercice','piscine','vestiaire'])): ?> <?php echo e($immobilier->{'nbr_'.$comp} ?? '-'); ?> <?php else: ?> - <?php endif; ?></td>
                <td><?php if($immobilier->$comp == 1): ?> <?php echo e($immobilier->{'superface_'.$comp} ? $immobilier->{'superface_'.$comp}.' م²' : '-'); ?> <?php else: ?> - <?php endif; ?></td>
            </tr>
            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
        </tbody>
    </table>
    <p>مساحات اخرى: <?php echo e($immobilier->autres_surfaces ?? '-'); ?> م²</p>
</div>

</body>
</html>
<?php /**PATH /home/preprov/www/mjs/back/resources/views/backoffice/investissement/gestion_salle_sport/salle_sport/pdf.blade.php ENDPATH**/ ?>