<?php $__env->startSection('content'); ?>
<style>
    .btn-success-custom { background-color: green; color: white; }
    .btn-success-custom i, .btn-orange i { color: white; }
    .btn-orange { background-color: orange; color: white; }
</style>

<?php if(Auth::check()): ?>
<div class="container-fluid dashboard-inner-body-container">
  <div class="row">
    <div class="col-lg-12">
      <div class="block-card dashboard-card mb-4 px-0">
        <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
          <h2 class="widget-title pb-0">المستخدمون</h2>
          <a class="btn btn-success font-weight-medium" href="<?php echo e(route('utilisateurs.create')); ?>">
            <i class="la la-plus mr-1"></i> إضافة مستخدم
          </a>
        </div>

<div class="block-card-header px-4 border-bottom-0 pb-0"> 
    <form method="GET" action="<?php echo e(route('utilisateurs.index')); ?>">
        <div class="form-row align-items-center">
            <div class="col-auto" style="width: 250px;">
                <select id="search-option" class="form-control" name="search_option" onchange="showSearchInput(this.value)">
                    <option value="">اختر</option>
                    <option value="cin" <?php echo e(request('search_option') == 'cin' ? 'selected' : ''); ?>>رقم بطاقة التعريف</option>
                    <option value="role" <?php echo e(request('search_option') == 'role' ? 'selected' : ''); ?>>فئة المستخدم</option>
                </select>
            </div>

            <div class="col" id="searchByCIN" style="display: none; width: 250px;">
                <input type="text" class="form-control" name="cin" placeholder="أدخل رقم بطاقة التعريف" value="<?php echo e(request('cin')); ?>">
            </div>

            <div class="col" id="searchByRole" style="display: none; width: 250px;">
                <select name="role_id" class="form-control">
                    <option value="">-- فئة المستخدم --</option>
                    <?php $__currentLoopData = $roles; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $role): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                        <option value="<?php echo e($role->id_roles); ?>" <?php echo e(request('role_id') == $role->id_roles ? 'selected' : ''); ?>>
                            <?php echo e($role->nom_ar); ?>

                        </option>
                    <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                </select>
            </div>

            <div class="col d-flex">
                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium" style="width: 100px;">بحث</button>
                <a href="<?php echo e(route('utilisateurs.index')); ?>" class="btn btn-secondary font-weight-medium" style="width: 100px; margin-right: 5px;">إعادة تعيين</a>
            </div>
        </div>
    </form>
</div>
        <div class="block-card-body">
          <?php if(session('ok')): ?>
            <div class="alert alert-success"><?php echo e(session('ok')); ?></div>
          <?php endif; ?>

          <div class="my-table table-responsive">
            <table class="table align-items-center table-flush mb-0">
              <thead class="thead-light">
                <tr>
                  <th width="5%">#</th>
                  <th width="15%">الاسم</th>
                  <th width="15%">رقم بطاقة التعريف</th>
                  <th width="20%">البريد الإلكتروني</th>
                  <th width="15%">العنوان</th>
                  <th width="10%">الحالة</th>
                  <th width="10%">فئة المستخدم</th>
                  <th width="30%"></th>
                </tr>
              </thead>
              <tbody>
                <?php $__empty_1 = true; $__currentLoopData = $utilisateurs; $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $u): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); $__empty_1 = false; ?>
                  <tr>
                    <td><?php echo e($u->id); ?></td>
                    <td><?php echo e($u->nom_prenom); ?></td>
                    <td><?php echo e($u->cin); ?></td>
                    <td><?php echo e($u->email); ?></td>
                    <td><?php echo e($u->adresse); ?></td>
                    <td>
                      <span class="badge <?php echo e($u->est_active ? 'badge-success' : 'badge-secondary'); ?>">
                        <?php echo e($u->est_active ? 'مفعل' : 'غير مفعل'); ?>

                      </span>
                    </td>
                    <td>
                     
                      <?php if($u->roles->isNotEmpty()): ?>
                          <span class="badge badge-info"><?php echo e($u->roles->first()->nom_ar); ?></span>
                      <?php else: ?>
                          <span class="badge badge-secondary">بدون دور</span>
                      <?php endif; ?>
                    </td>
                    <td class="btn-group">
                      <a class="btn btn-info btn-sm mr-2" href="<?php echo e(route('utilisateurs.show', $u)); ?>">
                        <i class="la la-eye mr-1"></i> عرض
                      </a>

                      

                      <button type="button"
                        class="btn btn-orange btn-sm mr-2" onclick="return confirmAction('هل تريد تعديل هذا المستخدم؟', '<?php echo e(route('utilisateurs.edit', $u)); ?>')"
                          title="تعديل">
                          <i class="la la-edit"></i>تعديل
                      </button>

                      <form action="<?php echo e(route('utilisateurs.activation', $u)); ?>" method="POST" class="mr-2" style="display:inline;">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('PATCH'); ?>
                        <button type="submit" class="btn btn-sm <?php echo e($u->est_active ? 'btn-warning' : 'btn-success-custom'); ?>">
                          <i class="la la-toggle-<?php echo e($u->est_active ? 'off' : 'on'); ?> mr-1"></i>
                          <?php echo e($u->est_active ? 'تعطيل' : 'تفعيل'); ?>

                        </button>
                      </form>

                      <form action="<?php echo e(route('utilisateurs.destroy', $u->id)); ?>" 
                          method="POST" 
                          onsubmit="return confirm('هل تريد حقًا حذف هذه الاستمارة؟');">
                        <?php echo csrf_field(); ?>
                        <?php echo method_field('DELETE'); ?>
                        <button type="button" 
                                onclick="return confirmAction('هل تريد حقًا حذف هذا المستخدم؟', null, this.closest('form'))" 
                                class="btn bg-rgb-primary1 font-weight-medium  mr-2">
                            <i class="la la-trash mr-1"> حذف</i>
                        </button>
                    </form>

                    </td>
                  </tr>
                <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); if ($__empty_1): ?>
                  <tr><td colspan="8" class="text-center">لا يوجد مستخدمون.</td></tr>
                <?php endif; ?>
              </tbody>
            </table>
          </div>

          <div class="mt-3">
            <?php echo e($utilisateurs->links('pagination::bootstrap-5')); ?>

          </div>
        </div>

      </div>
    </div>
  </div>
</div>
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>

<style>
.table-news th, 
.table-news td {
    vertical-align: middle;
    text-align: center;
}

.table-news th:nth-child(2),
.table-news td:nth-child(2) {
    text-align: right !important;
    direction: rtl;
}

.status-badge {
    display: inline-block;
    padding: 6px 12px;
    border-radius: 12px;
    font-size: 14px;
    font-weight: 600;
    color: #fff;
    min-width: 60px;
    text-align: center;
    box-shadow: 0 2px 4px rgba(0,0,0,0.1);
}

.status-badge--success {
    background-color: #e8f9ee; 
    color: #27ae60;           
}

.status-badge--danger {
    background-color: #fde8ea; 
    color: #e74c3c;            
}


</style>
<?php else: ?>
    <script>
        window.location.href = "<?php echo e(route('login')); ?>";
    </script>
<?php endif; ?>
<?php $__env->stopSection(); ?>

<?php echo $__env->make('backoffice.dashboard', array_diff_key(get_defined_vars(), ['__data' => 1, '__path' => 1]))->render(); ?><?php /**PATH /home/preprov/www/back/resources/views/backoffice/role-permission/user/index.blade.php ENDPATH**/ ?>