<?php

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Route;

/*$cin_list = [
    '12345678' => ['date_delivrance_cin' => '2025-01-01', 'nom_prenom' => 'Ali Ben Ahmed'],
    '87654321' => ['date_delivrance_cin' => '2024-05-10', 'nom_prenom' => 'Sara Romdhani'],
    '11223344' => ['date_delivrance_cin' => '2023-12-15', 'nom_prenom' => 'Mohamed Khaled'],
    '10785468' => ['date_delivrance_cin' => '2025-01-01', 'nom_prenom' => 'Adem Sayari'],
    '80179632' => ['date_delivrance_cin' => '2024-05-10', 'nom_prenom' => 'Salma Massoudi'],
    '10025412' => ['date_delivrance_cin' => '2023-12-15', 'nom_prenom' => 'Morad Ouni'],
    '44987401' => ['date_delivrance_cin' => '2025-03-20', 'nom_prenom' => 'Nour Ben Ali'],
    '07845120' => ['date_delivrance_cin' => '2022-08-30', 'nom_prenom' => 'Rawia Ben Salem'],
];

Route::post('/check-cin', function (Request $request) use ($cin_list) {

    $request->validate([
        'cin' => (string) $request->input('cin'),
        'date_delivrance_cin' => 'required|date',
    ], [
        'cin.required' => 'الرجاء إدخال رقم بطاقة التعريف',
        'cin.size' => 'رقم بطاقة التعريف يجب أن يحتوي على 8 أرقام',
        'date_delivrance_cin.required' => 'الرجاء إدخال تاريخ الإصدار',
        'date_delivrance_cin.date' => 'تاريخ الإصدار غير صالح',
    ]);

    if (isset($cin_list[$request->cin]) && $cin_list[$request->cin]['date_delivrance_cin'] === $request->date_delivrance_cin) {
        return response()->json([
            'status' => 'success',
            'message' => 'CIN vérifié avec succès',
            'data' => [
                'cin' => $request->cin,
                'date_delivrance_cin' => $request->date_delivrance_cin,
                'nom_prenom' => $cin_list[$request->cin]['nom_prenom'],
            ],
        ]);
    }


    return response()->json([
        'status' => 'error',
        'message' => 'CIN invalide ou date incorrecte',
    ], 422);
});
*/



