@extends('layouts.app')

@section('content')

<div id="preloader">
    <div class="preloader">
        <span></span>
        <span></span>
    </div>
</div>

<div id="magic-cursor">
    <div id="ball"></div>
</div>
 
<button class="scroll-top scroll-to-target" data-target="html" style="background-color: var(--it-theme-1); color: white;">
    <svg xmlns="http://www.w3.org/2000/svg" fill="none" viewBox="0 0 24 24" stroke-width="1.5" stroke="currentColor" class="size-6">
    <path stroke-linecap="round" stroke-linejoin="round" d="m4.5 18.75 7.5-7.5 7.5 7.5" />
    <path stroke-linecap="round" stroke-linejoin="round" d="m4.5 12.75 7.5-7.5 7.5 7.5" />
    </svg>
</button>



         <main>

            <!-- hero-area-start -->
            <div class="it-hero-2-area pt-50">
               <div class="slider">
                  <!-- First Slide -->
                  <div class="slide active">
                     <div class="it-hero-2-overlay fix gray-bg z-index-1" data-background="assets/img/hero/images2.jpg">
                        <div class="container">
                           <div class="row align-items-center">
                              <div class="col-xl-6 col-lg-6">
                                 <div class="it-hero-2-content">
                                    <h4 class="it-hero-3-subtitle it-split-in-right">
                                       <span>الجمهورية التونسية</span>
                                    </h4>
                                    <h1 class="it-hero-2-title it-split-in-right">
                                       وزارة الشباب والرياضة
                                    </h1>
                                    <div class="it-hero-2-text wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".5s">
                                       <p class="mb-30"><br/></p>
                                    </div>
                                    <div class="it-hero-btn d-sm-flex align-items-center">
                                       <div class="it-fade-anim" data-fade-from="top" data-ease="bounce" data-delay=".8">
                                          <a href="contact.html" class="it-btn-orange mr-30 wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".7s">
                                             <span>
                                                <span class="text-1">إتصل بنا</span>
                                                <span class="text-2">إتصل بنا</span>
                                             </span>
                                             <i>
                                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                </svg>
                                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                </svg>
                                             </i>
                                          </a>
                                       </div>
                                       <div class="it-fade-anim" data-fade-from="top" data-ease="bounce" data-delay="1">
                                          <a href="service.html" class="it-btn-border wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".9s">
                                             <span>
                                                <span class="text-1">آخر الأخبار</span>
                                                <span class="text-2">آخر الأخبار</span>
                                             </span>
                                             <i>
                                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                </svg>
                                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                </svg>
                                             </i>
                                          </a>
                                       </div>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-xl-6 col-lg-6">
                                 <div class="it-contact-form-box z-index-1 p-relative wow img-anim-top" data-wow-duration="1.5s" data-wow-delay="0.1">
                                    <h4 class="it-contact-form-title mb-10" style="color:#FFFFFF;">ابحث في الموقع</h4>
                                    <form action="#">
                                       <div class="it-contact-input-wrap">
                                          <div class="row gx-30">
                                             <div class="col-sm-12 mb-20">
                                                <div class="it-contact-input-box">
                                                   <input class="ph" type="text" placeholder="أدخل كلمة البحث..." style="color:#FFFFFF;">
                                                </div>
                                             </div>
                                          </div>
                                          <div class="it-contact-btn">
                                             <button type="submit" class="it-btn-orange">
                                                <span>
                                                   <span class="text-1">بحث</span>
                                                   <span class="text-2">بحث</span>
                                                </span>
                                                <i>
                                                   <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                      <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                   </svg>
                                                   <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                      <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                   </svg>
                                                </i>
                                             </button>
                                          </div>
                                       </div>
                                    </form>
                                    <img class="it-contact-shape-1" src="assets/img/shape/contact-1-1.png" alt="">
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <!-- Second Slide -->
                  <div class="slide">
                       <div class="it-hero-2-overlay fix gray-bg z-index-1" data-background="assets/img/hero/1.jpg">
                        <div class="container">
                           <div class="row align-items-center">
                              <div class="col-xl-6 col-lg-6">
                                 <div class="it-hero-2-content">
                                    <h4 class="it-hero-3-subtitle it-split-in-right">
                                       <span>الجمهورية التونسية</span>
                                    </h4>
                                    <h1 class="it-hero-2-title it-split-in-right">
                                       وزارة الشباب والرياضة
                                    </h1>
                                    <div class="it-hero-2-text wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".5s">
                                       <p class="mb-30"><br/></p>
                                    </div>
                                    <div class="it-hero-btn d-sm-flex align-items-center">
                                       <div class="it-fade-anim" data-fade-from="top" data-ease="bounce" data-delay=".8">
                                          <a href="contact.html" class="it-btn-orange mr-30 wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".7s">
                                             <span>
                                                <span class="text-1">إتصل بنا</span>
                                                <span class="text-2">إتصل بنا</span>
                                             </span>
                                             <i>
                                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                </svg>
                                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                </svg>
                                             </i>
                                          </a>
                                       </div>
                                       <div class="it-fade-anim" data-fade-from="top" data-ease="bounce" data-delay="1">
                                          <a href="service.html" class="it-btn-border wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".9s">
                                             <span>
                                                <span class="text-1">آخر الأخبار</span>
                                                <span class="text-2">آخر الأخبار</span>
                                             </span>
                                             <i>
                                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                </svg>
                                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                </svg>
                                             </i>
                                          </a>
                                       </div>
                                    </div>
                                 </div>
                              </div>
                       <div class="col-xl-6 col-lg-6">
   <div class="it-contact-form-box z-index-1 p-relative wow img-anim-top" 
        data-wow-duration="1.5s" data-wow-delay="0.1">
      
      <h4 class="it-contact-form-title mb-10" style="color:#FFFFFF;">احجز في مركب شباب داخل تونس</h4>
      
      <form id="searchForm" action="#">
         <div class="it-contact-input-wrap">
            <div class="row gx-30">
              
               <!-- Auberge (optionnel) -->
               <div class="col-sm-12 mb-20">
                  <div class="it-contact-input-box">
                     <input class="ph" type="text" id="auberge" name="auberge" placeholder="ابحث عن مركب شباب للحجز..."  style="color:#FFFFFF;">
                  </div>
               </div>
            </div>
            
            <!-- Bouton -->
            <div class="it-contact-btn">
               <button type="submit" class="it-btn-orange">
                  <span>
                     <span class="text-1">بحث</span>
                     <span class="text-2">بحث</span>
                  </span>
                  <i>
                     <svg width="12" height="13" viewBox="0 0 12 13" fill="none">
                        <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white"/>
                     </svg>
                  </i>
               </button>
            </div>
         </div>
      </form>

      <img class="it-contact-shape-1" src="assets/img/shape/contact-1-1.png" alt="">
   </div>
</div>
                           </div>
                        </div>
                     </div>
                  </div>
  <!-- Third Slide -->
                  <div class="slide">
                       <div class="it-hero-2-overlay fix gray-bg z-index-1" data-background="assets/img/hero/4.jpg">
                        <div class="container">
                           <div class="row align-items-center">
                              <div class="col-xl-6 col-lg-6">
                                 <div class="it-hero-2-content">
                                    <h4 class="it-hero-3-subtitle it-split-in-right">
                                       <span>الجمهورية التونسية</span>
                                    </h4>
                                    <h1 class="it-hero-2-title it-split-in-right">
                                       وزارة الشباب والرياضة
                                    </h1>
                                    <div class="it-hero-2-text wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".5s">
                                       <p class="mb-30"><br/></p>
                                    </div>
                                    <div class="it-hero-btn d-sm-flex align-items-center">
                                       <div class="it-fade-anim" data-fade-from="top" data-ease="bounce" data-delay=".8">
                                          <a href="contact.html" class="it-btn-orange mr-30 wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".7s">
                                             <span>
                                                <span class="text-1">إتصل بنا</span>
                                                <span class="text-2">إتصل بنا</span>
                                             </span>
                                             <i>
                                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                </svg>
                                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                </svg>
                                             </i>
                                          </a>
                                       </div>
                                       <div class="it-fade-anim" data-fade-from="top" data-ease="bounce" data-delay="1">
                                          <a href="service.html" class="it-btn-border wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".9s">
                                             <span>
                                                <span class="text-1">آخر الأخبار</span>
                                                <span class="text-2">آخر الأخبار</span>
                                             </span>
                                             <i>
                                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                </svg>
                                                <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                                                   <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
                                                </svg>
                                             </i>
                                          </a>
                                       </div>
                                    </div>
                                 </div>
                              </div>
                       <div class="col-xl-6 col-lg-6">
   <div class="it-contact-form-box z-index-1 p-relative wow img-anim-top" 
        data-wow-duration="1.5s" data-wow-delay="0.1">
      
      <h4 class="it-contact-form-title mb-10" style="color:#FFFFFF;">بعث المشاريع</h4>
      
      <form id="searchForm" action="#">
         <div class="it-contact-input-wrap">
            <div class="row gx-30">
              
               <!-- Auberge (optionnel) -->
               <div class="col-sm-12 mb-20">
                  <div class="it-contact-input-box">
                     <input class="ph" type="text" id="auberge" name="auberge" placeholder="اكتب نوع الاستثمار الذي تريد القيام به..."   style="color:#FFFFFF;">
                  </div>
               </div>
            </div>
            
            <!-- Bouton -->
            <div class="it-contact-btn">
               <button type="submit" class="it-btn-orange">
                  <span>
                     <span class="text-1">بحث</span>
                     <span class="text-2">بحث</span>
                  </span>
                  <i>
                     <svg width="12" height="13" viewBox="0 0 12 13" fill="none">
                        <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white"/>
                     </svg>
                  </i>
               </button>
            </div>
         </div>
      </form>

      <img class="it-contact-shape-1" src="assets/img/shape/contact-1-1.png" alt="">
   </div>
</div>
                           </div>
                        </div>
                     </div>
                  </div>
                             
			  </div>
            </div>
            <!-- hero-area-end -->
			      <!-- about-area-start -->
            <div class="it-about-2-area p-relative pt-95 pb-45">
               <img class="it-about-2-shape-1" src="assets/img/shape/about-2-1.png" alt="">
               <div class="container">
                  <div class="row align-items-center">
                     <div class="col-xl-6 col-lg-6 order-1 order-lg-0">
                        <div class="it-about-2-thumb p-relative">
                           <img src="assets/img/about/ministere.jpg" alt="">
                          <!-- <div class="it-about-2-experience wow itfadeLeft" data-wow-duration=".9s"
                              data-wow-delay=".5s">
                              <span><i>25</i> +Years</span>
                              <p>Experience</p>
                           </div>-->
                        </div>
                     </div>
                     <div class="col-xl-6 col-lg-6 order-0 order-lg-1">
                        <div class="it-about-2-right">
                           <div class="it-section-title-box mb-20">
                              <span class="it-section-subtitle">حول الوزارة</span>
                              <h4 class="it-section-title it-split-in-right mb-0">لمحة عن الوزارة وأنشطتها</h4>
                           </div>
                           <div class="it-about-2-text">
                              <p class="mb-30">تُعد وزارة الشباب والرياضة في الجمهورية التونسية الجهة الحكومية المسؤولة عن تنمية وتمكين الشباب وتشجيع النشاطات الرياضية في البلاد. تسعى الوزارة إلى تطوير السياسات والبرامج التي تساهم في بناء جيل قادر على المشاركة الفعالة في المجتمع وتعزيز القيم الوطنية والثقافية.

تعمل الوزارة على توفير بيئة ملائمة للشباب، من خلال دعم المبادرات الشبابية، وتنظيم الفعاليات والأنشطة الرياضية، وتحفيز المواهب، وتعزيز الرياضة الوطنية على جميع المستويات. كما تسعى إلى التعاون مع مختلف المؤسسات المحلية والدولية لتطوير برامج تدريبية وتعليمية ترتقي بالمهارات والقدرات لدى الشباب والرياضيين.

تلعب وزارة الشباب والرياضة دوراً محورياً في بناء مجتمع نشيط وصحي، يسعى إلى تحقيق التنمية المستدامة ويعزز الروح الرياضية والقيم الإنسانية.

</p>
                           </div>
                           <div class="row">
                              <div class="col-xxl-6 col-xl-7 col-lg-6 col-md-6">
                                 
                                 <div class="it-about-2-btn">
                                    <a href="contact.html" class="it-btn-orange">
                                       <span>
                                          <span class="text-1">إقرا المزيد</span>
                                          <span class="text-2">إقرا المزيد</span>
                                       </span>
                                       <i>
                                          <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                             <path
                                                d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                fill="white" />
                                          </svg>
                                          <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                             <path
                                                d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                fill="white" />
                                          </svg>
                                       </i>
                                    </a>
                                 </div>
                              </div>
                             
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <!-- about-area-end -->
 <!-- blog-area-start -->
            <div class="it-blog-area pt-45 pb-45"  style="background:ghostwhite;">
               <div class="container">
                  <div class="it-blog-top-wrap pb-65">
                     <div class="row align-items-end">
                        <div class="col-xl-5 col-lg-6">
                           <div class="it-section-title-box">
                              <span class="it-section-subtitle">آخر الأخبار</span>
                              <h4 class="it-section-title mb-0 it-split-in-right">اطلع على أحدث المستجدات</h4>
                           </div>
                        </div>
                        <div class="col-xl-7 col-lg-6">
                           <div class="it-blog-top-right d-flex justify-content-lg-end wow itfadeUp"
                              data-wow-duration=".9s" data-wow-delay=".3s">
                              <div>
                                
                                 <div class="it-blog-btn">
                                    <a href="blog.html" class="it-btn-orange">

                                       <span>
                                          <span class="text-1">المزيد من آخر الأخبار</span>
                                          <span class="text-2">المزيد من آخر الأخبار</span>
                                       </span>
                                       <i>
                                          <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                             <path
                                                d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                fill="white" />
                                          </svg>
                                          <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                             <path
                                                d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                fill="white" />
                                          </svg>
                                       </i>
                                    </a>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
                  <div class="row gx-35">
                     <div class="col-xl-6 col-lg-6 wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".3s">
                        <div class="it-blog-item white-bg mb-35">
                           <div class="row gx-0">
                              <div class="col-md-6">
                                 <div class="it-blog-thumb">
                                    <a href="blog-details.html">
                                       <img class="w-100" src="assets/img/blog/4.jpg" alt="">
                                       <img class="w-100" src="assets/img/blog/4.jpg" alt="">
                                    </a>
                                 </div>
                              </div>
                              <div class="col-md-6">
                                 <div class="it-blog-content d-md-flex justify-content-center align-items-center">
                                    <div>
                                       <div class="it-blog-meta mb-30">
                                          <span>
                                             <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                   d="M0.468788 13.1562H2.81253V14.5625C2.81253 14.8213 3.02241 15.0312 3.28128 15.0312H15.5313C15.7901 15.0312 16 14.8213 16 14.5625V2.375C16 2.11612 15.7901 1.90625 15.5313 1.90625H13.1875V1.4375C13.1875 1.17862 12.9776 0.96875 12.7188 0.96875C12.4599 0.96875 12.25 1.17862 12.25 1.4375V1.90625H9.87502V1.4375C9.87502 1.17862 9.66514 0.96875 9.40627 0.96875C9.1474 0.96875 8.93752 1.17862 8.93752 1.4375V1.90625H6.59378V1.4375C6.59378 1.17862 6.3839 0.96875 6.12503 0.96875C5.86615 0.96875 5.65628 1.17862 5.65628 1.4375V1.90625H3.28128C3.02241 1.90625 2.81253 2.11612 2.81253 2.375V5.18749C2.81253 8.64217 1.37676 11.2999 0.168695 12.3274C0.0170703 12.4537 -0.0391483 12.6615 0.0280078 12.8471C0.0952264 13.0326 0.271414 13.1562 0.468788 13.1562ZM15.0625 14.0937H3.75003V13.1562H12.7188C12.8284 13.1562 12.9346 13.1178 13.0189 13.0476C13.5824 12.5782 14.4552 11.4608 15.0625 10.0296V14.0937ZM3.75003 2.84375H5.65628V3.3125C5.65628 3.57137 5.86615 3.78124 6.12503 3.78124C6.3839 3.78124 6.59378 3.57137 6.59378 3.3125V2.84375H8.93752V3.3125C8.93752 3.57137 9.1474 3.78124 9.40627 3.78124C9.66514 3.78124 9.87502 3.57137 9.87502 3.3125V2.84375H12.25V3.3125C12.25 3.57137 12.4599 3.78124 12.7188 3.78124C12.9776 3.78124 13.1875 3.57137 13.1875 3.3125V2.84375H15.0625V4.71874H3.75003V2.84375ZM3.742 5.65593H15.0542C14.9486 8.62952 13.8073 10.9691 12.535 12.2187H1.535C2.97666 10.3818 3.66466 7.99005 3.742 5.65593Z"
                                                   fill="#E03B3B" />
                                             </svg>
                                            2025.08.05
                                          </span>
                                         
                                       </div>
                                       <h4 class="it-blog-title mb-25">
                                         <a class="border-line-black news-title" href="blog-details.html">
                                             وزير الشباب والرياضة يُكرّم الجمعيات الرياضية الصاعدة ويؤكد على دعمها وتحسين ظروف عملها
                                          </a>
                                       </h4>
                                       <a class="it-blog-btn border-line-orange" href="blog-details.html">إقرا المزيد
                                          <span>
                                             <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                   d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                   fill="#E03B3B" />
                                             </svg>
                                          </span>
                                       </a>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                     <div class="col-xl-6 col-lg-6 wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".5s">
                        <div class="it-blog-item white-bg mb-35">
                           <div class="row gx-0">
                              <div class="col-md-6">
                                 <div class="it-blog-thumb">
                                    <a href="blog-details.html">
                                       <img class="w-100" src="assets/img/blog/2.jpg" alt="">
                                       <img class="w-100" src="assets/img/blog/2.jpg" alt="">
                                    </a>
                                 </div>
                              </div>
                              <div class="col-md-6">
                                 <div class="it-blog-content d-md-flex justify-content-center align-items-center">
                                    <div>
                                       <div class="it-blog-meta mb-30">
                                          <span>
                                             <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                   d="M0.468788 13.1562H2.81253V14.5625C2.81253 14.8213 3.02241 15.0312 3.28128 15.0312H15.5313C15.7901 15.0312 16 14.8213 16 14.5625V2.375C16 2.11612 15.7901 1.90625 15.5313 1.90625H13.1875V1.4375C13.1875 1.17862 12.9776 0.96875 12.7188 0.96875C12.4599 0.96875 12.25 1.17862 12.25 1.4375V1.90625H9.87502V1.4375C9.87502 1.17862 9.66514 0.96875 9.40627 0.96875C9.1474 0.96875 8.93752 1.17862 8.93752 1.4375V1.90625H6.59378V1.4375C6.59378 1.17862 6.3839 0.96875 6.12503 0.96875C5.86615 0.96875 5.65628 1.17862 5.65628 1.4375V1.90625H3.28128C3.02241 1.90625 2.81253 2.11612 2.81253 2.375V5.18749C2.81253 8.64217 1.37676 11.2999 0.168695 12.3274C0.0170703 12.4537 -0.0391483 12.6615 0.0280078 12.8471C0.0952264 13.0326 0.271414 13.1562 0.468788 13.1562ZM15.0625 14.0937H3.75003V13.1562H12.7188C12.8284 13.1562 12.9346 13.1178 13.0189 13.0476C13.5824 12.5782 14.4552 11.4608 15.0625 10.0296V14.0937ZM3.75003 2.84375H5.65628V3.3125C5.65628 3.57137 5.86615 3.78124 6.12503 3.78124C6.3839 3.78124 6.59378 3.57137 6.59378 3.3125V2.84375H8.93752V3.3125C8.93752 3.57137 9.1474 3.78124 9.40627 3.78124C9.66514 3.78124 9.87502 3.57137 9.87502 3.3125V2.84375H12.25V3.3125C12.25 3.57137 12.4599 3.78124 12.7188 3.78124C12.9776 3.78124 13.1875 3.57137 13.1875 3.3125V2.84375H15.0625V4.71874H3.75003V2.84375ZM3.742 5.65593H15.0542C14.9486 8.62952 13.8073 10.9691 12.535 12.2187H1.535C2.97666 10.3818 3.66466 7.99005 3.742 5.65593Z"
                                                   fill="#E03B3B" />
                                             </svg>
                                           2025.07.30
                                          </span>
                                         
                                       </div>
                                       <h4 class="it-blog-title mb-25">
                                          <a class="border-line-black news-title" href="blog-details.html" >
                                            أحمد الجوادي يحرز ذهبية سباق 800 متر سباحة حرة في بطولة العالم للألعاب المائية بسنغافورة
                                          </a>
                                       </h4>
                                       <a class="it-blog-btn border-line-orange" href="blog-details.html">إقرا المزيد
                                          <span>
                                             <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                   d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                   fill="#E03B3B" />
                                             </svg>
                                          </span>
                                       </a>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                     <div class="col-xl-6 col-lg-6 wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".7s">
                        <div class="it-blog-item white-bg mb-35">
                           <div class="row gx-0">
                              <div class="col-md-6">
                                 <div class="it-blog-thumb">
                                    <a href="blog-details.html">
                                       <img class="w-100" src="assets/img/blog/3.jpg" alt="">
                                       <img class="w-100" src="assets/img/blog/3.jpg" alt="">
                                    </a>
                                 </div>
                              </div>
                              <div class="col-md-6">
                                 <div class="it-blog-content d-md-flex justify-content-center align-items-center">
                                    <div>
                                       <div class="it-blog-meta mb-30">
                                          <span>
                                             <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                   d="M0.468788 13.1562H2.81253V14.5625C2.81253 14.8213 3.02241 15.0312 3.28128 15.0312H15.5313C15.7901 15.0312 16 14.8213 16 14.5625V2.375C16 2.11612 15.7901 1.90625 15.5313 1.90625H13.1875V1.4375C13.1875 1.17862 12.9776 0.96875 12.7188 0.96875C12.4599 0.96875 12.25 1.17862 12.25 1.4375V1.90625H9.87502V1.4375C9.87502 1.17862 9.66514 0.96875 9.40627 0.96875C9.1474 0.96875 8.93752 1.17862 8.93752 1.4375V1.90625H6.59378V1.4375C6.59378 1.17862 6.3839 0.96875 6.12503 0.96875C5.86615 0.96875 5.65628 1.17862 5.65628 1.4375V1.90625H3.28128C3.02241 1.90625 2.81253 2.11612 2.81253 2.375V5.18749C2.81253 8.64217 1.37676 11.2999 0.168695 12.3274C0.0170703 12.4537 -0.0391483 12.6615 0.0280078 12.8471C0.0952264 13.0326 0.271414 13.1562 0.468788 13.1562ZM15.0625 14.0937H3.75003V13.1562H12.7188C12.8284 13.1562 12.9346 13.1178 13.0189 13.0476C13.5824 12.5782 14.4552 11.4608 15.0625 10.0296V14.0937ZM3.75003 2.84375H5.65628V3.3125C5.65628 3.57137 5.86615 3.78124 6.12503 3.78124C6.3839 3.78124 6.59378 3.57137 6.59378 3.3125V2.84375H8.93752V3.3125C8.93752 3.57137 9.1474 3.78124 9.40627 3.78124C9.66514 3.78124 9.87502 3.57137 9.87502 3.3125V2.84375H12.25V3.3125C12.25 3.57137 12.4599 3.78124 12.7188 3.78124C12.9776 3.78124 13.1875 3.57137 13.1875 3.3125V2.84375H15.0625V4.71874H3.75003V2.84375ZM3.742 5.65593H15.0542C14.9486 8.62952 13.8073 10.9691 12.535 12.2187H1.535C2.97666 10.3818 3.66466 7.99005 3.742 5.65593Z"
                                                   fill="#E03B3B" />
                                             </svg>
                                             2025.08.05
                                          </span>
                                         
                                       </div>
                                       <h4 class="it-blog-title mb-25">
                                          <a class="border-line-black news-title" href="blog-details.html">
                                           الترجّي الرياضي التونسي يُتوّج بكأس السوبر 2024-2025 <br>&nbsp;
                                          </a>
                                       </h4>
                                       <a class="it-blog-btn border-line-orange" href="blog-details.html">إقرا المزيد
                                          <span>
                                             <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                   d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                   fill="#E03B3B" />
                                             </svg>
                                          </span>
                                       </a>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                     <div class="col-xl-6 col-lg-6 wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".9s">
                        <div class="it-blog-item white-bg mb-35">
                           <div class="row gx-0">
                              <div class="col-md-6">
                                 <div class="it-blog-thumb">
                                    <a href="blog-details.html">
                                       <img class="w-100" src="assets/img/blog/1.jpg" alt="">
                                       <img class="w-100" src="assets/img/blog/1.jpg" alt="">
                                    </a>
                                 </div>
                              </div>
                              <div class="col-md-6">
                                 <div class="it-blog-content d-md-flex justify-content-center align-items-center">
                                    <div>
                                       <div class="it-blog-meta mb-30">
                                          <span>
                                             <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                   d="M0.468788 13.1562H2.81253V14.5625C2.81253 14.8213 3.02241 15.0312 3.28128 15.0312H15.5313C15.7901 15.0312 16 14.8213 16 14.5625V2.375C16 2.11612 15.7901 1.90625 15.5313 1.90625H13.1875V1.4375C13.1875 1.17862 12.9776 0.96875 12.7188 0.96875C12.4599 0.96875 12.25 1.17862 12.25 1.4375V1.90625H9.87502V1.4375C9.87502 1.17862 9.66514 0.96875 9.40627 0.96875C9.1474 0.96875 8.93752 1.17862 8.93752 1.4375V1.90625H6.59378V1.4375C6.59378 1.17862 6.3839 0.96875 6.12503 0.96875C5.86615 0.96875 5.65628 1.17862 5.65628 1.4375V1.90625H3.28128C3.02241 1.90625 2.81253 2.11612 2.81253 2.375V5.18749C2.81253 8.64217 1.37676 11.2999 0.168695 12.3274C0.0170703 12.4537 -0.0391483 12.6615 0.0280078 12.8471C0.0952264 13.0326 0.271414 13.1562 0.468788 13.1562ZM15.0625 14.0937H3.75003V13.1562H12.7188C12.8284 13.1562 12.9346 13.1178 13.0189 13.0476C13.5824 12.5782 14.4552 11.4608 15.0625 10.0296V14.0937ZM3.75003 2.84375H5.65628V3.3125C5.65628 3.57137 5.86615 3.78124 6.12503 3.78124C6.3839 3.78124 6.59378 3.57137 6.59378 3.3125V2.84375H8.93752V3.3125C8.93752 3.57137 9.1474 3.78124 9.40627 3.78124C9.66514 3.78124 9.87502 3.57137 9.87502 3.3125V2.84375H12.25V3.3125C12.25 3.57137 12.4599 3.78124 12.7188 3.78124C12.9776 3.78124 13.1875 3.57137 13.1875 3.3125V2.84375H15.0625V4.71874H3.75003V2.84375ZM3.742 5.65593H15.0542C14.9486 8.62952 13.8073 10.9691 12.535 12.2187H1.535C2.97666 10.3818 3.66466 7.99005 3.742 5.65593Z"
                                                   fill="#E03B3B" />
                                             </svg>
                                             2025.07.31
                                          </span>
                                         
                                       </div>
                                       <h4 class="it-blog-title mb-25">
                                          <a class="border-line-black news-title" href="blog-details.html" >
                                          وزير الشباب والرياضة يُكرّم فريقَي المستقبل الرياضي بالمرسى والشبيبة الرياضية القيروانية بمناسبة صعودهما إلى الرابطة المحترفة الأولى
                                          </a>
                                       </h4>
                                       <a class="it-blog-btn border-line-orange" href="blog-details.html">إقرا المزيد
                                          <span>
                                             <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                   d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                   fill="#E03B3B" />
                                             </svg>
                                          </span>
                                       </a>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <!-- blog-area-end -->
			     
            <!-- about-area-start -->
            <div class="it-about-3-area p-relative pt-125 pb-125">
               <img class="it-about-shape-1" src="assets/img/shape/about-1-1.png" alt="">
               <div class="container">
                  <div class="row">
                     <div class="col-xl-12">
                        <div class="it-section-title-box text-center mb-65">
                           <span class="it-section-subtitle">فرص وخدمات</span>
                           <h4 class="it-section-title it-split-in-right mb-0">فضاء الفرص والخدمات المتاحة لدى الوزارة</h4>
                        </div>
                     </div>
                  </div>
                  <div class="row gx-35">
                      <div class="services-container" dir="rtl">

  <a href="service-details.html" class="service-box">
    <div class="title-icon-wrapper">
      <span class="service-icon"><i class="ri-file-list-line"></i></span>
      مناظرات وإنتدابات
    </div>
    <span class="service-link">اقرأ المزيد</span>
  </a>

  <a href="service-details.html" class="service-box">
    <div class="title-icon-wrapper">
      <span class="service-icon"><i class="ri-graduation-cap-line"></i></span>
      فرص تدريب وخدمات
    </div>
    <span class="service-link">اقرأ المزيد</span>
  </a>

  <a href="service-details.html" class="service-box">
    <div class="title-icon-wrapper">
      <span class="service-icon"><i class="ri-map-pin-line"></i></span>
      المندوبيات الجهوية
    </div>
    <span class="service-link">اقرأ المزيد</span>
  </a>

  <a href="service-details.html" class="service-box">
    <div class="title-icon-wrapper">
      <span class="service-icon"><i class="ri-book-line"></i></span>
      مكتبة الوزارة
    </div>
    <span class="service-link">اقرأ المزيد</span>
  </a>

  <a href="service-details.html" class="service-box">
    <div class="title-icon-wrapper">
      <span class="service-icon"><i class="ri-lightbulb-line"></i></span>
      بعث المشاريع
    </div>
    <span class="service-link">اقرأ المزيد</span>
  </a>

  <a href="service-details.html" class="service-box">
    <div class="title-icon-wrapper">
      <span class="service-icon"><i class="ri-calendar-line"></i></span>
      برامج وأنشطة
    </div>
    <span class="service-link">اقرأ المزيد</span>
  </a>

</div>

					  </div>
               </div>
            </div>
            <!-- about-area-end -->
    <!-- project-area-start -->
            <div class="it-project-area it-project-style-2 z-index-1 pb-130 pt-125">
               <div class="container">
               
				   <div class="row">
                     <div class="col-xl-12">
                        <div class="it-section-title-box text-center mb-65">
                           <span class="it-section-subtitle">بعث المشاريع</span>
                           <h4 class="it-section-title it-split-in-right mb-0">أنشطة ومشاريع تحت إشراف الوزارة</h4>
                        </div>
                     </div>
                  </div>
                  <div class="row">
                     <div class="col-12">
                        <div class="it-project-wrapper p-relative">
                           <div class="swiper-container it-project-5-active">
                              <div class="swiper-wrapper">
                                 <div class="swiper-slide">
                                    <div class="it-project-item">
                                       <div class="it-project-thumb">
                                          <img class="w-100" src="assets/img/project/1.jpg" alt="">
                                       </div>
                                       <div class="it-project-2-content d-flex justify-content-between">
                                          <div>
                                             <h4 class="it-project-2-title">
                                                <a href="" class="border-line-white">
                                                  إحداث قاعة خاصة للرياضة
                                                </a>
                                             </h4>
                                            
                                          </div>
                                          <div class="it-project-arrow">
                                             <a href="">
                                                <svg width="13" height="14" viewBox="0 0 13 14" fill="none"
                                                   xmlns="http://www.w3.org/2000/svg">
                                                   <path
                                                      d="M11.103 0.952468C11.03 0.405028 10.527 0.0204122 9.97959 0.0934039L1.05854 1.28288C0.511097 1.35587 0.126481 1.85883 0.199473 2.40627C0.272465 2.95371 0.775425 3.33833 1.32287 3.26533L9.25269 2.20802L10.31 10.1378C10.383 10.6853 10.8859 11.0699 11.4334 10.9969C11.9808 10.9239 12.3654 10.421 12.2925 9.87352L11.103 0.952468ZM1.79436 13.6075L10.9061 1.69208L9.31739 0.477182L0.205642 12.3925L1.79436 13.6075Z"
                                                      fill="white" />
                                                </svg>
                                             </a>
                                          </div>
                                       </div>
                                    </div>
                                 </div>
                                 <div class="swiper-slide">
                                    <div class="it-project-item">
                                       <div class="it-project-thumb">
                                          <img class="w-100" src="assets/img/project/2.jpg" alt="">
                                       </div>
                                       <div class="it-project-2-content d-flex justify-content-between">
                                          <div>
                                             <h4 class="it-project-2-title">
                                                <a href="portfolio-details.html" class="border-line-white">
                                                  الفضاءات الترفيهية للشباب و الطفولة
                                                </a>
                                             </h4>
                                           
                                          </div>
                                          <div class="it-project-arrow">
                                             <a href="portfolio-details.html">
                                                <svg width="13" height="14" viewBox="0 0 13 14" fill="none"
                                                   xmlns="http://www.w3.org/2000/svg">
                                                   <path
                                                      d="M11.103 0.952468C11.03 0.405028 10.527 0.0204122 9.97959 0.0934039L1.05854 1.28288C0.511097 1.35587 0.126481 1.85883 0.199473 2.40627C0.272465 2.95371 0.775425 3.33833 1.32287 3.26533L9.25269 2.20802L10.31 10.1378C10.383 10.6853 10.8859 11.0699 11.4334 10.9969C11.9808 10.9239 12.3654 10.421 12.2925 9.87352L11.103 0.952468ZM1.79436 13.6075L10.9061 1.69208L9.31739 0.477182L0.205642 12.3925L1.79436 13.6075Z"
                                                      fill="white" />
                                                </svg>
                                             </a>
                                          </div>
                                       </div>
                                    </div>
                                 </div>
                                 <div class="swiper-slide">
                                    <div class="it-project-item">
                                       <div class="it-project-thumb">
                                          <img class="w-100" src="assets/img/project/3.jpg" alt="">
                                       </div>
                                       <div class="it-project-2-content d-flex justify-content-between">
                                          <div>
                                             <h4 class="it-project-2-title">
                                                <a href="" class="border-line-white">
                                                   المؤسسات الشبابية الخاصة
                                                </a>
                                             </h4>
                                            
                                          </div>
                                          <div class="it-project-arrow">
                                             <a href="">
                                                <svg width="13" height="14" viewBox="0 0 13 14" fill="none"
                                                   xmlns="http://www.w3.org/2000/svg">
                                                   <path
                                                      d="M11.103 0.952468C11.03 0.405028 10.527 0.0204122 9.97959 0.0934039L1.05854 1.28288C0.511097 1.35587 0.126481 1.85883 0.199473 2.40627C0.272465 2.95371 0.775425 3.33833 1.32287 3.26533L9.25269 2.20802L10.31 10.1378C10.383 10.6853 10.8859 11.0699 11.4334 10.9969C11.9808 10.9239 12.3654 10.421 12.2925 9.87352L11.103 0.952468ZM1.79436 13.6075L10.9061 1.69208L9.31739 0.477182L0.205642 12.3925L1.79436 13.6075Z"
                                                      fill="white" />
                                                </svg>
                                             </a>
                                          </div>
                                       </div>
                                    </div>
                                 </div>
                                 <div class="swiper-slide">
                                    <div class="it-project-item">
                                       <div class="it-project-thumb">
                                          <img class="w-100" src="assets/img/project/4.jpg" alt="">
                                       </div>
                                       <div class="it-project-2-content d-flex justify-content-between">
                                          <div>
                                             <h4 class="it-project-2-title">
                                                <a href="" class="border-line-white">
                                              تنظيم الأنشطة الترفيهية للشباب و الطفولة
                                                </a>
                                             </h4>
                                 
                                          </div>
                                          <div class="it-project-arrow">
                                             <a href="">
                                                <svg width="13" height="14" viewBox="0 0 13 14" fill="none"
                                                   xmlns="http://www.w3.org/2000/svg">
                                                   <path
                                                      d="M11.103 0.952468C11.03 0.405028 10.527 0.0204122 9.97959 0.0934039L1.05854 1.28288C0.511097 1.35587 0.126481 1.85883 0.199473 2.40627C0.272465 2.95371 0.775425 3.33833 1.32287 3.26533L9.25269 2.20802L10.31 10.1378C10.383 10.6853 10.8859 11.0699 11.4334 10.9969C11.9808 10.9239 12.3654 10.421 12.2925 9.87352L11.103 0.952468ZM1.79436 13.6075L10.9061 1.69208L9.31739 0.477182L0.205642 12.3925L1.79436 13.6075Z"
                                                      fill="white" />
                                                </svg>
                                             </a>
                                          </div>
                                       </div>
                                    </div>
                                 </div>
                                 <div class="swiper-slide">
                                    <div class="it-project-item">
                                       <div class="it-project-thumb">
                                          <img class="w-100" src="assets/img/project/5.jpg" alt="">
                                       </div>
                                       <div class="it-project-2-content d-flex justify-content-between">
                                          <div>
                                             <h4 class="it-project-2-title">
                                                <a href="" class="border-line-white">
                                                   مركز التربصات و تكوين الرياضيين
                                                </a>
                                             </h4>
                                          </div>
                                          <div class="it-project-arrow">
                                             <a href="">
                                                <svg width="13" height="14" viewBox="0 0 13 14" fill="none"
                                                   xmlns="http://www.w3.org/2000/svg">
                                                   <path
                                                      d="M11.103 0.952468C11.03 0.405028 10.527 0.0204122 9.97959 0.0934039L1.05854 1.28288C0.511097 1.35587 0.126481 1.85883 0.199473 2.40627C0.272465 2.95371 0.775425 3.33833 1.32287 3.26533L9.25269 2.20802L10.31 10.1378C10.383 10.6853 10.8859 11.0699 11.4334 10.9969C11.9808 10.9239 12.3654 10.421 12.2925 9.87352L11.103 0.952468ZM1.79436 13.6075L10.9061 1.69208L9.31739 0.477182L0.205642 12.3925L1.79436 13.6075Z"
                                                      fill="white" />
                                                </svg>
                                             </a>
                                          </div>
                                       </div>
                                    </div>
                                 </div>
                              </div>
                           </div>
                           <div class="mt-50">
                              <div class="row gx-0 align-items-center">
                                 <div class="col-lg-4 col-md-4 col-5">
                                    <div class="it-project-arrow-wrap">
                                     
                                       <button class="arrow-next">
                                          <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                             <path
                                                d="M15.7071 8.70711C16.0976 8.31658 16.0976 7.68342 15.7071 7.29289L9.34315 0.928932C8.95262 0.538408 8.31946 0.538408 7.92893 0.928932C7.53841 1.31946 7.53841 1.95262 7.92893 2.34315L13.5858 8L7.92893 13.6569C7.53841 14.0474 7.53841 14.6805 7.92893 15.0711C8.31946 15.4616 8.95262 15.4616 9.34315 15.0711L15.7071 8.70711ZM0 9H15V7H0V9Z"
                                                fill="currentcolor" />
                                          </svg>
                                       </button>
									     <button class="arrow-prev">
                                          <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                             <path
                                                d="M0.292892 7.29289C-0.0976315 7.68342 -0.0976315 8.31658 0.292892 8.70711L6.65685 15.0711C7.04738 15.4616 7.68054 15.4616 8.07107 15.0711C8.46159 14.6805 8.46159 14.0474 8.07107 13.6569L2.41421 8L8.07107 2.34315C8.46159 1.95262 8.46159 1.31946 8.07107 0.928932C7.68054 0.538408 7.04738 0.538408 6.65685 0.928932L0.292892 7.29289ZM16 7H0.999999V9H16V7Z"
                                                fill="currentcolor" />
                                          </svg>
                                       </button>
                                    </div>
                                 </div>
                                 <div class="col-lg-7 col-md-7 col-5">
                                    <div class="it-project-dots"></div>
                                 </div>
                                 <div class="col-lg-1 col-md-1 col-2">
                                    <div class="text-center">
                                       <div class="swiper-fraction"></div>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <!-- project-area-end -->
			     <!-- blog-area-start -->
            <div class="it-blog-area it-blog-style-2 pt-95 pb-45"  style="background:ghostwhite;">
               <div class="container">
                  <div class="row gx-35">
                     <div class="col-xl-4">
                        <div class="it-blog-3-left">
                           <div class="it-section-title-box mb-15">
                              <span class="it-section-subtitle"> تتويجات رياضية</span>
                              <h4 class="it-section-title it-split-in-right mb-0">أبرز التتويجات الرياضية الوطنية والدولية</h4>
                           </div>
                          
                           <div class="it-blog-btn wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".5s">
                              <a href="" class="it-btn-orange">
                                 <span>
                                    <span class="text-1">تصفح الكل</span>
                                    <span class="text-2">تصفح الكل</span>
                                 </span>
                                 <i>
                                    <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                       xmlns="http://www.w3.org/2000/svg">
                                       <path
                                          d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                          fill="white" />
                                    </svg>
                                    <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                       xmlns="http://www.w3.org/2000/svg">
                                       <path
                                          d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                          fill="white" />
                                    </svg>
                                 </i>

                              </a>
                           </div>
                        </div>
                     </div>
                     <div class="col-xl-8">
                        <div class="it-blog-item">
                           <div class="row align-items-center">
                              <div class="col-xxl-9 col-xl-10 col-lg-9 col-md-10">
                                 <div class="it-blog-item-left d-flex align-items-center">
                                    <div class="it-blog-thumb">
                                       <a href="">
                                          <img class="w-100" src="assets/img/blog/s1.jpg" alt="">
                                          <img class="w-100" src="assets/img/blog/s1.jpg" alt="">
                                       </a>
                                    </div>
                                    <div class="it-blog-content">
                                       <div class="it-blog-meta mb-20">
                                          <span>
                                             <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                   d="M0.468788 13.1562H2.81253V14.5625C2.81253 14.8213 3.02241 15.0312 3.28128 15.0312H15.5313C15.7901 15.0312 16 14.8213 16 14.5625V2.375C16 2.11612 15.7901 1.90625 15.5313 1.90625H13.1875V1.4375C13.1875 1.17862 12.9776 0.96875 12.7188 0.96875C12.4599 0.96875 12.25 1.17862 12.25 1.4375V1.90625H9.87502V1.4375C9.87502 1.17862 9.66514 0.96875 9.40627 0.96875C9.1474 0.96875 8.93752 1.17862 8.93752 1.4375V1.90625H6.59378V1.4375C6.59378 1.17862 6.3839 0.96875 6.12503 0.96875C5.86615 0.96875 5.65628 1.17862 5.65628 1.4375V1.90625H3.28128C3.02241 1.90625 2.81253 2.11612 2.81253 2.375V5.18749C2.81253 8.64217 1.37676 11.2999 0.168695 12.3274C0.0170703 12.4537 -0.0391483 12.6615 0.0280078 12.8471C0.0952264 13.0326 0.271414 13.1562 0.468788 13.1562ZM15.0625 14.0937H3.75003V13.1562H12.7188C12.8284 13.1562 12.9346 13.1178 13.0189 13.0476C13.5824 12.5782 14.4552 11.4608 15.0625 10.0296V14.0937ZM3.75003 2.84375H5.65628V3.3125C5.65628 3.57137 5.86615 3.78124 6.12503 3.78124C6.3839 3.78124 6.59378 3.57137 6.59378 3.3125V2.84375H8.93752V3.3125C8.93752 3.57137 9.1474 3.78124 9.40627 3.78124C9.66514 3.78124 9.87502 3.57137 9.87502 3.3125V2.84375H12.25V3.3125C12.25 3.57137 12.4599 3.78124 12.7188 3.78124C12.9776 3.78124 13.1875 3.57137 13.1875 3.3125V2.84375H15.0625V4.71874H3.75003V2.84375ZM3.742 5.65593H15.0542C14.9486 8.62952 13.8073 10.9691 12.535 12.2187H1.535C2.97666 10.3818 3.66466 7.99005 3.742 5.65593Z"
                                                   fill="#E03B3B" />
                                             </svg>
                                           2025.07.30
                                          </span>
       
                                       </div>
                                       <h4 class="it-blog-title">
                                          <a class="border-line-black" href="">
                                          الحصيلة النهائية لمشاركة عناصر المنتخب الوطني التونسي في بطولة إفريقيا المشتركة
                                          </a>
                                       </h4>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-xxl-3 col-xl-2 col-lg-3 col-md-2">
                                 <div class="it-blog-item-arrow text-md-end">
                                    <a href="">
                                       <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path
                                             d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                             fill="currentcolor" />
                                       </svg>
                                    </a>
                                 </div>
                              </div>
                           </div>
                        </div>
                        <div class="it-blog-item">
                           <div class="row align-items-center">
                              <div class="col-xxl-9 col-xl-10 col-lg-9 col-md-10">
                                 <div class="it-blog-item-left d-flex align-items-center">
                                    <div class="it-blog-thumb">
                                       <a href="">
                                          <img class="w-100" src="assets/img/blog/s2.jpg" alt="">
                                          <img class="w-100" src="assets/img/blog/s2.jpg" alt="">
                                       </a>
                                    </div>
                                    <div class="it-blog-content">
                                       <div class="it-blog-meta mb-20">
                                          <span>
                                             <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                   d="M0.468788 13.1562H2.81253V14.5625C2.81253 14.8213 3.02241 15.0312 3.28128 15.0312H15.5313C15.7901 15.0312 16 14.8213 16 14.5625V2.375C16 2.11612 15.7901 1.90625 15.5313 1.90625H13.1875V1.4375C13.1875 1.17862 12.9776 0.96875 12.7188 0.96875C12.4599 0.96875 12.25 1.17862 12.25 1.4375V1.90625H9.87502V1.4375C9.87502 1.17862 9.66514 0.96875 9.40627 0.96875C9.1474 0.96875 8.93752 1.17862 8.93752 1.4375V1.90625H6.59378V1.4375C6.59378 1.17862 6.3839 0.96875 6.12503 0.96875C5.86615 0.96875 5.65628 1.17862 5.65628 1.4375V1.90625H3.28128C3.02241 1.90625 2.81253 2.11612 2.81253 2.375V5.18749C2.81253 8.64217 1.37676 11.2999 0.168695 12.3274C0.0170703 12.4537 -0.0391483 12.6615 0.0280078 12.8471C0.0952264 13.0326 0.271414 13.1562 0.468788 13.1562ZM15.0625 14.0937H3.75003V13.1562H12.7188C12.8284 13.1562 12.9346 13.1178 13.0189 13.0476C13.5824 12.5782 14.4552 11.4608 15.0625 10.0296V14.0937ZM3.75003 2.84375H5.65628V3.3125C5.65628 3.57137 5.86615 3.78124 6.12503 3.78124C6.3839 3.78124 6.59378 3.57137 6.59378 3.3125V2.84375H8.93752V3.3125C8.93752 3.57137 9.1474 3.78124 9.40627 3.78124C9.66514 3.78124 9.87502 3.57137 9.87502 3.3125V2.84375H12.25V3.3125C12.25 3.57137 12.4599 3.78124 12.7188 3.78124C12.9776 3.78124 13.1875 3.57137 13.1875 3.3125V2.84375H15.0625V4.71874H3.75003V2.84375ZM3.742 5.65593H15.0542C14.9486 8.62952 13.8073 10.9691 12.535 12.2187H1.535C2.97666 10.3818 3.66466 7.99005 3.742 5.65593Z"
                                                   fill="#E03B3B" />
                                             </svg>
                                               2025.07.30
                                          </span>
                                        
                                       </div>
                                       <h4 class="it-blog-title">
                                          <a class="border-line-black" href="">
                                            تونس بطلة إفريقيا للفرق المختلطة للجودو - أنغولا 2025
                                          </a>
                                       </h4>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-xxl-3 col-xl-2 col-lg-3 col-md-2">
                                 <div class="it-blog-item-arrow text-md-end">
                                    <a href="">
                                       <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path
                                             d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                             fill="currentcolor" />
                                       </svg>
                                    </a>
                                 </div>
                              </div>
                           </div>
                        </div>
                        <div class="it-blog-item">
                           <div class="row align-items-center">
                              <div class="col-xxl-9 col-xl-10 col-lg-9 col-md-10">
                                 <div class="it-blog-item-left d-flex align-items-center">
                                    <div class="it-blog-thumb">
                                       <a href="">
                                          <img class="w-100" src="assets/img/blog/s3.jpg" alt="">
                                          <img class="w-100" src="assets/img/blog/s3.jpg" alt="">
                                       </a>
                                    </div>
                                    <div class="it-blog-content">
                                       <div class="it-blog-meta mb-20">
                                          <span>
                                             <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                                xmlns="http://www.w3.org/2000/svg">
                                                <path
                                                   d="M0.468788 13.1562H2.81253V14.5625C2.81253 14.8213 3.02241 15.0312 3.28128 15.0312H15.5313C15.7901 15.0312 16 14.8213 16 14.5625V2.375C16 2.11612 15.7901 1.90625 15.5313 1.90625H13.1875V1.4375C13.1875 1.17862 12.9776 0.96875 12.7188 0.96875C12.4599 0.96875 12.25 1.17862 12.25 1.4375V1.90625H9.87502V1.4375C9.87502 1.17862 9.66514 0.96875 9.40627 0.96875C9.1474 0.96875 8.93752 1.17862 8.93752 1.4375V1.90625H6.59378V1.4375C6.59378 1.17862 6.3839 0.96875 6.12503 0.96875C5.86615 0.96875 5.65628 1.17862 5.65628 1.4375V1.90625H3.28128C3.02241 1.90625 2.81253 2.11612 2.81253 2.375V5.18749C2.81253 8.64217 1.37676 11.2999 0.168695 12.3274C0.0170703 12.4537 -0.0391483 12.6615 0.0280078 12.8471C0.0952264 13.0326 0.271414 13.1562 0.468788 13.1562ZM15.0625 14.0937H3.75003V13.1562H12.7188C12.8284 13.1562 12.9346 13.1178 13.0189 13.0476C13.5824 12.5782 14.4552 11.4608 15.0625 10.0296V14.0937ZM3.75003 2.84375H5.65628V3.3125C5.65628 3.57137 5.86615 3.78124 6.12503 3.78124C6.3839 3.78124 6.59378 3.57137 6.59378 3.3125V2.84375H8.93752V3.3125C8.93752 3.57137 9.1474 3.78124 9.40627 3.78124C9.66514 3.78124 9.87502 3.57137 9.87502 3.3125V2.84375H12.25V3.3125C12.25 3.57137 12.4599 3.78124 12.7188 3.78124C12.9776 3.78124 13.1875 3.57137 13.1875 3.3125V2.84375H15.0625V4.71874H3.75003V2.84375ZM3.742 5.65593H15.0542C14.9486 8.62952 13.8073 10.9691 12.535 12.2187H1.535C2.97666 10.3818 3.66466 7.99005 3.742 5.65593Z"
                                                   fill="#E03B3B" />
                                             </svg>
                                               2025.07.30
                                          </span>
                                         
                                       </div>
                                       <h4 class="it-blog-title">
                                          <a class="border-line-black" href="">
                                             تونس تتألّق في كأس العالم للكيوكوشنكاي ببلغاريا بفضيّتين وجائزة الروح
                                          </a>
                                       </h4>
                                    </div>
                                 </div>
                              </div>
                              <div class="col-xxl-3 col-xl-2 col-lg-3 col-md-2">
                                 <div class="it-blog-item-arrow text-md-end">
                                    <a href="">
                                       <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                          xmlns="http://www.w3.org/2000/svg">
                                          <path
                                             d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                             fill="currentcolor" />
                                       </svg>
                                    </a>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                  </div>
               </div>
            </div>
            <!-- blog-area-end -->

            <!-- brand-area-start -->
            <div class="it-brand-area">
               <div class="container">
                  <div class="it-brand-ptb">
                      <div class="col-xl-12">
                        <div class="it-section-title-box text-center mb-65">
                           <span class="it-section-subtitle">الجامعات الرياضية</span>
						       <h4 class="it-section-title it-split-in-right mb-0">مراجع ومعطيات حول الجامعات الرياضية</h4>
							  </div>
							  </div>
                     
                   <div class="col-xl-12 col-lg-12 col-md-11">
   <div class="swiper-container it-brand-active">
      <div class="swiper-wrapper slider-transtion d-flex align-items-center">
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/1.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/2.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/3.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/4.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/5.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/6.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/7.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/8.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/9.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/10.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/11.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/12.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/13.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/14.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/15.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/16.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/17.jpg" alt=""></a></div></div>
         <div class="swiper-slide"><div class="it-brand-item"><a href="#"><img src="assets/img/brand/18.jpg" alt=""></a></div></div>
      </div>
   </div>
</div>


                     </div>
                  </div>
               </div>
         
            <!-- brand-area-end -->

        
            <!-- project-area-start -->
            <div class="it-project-3-area pt-65 pb-45"  style="background:ghostwhite;">
               <div class="container">
                  <div class="row">
                     <div class="col-xl-12">
                        <div class="it-section-title-box text-center mb-65">
                           <span class="it-section-subtitle">مركبات و مراكز اقامة الشباب في تونس</span>
                           <h4 class="it-section-title it-split-in-right mb-0">مركبات الشباب في تونس… اكتشف واحجز مباشرة</h4>
                        </div>
                     </div>
                  </div>
			
       
                  <div class="row">
                     <div class="col-12">
                        <div class="it-project-3-wrapper p-relative">
                           <div class="swiper-container it-project-3-active">
                              <div class="swiper-wrapper">
                                <div class="swiper-slide">
                                    <div class="luxury-room-card p-relative">
                                   <!--     <div class="price-tag">100 د.ت / ليلة</div>-->
                                        <div class="room-thumb">
                                            <img class="w-100" src="assets/img/project/zouaree.jpg" alt="مركز التخييم والاصطياف بالزوارع">
                                        </div>
                                        <div class="room-content">
                                         
                                            <h4 class="room-title">
                                                <a href="">مركز التخييم والاصطياف بالزوارع</a>
                                            </h4>
                                            <div class="room-meta">
                                                <span><i class="fas fa-bed"></i> 50 سريرا تحت الخيام</span>
                                            
                                            </div>
                                            <div class="room-features">
                                                <div class="feature">
                                                    <i class="fas fa-utensils"></i>
                                                    <span>فطور صباح وجبة غداء عشاء أكلة تنزه</span>
                                                </div>
                                                <div class="feature">
                                                    <i class="fas fa-car"></i>
                                                    <span>مأوى</span>
                                                </div>
                                            </div>
                                            <div class="room-contact">
                                                <i class="fas fa-phone"></i> +21697218046
                                                <i class="fas fa-map-marker-alt"></i> وشتاتة، 9000 باجة
                                            </div>
                                            <a class="book-now-btn" href="auberge.html">
                                                إحجز الآن
                                                <i class="fas fa-arrow-right"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
	    <div class="swiper-slide">
                                    <div class="luxury-room-card p-relative">
                                   <!--     <div class="price-tag">100 د.ت / ليلة</div>-->
                                        <div class="room-thumb">
                                            <img class="w-100" src="assets/img/project/gbeli.jpg" alt="دار الشباب بڤبلي">
                                        </div>
                                        <div class="room-content">
                                         
                                            <h4 class="room-title">
                                                <a href="portfolio-details.html">دار الشباب بڤبلي</a>
                                            </h4>
                                            <div class="room-meta">
                                                <span><i class="fas fa-bed"></i>60 سريرا</span>
                                                
                                            </div>
                                            <div class="room-features">
                                                <div class="feature">
                                                    <i class="fas fa-utensils"></i>
                                                    <span>فطور صباح الغداء العشاء</span>
                                                </div>
                                                <div class="feature">
                                                    <i class="fas fa-wifi"></i>
                                                    <span>WIFI</span>
													<span><i class="fas fa-utensils"></i>مطبخ مستقل</span>
                                                </div>
												
                                            </div>
                                            <div class="room-contact">
                                                <i class="fas fa-phone"></i> +21675490635
                                                <i class="fas fa-map-marker-alt"></i> 4200 ڤبلي
                                            </div>
                                            <a class="book-now-btn" href="portfolio-details.html">
                                                إحجز الآن
                                                <i class="fas fa-arrow-right"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>
				   						    <div class="swiper-slide">
                                    <div class="luxury-room-card p-relative">
                                   <!--     <div class="price-tag">100 د.ت / ليلة</div>-->
                                        <div class="room-thumb">
                                            <img class="w-100" src="assets/img/project/kef.jpg" alt="المركب الشبابي بالكاف">
                                        </div>
                                        <div class="room-content">
                                         
                                            <h4 class="room-title">
                                                <a href="portfolio-details.html">المركب الشبابي بالكاف</a>
                                            </h4>
                                            <div class="room-meta">
                                                <span><i class="fas fa-bed"></i>44 سريرا</span>
                                                
                                            </div>
                                            <div class="room-features">
                                                <div class="feature">
                                                    <i class="fas fa-utensils"></i>
                                                    <span>فطور صباح الغداء العشاء</span>
                                                </div>
                                                <div class="feature">
                                                    <i class="fas fa-wifi"></i>
                                                    <span>WIFI</span>
													<span><i class="fas fa-utensils"></i>مطبخ مستقل</span>
                                                </div>
												
                                            </div>
                                            <div class="room-contact">
                                                <i class="fas fa-phone"></i> +21678201214
                                                <i class="fas fa-map-marker-alt"></i>حي الدير  7100 الكاف
                                            </div>
                                            <a class="book-now-btn" href="portfolio-details.html">
                                                إحجز الآن
                                                <i class="fas fa-arrow-right"></i>
                                            </a>
                                        </div>
                                    </div>
                                </div>		
							
								
				</div>
                          
						  </div>
                           <div class="it-project-arrow-wrap d-none d-xl-block">
                              <button class="arrow-prev">
                                 <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                       d="M0.292892 7.29289C-0.0976315 7.68342 -0.0976315 8.31658 0.292892 8.70711L6.65685 15.0711C7.04738 15.4616 7.68054 15.4616 8.07107 15.0711C8.46159 14.6805 8.46159 14.0474 8.07107 13.6569L2.41421 8L8.07107 2.34315C8.46159 1.95262 8.46159 1.31946 8.07107 0.928932C7.68054 0.538408 7.04738 0.538408 6.65685 0.928932L0.292892 7.29289ZM16 7H0.999999V9H16V7Z"
                                       fill="currentcolor" />
                                 </svg>
                              </button>
                              <button class="arrow-next">
                                 <svg width="16" height="16" viewBox="0 0 16 16" fill="none"
                                    xmlns="http://www.w3.org/2000/svg">
                                    <path
                                       d="M15.7071 8.70711C16.0976 8.31658 16.0976 7.68342 15.7071 7.29289L9.34315 0.928932C8.95262 0.538408 8.31946 0.538408 7.92893 0.928932C7.53841 1.31946 7.53841 1.95262 7.92893 2.34315L13.5858 8L7.92893 13.6569C7.53841 14.0474 7.53841 14.6805 7.92893 15.0711C8.31946 15.4616 8.95262 15.4616 9.34315 15.0711L15.7071 8.70711ZM0 9H15V7H0V9Z"
                                       fill="currentcolor" />
                                 </svg>
                              </button>
                           </div>
                        </div>
                        <div class="it-project-3-dots text-center mt-55"></div>
                     </div>
                  </div>
				  <div class="row align-items-center">
                              <div class="col-xxl-12 col-xl-12 col-lg-12 col-md-12">
                                 
                                 <div class="it-about-2-btn" style="padding-top: 25px;text-align: center;">
                                    <a href="contact.html" class="it-btn-orange">
                                       <span>
                                          <span class="text-1"> جميع المراكز</span>
                                          <span class="text-2"> جميع المراكز</span>
                                       </span>
                                       <i>
                                          <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                             <path
                                                d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                fill="white" />
                                          </svg>
                                          <svg width="12" height="13" viewBox="0 0 12 13" fill="none"
                                             xmlns="http://www.w3.org/2000/svg">
                                             <path
                                                d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z"
                                                fill="white" />
                                          </svg>
                                       </i>
                                    </a>
                                 </div>
                              </div>
                             
                           </div>
               </div>
            </div>
            <!-- project-area-end -->
   

        <!-- contact-area-start -->
            <div class="it-contact-area  z-index-1 pt-130 pb-130"
               data-background="assets/img/shape/contact-1-2.jpg">
               <img class="it-contact-shape-2" src="assets/img/shape/choose-1-1.png" alt="">
               <div class="container">
                  <div class="row align-items-center">
                     <div class="col-xl-6 col-lg-6">
                        <div class="it-contact-left">
                           <div class="it-section-title-box mb-20">
                              <span class="it-section-subtitle">طرق التواصل</span>
                             
                           </div>
                           <p class="mb-30 wow itfadeUp" data-wow-duration=".9s" data-wow-delay=".3s">لأي استفسار أو تواصل مباشر، يُرجى استخدام المعطيات التالية</p>
                           <div class="it-contact-list-wrap">
                              <div class="row">
                                 <div class="col-lg-5 col-md-5 col-sm-6">
                                    <div class="it-contact-list-box wow itfadeUp" data-wow-duration=".9s"
                                       data-wow-delay=".5s">
                                       <div class="it-contact-list mb-40">
                                          <span>الهاتف</span>
                                          <a class="border-line-white" href="tel:71841433">71.841.433</a>
                                       </div>
                                       <div class="it-contact-list">
                                          <span>البريد الألكتروني</span>
                                          <a class="border-line-white"
                                             href="mailto:mjsep@mjs.tn">mjsep@mjs.tn</a>
                                       </div>
                                    </div>
                                 </div>
                                 <div class="col-lg-7 col-md-7 col-sm-6 wow itfadeUp" data-wow-duration=".9s"
                                    data-wow-delay=".7s">
                                    <div class="it-contact-list-box">
                                       <div>
                                          <div class="it-contact-list mb-40">
                                             <span>العنوان</span>
                                             <a class="border-line-white" href="tel:+000123456789">شارع محمد علي عقيد ، حي الخضراء 1003 تونس</a>
                                          </div>
                                         
                                       </div>
                                    </div>
                                 </div>
                              </div>
                           </div>
                        </div>
                     </div>
                     <div class="col-lg-6 col-lg-6">
                        <div class="it-contact-form-box z-index-1 p-relative">
                       <h4 class="it-contact-form-title  it-split-in-right mb-10">تواصل معنا</h4>
<p>يسعدنا استقبال استفساراتكم وملاحظاتكم، ونسعى دائمًا إلى خدمتكم بأعلى درجات المهنية والجودة.</p>
                       <form action="#">
   <div class="it-contact-input-wrap">
      <div class="row gx-30">
         <div class="col-sm-6 mb-20">
            <div class="it-contact-input-box">
               <input type="text" placeholder="الاسم الكامل*">
            </div>
         </div>
         <div class="col-sm-6 mb-20">
            <div class="it-contact-input-box">
               <input type="email" placeholder="البريد الإلكتروني*">
            </div>
         </div>
         <div class="col-sm-6 mb-20">
            <div class="it-contact-input-box">
               <input type="text" placeholder="رقم الهاتف*">
            </div>
         </div>
         <div class="col-sm-6 mb-20">
            <div class="it-contact-input-box">
               <div class="postbox__select">
                  <select>
                     <option selected disabled>الموضوع*</option>
                     <option>استفسار</option>
                     <option>ملاحظة</option>
                     <option>شكاية</option>
                     <option>اقتراح</option>
                  </select>
               </div>
            </div>
         </div>
         <div class="col-sm-12 mb-40">
            <div class="it-contact-input-box">
               <textarea placeholder="نص الرسالة*"></textarea>
            </div>
         </div>
      </div>
      <div class="it-contact-btn">
         <button type="submit" class="it-btn-orange">
            <span>
               <span class="text-1">إرسال</span>
               <span class="text-2">إرسال</span>
            </span>
            <i>
               <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
               </svg>
               <svg width="12" height="13" viewBox="0 0 12 13" fill="none" xmlns="http://www.w3.org/2000/svg">
                  <path d="M10.0035 3.90804L1.41153 12.5L0 11.0885L8.59097 2.49651H1.01922V0.5H12V11.4808H10.0035V3.90804Z" fill="white" />
               </svg>
            </i>
         </button>
      </div>
   </div>
</form>

                           <img class="it-contact-shape-1" src="assets/img/shape/contact-1-1.png" alt="">
                        </div>
                     </div>
                  </div>
               </div>
            </div>
         </main>
   
@endsection