@csrf
<style>
  .field-error { color: #d9534f; font-size: .9rem; margin-top: .25rem; display: none; }
  .is-invalid { border-color: #d9534f !important; }
</style>

<div class="block-card mb-4">
  <div class="block-card-header">
    <h2 class="widget-title">{{ $formTitle ?? 'نموذج التتويج الرياضي' }}</h2>
    <div class="stroke-shape"></div>
  </div>

  <div class="block-card-body">
    <div class="form-group row mb-3">
        <div class="col-md-6">
            <label>التاريخ <span class="text-danger">*</span></label>
            <input type="date" name="date" id="date"
                    class="form-control @error('date') is-invalid @enderror"
                    value="{{ old('date', $trophee_sportif->date ?? '') }}">
            @error('date')
                <span class="field-error d-block">{{ $message }}</span>
            @enderror
        </div>

      <div class="col-md-6">
        <label>العنوان بالعربية <span class="text-danger">*</span></label>
        <input type="text" name="title" id="title" class="form-control" value="{{ old('title', $trophee_sportif->title ?? '') }}" required>
        @error('title')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
      </div>
    </div>

    <div class="form-group row mb-3">
      <div class="col-md-6">
        <label>العنوان بالفرنسية <span class="text-danger">*</span></label>
        <input type="text" name="title_fr" id="title_fr" class="form-control" value="{{ old('title_fr', $trophee_sportif->title_fr ?? '') }}" required>
        @error('title_fr')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
      </div>

      <div class="col-md-6">
        <label>العنوان بالإنجليزية <span class="text-danger">*</span></label>
        <input type="text" name="title_en" id="title_en" class="form-control" value="{{ old('title_en', $trophee_sportif->title_en ?? '') }}" required>
        @error('title_en')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
      </div>
    </div>

    <div class="form-group mb-3" dir="rtl">
      <label class="fw-bold mb-2">المحتوى بالعربية<span class="text-danger">*</span></label>
      <textarea name="content" id="editor_ar" class="form-control" rows="10">{{ old('content', $trophee_sportif->content ?? '') }}</textarea>
      @error('content')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group mb-3" dir="rtl">
      <label class="fw-bold mb-2">الملخّص بالعربية<span class="text-danger">*</span></label>
      <textarea name="resume_ar" id="resume_ar" class="form-control" rows="3" required>{{ old('resume_ar', $trophee_sportif->resume_ar ?? '') }}</textarea>
      @error('resume_ar')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group mb-3">
      <label class="fw-bold mb-2">المحتوى بالفرنسية<span class="text-danger">*</span></label>
      <textarea name="content_fr" id="editor_fr" class="form-control" rows="10">{{ old('content_fr', $trophee_sportif->content_fr ?? '') }}</textarea>
      @error('content_fr')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group mb-3" dir="rtl">
      <label class="fw-bold mb-2">الملخّص بالفرنسية<span class="text-danger">*</span></label>
      <textarea name="resume_fr" id="resume_fr" class="form-control" rows="3" required>{{ old('resume_fr', $trophee_sportif->resume_fr ?? '') }}</textarea>
      @error('resume_fr')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group mb-3">
      <label class="fw-bold mb-2">المحتوى بالانقليزية<span class="text-danger">*</span></label>
      <textarea name="content_en" id="editor_en" class="form-control" rows="10">{{ old('content_en', $trophee_sportif->content_en ?? '') }}</textarea>
      @error('content_en')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group mb-3" dir="rtl">
      <label class="fw-bold mb-2">الملخّص بالانقليزية<span class="text-danger">*</span></label>
      <textarea name="resume_en" id="resume_en" class="form-control" rows="3" required>{{ old('resume_en', $trophee_sportif->resume_en ?? '') }}</textarea>
      @error('resume_en')
                <span class="field-error d-block">{{ $message }}</span>
        @enderror
    </div>

    <div class="form-group mb-3">
      <label>صورة الخبر</label>
      <input type="file" name="image" class="form-control" accept="image/*">
      @if(!empty($trophee_sportif->image))
        <div class="mt-2">
          <img src="data:image/*;base64,{{ base64_encode($trophee_sportif->image) }}" alt="صورة الخبر" style="height:100px; border-radius:8px;">
        </div>
      @endif
    </div>

    <div class="form-group mb-3">
      <label>رابط YouTube</label>
      <input type="text" name="youtube_url" id="youtube_url" class="form-control" value="{{ old('youtube_url', $trophee_sportif->youtube_url ?? '') }}" placeholder="https://www.youtube.com/watch?v=...">
    </div>

    <div class="form-check mb-3">
      <input type="hidden" name="published" value="0">
      <input type="checkbox" name="published" value="1" class="form-check-input" id="published" {{ old('published', $trophee_sportif->published ?? false) ? 'checked' : '' }}>
      <label for="published" class="form-check-label">منشور</label>
    </div>
  </div>

  <div class="block-card-footer mt-3 mb-3 text-center">
    <button type="submit" id="submitBtn" class="btn bg-rgb-primary1 font-weight-medium">
      <i class="la la-save mr-1"></i> حفظ
    </button>
    <a href="{{ route('trophee_sportif.index') }}" class="btn bg-rgb-primary1 font-weight-medium">
      <i class="la la-times mr-1"></i> إلغاء
    </a>
  </div>
</div>

<script src="https://cdn.jsdelivr.net/npm/tinymce@6/tinymce.min.js" referrerpolicy="origin"></script>
<script>
  tinymce.init({
    selector: '#editor_ar',
    directionality: 'rtl',
    height: 350,
    plugins: 'advlist autolink lists link image charmap preview anchor searchreplace visualblocks code fullscreen table',
    toolbar: 'undo redo | formatselect | bold italic | forecolor backcolor | alignleft aligncenter alignright alignjustify | bullist numlist | link image | code',
    forced_root_block: false,
  });
  tinymce.init({
    selector: '#editor_fr',
    height: 350,
    plugins: 'advlist autolink lists link image charmap preview anchor searchreplace visualblocks code fullscreen table',
    toolbar: 'undo redo | formatselect | bold italic | forecolor backcolor | alignleft aligncenter alignright alignjustify | bullist numlist | link image | code',
    forced_root_block: false,
  });
  tinymce.init({
    selector: '#editor_en',
    height: 350,
    plugins: 'advlist autolink lists link image charmap preview anchor searchreplace visualblocks code fullscreen table',
    toolbar: 'undo redo | formatselect | bold italic | forecolor backcolor | alignleft aligncenter alignright alignjustify | bullist numlist | link image | code',
    forced_root_block: false,
  });
  function stripHtml(html){
    const tmp = document.createElement("DIV");
    tmp.innerHTML = html || "";
    return tmp.textContent || tmp.innerText || "";
  }

  document.querySelector('form').addEventListener('submit', function (e) {
    document.querySelectorAll('.field-error').forEach(el => el.style.display = 'none');
    document.querySelectorAll('.is-invalid').forEach(el => el.classList.remove('is-invalid'));
    let firstError = null;
    function showError(elSelector, msgId) {
      const el = document.querySelector(elSelector);
      if (el) el.classList.add('is-invalid');
      const msg = document.getElementById(msgId);
      if (msg) msg.style.display = 'block';
      if (!firstError) firstError = el || msg;
    }

    const date = document.getElementById('date').value.trim();
    if (!date) showError('#date', 'error_date');
    const title = document.getElementById('title').value.trim();
    if (!title) showError('#title', 'error_title');
    const titleFr = document.getElementById('title_fr').value.trim();
    if (!titleFr) showError('#title_fr', 'error_title_fr');
    const titleEn = document.getElementById('title_en').value.trim();
    if (!titleEn) showError('#title_en', 'error_title_en');
    const resumeAr = document.getElementById('resume_ar').value.trim();
    if (!resumeAr) showError('#resume_ar', 'error_resume_ar');
    const resumeFr = document.getElementById('resume_fr').value.trim();
    if (!resumeFr) showError('#resume_fr', 'error_resume_fr');
    const resumeEn = document.getElementById('resume_en').value.trim();
    if (!resumeEn) showError('#resume_en', 'error_resume_en');
    const arContent = stripHtml(tinymce.get('editor_ar') ? tinymce.get('editor_ar').getContent() : document.getElementById('editor_ar').value).trim();
    if (!arContent) showError('#editor_ar', 'error_content_ar');
    const frContent = stripHtml(tinymce.get('editor_fr') ? tinymce.get('editor_fr').getContent() : document.getElementById('editor_fr').value).trim();
    if (!frContent) showError('#editor_fr', 'error_content_fr');
    const enContent = stripHtml(tinymce.get('editor_en') ? tinymce.get('editor_en').getContent() : document.getElementById('editor_en').value).trim();
    if (!enContent) showError('#editor_en', 'error_content_en');
    if (firstError) {
      e.preventDefault();
      firstError.scrollIntoView({ behavior: 'smooth', block: 'center' });
      return false;
    }
    if (tinymce.get('editor_ar')) document.querySelector('textarea[name="content"]').value = tinymce.get('editor_ar').getContent();
    if (tinymce.get('editor_fr')) document.querySelector('textarea[name="content_fr"]').value = tinymce.get('editor_fr').getContent();
    if (tinymce.get('editor_en')) document.querySelector('textarea[name="content_en"]').value = tinymce.get('editor_en').getContent();
  });
</script>
