@extends('backoffice.dashboard')

@section('title', $item->title)

@section('content')
<div class="container mt-4" dir="rtl">
    <div class="card shadow-sm border-0">
        <div class="card-body">

            {{-- ======= Titre ======= --}}
            <h2 class="text-center mb-4" style="color:#a52a2a; font-weight:bold;">
                {{ $item->title }}
            </h2>

            {{-- ======= Image principale ======= --}}
            @if($item->image)
                <div class="text-center mb-4">
                    <img src="{{ asset('storage/' . $item->image) }}" 
                         class="img-fluid rounded shadow-sm"
                         style="max-height: 300px; width:auto; border: 2px solid #eee;">
                </div>
            @endif

            {{-- ======= Bloc principal (vidéo + contenu) ======= --}}
            <div class="row align-items-start mt-4" style="text-align: right;">
                {{-- Vidéo YouTube si présente --}}
                @if(!empty($item->youtube_url))
                    @php
                        if (preg_match('/(youtu\.be\/|v=)([A-Za-z0-9_\-]+)/', $item->youtube_url, $m)) {
                            $embedUrl = 'https://www.youtube.com/embed/' . $m[2];
                        } else {
                            $embedUrl = null;
                        }
                    @endphp
                    @if($embedUrl)
                        <div class="col-md-5 mb-4">
                            <div class="ratio ratio-16x9 rounded overflow-hidden shadow-sm">
                                <iframe src="{{ $embedUrl }}" 
                                        title="فيديو يوتيوب"
                                        frameborder="0" 
                                        allowfullscreen></iframe>
                            </div>
                        </div>
                    @endif
                @endif

                {{-- Contenu texte --}}
                <div class="col-md-7" style="line-height: 1.9; font-size: 1.1rem; color:#333;">
                    {!! $item->content !!}
                </div>
            </div>

            {{-- ======= Informations supplémentaires ======= --}}
            <div class="mt-4 border-top pt-3 text-muted" style="font-size:0.95rem;">
                <p><strong>📅 التاريخ:</strong> {{ $item->date ?? 'غير محدد' }}</p>
                @if(isset($item->utilisateur))
                    <p><strong>✍ تمت الإضافة بواسطة:</strong> {{ $item->utilisateur->nom_prenom }}</p>
                @endif
                <p><strong>📢 الحالة:</strong> 
                    <span class="badge {{ $item->published ? 'bg-success' : 'bg-danger' }}">
                        {{ $item->published ? 'منشور' : 'غير منشور' }}
                    </span>
                </p>
            </div>

            {{-- ======= Boutons d’action ======= --}}
            <div class="text-center mt-5 d-flex justify-content-center gap-2 flex-wrap">
                <a href="{{ route('news.index') }}" 
                   class="btn btn-secondary px-4 py-2">
                    ← الرجوع إلى القائمة
                </a>

                <a href="{{ route('news.edit', $item->id) }}" 
                   class="btn btn-warning px-4 py-2">
                    ✏️ تعديل
                </a>

                <form action="{{ route('news.destroy', $item->id) }}" method="POST" onsubmit="return confirmDelete(this)">
                    @csrf
                    @method('DELETE')
                    <button type="submit" class="btn btn-danger px-4 py-2">
                        🗑 حذف
                    </button>
                </form>
            </div>

        </div>
    </div>
</div>

{{-- ======= SweetAlert pour confirmation de suppression ======= --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmDelete(form) {
    event.preventDefault();
    Swal.fire({
        title: 'تأكيد الحذف',
        text: 'هل أنت متأكد أنك تريد حذف هذا العنصر؟',
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#d33',
        cancelButtonColor: '#6c757d',
        confirmButtonText: 'نعم، احذف',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.i
