@csrf
<style>
  .field-error { color: #d9534f; font-size: .9rem; margin-top: .25rem; display: none; }
  .is-invalid { border-color: #d9534f !important; }
</style>

<div class="block-card mb-4">
  <div class="block-card-header">
    <h2 class="widget-title">{{ $formTitle ?? 'نموذج السلايدر' }}</h2>
    <div class="stroke-shape"></div>
  </div>

  <div class="block-card-body">

    {{-- Titres --}}
    <div class="form-group row mb-3">
        <div class="col-md-4">
            <label>العنوان بالعربية <span class="text-danger">*</span></label>
            <input type="text" name="titre_ar" class="form-control" value="{{ old('titre_ar', $slider->titre_ar ?? '') }}" required>
            @error('titre_ar') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
        <div class="col-md-4">
            <label>العنوان بالفرنسية <span class="text-danger">*</span></label>
            <input type="text" name="titre_fr" class="form-control" value="{{ old('titre_fr', $slider->titre_fr ?? '') }}" required>
            @error('titre_fr') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
        <div class="col-md-4">
            <label>العنوان بالإنجليزية <span class="text-danger">*</span></label>
            <input type="text" name="titre_en" class="form-control" value="{{ old('titre_en', $slider->titre_en ?? '') }}" required>
            @error('titre_en') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
    </div>

    {{-- Sous-titres --}}
    <div class="form-group row mb-3">
        <div class="col-md-4">
            <label>العنوان الفرعي بالعربية</label>
            <input type="text" name="soustitre_ar" class="form-control" value="{{ old('soustitre_ar', $slider->soustitre_ar ?? '') }}">
            @error('soustitre_ar') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
        <div class="col-md-4">
            <label>العنوان الفرعي بالفرنسية</label>
            <input type="text" name="soustitre_fr" class="form-control" value="{{ old('soustitre_fr', $slider->soustitre_fr ?? '') }}">
            @error('soustitre_fr') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
        <div class="col-md-4">
            <label>العنوان الفرعي بالإنجليزية</label>
            <input type="text" name="soustitre_en" class="form-control" value="{{ old('soustitre_en', $slider->soustitre_en ?? '') }}">
            @error('soustitre_en') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
    </div>

    <label style="color:black; font-weight:bold;">الزر 1 :</label>
    <div class="form-group row mb-3">
        <div class="col-md-6">
            <label>عنوان الزر 1 بالعربية</label>
            <input type="text" name="titre_bouton_ar" class="form-control" value="{{ old('titre_bouton_ar', $slider->titre_bouton_ar ?? '') }}">
            @error('titre_bouton_ar') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
        <div class="col-md-6">
            <label>رابط الزر 1 بالعربية</label>
            <input type="text" name="lien_bouton_ar" class="form-control" value="{{ old('lien_bouton_ar', $slider->lien_bouton_ar ?? '') }}">
            @error('lien_bouton_ar') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
    </div>

    <div class="form-group row mb-3">
      <div class="col-md-6">
            <label>عنوان الزر 1 بالفرنسية</label>
            <input type="text" name="titre_bouton_fr" class="form-control" value="{{ old('titre_bouton_fr', $slider->titre_bouton_fr ?? '') }}">
            @error('titre_bouton_fr') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
        <div class="col-md-6">
            <label>رابط الزر 1 بالفرنسية</label>
            <input type="text" name="lien_bouton_fr" class="form-control" value="{{ old('lien_bouton_fr', $slider->lien_bouton_fr ?? '') }}">
            @error('lien_bouton_fr') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
    </div>

    <div class="form-group row mb-3">
        <div class="col-md-6">
            <label>عنوان الزر 1 بالإنجليزية</label>
            <input type="text" name="titre_bouton_en" class="form-control" value="{{ old('titre_bouton_en', $slider->titre_bouton_en ?? '') }}">
            @error('titre_bouton_en') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
        <div class="col-md-6">
            <label>رابط الزر 1 بالإنجليزية</label>
            <input type="text" name="lien_bouton_en" class="form-control" value="{{ old('lien_bouton_en', $slider->lien_bouton_en ?? '') }}">
            @error('lien_bouton_en') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
    </div>

    <label style="color:black; font-weight:bold;">الزر 2 :</label>
    <div class="form-group row mb-3">
        <div class="col-md-6">
            <label>عنوان الزر 2 بالعربية</label>
            <input type="text" name="titre_bouton2_ar" class="form-control" value="{{ old('titre_bouton2_ar', $slider->titre_bouton2_ar ?? '') }}">
            @error('titre_bouton2_ar') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
        <div class="col-md-6">
            <label>رابط الزر 2 بالعربية</label>
            <input type="text" name="lien_bouton2_ar" class="form-control" value="{{ old('lien_bouton2_ar', $slider->lien_bouton2_ar ?? '') }}">
            @error('lien_bouton2_ar') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
    </div>

    <div class="form-group row mb-3">
        <div class="col-md-6">
              <label>عنوان الزر 2 بالفرنسية</label>
              <input type="text" name="titre_bouton2_fr" class="form-control" value="{{ old('titre_bouton2_fr', $slider->titre_bouton2_fr ?? '') }}">
              @error('titre_bouton2_fr') <span class="field-error d-block">{{ $message }}</span> @enderror
          </div>
        <div class="col-md-6">
            <label>رابط الزر 2 بالفرنسية</label>
            <input type="text" name="lien_bouton2_fr" class="form-control" value="{{ old('lien_bouton2_fr', $slider->lien_bouton2_fr ?? '') }}">
            @error('lien_bouton2_fr') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
    </div>

    <div class="form-group row mb-3">
        <div class="col-md-6">
            <label>عنوان الزر 2 بالإنجليزية</label>
            <input type="text" name="titre_bouton2_en" class="form-control" value="{{ old('titre_bouton2_en', $slider->titre_bouton2_en ?? '') }}">
            @error('titre_bouton2_en') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
        <div class="col-md-6">
            <label>رابط الزر 2 بالإنجليزية</label>
            <input type="text" name="lien_bouton2_en" class="form-control" value="{{ old('lien_bouton2_en', $slider->lien_bouton2_en ?? '') }}">
            @error('lien_bouton2_en') <span class="field-error d-block">{{ $message }}</span> @enderror
        </div>
    </div>

    <div class="form-group mb-3">
      <label>صورة السلايدر</label>
      <input type="file" name="image" class="form-control" accept="image/*">
      @if(!empty($slider->image))
        <div class="mt-2">
          <img src="{{ asset('storage/'.$slider->image) }}" alt="صورة السلايدر" style="height:100px; border-radius:8px;">
        </div>
      @endif
      @error('image') <span class="field-error d-block">{{ $message }}</span> @enderror
    </div>

  </div>

  <div class="block-card-footer mt-3 mb-3 text-center">
    <button type="submit" class="btn bg-rgb-primary1 font-weight-medium">
      <i class="la la-save mr-1"></i> حفظ
    </button>
    <a href="{{ route('sliders.index') }}" class="btn bg-rgb-primary1 font-weight-medium">
      <i class="la la-times mr-1"></i> إلغاء
    </a>
  </div>
</div>
