@extends('backoffice.dashboard')

@section('content')

@if (session('status'))
    <div class="alert alert-success">{{ session('status') }}</div>
@endif

@if (session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
@endif

@if(Auth::check())
<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <div class="block-card mb-4">
                    <div class="block-card-header">
                        <div class="d-flex justify-content-between align-items-center">
                            <h2 class="widget-title mb-0">ملف المستخدم</h2>
                            <a href="{{ route('utilisateurs.editprofil', $utilisateur->id) }}" 
                               class="btn btn-outline-secondary custom-hover">
                                <i class="fas fa-edit"></i> تعديل ملف المستخدم
                            </a>
                        </div>
                        <div class="stroke-shape"></div>
                    </div>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="input-box">
                                <table class="table table-bordered">
                                    <tbody>
                                        <tr>
                                            <th>الاسم الكامل</th>
                                            <td>{{ $utilisateur->nom_prenom }}</td>
                                        </tr>

                                        <tr>
                                            <th>رقم بطاقة التعريف</th>
                                            <td>{{ $utilisateur->cin }}</td>
                                        </tr>

                                        <tr>
                                            <th>تاريخ الإصدار</th>
                                            <td>{{ \Carbon\Carbon::parse($utilisateur->date_delivrance_cin)->format('d/m/Y') }}</td>
                                        </tr>

                                        <tr>
                                            <th>مكان الإصدار</th>
                                            <td>{{ $utilisateur->lieu_delivrance_cin }}</td>
                                        </tr>

                                        <tr>
                                            <th>البريد الإلكتروني</th>
                                            <td>{{ $utilisateur->email }}</td>
                                        </tr>

                                        <tr>
                                            <th>رقم الهاتف</th>
                                            <td>{{ $utilisateur->tel ?? 'غير محدد' }}</td>
                                        </tr>

                                        <tr>
                                            <th>العنوان</th>
                                            <td>{{ $utilisateur->adresse ?? 'غير محدد' }}</td>
                                        </tr>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
@else
    <script>
        window.location.href = "{{ route('admin') }}";
    </script>
@endif
@endsection
