@extends('backoffice.dashboard')

@section('content')

@if (session('ok'))
    <div class="alert alert-success">{{ session('ok') }}</div>
@endif

@if (session('error'))
    <div class="alert alert-danger">{{ session('error') }}</div>
@endif

@if(Auth::check())
<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <div class="block-card mb-4">
                    <div class="block-card-header">
                        <h2 class="widget-title">تعديل الملف الشخصي</h2>
                        <div class="stroke-shape"></div>
                    </div>

                    <div class="row">
                        <div class="col-lg-12">
                            <div class="input-box">
                                <form method="POST" action="{{ route('utilisateurs.updateprofil', auth()->user()->id) }}" enctype="multipart/form-data">
                                    @csrf
                                    @method('PATCH')

                                    <table class="table table-bordered">
                                        <tbody>
                                            <tr>
                                                <th>الاسم الكامل</th>
                                                <td>
                                                    <input type="text" name="nom_prenom" class="form-control" 
                                                           value="{{ old('nom_prenom', auth()->user()->nom_prenom) }}" 
                                                           required minlength="3" maxlength="255">
                                                </td>
                                            </tr>

                                            <th>رقم البطاقة</th>
                                                <td>
                                                    <input type="text" class="form-control" style="background-color: #ffffff;"
                                                        value="{{ old('cin', auth()->user()->cin) }}" 
                                                        disabled>
                                                    <input type="hidden" name="cin" value="{{ auth()->user()->cin }}">
                                                </td>
                                            </tr>

                                            <tr>
                                                <th>البريد الإلكتروني</th>
                                                <td>
                                                    <input type="email" class="form-control" style="background-color: #ffffff;"
                                                        value="{{ old('email', auth()->user()->email) }}" 
                                                        disabled>
                                                    <input type="hidden" name="email" value="{{ auth()->user()->email }}">
                                                </td>
                                            </tr>

                                            <tr>
                                                <th>رقم الهاتف</th>
                                                <td>
                                                    <input type="text" name="tel" class="form-control" 
                                                           value="{{ old('tel', auth()->user()->tel) }}">
                                                </td>
                                            </tr>

                                            <tr>
                                                <th>العنوان</th>
                                                <td>
                                                    <input type="text" name="adresse" class="form-control" 
                                                           value="{{ old('adresse', auth()->user()->adresse) }}">
                                                </td>
                                            </tr>

                                            

                                            <tr>
                                                <th>كلمة المرور</th>
                                                <td>
                                                    <input type="password" name="password" minlength="8" 
                                                           class="form-control" placeholder="أدخل كلمة المرور الجديدة">
                                                    @error('password')
                                                        <div class="alert alert-danger mt-2">{{ $message }}</div>
                                                    @enderror
                                                </td>
                                            </tr>

                                            <tr>
                                                <th>تأكيد كلمة المرور</th>
                                                <td>
                                                    <input type="password" name="password_confirmation" minlength="8" 
                                                           class="form-control" placeholder="أكد كلمة المرور">
                                                    @error('password_confirmation')
                                                        <div class="alert alert-danger mt-2">{{ $message }}</div>
                                                    @enderror
                                                </td>
                                            </tr>
                                        </tbody>
                                    </table>

                                    <div class="text-center mt-4 d-flex justify-content-between">
                                        <button type="submit" class="btn btn-success btn-custom">
                                            <i class="fas fa-save"></i> تحديث
                                        </button>
                                    </div>
                                </form>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
</section>
@else
    <script>
        window.location.href = "{{ route('admin') }}";
    </script>
@endif
@endsection
