@extends('backoffice.dashboard')

@section('content')
@if(Auth::check())
<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <div class="block-card mb-4">
                    <div class="block-card-header">
                        <h2 class="widget-title">إنشاء مستخدم</h2>
                    </div>
                    <div class="card-body">
                        <form action="{{ route('utilisateurs.store') }}" method="POST" enctype="multipart/form-data" novalidate>
                            @csrf
                            <div class="input-box">
                                <label class="label-text">الاسم و اللقب</label>
                                <input type="text" name="nom_prenom" class="form-control pl-3 @error('nom_prenom') is-invalid @enderror" value="{{ old('nom_prenom') }}">
                                @error('nom_prenom') <span class="invalid-feedback">{{ $message }}</span> @enderror
                            </div>
                            <div class="input-box">
                                <label class="label-text">رقم بطاقة التعريف</label>
                                <input type="text" name="cin" class="form-control pl-3 @error('cin') is-invalid @enderror" value="{{ old('cin') }}">
                                @error('cin') <span class="invalid-feedback">{{ $message }}</span> @enderror
                            </div>
                            <div class="input-box">
                                <label class="label-text">البريد الإلكتروني</label>
                                <input type="email" name="email" class="form-control pl-3 @error('email') is-invalid @enderror" value="{{ old('email') }}">
                                @error('email') <span class="invalid-feedback">{{ $message }}</span> @enderror
                            </div>
                            <div class="input-box">
                                <label class="label-text">الهاتف</label>
                                <input type="text" name="tel" class="form-control pl-3 @error('tel') is-invalid @enderror" value="{{ old('tel') }}">
                                @error('tel') <span class="invalid-feedback">{{ $message }}</span> @enderror
                            </div>
                            <div class="input-box">
                                <label class="label-text">العنوان</label>
                                <input type="text" name="adresse" class="form-control pl-3 @error('adresse') is-invalid @enderror" value="{{ old('adresse') }}">
                                @error('adresse') <span class="invalid-feedback">{{ $message }}</span> @enderror
                            </div>
                            <div class="input-box">
                                <label for="role_id" class="label-text">فئة المستخدم</label>
                                <select name="role_id" id="role_id" class="form-control @error('role_id') is-invalid @enderror">
                                    <option value="">-- اختر الدور --</option>
                                    @foreach($roles as $role)
                                        <option value="{{ $role->id_roles }}" {{ old('role_id') == $role->id_roles ? 'selected' : '' }}>
                                            {{ $role->nom_ar }}
                                        </option>
                                    @endforeach
                                </select>
                                @error('role_id')
                                    <span class="invalid-feedback">{{ $message }}</span>
                                @enderror
                            </div>
							<div class="input-box" id="auberge_box" style="display:none;">
								<label class="label-text">  المراكز  </label>
								<select name="auberge_id" class="form-control @error('auberge_id') is-invalid @enderror">
									<option value="">-- اختر المركز --</option>
									@foreach($auberges as $aub)
										<option value="{{ $aub->id }}">{{ $aub->nom_ar }}</option>
									@endforeach
								</select>
								@error('auberge_id')
									<span class="invalid-feedback">{{ $message }}</span>
								@enderror
							</div>
							<div class="input-box" id="gouv_box" style="display:none;">
								<label class="label-text">الولاية</label>
								<select name="id_gouv" class="form-control @error('id_gouv') is-invalid @enderror">
									<option value="">-- اختر الولاية --</option>
									@foreach($gouvernorat as $gouv)
										<option value="{{ $gouv->id_gouver }}" {{ old('id_gouv') == $gouv->id_gouver ? 'selected' : '' }}>
											{{ $gouv->nom_ar }}
										</option>
									@endforeach
								</select>
								@error('id_gouv')
									<span class="invalid-feedback">{{ $message }}</span>
								@enderror
							</div>
                            <button type="submit" class="btn btn-success font-weight-medium mt-3">
                                <i class="la la-save mr-1"></i> حفظ
                            </button>
                            <a href="{{ route('utilisateurs.index') }}" class="btn bg-rgb-primary1 font-weight-medium mt-3">
                                <i class="la la-times mr-1"></i> إلغاء
                            </a>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
</section>
<script>
    const roleSelect = document.getElementById('role_id');
    const aubergeBox = document.getElementById('auberge_box');
    const gouvBox = document.getElementById('gouv_box');
    function checkRole() {
        aubergeBox.style.display = 'none';
        gouvBox.style.display = 'none';
        if (roleSelect.value == 7) {
            aubergeBox.style.display = 'block';
        }
        if (roleSelect.value == 8) {
            gouvBox.style.display = 'block';
        }
    }
    roleSelect.addEventListener('change', checkRole);
    checkRole();
</script>
@else
    <script>
        window.location.href = "{{ route('admin') }}";
    </script>
@endif
@endsection