@extends('backoffice.dashboard')

@section('content')

@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif

@if(Auth::check())
<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                <form method="POST" action="{{ route('roles.store') }}" enctype="multipart/form-data">
                    @csrf

                    <div class="block-card mb-4">
                        <div class="block-card-header">
                            <h2 class="widget-title">إضافة دور</h2>
                            <div class="stroke-shape"></div>
                        </div>

                        <div class="block-card-body">
                            <div class="form-group">
                                <label>الاسم (عربي)</label>
                                <input name="nom_ar" class="form-control" value="{{ old('nom_ar') }}" required>
                            </div>
                            <div class="form-group">
                                <label>الاسم (Fr)</label>
                                <input name="nom_fr" class="form-control" value="{{ old('nom_fr') }}">
                            </div>
                            <div class="form-group">
                                <label>الاسم (En)</label>
                                <input name="nom_en" class="form-control" value="{{ old('nom_en') }}">
                            </div>
                            <div class="form-group">
                                <label>Guard Name</label>
                                <input name="guard_name" class="form-control" value="{{ old('guard_name','web') }}">
                            </div>
                        </div>

                        <div class="block-card-footer d-flex justify-content-start px-3 pb-3">
                            <button type="submit" class="btn bg-rgb-primary1 font-weight-medium mr-2">
                                <i class="la la-save mr-1"></i> حفظ
                            </button>
                            <a href="{{ route('roles.index') }}" class="btn bg-rgb-primary1 font-weight-medium">
                                <i class="la la-times mr-1"></i> إلغاء
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
@else
    <script>
        window.location.href = "{{ route('admin') }}";
    </script>
@endif
@endsection
