@extends('backoffice.dashboard')

@section('content')

@if(Auth::check())
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0 shadow-sm rounded-3 border-0">
 
    <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between">
          <h2 class="widget-title pb-0">الأذونات</h2>
          <a class="btn btn-success font-weight-medium" href="{{ route('permissions.create') }}">
            <i class="la la-plus mr-1"></i> إضافة إذن
          </a>
        </div>
                <div class="block-card-body">
          @if(session('success'))
            <div class="alert alert-success alert-dismissible fade show" role="alert">
              {{ session('success') }}
              <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
            </div>
          @endif

          <div class="my-table table-responsive" style="direction: rtl; text-align: right;">
            <table class="table align-items-center table-flush mb-0 table-hover" style="direction: rtl; text-align: right;">
                <thead class="thead-light">
                    <tr>
                                    <th class="text-center" style="width:10%">المعرف</th>
                                    <th class="text-center" style="width:50%">الإذن</th>
                                    <th class="text-center" style="width:40%">الإجراءات</th>
                                </tr>
                            </thead>

                            <tbody>
                                @forelse ($permissions as $permission)
                                    <tr>
                                        {{-- ID --}}
                                        <td class="text-center fw-bold align-middle">{{ $permission->id_perm }}</td>

                                        {{-- Nom en arabe --}}
                                        <td class="text-end align-middle" style="direction: rtl;">
                                            {{ $permission->nom_ar }}
                                        </td>

                                        {{-- Actions --}}
                                        <td class="text-center align-middle">
                                            <div class="d-flex justify-content-center align-items-center gap-2">

                                                {{-- Modifier --}}
                                                <button type="button"
														class="btn-icon btn-icon--warning"
														onclick="window.location='{{ route('permissions.edit', $permission->id_perm) }}'"
														title="تعديل">
													<i class="la la-edit"></i> 
												</button>


                                                {{-- Supprimer --}}
                                                <form action="{{ route('permissions.destroy', $permission->id_perm) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                 
													 <button type="button"
                                          class="btn-icon btn-icon--danger"
                                          title="حذف"
                                         onclick="return confirmAction('هل تريد حذف هذا الإذن؟', null, this.closest('form'))">
                                          <i class="la la-trash"></i> 
                                      </button>
                                                </form>

                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="3" class="py-4 text-muted text-center">لا توجد أذونات حالياً.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>


					<div class="d-flex justify-content-between align-items-center mt-3">
                      {{ $permissions->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

{{-- ======= SweetAlert Confirm ======= --}}
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>

<style>
.table th, .table td {
    vertical-align: middle;
    text-align: center;
}

.table td:nth-child(2) {
    text-align: right !important;
    direction: rtl;
}

</style>

@else
<script>window.location.href = "{{ route('admin') }}";</script>
@endif

@endsection






