@extends('backoffice.dashboard')

@section('content')

@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())
<section class="add-listing-area section-padding">
    <div class="container">
        <div class="row">
            <div class="col-lg-10 mx-auto">
                {{-- Formulaire d'édition --}}
                <form method="POST" action="{{ route('permissions.update', $permission->id_perm) }}">
                    @csrf
                    @method('PUT')

                    <div class="block-card mb-4">
                        <div class="block-card-header">
                            <h2 class="widget-title">تعديل الإذن</h2>
                            <div class="stroke-shape"></div>
                        </div>

                        <div class="block-card-body">
                            <div class="form-group">
                                <label>الاسم (عربي)</label>
                                <input name="nom_ar" class="form-control" 
                                       value="{{ old('nom_ar', $permission->nom_ar) }}" required>
                            </div>

                            <div class="form-group">
                                <label>الاسم (fr)</label>
                                <input name="nom_fr" class="form-control" 
                                       value="{{ old('nom_fr', $permission->nom_fr) }}">
                            </div>

                            <div class="form-group">
                                <label>الاسم (en)</label>
                                <input name="nom_en" class="form-control" 
                                       value="{{ old('nom_en', $permission->nom_en) }}">
                            </div>

                            <div class="form-group">
                                <label>guard_name</label>
                                <input name="guard_name" class="form-control" 
                                       value="{{ old('guard_name', $permission->guard_name ?? 'web') }}">
                            </div>
                        </div>

                        <div class="px-3 pb-3">
                            <button type="submit" class="btn bg-rgb-primary1 font-weight-medium">
                                <i class="la la-save mr-1">حفظ</i>
                            </button>

                            <a href="{{ route('permissions.index') }}" class="btn bg-rgb-primary1 font-weight-medium">
                                <i class="la la-times mr-1">الغاء</i>
                            </a>
                        </div>
                    </div>
                </form>
            </div>
        </div>
    </div>
</section>
@else
    <script>
        window.location.href = "{{ route('admin') }}";
    </script>
@endif
@endsection
