@extends('backoffice.dashboard')

@section('title', 'قائمة الرسائل')

@section('content')
@if(Auth::check())
	<link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.0/css/all.min.css">
<div class="container-fluid dashboard-inner-body-container">
    <div class="row">
        <div class="col-lg-12">
            <div class="block-card dashboard-card mb-4 px-0 shadow-sm rounded-3 border-0">

                <div class="block-card-header px-4 border-bottom-0 pb-0 d-flex justify-content-between align-items-center">
                    <h2 class="widget-title m-0">قائمة الرسائل الواردة</h2>

                </div>
				
				<div class="block-card-header px-4 border-bottom-0 pb-3">
                    <form method="GET" action="{{ route('contacts.index') }}">
                        <div class="form-row align-items-center" style="direction: rtl;">
                            <div class="col-auto" style="width: 250px;">
                                <input 
                                    type="text" 
                                    name="q" 
                                    class="form-control" 
                                   placeholder="بحث"
                                    value="{{ $search ?? '' }}"
                                >
                            </div>
                            <div class="col d-flex">
                                <button type="submit" class="btn bg-rgb-primary1 font-weight-medium" style="width: 105px;">
                                    بحث
                                </button>
                                <a href="{{ route('contacts.index') }}"
                                   class="btn bg-rgb-primary1 font-weight-medium d-flex align-items-center justify-content-center"
                                   style="width: 45px; height: 38px; margin-right: 5px; padding: 0;">
                                    <i class="fa-solid fa-rotate-right"></i>
                                </a>
                            </div>
                        </div>
                    </form>
                </div>
				
				
               <div class="block-card-body">
                    @if(session('ok'))
                        <div class="alert alert-success alert-dismissible fade show" role="alert">
                            {{ session('ok') }}
                            <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                        </div>
                    @endif

                    <div class="my-table table-responsive" style="direction: rtl; text-align: right;">
                        <table class="table align-items-center table-flush mb-0 table-hover">
                            <thead class="thead-light">
                                <tr>
                                    <th style="width:30px">المعرف</th>
                                    <th style="width:22%">المرسل</th>
                                    <th style="width:22%">البريد الإلكتروني</th>
                                    <th style="width:10%">الموضوع</th>
                                    <th style="width:15%">الرسالة</th>
                                    <th style="width:70px">مقروء</th>
                                    <th style="width:160px">التاريخ</th>
                                    <th style="width:150px">الإجراءات</th>
                                </tr>
                            </thead>
                            <tbody>
                                @forelse ($contacts as $c)
                                    <tr>
                                        <td>{{ $c->id }}</td>
                                        <td class="text-end">{{ $c->name }}</td>
                                        <td class="text-end">{{ $c->email }}</td>
                                        <td class="text-end">{{ $c->subject ?? '—' }}</td>
                                        <td class="text-end" style="max-width:300px; white-space: nowrap; overflow: hidden; text-overflow: ellipsis;">
                                            {{ \Illuminate\Support\Str::limit($c->message, 80) }}
                                        </td>
                                      <td class="text-center">
    <span class="badge-read {{ $c->is_read ? 'read' : 'unread' }}" title="{{ $c->is_read ? 'تمت قراءته' : 'غير مقروء' }}">
        @if($c->is_read)
            <i class="la la-check"></i>
        @else
            <i class="la la-envelope-open"></i>
        @endif
    </span>
</td>

                                        <td>{{ optional($c->created_at)->format('Y-m-d H:i') }}</td>
                                        <td>
                                            <div class="d-flex justify-content-center gap-2">
                                                <a href="{{ route('contacts.show', $c) }}" class="btn-icon btn-icon--info" title="عرض">
                                                    <i class="la la-eye"></i>
                                                </a>

                                                <form action="{{ route('contacts.destroy', $c) }}" method="POST" class="d-inline">
                                                    @csrf
                                                    @method('DELETE')
                                                    <button type="button"
                                                            onclick="return confirmAction('هل تريد حذف هذه الرسالة؟', null, this.closest('form'))"
                                                            class="btn-icon btn-icon--danger"
                                                            title="حذف">
                                                        <i class="la la-trash"></i>
                                                    </button>
                                                </form>
                                            </div>
                                        </td>
                                    </tr>
                                @empty
                                    <tr>
                                        <td colspan="8" class="py-4 text-muted text-center">لا توجد رسائل حالياً.</td>
                                    </tr>
                                @endforelse
                            </tbody>
                        </table>
                    </div>

                    <div class="d-flex justify-content-between align-items-center mt-3">
                        {{ $contacts->links('pagination::bootstrap-5') }}
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

<!-- SweetAlert confirm (same as your news view) -->
<script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
<script>
function confirmAction(message, url = null, form = null) {
    Swal.fire({
        title: 'تأكيد',
        text: message,
        icon: 'warning',
        showCancelButton: true,
        confirmButtonColor: '#28a745',
        cancelButtonColor: '#d33',
        confirmButtonText: 'نعم',
        cancelButtonText: 'إلغاء'
    }).then((result) => {
        if (result.isConfirmed) {
            if (url) {
                window.location.href = url;
            } else if (form) {
                form.submit();
            }
        }
    });
    return false;
}
</script>

<style>
.status-badge {
    display: inline-block;
    padding: 6px 10px;
    border-radius: 12px;
    font-size: 13px;
    font-weight: 600;
    color: #fff;
}
.status-badge--success { background-color: #27ae60; }
.status-badge--danger  { background-color: #e74c3c; }
</style>

@else
<script>window.location.href = "{{ route('admin') }}";</script>
@endif

@endsection
