<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <style>
        body {
            font-family: dejavusans;
            direction: rtl;
            text-align: right;
            font-size: 12px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            border: 1px solid #000;
            padding: 6px;
            text-align: center;
        }

        th {
            background: #f2f2f2;
        }
    </style>
</head>
<body>

<h3 style="text-align:center">قائمة مطالب إنشاء قاعات رياضية</h3>

<table>
    <thead>
        <tr>
            <th>الرقم</th>
            <th>تاريخ الإيداع</th>
            <th>الاسم</th>
            <th>الحالة</th>
        </tr>
    </thead>
    <tbody>
        @foreach($salles as $salle)
        <tr>
            <td>{{ $salle->id_imm }}</td>
            <td>{{ $salle->created_at->format('Y-m-d') }}</td>
            <td>{{ $salle->utilisateur->nom_prenom ?? '---' }}</td>
            <td>{{ $salle->statut->statut_ar ?? 'في الانتظار' }}</td>
        </tr>
        @endforeach
    </tbody>
</table>

</body>
</html>
