<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <style>
        body {
            font-family: "amiri", serif;
            direction: rtl;
            text-align: right;
            font-size: 13px;
        }
        h1,h2,h3,h4,h5 {
            font-family: "amiri", serif;
            text-align: center;
        }
        table {
            width: 100%;
            border-collapse: collapse;
            direction: rtl;
            margin-bottom: 10px;
        }
        th, td {
            border: 1px solid #000;
            padding: 6px;
            text-align: right;
            vertical-align: middle;
        }
        .section {
            border: 1px solid #000;
            padding: 10px;
            margin-bottom: 15px;
        }
        .section-title {
            font-weight: bold;
            margin-bottom: 8px;
            text-decoration: underline;
        }
    </style>
</head>
<body>



<div class="header">
    <table width="100%" style="border: none;">
        <tr>
            <td style="width:120px; text-align:right; border:none;">
                <img src="{{ public_path('storage/logo.png') }}"
                     style="width:90px; height:auto;">
            </td>

            <td style="text-align:center; border:none;">
                <div style="display:inline-block; text-align:center;">
                    <h1>الجمهورية التونسية</h1>
                    <h2>وزارة الشباب و الرياضة</h2>
                   <h3>{{ $formulaire->type_ar }}</h3>
				   <h4 style="text-align:center;padding-top:20px;">إستمارة تسجيل الإنتفاع بإعفاء جبائي</h4>
                </div>
            </td>

            <td style="width:120px; border:none;"></td>
        </tr>
    </table>
</div>


<div class="section">
    <div class="section-title">الوضعية الحالية</div>
    <table>
        <tr>
            <td>الحالة</td>
            <td>
                @if($document->id_statut == 1)
                    موافقة
                @elseif($document->id_statut == 3)
                    عدم موافقة
                @elseif($document->id_statut == 4)
                    موافقة شريطة
                @elseif($document->id_statut == 5)
                    ارجاء لابداء الراي
                @else
                    في الانتظار
                @endif
            </td>
        </tr>
        @if($document->id_statut == 3 && $document->commentaire_motif)
        <tr>
            <td>سبب الرفض</td>
            <td>{{ $document->commentaire_motif }}</td>
        </tr>
        @endif
        @if($document->id_statut == 4 && $document->commentaire_acceptation)
        <tr>
            <td>تعليق</td>
            <td>{{ $document->commentaire_acceptation }}</td>
        </tr>
        @endif
        @if($document->id_statut == 5 && $document->commentaire_avis)
        <tr>
            <td>تعليق</td>
            <td>{{ $document->commentaire_avis }}</td>
        </tr>
        @endif
    </table>
</div>

<div class="section">
    <div class="section-title">هوية صاحب المشروع</div>
    <table>
        <tr>
            <td>الاسم و اللقب</td>
            <td>{{ $document->utilisateur->nom_prenom ?? '-' }}</td>
        </tr>
        <tr>
            <td>رقم الهاتف</td>
            <td>{{ $document->utilisateur->tel ?? '-' }}</td>
        </tr>
        <tr>
            <td>البريد الالكتروني</td>
            <td>{{ $document->utilisateur->email ?? '-' }}</td>
        </tr>
        <tr>
            <td>العنوان الشخصي</td>
            <td>{{ $document->utilisateur->adresse ?? '-' }}</td>
        </tr>
    </table>
</div>

<div class="section">
    <div class="section-title">مشروع</div>
    <table>
        <tr>
            <td>عنوان المشروع</td>
            <td>{{ $document->nom_projet ?? '-' }}</td>
        </tr>
        <tr>
            <td>مكان المشروع</td>
            <td>{{ $document->adresse_projet ?? '-' }}</td>
        </tr>
    </table>
</div>

<div class="section">
    <div class="section-title">الوثائق المرفقة</div>
    <table>
        @php
            $files = [
                'copie_cahier_des_charges','copie_originale','facture','contrat','fichier_arrivage','fichier_colisage',
                'copie_registre_fiscal','copie_registre_national_institutions','copie_certificat_propriete','engagement','exemple_projet'
            ];
            $labels = [
                '1- نسخة من كراس الشروط','2- الأصل من شهادة إيداع التصريح','3- فاتورة','4- عقد بين المشتري و المورد','5- وثيقة الإعلام بالوصول',
                '6- وثيقة الشحن','7- نسخة من بطاقة التعريف الجبائي','8- نسخة من مضمون السجل الوطني للمؤسسات','9- نسخة من شهادة الملكية',
                '10- تعهد','11- مثال هندسي للمشروع'
            ];
        @endphp
        @foreach($files as $index => $file)
            <tr>
                <td>{{ $labels[$index] }}</td>
                <td>@if(!empty($document->$file)) ملف موجود @else - @endif</td>
            </tr>
        @endforeach
    </table>
</div>

</body>
</html>
