@extends('backoffice.dashboard')
@section('content')

<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">
<div class="container">
    <form action="{{ route('admin.debut_activite.update', $debutActivite->id_debut) }}" method="POST" id="myForm" lang="ar" enctype="multipart/form-data">
        @csrf
        @method('PUT') 
        <input type="hidden" name="immobilier_id" value="{{ $debutActivite->immobilier_id ?? '' }}">
        <input type="hidden" name="utilisateur_id" id="utilisateur_id" value="{{ $debutActivite->immobilier->utilisateur->id ?? '' }}">

      
        <h3>استمارة الاعلام ببداية النشاط</h3>

{{-- status card --}}
<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-custom-gray text-dark d-flex justify-content-between align-items-center">
    <h5 class="mb-0 fw-bold">الوضعية الحالية:</h5>
    @switch($debutActivite->id_statut)
      @case(1)<span class="status-badge status-badge--success">مقبول</span>@break
      @case(3)<span class="status-badge status-badge--danger">مرفوض</span>@break
      @case(4)<span class="status-badge status-badge--warning">موافقة شريطة</span>@break
      @case(5)<span class="status-badge status-badge--info">إرجاء لإبداء الرأي</span>@break
      @case(2)<span class="status-badge status-badge--pending">في الانتظار</span>@break
      @case(6)<span class="status-badge status-badge--secondary">مسودّة</span>@break
      @default <span class="status-badge status-badge--secondary">غير محدد</span>
    @endswitch
  </div>

  <div class="card-body">
    <p class="text-muted mb-4 text-center fs-6">إذا كنت ترغب في تعديل الوضعية الحالية، يرجى الاختيار من القائمة أدناه:</p>

    <div class="form-group row align-items-center mb-3">
      <label for="id_statut" class="col-sm-2 col-form-label fw-bold">تغيير الوضعية</label>
      <div class="col-sm-4">
        <select required class="form-control" id="id_statut" name="id_statut" onchange="toggleMotifInput()">
          <option value="">اختر...</option>
          @foreach($statuts as $s)
            @php
              $statutId = $s->id_statut ?? $s->id ?? null;
              // hide pending(2) and draft(6) from selection list
              if (in_array($statutId, [2, 6])) continue;
              $label = $s->libelle_ar ?? $s->statut_ar ?? $s->label ?? $s->name ?? $s->statut ?? '—';
              $selected = (string) old('id_statut', $debutActivite->id_statut ?? '') === (string) $statutId;
            @endphp
            <option value="{{ $statutId }}" {{ $selected ? 'selected' : '' }}>{{ $label }}</option>
          @endforeach
        </select>
      </div>
    </div>

   {{-- nouveau div (shown when status is 4 or 5) --}}
<div class="mb-3 d-none" id="motifDivStatus">
  <label class="form-label fw-bold text-warning">سبب / تعليق</label>
  <textarea name="commentaire_status"
            id="commentaire_status"
            class="form-control border-warning shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال السبب أو التعليق">
	</textarea>
</div>

{{-- reject textarea shown only when status == 3 --}}
<div class="mb-3 d-none" id="motifDiv">
  <label for="commentaire_refus" class="form-label fw-bold text-danger">سبب الرفض</label>
    <textarea name="commentaire_refus"
            id="commentaire_refus"
            class="form-control border-danger shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال سبب الرفض">
	</textarea>
</div>
  </div>
</div>

{{-- history card (compact) --}}
<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-light py-2">
       <h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h5>
  </div>

  <div class="card-body p-2" dir="rtl">
    @if($debutActivite->statutHistories->isEmpty())
      <p class="text-muted mb-0">لا توجد تغييرات سابقة.</p>
    @else
      <div class="compact-timeline">
        @foreach($debutActivite->statutHistories as $hist)
          @php
            $from = optional($hist->fromStatut)->statut_ar ?? optional($hist->fromStatut)->libelle_ar ?? '—';
            $to = optional($hist->toStatut)->statut_ar ?? optional($hist->toStatut)->libelle_ar ?? '—';
            $toId = optional($hist->toStatut)->id_statut;
            $badgeClass = $toId === 1 ? 'badge-success' : ($toId === 3 ? 'badge-danger' : 'badge-muted');
            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
          @endphp

          <div class="compact-item">
            <div class="compact-row d-flex align-items-center justify-content-between w-100">
              <div class="left-block text-end">
                <div class="small text-muted compact-date">{{ $hist->created_at->format('d/m/Y H:i') }}</div>
                <div class="very-small text-muted compact-user">بواسطة: {{ $changer }}</div>
              </div>

              <div class="right-block text-right flex-fill">
                <span class="compact-from small text-muted">{{ $from }}</span>
                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                <span class="compact-to small {{ $badgeClass }}">{{ $to }}</span>
              </div>
            </div>

            @if($hist->commentaire)
              <details class="compact-comment mt-1">
                <summary class="very-small text-danger">سبب / تعليق</summary>
                <div class="very-small text-muted mt-1">{{ $hist->commentaire }}</div>
              </details>
            @endif
          </div>
        @endforeach
      </div>
    @endif
  </div>
</div>

<style>
/* compact styles (same as earlier) */
.compact-timeline { display:flex; flex-direction:column; gap:6px; }
.compact-item { padding:6px 4px; border-bottom:1px solid rgba(0,0,0,0.06); }
.left-block { width:160px; min-width:120px; margin-left:12px; }
.compact-date { font-size:12px; color:#6c757d; }
.compact-user { font-size:11px; color:#8a8f94; margin-top:2px; }
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color:#6c757d; font-size:13px; }
.compact-arrow { color:#6c757d; font-size:14px; margin:0 4px; }
.compact-to { font-size:13px; padding:3px 8px; border-radius:10px; }
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }
.compact-comment summary { list-style:none; cursor:pointer; outline:none; padding:0; }
</style>


        <div class="form-section">
            <h4>هوية الباعث</h4> 
            <div class="form-group row align-items-center mb-3">
                <label class="col-sm-2 col-form-label">نوع الهوية</label>
                <div class="col-sm-4">
                    <span class="form-control">
                        {{ 
                            $debutActivite->immobilier->utilisateur->cin ? 'بطاقة تعريف وطنية (CIN)' : 
                            ($debutActivite->immobilier->utilisateur->passport ? 'جواز سفر (Passport)' : 
                            ($debutActivite->immobilier->utilisateur->num_fiscal ? 'رقم تعريفي جبائي (Num Fiscal)' : '---')) 
                        }}
                    </span>
                </div>

                <div class="col-sm-4">
                    <input type="text" class="form-control" id="identifiant" value="{{ $debutActivite->immobilier->utilisateur->cin ?? $debutActivite->immobilier->utilisateur->passport ?? $debutActivite->immobilier->utilisateur->num_fiscal ?? '' }}">
                </div>
                
            </div>

            <div id="sectionIdentite" class="d-block">
                <h5>بيانات الباعث</h5>
                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">الاسم و اللقب أو الاسم التجاري</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="nom_prenom" name="nom_prenom" value="{{ $debutActivite->immobilier->utilisateur->nom_prenom ?? '' }}" readonly>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">رقم الهوية</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="identifiantAffiche" value="{{ $debutActivite->immobilier->utilisateur->cin ?? $debutActivite->immobilier->utilisateur->passport ?? $debutActivite->immobilier->utilisateur->num_fiscal ?? '' }}" readonly>
                    </div>
                </div>

                <div class="form-group row">
                    <label class="col-sm-2 col-form-label">المندوبية الجهوية للشباب و الرياضة</label>
                    <div class="col-sm-10">
                        <input type="text" class="form-control" id="mandoubia" value="{{ $debutActivite->immobilier->gouvernorat->nom_ar ?? '' }}" readonly>
                    </div>
                </div>
            </div>

            <h4>تاريخ بداية النشاط</h4>
            <div class="form-group row">
                <div class="col-sm-11">
                    <input required type="date" class="form-control" id="date_debut_activite" name="date_debut_activite" value="{{ $debutActivite->date_debut_activite ? $debutActivite->date_debut_activite->format('Y-m-d') : '' }}">
                </div>
            </div>
            <span>تاريخ بداية النشاط يجب ان يكون بعد 15 يوما من تاريخ استلام وصل التسجيل.</span>

            <h4>إضافة الوثائق المطلوبة</h4>
            @php
                $docs = [
                    'preuve_propriete_location' => 'نسخة من شهادة الملكية او عقد بيع او عقد كراء ...',
                    'plan_architectural' => 'مثال هندسي معد من قبل مهندس معماري ...',
                    'declaration_investissement' => 'شهادة تصريح بالاستثمار ...',
                    'identification' => 'بطاقة تعريف جبائية',
                    'extrait_registre_national_entreprise' => 'مضمون السجل الوطني للمؤسسات',
                    'certificat_prevention' => 'شهادة وقاية مسلمة من المصالح الجهوية ...',
                    'contrat_assurance' => 'عقد التامين',
                    'approbation_autorite_minicipale' => 'عقود الشغل مع الاعوان ...'
                ];
            @endphp

            @foreach($docs as $field => $label)
                <div class="form-group row">
                    <label for="{{ $field }}" class="col-sm-8 col-form-label">{{ $label }}</label>
                    <div class="col-sm-3">
                        <input type="file" class="form-control" id="{{ $field }}" name="{{ $field }}">
                        @if(!empty($debutActivite->$field))
							<a href="{{ route('debutActivite.download', ['id' => $debutActivite->id_debut, 'field' => $field]) }}" target="_blank">الملف الحالي</a>
						@endif

                    </div>
                </div>
            @endforeach

          
  <div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                <button type="submit" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill">
                <i class="bx bx-save"></i> حفظ
                </button>
                <a href="{{ route('salle-sport.index') }}" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
			
		
        </div>   
    </form>
</div>

@endsection
