@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">

@if(Auth::check())

<div class="container">
    <form action="{{ route('admin.jeunesse2.update', $activite->id_jeune_enfant) }}" method="POST" enctype="multipart/form-data" lang="ar">
        @csrf
        @method('PUT')

       <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
          <h3>{{ $formulaire->type_ar }}</h3>
        <h4 style="text-align:center;">تحيين الاستمارة</h4>

   <div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-custom-gray text-dark d-flex justify-content-between align-items-center">
    <h5 class="mb-0 fw-bold">الوضعية الحالية:</h5>
    @switch($activite->id_statut)
      @case(1)<span class="status-badge status-badge--success">مقبول</span>@break
      @case(3)<span class="status-badge status-badge--danger">مرفوض</span>@break
      @case(4)<span class="status-badge status-badge--warning">موافقة شريطة</span>@break
      @case(5)<span class="status-badge status-badge--info">إرجاء لإبداء الرأي</span>@break
      @case(2)<span class="status-badge status-badge--pending">في الانتظار</span>@break
      @case(6)<span class="status-badge status-badge--secondary">مسودّة</span>@break
      @default <span class="status-badge status-badge--secondary">غير محدد</span>
    @endswitch
  </div>

  <div class="card-body">
    <p class="text-muted mb-4 text-center fs-6">إذا كنت ترغب في تعديل الوضعية الحالية، يرجى الاختيار من القائمة أدناه:</p>

    <div class="form-group row align-items-center mb-3">
      <label for="id_statut" class="col-sm-2 col-form-label fw-bold">تغيير الوضعية</label>
      <div class="col-sm-4">
        <select class="form-control" id="id_statut" name="id_statut" onchange="toggleMotifInputActivite()">
          <option value="">اختر...</option>
          @foreach($statuts as $s)
            @php
              $statutId = $s->id_statut ?? $s->id ?? $s->ID;
              if (in_array($statutId, [2,6])) continue; // hide pending & draft
              $label = $s->libelle_ar ?? $s->statut_ar ?? $s->label ?? $s->name ?? $s->statut ?? '—';
              $selected = (string) old('id_statut', $activite->id_statut ?? '') === (string) $statutId;
            @endphp
            <option value="{{ $statutId }}" {{ $selected ? 'selected' : '' }}>
              {{ $label }}
            </option>
          @endforeach
        </select>
      </div>
    </div>

<div class="mb-3 d-none" id="motifDivStatus">
  <label class="form-label fw-bold text-warning">سبب / تعليق</label>
  <textarea name="commentaire_status"
            id="commentaire_status"
            class="form-control border-warning shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال السبب أو التعليق">
	</textarea>
</div>

{{-- reject textarea shown only when status == 3 --}}
<div class="mb-3 d-none" id="motifDiv">
  <label for="commentaire_refus" class="form-label fw-bold text-danger">سبب الرفض</label>
    <textarea name="commentaire_refus"
            id="commentaire_refus"
            class="form-control border-danger shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال سبب الرفض">
	</textarea>
</div>
  </div>
</div>
{{-- history card (compact) --}}
<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-light py-2">
    <h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h5>
  </div>

  <div class="card-body p-2" dir="rtl">
    @if($activite->statutHistories->isEmpty())
      <p class="text-muted mb-0">لا توجد تغييرات سابقة.</p>
    @else
      <div class="compact-timeline">
        @foreach($activite->statutHistories as $hist)
          @php
            $from = optional($hist->fromStatut)->statut_ar ?? optional($hist->fromStatut)->libelle_ar ?? '—';
            $to   = optional($hist->toStatut)->statut_ar   ?? optional($hist->toStatut)->libelle_ar   ?? '—';
            $toId = optional($hist->toStatut)->id_statut;
            $badgeClass = $toId === 1 ? 'badge-success' : ($toId === 3 ? 'badge-danger' : 'badge-muted');
            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
          @endphp

          <div class="compact-item">
            <div class="compact-row d-flex align-items-center justify-content-between w-100">
              <div class="left-block text-end">
                <div class="small text-muted compact-date">{{ $hist->created_at->format('d/m/Y H:i') }}</div>
                <div class="very-small text-muted compact-user">بواسطة: {{ $changer }}</div>
              </div>

              <div class="right-block text-right flex-fill">
                <span class="compact-from small text-muted">{{ $from }}</span>
                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                <span class="compact-to small {{ $badgeClass }}">{{ $to }}</span>
              </div>
            </div>

            @if($hist->commentaire)
              <details class="compact-comment mt-1">
                <summary class="very-small text-danger">سبب / تعليق</summary>
                <div class="very-small text-muted mt-1">{{ $hist->commentaire }}</div>
              </details>
            @endif
          </div>
        @endforeach
      </div>
    @endif
  </div>
</div>

<style>
/* compact styles (same as earlier) */
.compact-timeline { display:flex; flex-direction:column; gap:6px; }
.compact-item { padding:6px 4px; border-bottom:1px solid rgba(0,0,0,0.06); }
.left-block { width:160px; min-width:120px; margin-left:12px; }
.compact-date { font-size:12px; color:#6c757d; }
.compact-user { font-size:11px; color:#8a8f94; margin-top:2px; }
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color:#6c757d; font-size:13px; }
.compact-arrow { color:#6c757d; font-size:14px; margin:0 4px; }
.compact-to { font-size:13px; padding:3px 8px; border-radius:10px; }
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }
.compact-comment summary { list-style:none; cursor:pointer; outline:none; padding:0; }
</style>
       <div class="form-section">
            <h4>المستثمر</h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="nom_prenom" 
                            value="{{ old('nom_prenom', $activite->investissements->first()?->utilisateur->nom_prenom) }}" 
                            placeholder="الاسم و اللقب" maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">مكان الولادة</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="lieu_naissance" 
                           value="{{ old('lieu_naissance', $activite->investissements->first()?->utilisateur->lieu_naissance) }}" 
                           placeholder="مكان الولادة">
                </div>

                <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                <div class="col-sm-4">
                    <input required type="date" class="form-control" name="date_naissance" 
                           value="{{ old('date_naissance', $activite->investissements->first()?->utilisateur->date_naissance) }}">
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                <div class="col-sm-4">
                    <select required class="form-control" id="id_type_identite" name="id_type_identite" onchange="showTypeIdentiteInput3()">
                        <option value="" disabled>اختر...</option>
                        @foreach($typesIdentite as $type)
                            <option value="{{ $type->id_type }}" 
                                {{ old('id_type_identite', $activite->investissements->first()?->utilisateur->id_type_identite) == $type->id_type ? 'selected' : '' }}>
                                {{ $type->type_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-sm-6" id="cin_input_wrapper" style="display:{{ $activite->investissements->first()?->utilisateur->id_type_identite == 1 ? 'block' : 'none' }};">
                    <input type="text" class="form-control" id="cin_input" name="cin" 
                           value="{{ old('cin', $activite->investissements->first()?->utilisateur->cin) }}" 
                           placeholder="أدخل رقم بطاقة التعريف" pattern="^\d{8}$" maxlength="8">
                </div>
                <div class="col-sm-6" id="passport_field" style="display:{{ $activite->investissements->first()?->utilisateur->id_type_identite == 2 ? 'block' : 'none' }};">
                    <input type="text" class="form-control" id="passport_input" name="passport" 
                           value="{{ old('passport', $activite->investissements->first()?->utilisateur->passport) }}" 
                           placeholder="أدخل رقم جواز السفر" pattern="^\d{8,12}$" minlength="8" maxlength="12">
                </div>
                <div class="col-sm-6" id="fiscal_field" style="display:{{ $activite->investissements->first()?->utilisateur->id_type_identite == 3 ? 'block' : 'none' }};">
                    <input type="text" class="form-control" id="num_fiscal_input" name="num_fiscal" 
                           value="{{ old('num_fiscal', $activite->investissements->first()?->utilisateur->num_fiscal) }}" 
                           placeholder="أدخل رقم المعرف الجبائي" pattern="^\d{12}$" maxlength="12">
                </div>
            </div>

            <div class="form-group row mb-3" id="cin_extra_fields" style="display:{{ $activite->investissements->first()?->utilisateur->id_type_identite == 1 ? 'flex' : 'none' }};">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance_cin" name="date_delivrance_cin" 
                           value="{{ old('date_delivrance_cin', $activite->investissements->first()?->utilisateur->date_delivrance_cin) }}">
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance_cin" name="lieu_delivrance_cin" 
                           value="{{ old('lieu_delivrance_cin', $activite->investissements->first()?->utilisateur->lieu_delivrance_cin) }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" 
                           value="{{ old('adresse', $activite->investissements->first()?->utilisateur->adresse) }}" 
                           placeholder=" العنوان الشخصي " maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" 
                           value="{{ old('niveau_etude', $activite->investissements->first()?->utilisateur->niveau_etude) }}" 
                           placeholder=" المستوى التعليمي ">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome" 
                           value="{{ old('dernier_diplome', $activite->investissements->first()?->utilisateur->dernier_diplome) }}" 
                           placeholder="آخر شهادة متحصل عليها">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الاقدمية في تعاطي النشاط </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="experience" 
                           value="{{ old('experience', $activite->investissements->first()?->utilisateur->experience) }}" 
                           placeholder="الاقدمية في تعاطي النشاط" maxlength="50">
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4> خاصيات النشاط </h4>
            <div class="row align-items-center">
                <div class="col-sm-6">
                    <label for="" class="col-sm-10 col-form-label">
                        <strong> تنظيم الأنشطة الترفيهية للشباب و الطفولة  </strong>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"><strong>الإستثمار في هذا النشاط</strong></label>
                <div class="col-sm-4">
                    <select required class="form-control" name="id_statut_inv">
                        @foreach($statut_inv as $statut)
                            <option value="{{ $statut->id_status }}"
                                {{ old('id_statut_inv', $activite->id_statut_inv) == $statut->id_status ? 'selected' : '' }}>
                                {{ $statut->statut_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
                <label class="col-sm-2 col-form-label"><strong>طبيعة الأنشطة</strong></label>
                <div class="col-sm-4">
                    <select required class="form-control" name="id_nature_activite">
                        @foreach($nature as $nature)
                            <option value="{{ $nature->id_nature_ac }}"
                                {{ old('id_nature_activite', $activite->id_statut_inv) == $nature->id_nature_ac ? 'selected' : '' }}>
                                {{ $nature->nature_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="form-group row mb-3 align-items-center">
                <label class="col-sm-2 col-form-label">الاسم التجاري للمشروع</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" 
                        name="nom_projet" 
                        placeholder="الاسم التجاري للمشروع" 
                        maxlength="100"
                        value="{{ old('nom_projet', $activite->nom_projet ?? '') }}">
                </div>

                <label class="col-sm-2 col-form-label">عنوان المقر الاجتماعي</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" 
                        name="adresse_siege" 
                        placeholder="عنوان المقر الاجتماعي" 
                        maxlength="100"
                        value="{{ old('adresse_siege', $activite->adresse_siege ?? '') }}">
                </div>
            </div>

            <div class="form-group row">
                <label class="col-sm-2 col-form-label"> الولاية </label>
                <div class="col-sm-4">
                    <select required class="form-control" id="gouvernorat_id" name="gouvernorat_id">
                        <option value="" disabled {{ old('gouvernorat_id', $activite->id_gouvernorat ?? '') == '' ? 'selected' : '' }}>اختر...</option>
                        @foreach($gouvernorats as $gouv)
                            <option value="{{ $gouv->id_gouver }}" 
                                {{ old('gouvernorat_id', $activite->id_gouvernorat ?? '') == $gouv->id_gouver ? 'selected' : '' }}>
                                {{ $gouv->nom_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <label class="col-sm-2 col-form-label"> البلدية </label>
                <div class="col-sm-4">
                    <select required class="form-control" id="delegation_id" name="delegation_id">
                        <option value="" disabled {{ old('delegation_id', $activite->id_delegation ?? '') == '' ? 'selected' : '' }}>اختر...</option>
                        @foreach($delegations as $deleg)
                            <option value="{{ $deleg->id_delegation }}" 
                                {{ old('delegation_id', $activite->id_delegation ?? '') == $deleg->id_delegation ? 'selected' : '' }}>
                                {{ $deleg->nom_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الترقيم البريدي </label>
                <div class="col-sm-4">
                    <input required type="number" class="form-control" 
                        name="code_postal"  value="{{ old('code_postal', $activite->code_postal ?? '') }}"  placeholder="أدخل الترقيم البريدي" >
                </div>
            </div>
        </div>

        <h4>جدول الاستثمار و التمويل</h4>
        <div class="form-group row">
            <table id="investissement-table" class="custom-table">
                <thead>
                    <tr>
                        <th>الإستثمار</th>
                        <th>مبلغ الإستثمار</th>
                        <th>مصادر التمويل</th>
                        <th>مبلغ التمويل</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody id="investissement-body">
                    @foreach($activite->investissements as $index => $inv)
                    <tr>
                        <td data-label="الإستثمار">
                            <select class="form-control" name="investissements[{{ $index }}][secteur_invest_id]" id="secteur_invest_id_{{ $index }}">
                                <option value="" disabled>اختر...</option>
                                @foreach($secteurs as $secteur)
                                    <option value="{{ $secteur->id_secteur }}" 
                                        {{ $inv->secteur_invest_id == $secteur->id_secteur ? 'selected' : '' }}>
                                        {{ $secteur->secteur_ar }}
                                    </option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="مبلغ الإستثمار">
                            <input type="number" name="investissements[{{ $index }}][montant_inv]" 
                                class="form-control" min=1 value="{{ $inv->montant_inv }}">
                        </td>
                        <td data-label="مصادر التمويل">
                            <select class="form-control" name="investissements[{{ $index }}][id_source_financement]" id="id_source_financement_{{ $index }}">
                                <option value="" disabled>اختر...</option>
                                @foreach($source_fin as $source)
                                    <option value="{{ $source->id_source }}" 
                                        {{ $inv->id_source_financement == $source->id_source ? 'selected' : '' }}>
                                        {{ $source->source_ar }}
                                    </option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="مبلغ التمويل">
                            <input type="number" name="investissements[{{ $index }}][montant_fin]" 
                                class="form-control" min=1 value="{{ $inv->montant_fin }}">
                        </td>
                        <td class="action-buttons">
                            <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <button type="button" class="btn btn-primary mt-2" onclick="addInvestissementRow()" 
                    style="background-color: #28a745; border-color: #28a745;">
                إضافة صف
            </button>
        </div>

        <div class="mt-3">
            <h4>تصريح على الشرف</h4>
            <span>
                إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4> ملاحظات خاصة بالمندوبية الجهوية : </h4>
            <textarea class="form-control mt-2" name="remarques" rows="6" placeholder="اكتب ملاحظاتك هنا...">{{ old('remarques', $activite->remarques) }}</textarea>
        </div>

         <div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                <button type="submit" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill">
                <i class="bx bx-save"></i> حفظ
                </button>
                <a href="{{ route('admin.jeunesse2.index') }}" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    </form>
</div>
<script>document.addEventListener("DOMContentLoaded", function () {    const gouvSelect = document.getElementById('gouvernorat_id');    const delSelect  = document.getElementById('delegation_id');    gouvSelect.addEventListener('change', function () {        let gouvId = this.value;        delSelect.innerHTML = '';        delSelect.disabled = true;        delSelect.innerHTML = '<option disabled selected>تحميل...</option>';        let url = "{{ route('delegations.get', ['gouvernoratId' => 'ID_PLACEHOLDER']) }}";        url = url.replace("ID_PLACEHOLDER", gouvId);        fetch(url)            .then(response => response.json())            .then(data => {                                delSelect.innerHTML = '<option disabled selected>اختر...</option>';                                data.forEach(d => {                    let option = document.createElement('option');                    option.value = d.id_delegation;                    option.text  = d.nom_ar;                    delSelect.appendChild(option);                });                delSelect.disabled = false;            });    });});</script>
<script>
    let investIndex = {{ count($activite->investissements) }}; 

    function addInvestissementRow() {
        let tableBody = document.getElementById('investissement-body');

        let newRow = `
            <tr>
                <td data-label="الإستثمار">
                    <select class="form-control" name="investissements[${investIndex}][secteur_invest_id]" id="secteur_invest_id_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($secteurs as $secteur)
                        <option value="{{ $secteur->id_secteur }}">{{ $secteur->secteur_ar }}</option>
                        @endforeach
                    </select>
                </td>
                <td data-label="مبلغ الإستثمار">
                    <input type="number" name="investissements[${investIndex}][montant_inv]" class="form-control" min=1>
                </td>
                <td data-label="مصادر التمويل">
                    <select class="form-control" name="investissements[${investIndex}][id_source_financement]" id="id_source_financement_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($source_fin as $source)
                            <option value="{{ $source->id_source }}">{{ $source->source_ar }}</option>
                         @endforeach
                    </select>
                </td>
                <td data-label="مبلغ التمويل">
                    <input type="number" name="investissements[${investIndex}][montant_fin]" class="form-control" min=1>
                </td>
                <td class="action-buttons">
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                </td>
            </tr>
        `;

        tableBody.insertAdjacentHTML('beforeend', newRow);
        investIndex++;
    }

    function removeRow(button) {
        let row = button.closest('tr');
        row.remove();
    }
</script>

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection