@extends('backoffice.dashboard')
@section('content')
<link rel="stylesheet" href="{{ asset('BackOfficeAR/css/formulaire.css') }}">
@if ($errors->any())
    <ul class="alert alert-warning">
        @foreach ($errors->all() as $error)
            <li>{{ $error }}</li>
        @endforeach
    </ul>
@endif
@if(Auth::check())

<div class="container">
    <form action="{{ route('admin.jeunesse.update', $institution->id_inst) }}" method="POST" enctype="multipart/form-data" lang="ar">
    @csrf
    @method('PUT')
        <input type="hidden" name="id_formulaire" value="{{ $formulaire->id_type }}">
           <h3>{{ $formulaire->type_ar }}</h3>
        <h4 style="text-align:center;">تحيين الاستمارة</h4>

        <div class="card shadow-lg border-0 mb-4 rounded-4">
                                 <div class="card-header bg-custom-gray text-dark d-flex justify-content-between align-items-center">
                <h5 class="mb-0 fw-bold">الوضعية الحالية:</h5>
                @if($institution->id_statut == 1)
                    <span class="status-badge status-badge--success">موافقة </span>
                @elseif($institution->id_statut== 3)
                    <span class="status-badge status-badge--danger">عدم موافقة</span>
                @elseif($institution->id_statut == 4)
                    <span class="status-badge status-badge--pending">موافقة شريطة</span>
                @elseif($institution->id_statut== 5)
                    <span class="status-badge status-badge--pending">ارجاء لابداء الراي</span>
                @else
                    <span class="status-badge status-badge--pending">في الانتظار</span>
                @endif
            </div>
            <div class="card-body">
                <p class="text-muted mb-4 text-center fs-6">
                    إذا كنت ترغب في تعديل الوضعية الحالية، يرجى الاختيار من القائمة أدناه:
                </p>
               <div class="form-group row align-items-center mb-3">
    <label for="id_statut" class="col-sm-2 col-form-label fw-bold">تغيير الوضعية</label>
    <div class="col-sm-4">
        <select class="form-control" id="id_statut" name="id_statut" onchange="toggleMotifInput()">
            <option value="">اختر...</option>
            @foreach($statuts as $s)
                @php
                    $statutId = $s->id_statut ?? $s->id ?? null;
                    // hide Pending(2) and Draft(6) if you still want to (same as debutActivite)
                    if (in_array($statutId, [2, 6])) continue;
                    $label = $s->libelle_ar ?? $s->statut_ar ?? $s->label ?? $s->name ?? $s->statut ?? '—';
                    $selected = (string) old('id_statut', $institution->id_statut ?? '') === (string) $statutId;
                @endphp
                <option value="{{ $statutId }}" {{ $selected ? 'selected' : '' }}>{{ $label }}</option>
            @endforeach
        </select>
    </div>
</div>
   {{-- nouveau div (shown when status is 4 or 5) --}}
<div class="mb-3 d-none" id="motifDivStatus">
  <label class="form-label fw-bold text-warning">سبب / تعليق</label>
  <textarea name="commentaire_status"
            id="commentaire_status"
            class="form-control border-warning shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال السبب أو التعليق"></textarea>
</div>

{{-- reject textarea shown only when status == 3 --}}
<div class="mb-3 d-none" id="motifDiv">
  <label for="commentaire_refus" class="form-label fw-bold text-danger">سبب الرفض</label>
  <textarea name="commentaire_refus"
            id="commentaire_refus"
            class="form-control border-danger shadow-sm"
            rows="3"
            placeholder="الرجاء إدخال سبب الرفض"></textarea>
</div>
            </div>
        </div>
{{-- history card (compact) --}}
<div class="card shadow-lg border-0 mb-4 rounded-4">
  <div class="card-header bg-light py-2"><h5 class="mb-0 fw-bold">تاريخ تغيّر الوضعية</h5></div>

  <div class="card-body p-2" dir="rtl">
    @if(! isset($institution->statutHistories) || $institution->statutHistories->isEmpty())
      <p class="text-muted mb-0">لا توجد تغييرات سابقة.</p>
    @else
      <div class="compact-timeline">
        @foreach($institution->statutHistories as $hist)
          @php
            $from = optional($hist->fromStatut)->statut_ar ?? optional($hist->fromStatut)->libelle_ar ?? '—';
            $to = optional($hist->toStatut)->statut_ar ?? optional($hist->toStatut)->libelle_ar ?? '—';
            $toId = optional($hist->toStatut)->id_statut;
            $badgeClass = $toId === 1 ? 'badge-success' : ($toId === 3 ? 'badge-danger' : 'badge-muted');
            $changer = optional($hist->changer)->nom_prenom ?? optional($hist->changer)->email ?? 'نظام';
          @endphp

          <div class="compact-item">
            <div class="compact-row d-flex align-items-center justify-content-between w-100">
              <div class="left-block text-end">
                <div class="small text-muted compact-date">{{ $hist->created_at->format('d/m/Y H:i') }}</div>
                <div class="very-small text-muted compact-user">بواسطة: {{ $changer }}</div>
              </div>

              <div class="right-block text-right flex-fill">
                <span class="compact-from small text-muted">{{ $from }}</span>
                <span class="compact-arrow" aria-hidden="true"> &larr; </span>
                <span class="compact-to small {{ $badgeClass }}">{{ $to }}</span>
              </div>
            </div>

            @if($hist->commentaire)
              <details class="compact-comment mt-1">
                <summary class="very-small text-danger">سبب / تعليق</summary>
                <div class="very-small text-muted mt-1">{{ $hist->commentaire }}</div>
              </details>
            @endif
          </div>
        @endforeach
      </div>
    @endif
  </div>
</div>
<style>
/* compact styles (same as earlier) */
.compact-timeline { display:flex; flex-direction:column; gap:6px; }
.compact-item { padding:6px 4px; border-bottom:1px solid rgba(0,0,0,0.06); }
.left-block { width:160px; min-width:120px; margin-left:12px; }
.compact-date { font-size:12px; color:#6c757d; }
.compact-user { font-size:11px; color:#8a8f94; margin-top:2px; }
.right-block { display:flex; align-items:center; gap:6px; justify-content:flex-start; }
.compact-from { color:#6c757d; font-size:13px; }
.compact-arrow { color:#6c757d; font-size:14px; margin:0 4px; }
.compact-to { font-size:13px; padding:3px 8px; border-radius:10px; }
.badge-success { background:#198754; color:#fff; }
.badge-danger  { background:#dc3545; color:#fff; }
.badge-muted   { background:#6c757d; color:#fff; }
.compact-comment summary { list-style:none; cursor:pointer; outline:none; padding:0; }
</style>
        <div class="form-section">
            <h4>المستثمر</h4>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input type="text" class="form-control" name="nom_prenom" 
                            value="{{ old('nom_prenom', $institution->investissements->first()?->utilisateur->nom_prenom) }}" 
                            placeholder="الاسم و اللقب" maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">مكان الولادة</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="lieu_naissance" 
                           value="{{ old('lieu_naissance', $institution->investissements->first()?->utilisateur->lieu_naissance) }}" 
                           placeholder="مكان الولادة">
                </div>

                <label class="col-sm-2 col-form-label">تاريخ الولادة</label>
                <div class="col-sm-4">
                    <input required type="date" class="form-control" name="date_naissance" 
                           value="{{ old('date_naissance', $institution->investissements->first()?->utilisateur->date_naissance) }}">
                </div>
            </div>

            <div class="form-group row align-items-center">
                <label class="col-sm-2 col-form-label">الهوية الشخصية</label>  
                <div class="col-sm-4">
                    <select required class="form-control" id="id_type_identite" name="id_type_identite" onchange="showTypeIdentiteInput3()">
                        <option value="" disabled>اختر...</option>
                        @foreach($typesIdentite as $type)
                            <option value="{{ $type->id_type }}" 
                                {{ old('id_type_identite', $institution->investissements->first()?->utilisateur->id_type_identite) == $type->id_type ? 'selected' : '' }}>
                                {{ $type->type_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>

                <div class="col-sm-6" id="cin_input_wrapper" style="display:{{ $institution->investissements->first()?->utilisateur->id_type_identite == 1 ? 'block' : 'none' }};">
                    <input type="text" class="form-control" id="cin_input" name="cin" 
                           value="{{ old('cin', $institution->investissements->first()?->utilisateur->cin) }}" 
                           placeholder="أدخل رقم بطاقة التعريف" pattern="^\d{8}$" maxlength="8">
                </div>
                <div class="col-sm-6" id="passport_field" style="display:{{ $institution->investissements->first()?->utilisateur->id_type_identite == 2 ? 'block' : 'none' }};">
                    <input type="text" class="form-control" id="passport_input" name="passport" 
                           value="{{ old('passport', $institution->investissements->first()?->utilisateur->passport) }}" 
                           placeholder="أدخل رقم جواز السفر" pattern="^\d{8,12}$" minlength="8" maxlength="12">
                </div>
                <div class="col-sm-6" id="fiscal_field" style="display:{{ $institution->investissements->first()?->utilisateur->id_type_identite == 3 ? 'block' : 'none' }};">
                    <input type="text" class="form-control" id="num_fiscal_input" name="num_fiscal" 
                           value="{{ old('num_fiscal', $institution->investissements->first()?->utilisateur->num_fiscal) }}" 
                           placeholder="أدخل رقم المعرف الجبائي" pattern="^\d{12}$" maxlength="12">
                </div>
            </div>

            <div class="form-group row mb-3" id="cin_extra_fields" style="display:{{ $institution->investissements->first()?->utilisateur->id_type_identite == 1 ? 'flex' : 'none' }};">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance_cin" name="date_delivrance_cin" 
                           value="{{ old('date_delivrance_cin', $institution->investissements->first()?->utilisateur->date_delivrance_cin) }}">
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance_cin" name="lieu_delivrance_cin" 
                           value="{{ old('lieu_delivrance_cin', $institution->investissements->first()?->utilisateur->lieu_delivrance_cin) }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> العنوان الشخصي </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="adresse" 
                           value="{{ old('adresse', $institution->investissements->first()?->utilisateur->adresse) }}" 
                           placeholder=" العنوان الشخصي " maxlength="50">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> المستوى التعليمي </label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="niveau_etude" 
                           value="{{ old('niveau_etude', $institution->investissements->first()?->utilisateur->niveau_etude) }}" 
                           placeholder=" المستوى التعليمي ">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="dernier_diplome" 
                           value="{{ old('dernier_diplome', $institution->investissements->first()?->utilisateur->dernier_diplome) }}" 
                           placeholder="آخر شهادة متحصل عليها">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> الاقدمية في تعاطي النشاط </label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="experience" 
                           value="{{ old('experience', $institution->investissements->first()?->utilisateur->experience) }}" 
                           placeholder="الاقدمية في تعاطي النشاط" maxlength="50">
                </div>
            </div>
        </div>

        <div class="form-section mt-4">
            <h4> خاصيات النشاط </h4>
            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <strong> المؤسسة الشبابية الخاصة</strong>
                    </label>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label">
                        <strong> الرجاء الاختبار </strong>
                    </label>
                </div>
        
                <div class="col-sm-4">
                    <select required class="form-control" id="type_espace_id" name="type_espace_id">
                        <option value="" disabled>اختر...</option>
                        @foreach($types_espace as $type)
                            <option value="{{ $type->id_type }}"
                                {{ old('type_espace_id', $institution->type_espace_id) == $type->id_type ? 'selected' : '' }}>
                                {{ $type->type_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u> مميزات الفضاء  </u>
                    </label>
                </div>
            </div>
            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label"> عدد الغرف </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_chambre" name="nbr_chambre" 
                        min="1"
                        value="{{ old('nbr_chambre', $institution->nbr_chambre) }}">
                </div>

                <label class="col-sm-2 col-form-label"> عدد القاعات </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_salles" name="nbr_salles" 
                        min="1"
                        value="{{ old('nbr_salles', $institution->nbr_salles) }}">
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u>طاقة الاستعاب</u>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">  بالمبيت </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="capacite_accueil_hebergement" 
                        name="capacite_accueil_hebergement" min="1"
                        value="{{ old('capacite_accueil_hebergement', $institution->capacite_accueil_hebergement) }}">
                </div>

                <label class="col-sm-2 col-form-label">  تحت الخيام </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="capacite_accueil_sous_tente" 
                        name="capacite_accueil_sous_tente" min="1"
                        value="{{ old('capacite_accueil_sous_tente', $institution->capacite_accueil_sous_tente) }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">  بفضاءات التنشيط </label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="capacite_accueil_espace_animation" 
                        name="capacite_accueil_espace_animation" min="1"
                        value="{{ old('capacite_accueil_espace_animation', $institution->capacite_accueil_espace_animation) }}">
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="nature_projet_id" class="col-sm-10 col-form-label">
                        <u> الخدمات التي تؤمنها المؤسسة  </u>
                    </label>
                </div>
            </div>
            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="heberg_rest" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="heberg_rest" 
                    name="heberg_rest" value="1"
                    {{ old('heberg_rest', $institution->heberg_rest) == 1 ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="heberg_rest">
                    الإقامة والتغذية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="heberg_stage_activ" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="heberg_stage_activ" 
                    name="heberg_stage_activ" value="1"
                    {{ old('heberg_stage_activ', $institution->heberg_stage_activ) == 1 ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="heberg_stage_activ">
                    إيواء التربصات والأنشطة التكوينية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="camping" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="camping" name="camping" value="1"
                    {{ old('camping', $institution->camping) == 1 ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="camping">
                    التخييم
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="activ_educative" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="activ_educative" name="activ_educative" value="1"
                    {{ old('activ_educative', $institution->activ_educative) == 1 ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="activ_educative">
                    التنشيط التربوي والإجتماعي والثقافي
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="voyage" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="voyage" name="voyage" value="1"
                    {{ old('voyage', $institution->voyage) == 1 ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="voyage">
                    الرحلات الداخلية والخارجية
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="evenement" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="evenement" name="evenement" value="1"
                    {{ old('evenement', $institution->evenement) == 1 ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="evenement">
                    التظاهرات الثقافية والحفلات
                </label>
            </div>

            <div class="form-check d-flex align-items-center">
                <input type="hidden" name="autre" value="0"> 
                <input class="form-check-input me-2" type="checkbox" id="autre" name="autre" value="1"
                    {{ old('autre', $institution->autre) == 1 ? 'checked' : '' }}>
                <label class="col-sm-6 col-form-label" for="autre">
                    غير ذلك
                </label>
            </div>

            <div class="form-group row mb-3 align-items-center">
                <label class="col-sm-2 col-form-label">الاسم التجاري للمشروع</label>
                <div class="col-sm-4">
                    <input required type="text" class="form-control" name="nom_projet" 
                        placeholder="الاسم التجاري للمشروع" maxlength="50"
                        value="{{ old('nom_projet', $institution->nom_projet) }}">
                </div>

                <label class="col-sm-2 col-form-label" for="nature_projet_id">طبيعة المشروع</label>
                <div class="col-sm-4">
                    <select required class="form-control" id="nature_projet_id" name="nature_projet_id">
                        <option value="" disabled>اختر...</option>
                        @foreach($nature_projet as $nature)
                            <option value="{{ $nature->id_nature_p }}"
                                {{ old('nature_projet_id', $institution->nature_projet_id) == $nature->id_nature_p ? 'selected' : '' }}>
                                {{ $nature->nature_ar }}
                            </option>
                        @endforeach
                    </select>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">عدد مواطن الشغل</label>
                <div class="col-sm-4">
                    <input type="number" class="form-control" id="nbr_emplois" name="nbr_emplois" min="1"
                        value="{{ old('nbr_emplois', $institution->nbr_emplois) }}">
                </div>
            </div>

            <div class="row align-items-center">
                <div class="col-sm-4">
                    <label for="" class="col-sm-10 col-form-label">
                        <u>مدير المؤسسة</u>
                    </label>
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">الاسم و اللقب</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="nom_prenom_d" maxlength="50"
                        placeholder="الاسم و اللقب"
                        value="{{ old('nom_prenom_d', $institution->directeur->nom_prenom_d ?? '') }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">رقم بطاقة التعريف الوطنية</label>
                <div class="col-sm-10">
                    <input required type="text" class="form-control" name="num_cin" maxlength="8"
                        value="{{ old('num_cin', $institution->directeur->num_cin ?? '') }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">تاريخ إصدار البطاقة</label>
                <div class="col-sm-4">
                    <input type="date" class="form-control" id="date_delivrance" name="date_delivrance"
                        value="{{ old('date_delivrance', $institution->directeur->date_delivrance ?? '') }}">
                </div>

                <label class="col-sm-2 col-form-label">مكان الإصدار</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" id="lieu_delivrance" name="lieu_delivrance" placeholder="مكان الإصدار"
                        value="{{ old('lieu_delivrance', $institution->directeur->lieu_delivrance ?? '') }}">
                </div>
            </div>

            <div class="form-group row mb-3">
                <label class="col-sm-2 col-form-label">المستوى التعليمي</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="niveau_etude" placeholder="المستوى التعليمي"
                        value="{{ old('niveau_etude', $institution->directeur->niveau_etude ?? '') }}">
                </div>

                <label class="col-sm-2 col-form-label">آخر شهادة متحصل عليها</label>
                <div class="col-sm-4">
                    <input type="text" class="form-control" name="dernier_diplome_obtenu" placeholder="آخر شهادة متحصل عليها"
                        value="{{ old('dernier_diplome_obtenu', $institution->directeur->dernier_diplome_obtenu ?? '') }}">
                </div>
            </div>
        </div>
        <h4>جدول الاستثمار و التمويل</h4>
        <div class="form-group row">
            <table id="investissement-table" class="custom-table">
                <thead>
                    <tr>
                        <th>الإستثمار</th>
                        <th>مبلغ الإستثمار</th>
                        <th>مصادر التمويل</th>
                        <th>مبلغ التمويل</th>
                        <th></th>
                    </tr>
                </thead>
                <tbody id="investissement-body">
                    @foreach($institution->investissements as $index => $inv)
                    <tr>
                        <td data-label="الإستثمار">
                            <select class="form-control" name="investissements[{{ $index }}][secteur_invest_id]" id="secteur_invest_id_{{ $index }}">
                                <option value="" disabled>اختر...</option>
                                @foreach($secteurs as $secteur)
                                    <option value="{{ $secteur->id_secteur }}" 
                                        {{ $inv->secteur_invest_id == $secteur->id_secteur ? 'selected' : '' }}>
                                        {{ $secteur->secteur_ar }}
                                    </option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="مبلغ الإستثمار">
                            <input type="number" name="investissements[{{ $index }}][montant_inv]" 
                                class="form-control" min=1 value="{{ $inv->montant_inv }}">
                        </td>
                        <td data-label="مصادر التمويل">
                            <select class="form-control" name="investissements[{{ $index }}][id_source_financement]" id="id_source_financement_{{ $index }}">
                                <option value="" disabled>اختر...</option>
                                @foreach($source_fin as $source)
                                    <option value="{{ $source->id_source }}" 
                                        {{ $inv->id_source_financement == $source->id_source ? 'selected' : '' }}>
                                        {{ $source->source_ar }}
                                    </option>
                                @endforeach
                            </select>
                        </td>
                        <td data-label="مبلغ التمويل">
                            <input type="number" name="investissements[{{ $index }}][montant_fin]" 
                                class="form-control" min=1 value="{{ $inv->montant_fin }}">
                        </td>
                        <td class="action-buttons">
                            <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                        </td>
                    </tr>
                    @endforeach
                </tbody>
            </table>

            <button type="button" class="btn btn-primary mt-2" onclick="addInvestissementRow()" 
                    style="background-color: #28a745; border-color: #28a745;">
                إضافة صف
            </button>
        </div>

        <div class="mt-3">
            <h4>تصريح على الشرف</h4>
            <span>
                إني الممضي أسفله أشهد بصحة البيانات التي تضمنتها هذه الإستمارة كما أصرح أني لم أتعرض إلى أي عقاب جزائي أو إداري من شأنه أن يحجر على إدارة و تسيير مؤسسة أو الإستثمار في الأنشطة المنصوص عليها.
            </span>
        </div>

        <div class="remarques-block mt-3 p-3" style="border: 2px solid #000; border-radius: 5px;">
            <h4> ملاحظات خاصة بالمندوبية الجهوية : </h4>
            <textarea class="form-control mt-2" name="remarques" rows="6" placeholder="اكتب ملاحظاتك هنا...">{{ old('remarques', $institution->remarques) }}</textarea>
        </div>

       
		  <div class="form-group text-center mt-5">
            <div class="d-flex flex-wrap justify-content-center align-items-center gap-2" style="max-width: 600px; margin: 0 auto;">
                <button type="submit" class="btn btn-success d-flex align-items-center justify-content-center gap-1 flex-fill">
                <i class="bx bx-save"></i> حفظ
                </button>
                <a href="{{ route('admin.jeunesse.index') }}" class="btn btn-primary d-flex align-items-center justify-content-center gap-1 flex-fill">
                    <i class="bx bx-arrow-back" style="margin-right:5px;"></i> رجوع
                </a>
            </div>
        </div>
		<link href="https://unpkg.com/boxicons@2.1.4/css/boxicons.min.css" rel="stylesheet">
    </form>
</div>


<script>
    let investIndex = {{ count($institution->investissements) }}; 

    function addInvestissementRow() {
        let tableBody = document.getElementById('investissement-body');

        let newRow = `
            <tr>
                <td data-label="الإستثمار">
                    <select class="form-control" name="investissements[${investIndex}][secteur_invest_id]" id="secteur_invest_id_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($secteurs as $secteur)
                        <option value="{{ $secteur->id_secteur }}">{{ $secteur->secteur_ar }}</option>
                        @endforeach
                    </select>
                </td>
                <td data-label="مبلغ الإستثمار">
                    <input type="number" name="investissements[${investIndex}][montant_inv]" class="form-control" min=1>
                </td>
                <td data-label="مصادر التمويل">
                    <select class="form-control" name="investissements[${investIndex}][id_source_financement]" id="id_source_financement_${investIndex}">
                        <option value="" disabled selected>اختر...</option>
                        @foreach($source_fin as $source)
                            <option value="{{ $source->id_source }}">{{ $source->source_ar }}</option>
                         @endforeach
                    </select>
                </td>
                <td data-label="مبلغ التمويل">
                    <input type="number" name="investissements[${investIndex}][montant_fin]" class="form-control" min=1>
                </td>
                <td class="action-buttons">
                    <button type="button" class="btn btn-danger btn-sm" onclick="removeRow(this)">حذف</button>
                </td>
            </tr>
        `;

        tableBody.insertAdjacentHTML('beforeend', newRow);
        investIndex++;
    }

    function removeRow(button) {
        let row = button.closest('tr');
        row.remove();
    }
</script>

@else
    <script>
        window.location.href = "{{ route('login') }}";
    </script>
@endif
@endsection