<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <style>
        body {
            font-family: dejavusans;
            direction: rtl;
            text-align: right;
            font-size: 12px;
        }

        h3 {
            text-align: center;
            margin-bottom: 15px;
        }

        table {
            width: 100%;
            border-collapse: collapse;
        }

        th, td {
            border: 1px solid #000;
            padding: 6px;
            text-align: center;
        }

        th {
            background: #f2f2f2;
        }
    </style>
</head>
<body>

<h3>قائمة استمارات مشاريع الترفيه للشباب و الأطفال</h3>

<table>
    <thead>
        <tr>
            <th>المعرف</th>
            <th>تاريخ الإيداع</th>
            <th>الاسم و اللقب</th>
            <th>طبيعة المشروع</th>
            <th>وضعية الطلب</th>
        </tr>
    </thead>
    <tbody>
        @foreach($projets as $projet)
            <tr>
                <td>{{ $projet->id_projet }}</td>
                <td>{{ $projet->created_at->format('Y-m-d') }}</td>
                <td>{{ $projet->investissements->first()?->utilisateur?->nom_prenom ?? '---' }}</td>
                <td>{{ $projet->natureProjet?->nature_ar ?? '---' }}</td>
                <td>{{ $projet->statut?->statut_ar ?? 'في الانتظار' }}</td>
            </tr>
        @endforeach
    </tbody>
</table>

</body>
</html>
